/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.physicsquiz;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import net.handyx.api.GMG;
import net.handyx.api.MasterCanvas;
import net.handyx.api.RunnableCanvas;
import net.handyx.physicsquiz.GameRes;
import net.handyx.physicsquiz.HelpCanvas;
import net.handyx.physicsquiz.MenuCanvas;
import net.handyx.physicsquiz.ProgressCanvas;
import net.handyx.physicsquiz.QuestionCanvas;
import net.handyx.physicsquiz.QuestionsDB;
import net.handyx.physicsquiz.QuizDB;
import net.handyx.physicsquiz.SettingsCanvas;
import net.handyx.physicsquiz.SplashScreen;

public class Quiz
extends MIDlet
implements Runnable {
    public static final int INIT = 0;
    public static final int MAIN_MENU = 1;
    public static final int NEW_ROUNDS_GAME = 2;
    public static final int NEW_CONTINUOUS_GAME = 3;
    public static final int RESUME_GAME = 4;
    public static final int LOAD_QUESTION_SET = 5;
    public static final int DISPLAY_PROGRESS = 6;
    public static final int DISPLAY_SETTINGS = 7;
    public static final int DISPLAY_HELP = 8;
    public static final int EXIT = 666;
    public int loadingStage = 0;
    public Display display = Display.getDisplay((MIDlet)this);
    public MasterCanvas masterCanvas;
    public SplashScreen splashScreen;
    public MenuCanvas menuCanvas;
    public ProgressCanvas progressCanvas;
    public HelpCanvas helpCanvas;
    public QuestionCanvas questionCanvas;
    public SettingsCanvas settingsCanvas;

    public Quiz() {
        GMG.getJadParameters(this);
        RunnableCanvas.getJadParameters(this);
        this.masterCanvas = new MasterCanvas();
        this.masterCanvas.loadResources();
        this.masterCanvas.start();
        this.display.setCurrent((Displayable)this.masterCanvas);
        this.doLoadingStage(0, true);
    }

    public void doLoadingStage(int n, boolean bl) {
        if (bl) {
            this.masterCanvas.displaySpinner(true);
        }
        this.loadingStage = n;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        if (this.loadingStage == 0) {
            GameRes.getVersion(this);
            QuizDB.init();
            QuestionsDB.loadState();
            QuizDB.loadState();
            this.splashScreen = new SplashScreen(this);
            this.splashScreen.loadResources();
            this.menuCanvas = new MenuCanvas(this);
            this.settingsCanvas = new SettingsCanvas(this);
            this.settingsCanvas.loadSettings();
            this.questionCanvas = new QuestionCanvas(this);
            this.questionCanvas.loadState();
            this.masterCanvas.setCanvas(this.splashScreen, 1);
            return;
        }
        if (this.loadingStage == 1) {
            if (this.splashScreen != null) {
                this.splashScreen.purgeResources();
                this.splashScreen = null;
                System.gc();
            }
            this.questionCanvas.purgeResources();
            this.settingsCanvas.purgeResources();
            if (this.helpCanvas != null) {
                this.helpCanvas.purgeResources();
            }
            if (this.progressCanvas != null) {
                this.progressCanvas.purgeResources();
            }
            System.gc();
            GameRes.loadResources();
            this.menuCanvas.loadResources();
            this.masterCanvas.setCanvas(this.menuCanvas, 3);
            return;
        }
        if (this.loadingStage == 2 || this.loadingStage == 3) {
            if (this.progressCanvas != null) {
                this.progressCanvas.purgeResources();
            }
            this.settingsCanvas.purgeResources();
            if (this.helpCanvas != null) {
                this.helpCanvas.purgeResources();
            }
            System.gc();
            GameRes.initSound();
            this.questionCanvas.loadResources();
            if (this.loadingStage == 2) {
                QuestionsDB.setQuestionIds(QuizDB.getRandomUnansweredQuestionIds(10));
            } else {
                QuestionsDB.setQuestionIds(QuizDB.getRandomUnansweredQuestionIds(50));
            }
            QuestionsDB.cacheQuestions();
            if (this.loadingStage == 2) {
                this.questionCanvas.newGame(0, GameRes.setting_countdown, GameRes.setting_show_answers);
            } else {
                this.questionCanvas.newGame(1, GameRes.setting_countdown, GameRes.setting_show_answers);
            }
            this.masterCanvas.setCanvas(this.questionCanvas, 3);
            return;
        }
        if (this.loadingStage == 4) {
            if (this.progressCanvas != null) {
                this.progressCanvas.purgeResources();
            }
            this.settingsCanvas.purgeResources();
            if (this.helpCanvas != null) {
                this.helpCanvas.purgeResources();
            }
            System.gc();
            this.questionCanvas.loadResources();
            this.questionCanvas.measureCanvas();
            if (!QuestionsDB.questionsCached()) {
                QuestionsDB.cacheQuestions();
            }
            this.masterCanvas.setCanvas(this.questionCanvas, 3);
            return;
        }
        if (this.loadingStage == 5) {
            QuestionsDB.setQuestionIds(QuizDB.getRandomUnansweredQuestionIds(this.questionCanvas.getQuestionsPerRound()));
            QuestionsDB.cacheQuestions();
            this.questionCanvas.nextQuestion();
            this.masterCanvas.displaySpinner(false);
            return;
        }
        if (this.loadingStage == 6) {
            this.questionCanvas.purgeResources();
            this.settingsCanvas.purgeResources();
            if (this.helpCanvas != null) {
                this.helpCanvas.purgeResources();
            }
            System.gc();
            if (this.progressCanvas == null) {
                this.progressCanvas = new ProgressCanvas(this);
            }
            this.progressCanvas.loadResources();
            this.masterCanvas.setCanvas(this.progressCanvas, 3);
            return;
        }
        if (this.loadingStage == 8) {
            this.questionCanvas.purgeResources();
            if (this.progressCanvas != null) {
                this.progressCanvas.purgeResources();
            }
            this.settingsCanvas.purgeResources();
            System.gc();
            if (this.helpCanvas == null) {
                this.helpCanvas = new HelpCanvas(this);
            }
            this.helpCanvas.loadResources();
            this.helpCanvas.resetScrolling();
            this.masterCanvas.setCanvas(this.helpCanvas, 3);
            return;
        }
        if (this.loadingStage == 7) {
            this.questionCanvas.purgeResources();
            if (this.progressCanvas != null) {
                this.progressCanvas.purgeResources();
            }
            if (this.helpCanvas != null) {
                this.helpCanvas.purgeResources();
            }
            System.gc();
            this.settingsCanvas.loadResources();
            this.masterCanvas.setCanvas(this.settingsCanvas, 3);
        }
    }

    public void startNewGame(int n) {
        if (n == 0) {
            this.doLoadingStage(2, true);
            return;
        }
        this.doLoadingStage(3, true);
    }

    public void resumeGame() {
        this.doLoadingStage(4, true);
    }

    public void displayMainMenu() {
        this.masterCanvas.setCanvas(this.menuCanvas, 2);
    }

    public void displayProgress() {
        this.doLoadingStage(6, this.progressCanvas == null || !this.progressCanvas.resourcesLoaded);
    }

    public void displayHelp() {
        this.doLoadingStage(8, this.helpCanvas == null || !this.helpCanvas.resourcesLoaded);
    }

    public void displaySettings() {
        this.doLoadingStage(7, this.settingsCanvas == null || !this.settingsCanvas.resourcesLoaded);
    }

    public void loadNextQuestionSet() {
        this.doLoadingStage(5, true);
    }

    public void displayLoading(boolean bl) {
        this.masterCanvas.displaySpinner(bl);
    }

    public void resetProgress() {
        QuizDB.resetProgress();
        this.questionCanvas.resetGame();
    }

    public boolean canResumeGame() {
        return this.questionCanvas.canResume();
    }

    public void exitApplication() {
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public void splashScreenCleared() {
        this.doLoadingStage(1, true);
    }

    public void destroyApp(boolean bl) {
        if (this.questionCanvas != null) {
            this.questionCanvas.saveState();
        }
        QuestionsDB.saveState();
        QuizDB.saveState();
        if (this.settingsCanvas != null) {
            this.settingsCanvas.saveSettings();
        }
        if (this.masterCanvas != null) {
            this.masterCanvas.stop();
        }
        GameRes.stopSounds();
    }

    public void startApp() {
    }

    public void pauseApp() {
        GameRes.stopSounds();
    }
}

