/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class OptionCanvas
extends Canvas
implements Runnable {
    public static int NO_COMMAND = 0;
    public static int BACK_COMMAND = 1;
    public static int SELECT_COMMAND = 2;
    public static int LEFT_SOFTKEY = 3;
    public static int RIGHT_SOFTKEY = 4;
    public static int BACK_SOFTKEY = 5;
    public static final int SELECT_SINGLE = 0;
    public static final int SELECT_MULTI = 1;
    private static final int DEFAULT_COLOUR = -1;
    private static final int BACKGROUND_COLOUR = 0xFFFFFF;
    private static final int TITLE_COLOUR = 1986477;
    private static final int TEXT_COLOUR = 0;
    private static final int ANSWER_COLOUR = 0;
    private static final int ROLLOVER_TEXT_COLOUR = 0xFFFFFF;
    private static final int ROLLOVER_BG_COLOUR = 0x333333;
    private static final int SCROLL_BAR_BACKGROUND = 1986477;
    private static final int SCROLL_BAR_DRAGGER = 0xFFFFFF;
    private static final int SCROLL_INCREMENT = 30;
    private int LINE_SPACING = 2;
    private int LEFT_MARGIN = 5;
    private int TOP_MARGIN = 0;
    private int RADIO_WIDTH = 18;
    private int RADIO_HEIGHT = 12;
    private int SCROLL_BAR_WIDTH = 4;
    private int verticalPosition = 0;
    private int draggerHeight = 0;
    private int pageHeight = 0;
    private int w;
    private int h;
    private int sw;
    private int sh;
    private int selectedIndex = 0;
    private Vector checkedOptions;
    private int selectMode = 0;
    private Image radioButtonImage;
    private Image checkBoxImage;
    private Image topImage = null;
    private Image bodyImage = null;
    private Image loadingImage = null;
    private boolean displayLoading = false;
    private String body;
    private String title;
    private Vector titleLines;
    private Vector bodyLines;
    private Vector options;
    private Vector checkboxVerticalPositions;
    private int titleColour = 1986477;
    private String leftCommand = null;
    private String rightCommand = null;
    public String alertTitle;
    public String alertText;
    public boolean displayAlert = false;
    private OptionCanvasListener listener = null;
    private Image timeLimit;
    private int countdown = 0;
    private boolean doCountdown = false;
    private long countdownStartTime = 0L;
    private Thread t = null;
    private Quiz parent = null;

    public void setCommands(String l, String r) {
        this.leftCommand = l;
        this.rightCommand = r;
        this.h = l != null || r != null ? this.sh - Common.fontRenderer.getHeight() - 6 : this.sh;
    }

    public void drawCommands(Graphics g) {
        Common.drawCommands(g, this.leftCommand, this.rightCommand, this.sw, this.sh);
    }

    public void displayAlert(String title, String text) {
        this.displayAlert = true;
        this.alertTitle = title;
        this.alertText = text;
        this.repaint();
    }

    public boolean alertOnDisplay() {
        return this.displayAlert;
    }

    public void hideAlert() {
        this.displayAlert = false;
        this.repaint();
    }

    public OptionCanvas() {
        this.construct(null);
    }

    public OptionCanvas(Image img) {
        this.construct(img);
    }

    public OptionCanvas(String title, String body, Image img) {
        this.construct(img);
        this.setPageTitle(title);
        this.setText(body);
    }

    public OptionCanvas(String title, String body) {
        this.construct(null);
        this.setPageTitle(title);
        this.setText(body);
    }

    public OptionCanvas(String t, String b, String op1, String op2) {
        this.construct(null);
        this.setPageTitle(t);
        this.setText(b);
        this.addOption(op1);
        this.addOption(op2);
    }

    private void construct(Image img) {
        this.setFullScreenMode(true);
        this.loadUIImages();
        this.topImage = img;
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.selectMode = 0;
        this.selectedIndex = 0;
        this.checkedOptions = new Vector();
        this.init();
    }

    public void setOptionCanvasListener(OptionCanvasListener l) {
        this.listener = l;
    }

    private void init() {
        this.title = null;
        this.titleLines = new Vector();
        this.body = null;
        this.bodyLines = new Vector();
        this.selectedIndex = 0;
        this.options = new Vector();
        this.checkedOptions = new Vector();
        this.checkboxVerticalPositions = new Vector();
    }

    public void reset() {
        this.init();
    }

    private void measureCanvas() {
        this.verticalPosition = 0;
        this.selectedIndex = 0;
        int totalHeight = this.TOP_MARGIN;
        if (this.topImage != null) {
            totalHeight += this.topImage.getHeight();
        }
        if (this.bodyImage != null) {
            totalHeight += this.bodyImage.getHeight();
        }
        totalHeight += 3;
        totalHeight += this.titleLines.size() * (Common.titleFontRenderer.getHeight() + this.LINE_SPACING);
        totalHeight += Common.titleFontRenderer.getHeight();
        totalHeight += this.bodyLines.size() * (Common.fontRenderer.getHeight() + this.LINE_SPACING);
        if (this.options.size() > 0) {
            totalHeight += Common.fontRenderer.getHeight();
            int count = 0;
            Enumeration e = this.options.elements();
            while (e.hasMoreElements()) {
                Vector optionLines = (Vector)e.nextElement();
                this.checkboxVerticalPositions.setElementAt(new Integer(totalHeight += optionLines.size() * (Common.fontRenderer.getHeight() + this.LINE_SPACING) + this.LINE_SPACING * 2), count++);
            }
        }
        this.pageHeight = totalHeight += Common.fontRenderer.getHeight() >> 2;
        try {
            this.draggerHeight = (this.h - 2) * 100 / (this.pageHeight * 100 / (this.h - 2));
            if (this.draggerHeight > this.h - 2) {
                this.draggerHeight = this.sh - 2;
            }
        }
        catch (Exception e) {
            this.draggerHeight = this.h >> 1;
        }
        if (this.isShown()) {
            this.repaint();
        }
    }

    public void setOption(int optionNo, String optionStr) throws ArrayIndexOutOfBoundsException {
        this.options.setElementAt(optionStr.trim(), optionNo);
        this.measureCanvas();
    }

    public void addOption(String optionStr) {
        this.options.addElement(FontRenderer.splitString("\n", Common.fontRenderer.wrapString(optionStr, this.w - this.LEFT_MARGIN - this.RADIO_WIDTH - this.SCROLL_BAR_WIDTH)));
        this.checkboxVerticalPositions.addElement(new Integer(0));
        this.checkedOptions.addElement(new Boolean(false));
        this.measureCanvas();
    }

    public void removeAllOptions() {
        this.options = new Vector();
        this.checkboxVerticalPositions = new Vector();
        this.checkedOptions = new Vector();
        this.selectedIndex = 0;
        this.measureCanvas();
    }

    public void setText(String txt) {
        if (txt == null) {
            this.bodyLines = new Vector();
        } else {
            String tmpBody = txt.trim();
            this.body = "";
            boolean processing = true;
            int idx = -1;
            int beginIndex = 0;
            while (processing) {
                idx = tmpBody.indexOf("\\n", beginIndex);
                if (idx == -1) {
                    this.body = this.body + tmpBody.substring(beginIndex);
                    processing = false;
                    continue;
                }
                this.body = this.body + tmpBody.substring(beginIndex, idx);
                this.body = this.body + '\n';
                beginIndex = idx + 2;
            }
            this.bodyLines = FontRenderer.splitString("\n", Common.fontRenderer.wrapString(this.body, this.w - this.LEFT_MARGIN * 2 - this.SCROLL_BAR_WIDTH));
        }
        this.measureCanvas();
    }

    public void setImage(Image img) {
        this.topImage = img;
        this.measureCanvas();
    }

    public void setPageTitle(String t) {
        if (t == null) {
            this.titleLines = new Vector();
        } else {
            this.title = t.trim();
            this.titleLines = FontRenderer.splitString("\n", Common.titleFontRenderer.wrapString(this.title, this.w - this.LEFT_MARGIN - this.SCROLL_BAR_WIDTH));
        }
        this.measureCanvas();
    }

    public void setPageTitleColour(int newcol) {
        this.titleColour = newcol == -1 ? 1986477 : newcol;
    }

    public void setBodyImage(Image img) {
        this.bodyImage = img;
        this.measureCanvas();
    }

    public void setSelectMode(int mode) {
        this.selectMode = mode;
        if (this.selectMode > 1) {
            this.selectMode = 0;
        }
    }

    public int getSelectMode() {
        return this.selectMode;
    }

    public int getCheckedOption() {
        int count = 0;
        Enumeration e = this.checkedOptions.elements();
        while (e.hasMoreElements()) {
            if (((Boolean)e.nextElement()).booleanValue()) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    public int getSelectedIndex() {
        return this.getCheckedOption();
    }

    public boolean[] getCheckedOptions() {
        boolean[] ret = new boolean[this.checkedOptions.size()];
        int count = 0;
        Enumeration e = this.checkedOptions.elements();
        while (e.hasMoreElements()) {
            ret[count++] = (Boolean)e.nextElement();
        }
        return ret;
    }

    public void setCheckedOption(int opt, boolean val) throws ArrayIndexOutOfBoundsException {
        if (this.selectMode == 0) {
            int currentChecked;
            if (val && (currentChecked = this.getCheckedOption()) > 0) {
                this.checkedOptions.setElementAt(new Boolean(false), currentChecked);
            }
            this.checkedOptions.setElementAt(new Boolean(val), opt);
        } else {
            this.checkedOptions.setElementAt(new Boolean(val), opt);
        }
    }

    public void setSelectedIndex(int opt) throws ArrayIndexOutOfBoundsException {
        this.setCheckedOption(opt, true);
    }

    private void loadUIImages() {
        try {
            this.radioButtonImage = Image.createImage((String)"/ui_radio.png");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unable to load: /ui_radio.png");
        }
        try {
            this.checkBoxImage = Image.createImage((String)"/ui_check.png");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unable to load: /ui_check.png");
        }
        try {
            this.loadingImage = Image.createImage((String)"/ui_loading.png");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unable to load: /ui_loading.png");
        }
    }

    private void renderPage(Graphics g) {
        Enumeration enumeration;
        int lineY = this.TOP_MARGIN + this.verticalPosition;
        if (this.topImage != null) {
            if (lineY + this.topImage.getHeight() > 0) {
                g.drawImage(this.topImage, 0, lineY, 0x10 | 4);
            }
            lineY += this.topImage.getHeight();
        }
        lineY += 3;
        if (this.doCountdown) {
            int countdownX = this.w - this.LEFT_MARGIN - 32 - 2;
            g.setClip(countdownX, lineY - 7, 32, 45);
            g.drawImage(this.timeLimit, this.w - this.LEFT_MARGIN - 32 - 2 - this.countdown * 32, lineY - 7, 0x10 | 4);
            g.setClip(0, 0, this.w, this.h);
        }
        if (this.titleLines.size() > 0) {
            enumeration = this.titleLines.elements();
            while (enumeration.hasMoreElements()) {
                String currentLine = (String)enumeration.nextElement();
                if (lineY + Common.titleFontRenderer.getHeight() > 0 && lineY < this.h) {
                    Common.titleFontRenderer.drawString(g, currentLine, this.LEFT_MARGIN, lineY);
                }
                lineY += Common.titleFontRenderer.getHeight() + this.LINE_SPACING;
            }
        }
        lineY += Common.titleFontRenderer.getHeight();
        if (this.bodyImage != null) {
            if (lineY + this.bodyImage.getHeight() > 0) {
                g.drawImage(this.bodyImage, this.LEFT_MARGIN, lineY, 0x10 | 4);
            }
            lineY += this.bodyImage.getHeight() + 3;
        }
        if (this.bodyLines.size() > 0) {
            enumeration = this.bodyLines.elements();
            while (enumeration.hasMoreElements()) {
                String currentLine = (String)enumeration.nextElement();
                if (lineY + Common.fontRenderer.getHeight() > 0 && lineY + Common.fontRenderer.getHeight() < this.h) {
                    Common.fontRenderer.drawString(g, currentLine, this.LEFT_MARGIN, lineY);
                }
                lineY += Common.fontRenderer.getHeight() + this.LINE_SPACING;
            }
        }
        if (this.options.size() > 0) {
            int radioOffset = 0;
            if (Common.fontRenderer.getHeight() + this.LINE_SPACING > this.RADIO_HEIGHT) {
                radioOffset = (Common.fontRenderer.getHeight() + this.LINE_SPACING - this.RADIO_HEIGHT) / 2;
            }
            lineY += Common.fontRenderer.getHeight();
            boolean drawnRadio = false;
            int optionNumber = 0;
            enumeration = this.options.elements();
            while (enumeration.hasMoreElements()) {
                Vector optionLines = (Vector)enumeration.nextElement();
                if (this.selectedIndex == optionNumber) {
                    g.setColor(0x333333);
                    g.fillRect(1, lineY - 3, this.w - 2, optionLines.size() * (Common.fontRenderer.getHeight() + this.LINE_SPACING) + 6);
                    g.setClip(this.LEFT_MARGIN, lineY + radioOffset, this.RADIO_HEIGHT, this.RADIO_HEIGHT);
                    if (this.selectMode == 0) {
                        if (((Boolean)this.checkedOptions.elementAt(optionNumber)).booleanValue()) {
                            g.drawImage(this.radioButtonImage, this.LEFT_MARGIN - 3 * this.RADIO_HEIGHT, lineY + radioOffset, 0x10 | 4);
                        } else {
                            g.drawImage(this.radioButtonImage, this.LEFT_MARGIN - 2 * this.RADIO_HEIGHT, lineY + radioOffset, 0x10 | 4);
                        }
                    } else if (((Boolean)this.checkedOptions.elementAt(optionNumber)).booleanValue()) {
                        g.drawImage(this.checkBoxImage, this.LEFT_MARGIN - 3 * this.RADIO_HEIGHT, lineY + radioOffset, 0x10 | 4);
                    } else {
                        g.drawImage(this.checkBoxImage, this.LEFT_MARGIN - 2 * this.RADIO_HEIGHT, lineY + radioOffset, 0x10 | 4);
                    }
                } else {
                    g.setClip(this.LEFT_MARGIN, lineY + radioOffset, this.RADIO_HEIGHT, this.RADIO_HEIGHT);
                    if (this.selectMode == 0) {
                        if (((Boolean)this.checkedOptions.elementAt(optionNumber)).booleanValue()) {
                            g.drawImage(this.radioButtonImage, this.LEFT_MARGIN - this.RADIO_HEIGHT, lineY + radioOffset, 0x10 | 4);
                        } else {
                            g.drawImage(this.radioButtonImage, this.LEFT_MARGIN, lineY + radioOffset, 0x10 | 4);
                        }
                    } else if (((Boolean)this.checkedOptions.elementAt(optionNumber)).booleanValue()) {
                        g.drawImage(this.checkBoxImage, this.LEFT_MARGIN - this.RADIO_HEIGHT, lineY + radioOffset, 0x10 | 4);
                    } else {
                        g.drawImage(this.checkBoxImage, this.LEFT_MARGIN, lineY + radioOffset, 0x10 | 4);
                    }
                }
                g.setClip(0, 0, this.w, this.h);
                Enumeration enumerationLines = optionLines.elements();
                while (enumerationLines.hasMoreElements()) {
                    String currentLine = (String)enumerationLines.nextElement();
                    if (lineY + Common.fontRenderer.getHeight() > 0 && lineY < this.h) {
                        if (this.selectedIndex == optionNumber) {
                            Common.inverseFontRenderer.drawString(g, currentLine, this.LEFT_MARGIN + this.RADIO_WIDTH, lineY + 2);
                        } else {
                            Common.fontRenderer.drawString(g, currentLine, this.LEFT_MARGIN + this.RADIO_WIDTH, lineY + 2);
                        }
                    }
                    lineY += Common.fontRenderer.getHeight() + this.LINE_SPACING;
                }
                lineY += this.LINE_SPACING * 2;
                ++optionNumber;
            }
        }
    }

    public void paint(Graphics g) {
        this.setFullScreenMode(true);
        this.sw = this.getWidth();
        this.sh = this.getHeight();
        this.h = this.leftCommand != null || this.rightCommand != null ? this.sh - Common.fontRenderer.getHeight() - 6 : this.sh;
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.sw, this.sh);
        int percentageDown = 0;
        int dragY = 0;
        if (this.verticalPosition < 0) {
            try {
                percentageDown = 100000 / (this.pageHeight - this.h) * Math.abs(this.verticalPosition) / 1000;
                dragY = (this.h - this.draggerHeight) * 10000 / 100 * percentageDown / 10000;
            }
            catch (Exception e) {
                percentageDown = 0;
                dragY = 0;
            }
            if (percentageDown > 98) {
                dragY = this.h - this.draggerHeight - 2;
            }
            if (dragY + this.draggerHeight >= this.h - 3) {
                this.verticalPosition = -(this.pageHeight - this.h);
                dragY = this.h - this.draggerHeight - 2;
            }
        } else if (this.draggerHeight > this.h - 2) {
            this.draggerHeight = this.h - 2;
        }
        this.renderPage(g);
        g.setClip(0, 0, this.w, this.h);
        if (this.displayLoading) {
            g.drawImage(this.loadingImage, this.w - this.loadingImage.getWidth() - this.SCROLL_BAR_WIDTH - 1, 1, 0x10 | 4);
        }
        g.setColor(1986477);
        g.fillRect(this.w - this.SCROLL_BAR_WIDTH, 0, this.SCROLL_BAR_WIDTH, this.h);
        g.setColor(0xFFFFFF);
        g.fillRect(this.w - this.SCROLL_BAR_WIDTH + 1, dragY + 1, this.SCROLL_BAR_WIDTH - 2, this.draggerHeight);
        g.setClip(0, 0, this.w, this.sh);
        g.setColor(0xD0D0D0);
        g.fillRect(0, this.h, this.w, this.sh - this.h);
        if (this.displayAlert) {
            Common.drawAlert(g, this.alertTitle, this.alertText, this.sw, this.h);
            Common.drawCommands(g, null, Strings.CMD_OK, this.sw, this.getHeight());
        } else {
            this.drawCommands(g);
        }
    }

    protected void keyPressed(int keyCode) {
        if (!this.displayLoading) {
            this.handleScrolling(keyCode);
        }
    }

    protected void keyRepeated(int keyCode) {
        if (!this.displayLoading) {
            this.handleScrolling(keyCode);
        }
    }

    protected void handleScrolling(int keyCode) {
        int ga;
        if (Common.isLSK(keyCode)) {
            if (this.listener != null) {
                this.listener.optionCanvasAction(this, LEFT_SOFTKEY);
                return;
            }
        } else {
            if (Common.isRSK(keyCode)) {
                if (this.listener != null) {
                    this.listener.optionCanvasAction(this, RIGHT_SOFTKEY);
                }
                return;
            }
            if (Common.isBackKey(keyCode) && this.listener != null) {
                this.listener.optionCanvasAction(this, BACK_SOFTKEY);
                return;
            }
        }
        if ((ga = this.getGameAction(keyCode)) == 6 || keyCode == 56) {
            if (this.selectedIndex < this.options.size() - 1) {
                if (this.pageHeight <= this.h || Math.abs(this.verticalPosition) == Math.abs(this.pageHeight - this.h)) {
                    ++this.selectedIndex;
                } else {
                    this.verticalPosition -= 30;
                    this.checkConstraints();
                    if ((Integer)this.checkboxVerticalPositions.elementAt(this.selectedIndex + 1) - Math.abs(this.verticalPosition) < this.h >> 1 || (Integer)this.checkboxVerticalPositions.elementAt(this.selectedIndex) - Math.abs(this.verticalPosition) < 0) {
                        ++this.selectedIndex;
                    }
                }
            } else {
                this.verticalPosition -= 30;
                this.checkConstraints();
            }
            this.repaint();
        } else if (ga == 1 || keyCode == 50) {
            if (this.selectedIndex > 0) {
                if (this.pageHeight <= this.h || Math.abs(this.verticalPosition) == Math.abs(this.pageHeight - this.h)) {
                    --this.selectedIndex;
                    if ((Integer)this.checkboxVerticalPositions.elementAt(this.selectedIndex) - Math.abs(this.verticalPosition) < 10) {
                        this.verticalPosition += 30;
                        this.checkConstraints();
                    }
                } else {
                    this.verticalPosition += 30;
                    this.checkConstraints();
                    if ((Integer)this.checkboxVerticalPositions.elementAt(this.selectedIndex - 1) - Math.abs(this.verticalPosition) >= 10) {
                        --this.selectedIndex;
                    }
                }
            } else {
                this.verticalPosition += 30;
                this.checkConstraints();
            }
            this.repaint();
        } else if (ga == 8 || keyCode == 53) {
            if (this.options.size() > 0) {
                this.manualSelect();
                if (this.listener != null) {
                    this.listener.optionCanvasAction(this, SELECT_COMMAND);
                }
            }
        } else if (ga == 2 || keyCode == 52) {
            if (this.listener != null) {
                this.listener.optionCanvasAction(this, BACK_COMMAND);
            }
        } else if (this.listener != null) {
            this.listener.optionCanvasAction(this, keyCode);
        }
    }

    public void manualSelect() {
        if (this.selectMode == 0) {
            int checkedOption = this.getCheckedOption();
            if (checkedOption >= 0) {
                this.checkedOptions.setElementAt(new Boolean(false), this.getCheckedOption());
            }
            this.checkedOptions.setElementAt(new Boolean(true), this.selectedIndex);
        } else if (((Boolean)this.checkedOptions.elementAt(this.selectedIndex)).booleanValue()) {
            this.checkedOptions.setElementAt(new Boolean(false), this.selectedIndex);
        } else {
            this.checkedOptions.setElementAt(new Boolean(true), this.selectedIndex);
        }
        this.repaint();
    }

    protected void checkConstraints() {
        if (this.pageHeight <= this.h) {
            this.verticalPosition = 0;
            return;
        }
        if (this.verticalPosition > 0) {
            this.verticalPosition = 0;
        }
        if (Math.abs(this.verticalPosition) > Math.abs(this.pageHeight - this.h)) {
            this.verticalPosition = -(this.pageHeight - this.h);
        }
    }

    public void resetScrolling() {
        this.verticalPosition = 0;
        this.selectedIndex = 0;
        this.repaint();
    }

    public void setLoading(boolean val) {
        this.displayLoading = val;
        if (this.loadingImage == null) {
            this.displayLoading = false;
        }
        this.repaint();
    }

    public void displayCountdown(boolean v) {
        this.doCountdown = v;
        try {
            if (this.timeLimit == null) {
                this.timeLimit = Image.createImage((String)"/countdown.png");
            }
        }
        catch (Exception e) {
            System.out.println("Unable to load timer image");
        }
    }

    public void resetCountdown() {
        this.countdown = 0;
    }

    public void startCountdown() {
        if (this.t == null && this.doCountdown) {
            this.t = new Thread(this);
            this.t.start();
        }
        this.countdownStartTime = System.currentTimeMillis();
    }

    public void stopCountdown() {
        this.t = null;
    }

    public void run() {
        Thread myThread = Thread.currentThread();
        while (this.t == myThread) {
            try {
                this.repaint();
                this.serviceRepaints();
                Thread.sleep(60L);
                if (this.countdown >= 10) continue;
                this.countdown = (int)((System.currentTimeMillis() - this.countdownStartTime) / 1200L);
                if (this.countdown < 10) continue;
                this.parent.ontoNextQuestion();
            }
            catch (Exception exception) {}
        }
    }

    public void setParent(Quiz p) {
        this.parent = p;
    }
}

