/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class SoundManager
implements Runnable,
PlayerListener {
    public static final int LOOP_FOREVER = -1;
    public static final String NONE = "uninitialized";
    public static final String STARTED = "started";
    public static final String STOPPED = "stopped";
    public static final String END_OF_MEDIA = "endOfMedia";
    public static final String DEVICE_UNAVAILABLE = "deviceUnavailable";
    public static final String DEVICE_AVAILABLE = "deviceAvailable";
    public static final String ERROR = "deviceAvailable";
    public static final String CLOSED = "deviceAvailable";
    public static final String VOLUME_CHANGED = "volumeChanged";
    private String currentState = "uninitialized";
    public String errLog = "";
    private String cachedSoundRes = "";
    private String cachedSoundMimeType = "";
    private String soundRes = "";
    private String soundMimeType = "audio/x-wav";
    private boolean preCacheSound = false;
    private boolean garbageCollectAfterDeAlloc = true;
    private Player p = null;
    private Thread t = null;
    private int playerVolume = 100;
    private boolean volumeControlEnabled = false;
    private int soundLoopCount = 1;
    private boolean playerListenerEnabled = false;
    private boolean waitForEndOfMedia = false;
    private boolean logState = false;
    private String statelog = "";
    private long logStartTime = 0L;

    public boolean playSound(String r, String mimeType) {
        return this.playSound(r, mimeType, 1);
    }

    public boolean playSound(String r, String mimeType, int loopCount) {
        if (this.playerListenerEnabled && this.waitForEndOfMedia && (this.currentState.equals(STARTED) || this.currentState.equals(DEVICE_UNAVAILABLE))) {
            return false;
        }
        String testMime = this.checkMimeTypes(mimeType);
        if (testMime != null) {
            this.soundRes = r;
            this.soundMimeType = testMime;
            this.soundLoopCount = loopCount;
            this.killPlayer(false);
            this.t = new Thread(this);
            this.t.start();
            return true;
        }
        System.out.println("Unsupported mime-type: " + mimeType);
        return false;
    }

    public boolean forcePlaySound(String r, String mimeType) {
        return this.forcePlaySound(r, mimeType, 1);
    }

    public boolean forcePlaySound(String r, String mimeType, int loopCount) {
        if (this.playerListenerEnabled && this.waitForEndOfMedia && (this.currentState.equals(STARTED) || this.currentState.equals(DEVICE_UNAVAILABLE))) {
            return false;
        }
        String testMime = this.checkMimeTypes(mimeType);
        if (testMime != null) {
            this.soundRes = r;
            this.soundMimeType = testMime;
            this.soundLoopCount = loopCount;
            this.killPlayer(true);
            this.t = new Thread(this);
            this.t.start();
            return true;
        }
        System.out.println("Unsupported mime-type: " + mimeType);
        return false;
    }

    public boolean cacheSound(String r, String mimeType) {
        this.preCacheSound = true;
        return this.playSound(r, mimeType, 1);
    }

    public boolean cacheSound(String r, String mimeType, int loopCount) {
        this.preCacheSound = true;
        return this.playSound(r, mimeType, loopCount);
    }

    public boolean stopSound() {
        return this.killPlayer(true);
    }

    public void purgeResources() {
        this.stopSound();
    }

    public void run() {
        block19: {
            try {
                if (this.preCacheSound) {
                    if (!this.soundRes.equals(this.cachedSoundRes)) {
                        this.createPlayer();
                        this.p.realize();
                        if (this.volumeControlEnabled && this.playerVolume != 100) {
                            System.out.println("Setting Volume to " + this.playerVolume);
                            try {
                                VolumeControl vol = (VolumeControl)this.p.getControl("javax.microedition.media.control.VolumeControl");
                                vol.setLevel(this.playerVolume);
                            }
                            catch (Exception e) {
                                System.out.println("Unable to set volume: " + e.toString());
                            }
                        }
                        this.p.prefetch();
                    }
                    this.preCacheSound = false;
                    break block19;
                }
                if (this.soundRes.equals(this.cachedSoundRes)) {
                    if (this.volumeControlEnabled && this.playerVolume != 100) {
                        System.out.println("Setting Volume to " + this.playerVolume);
                        try {
                            VolumeControl vol = (VolumeControl)this.p.getControl("javax.microedition.media.control.VolumeControl");
                            vol.setLevel(this.playerVolume);
                        }
                        catch (Exception e) {
                            System.out.println("Unable to set volume: " + e.toString());
                        }
                    }
                    if (this.cachedSoundMimeType.equals("audio/midi") || this.cachedSoundMimeType.equals("audio/mid")) {
                        try {
                            this.p.setMediaTime(-1L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    this.p.start();
                    break block19;
                }
                this.createPlayer();
                this.p.realize();
                if (this.volumeControlEnabled && this.playerVolume != 100) {
                    System.out.println("Setting Volume to " + this.playerVolume);
                    try {
                        VolumeControl vol = (VolumeControl)this.p.getControl("javax.microedition.media.control.VolumeControl");
                        vol.setLevel(this.playerVolume);
                    }
                    catch (Exception e) {
                        System.out.println("Unable to set volume: " + e.toString());
                    }
                }
                this.p.start();
            }
            catch (Exception e) {
                System.out.println("SoundManager.run(): " + e.toString());
                if (this.p == null) break block19;
                try {
                    this.p.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this.p.deallocate();
                this.p.close();
                this.p = null;
                if (!this.garbageCollectAfterDeAlloc) break block19;
                System.gc();
            }
        }
    }

    private void createPlayer() {
        block7: {
            try {
                if (this.logState) {
                    this.statelog = this.statelog + "-- createPlayer --\n";
                    this.statelog = this.statelog + this.soundRes + "\n";
                    this.statelog = this.statelog + this.soundMimeType + "\n";
                    this.statelog = this.statelog + "--------------------\n";
                }
                InputStream is = this.getClass().getResourceAsStream(this.soundRes);
                this.p = Manager.createPlayer((InputStream)is, (String)this.soundMimeType);
                if (this.playerListenerEnabled) {
                    this.p.addPlayerListener((PlayerListener)this);
                }
                if (this.soundLoopCount != 0 && this.soundLoopCount != 1) {
                    this.p.setLoopCount(this.soundLoopCount);
                }
                this.cachedSoundRes = this.soundRes;
                this.cachedSoundMimeType = this.soundMimeType;
            }
            catch (Exception e) {
                System.out.println("SoundManager.createPlayer(): " + e.toString());
                if (this.p == null) break block7;
                try {
                    this.p.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this.p.deallocate();
                this.p.close();
                this.p = null;
                if (!this.garbageCollectAfterDeAlloc) break block7;
                System.gc();
            }
        }
    }

    private boolean killPlayer(boolean forcePurge) {
        try {
            if (this.playerListenerEnabled && this.waitForEndOfMedia && (this.currentState.equals(STARTED) || this.currentState.equals(DEVICE_UNAVAILABLE))) {
                return false;
            }
            if (this.p != null && (!this.soundRes.equals(this.cachedSoundRes) || forcePurge)) {
                try {
                    this.p.stop();
                }
                catch (MediaException me) {
                    // empty catch block
                }
                this.p.deallocate();
                this.p.close();
                this.p = null;
                this.cachedSoundRes = "";
                this.cachedSoundMimeType = "";
                if (this.garbageCollectAfterDeAlloc) {
                    System.gc();
                }
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            System.out.println("SoundManager.killPlayer(): " + ex.toString());
            return false;
        }
    }

    public String checkMimeTypes(String mime) {
        int i;
        mime = mime.toLowerCase().trim();
        String[] contentTypes = Manager.getSupportedContentTypes(null);
        for (i = 0; i < contentTypes.length; ++i) {
            if (!mime.equals(contentTypes[i])) continue;
            return contentTypes[i];
        }
        for (i = 0; i < contentTypes.length; ++i) {
            if (!(mime.equals("audio/mpeg") || mime.equals("audio/mp3") ? contentTypes[i].equals("audio/mpeg") || contentTypes[i].equals("audio/mp3") || contentTypes[i].equals("audio/mpeg3") || contentTypes[i].equals("audio/x-mpeg") : (mime.equals("audio/x-wav") ? contentTypes[i].equals("audio/wav") : (mime.equals("audio/midi") ? contentTypes[i].equals("audio/mid") || contentTypes[i].equals("audio/x-midi") : (mime.equals("audio/x-smaf") ? contentTypes[i].equals("audio/mmf") || contentTypes[i].equals("audio/x-mmf") || contentTypes[i].equals("application/x-smaf") || contentTypes[i].equals("application/x-smaf-audio") || contentTypes[i].equals("application/vnd.smaf") : (mime.equals("application/x-smaf-audio") || mime.equals("application/x-smaf-phrase") ? contentTypes[i].equals("audio/mmf") || contentTypes[i].equals("audio/x-mmf") || contentTypes[i].equals("audio/x-smaf") : !(!mime.equals("audio/m4a") && !mime.equals("audio/aac") || !contentTypes[i].equals("audio/aac") && !contentTypes[i].equals("audio/m4a") && !contentTypes[i].equals("audio/mp4")))))))) continue;
            return contentTypes[i];
        }
        return null;
    }

    public boolean supportsVolume(String res, String mime) {
        boolean ret = false;
        try {
            InputStream is = this.getClass().getResourceAsStream(res);
            Player tmpPlayer = Manager.createPlayer((InputStream)is, (String)mime);
            tmpPlayer.realize();
            VolumeControl vol = (VolumeControl)tmpPlayer.getControl("javax.microedition.media.control.VolumeControl");
            vol.setLevel(this.playerVolume);
            ret = true;
            try {
                tmpPlayer.stop();
            }
            catch (MediaException me) {
                // empty catch block
            }
            tmpPlayer.deallocate();
            tmpPlayer.close();
            tmpPlayer = null;
            vol = null;
            System.gc();
        }
        catch (MediaException me) {
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    public void enableVolumeControl(boolean v) {
        this.volumeControlEnabled = v;
    }

    public void enableVolumeControl() {
        this.volumeControlEnabled = true;
    }

    public void disableVolumeControl() {
        this.volumeControlEnabled = false;
    }

    public void setVolume(int v) {
        if (v > 100) {
            v = 100;
        }
        if (v < 0) {
            v = 0;
        }
        this.playerVolume = v;
    }

    public int getVolume() {
        return this.playerVolume;
    }

    public void playerUpdate(Player ply, String state, Object obj) {
        this.currentState = state;
        if (this.logState) {
            this.statelog = this.statelog + state + " @ " + (System.currentTimeMillis() - this.logStartTime) + "ms\n";
        }
        System.out.println("SoundManager.currentState = " + state);
    }

    public String getState() {
        return this.currentState;
    }

    public boolean getState(String s) {
        return this.currentState.equals(s);
    }

    public String getStateLog() {
        return this.statelog;
    }

    public void startStateLogging() {
        this.statelog = "";
        this.logState = true;
        this.logStartTime = System.currentTimeMillis();
    }

    public void stopStateLogging() {
        this.logState = false;
    }

    public void disablePlayerListener() {
        this.playerListenerEnabled = false;
    }

    public void enablePlayerListener() {
        this.playerListenerEnabled = true;
    }

    public void enableWaitForEndOfMedia() {
        this.waitForEndOfMedia = true;
    }

    public void disableWaitForEndOfMedia() {
        this.waitForEndOfMedia = false;
    }
}

