/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;

public class RecordManager {
    public static void save(byte[] arr, String name) {
        RecordStore recstor = null;
        try {
            recstor = RecordStore.openRecordStore((String)name, (boolean)true);
            recstor.setRecord(1, arr, 0, arr.length);
            recstor.closeRecordStore();
        }
        catch (InvalidRecordIDException idex) {
            try {
                recstor = RecordStore.openRecordStore((String)name, (boolean)true);
                recstor.addRecord(arr, 0, arr.length);
                recstor.closeRecordStore();
            }
            catch (Exception e) {
                try {
                    recstor.closeRecordStore();
                }
                catch (Exception ee) {
                    System.out.println(e.toString());
                }
            }
        }
        catch (Exception eee) {
            System.out.println(eee.toString());
        }
    }

    public static void save(int intval, String name) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeInt(intval);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        RecordManager.save(baos.toByteArray(), name);
    }

    public static void save(long longval, String name) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeLong(longval);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        RecordManager.save(baos.toByteArray(), name);
    }

    public static void save(String strval, String name) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            os.writeUTF(strval);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        RecordManager.save(baos.toByteArray(), name);
    }

    public static byte[] load(String name) {
        byte[] data = null;
        RecordStore recstor = null;
        try {
            recstor = RecordStore.openRecordStore((String)name, (boolean)true);
            if (recstor.getNumRecords() > 0) {
                data = recstor.getRecord(1);
            }
            recstor.closeRecordStore();
        }
        catch (Exception e) {
            try {
                recstor.closeRecordStore();
            }
            catch (Exception ee) {
                System.out.println(e.toString());
            }
        }
        return data;
    }

    public static void delete(String name) {
        try {
            RecordStore.deleteRecordStore((String)name);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public static boolean exists(String name) {
        String[] recStores = RecordStore.listRecordStores();
        if (recStores == null) {
            return false;
        }
        for (int i = 0; i < recStores.length; ++i) {
            if (!recStores[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public static int byteArrayToInt(byte[] arr) {
        if (arr == null) {
            return 0;
        }
        if (arr.length < 4) {
            return 0;
        }
        int val = 0;
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(arr));
        try {
            val = is.readInt();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return val;
    }

    public static long byteArrayToLong(byte[] arr) {
        if (arr == null) {
            return 0L;
        }
        if (arr.length < 8) {
            return 0L;
        }
        long val = 0L;
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(arr));
        try {
            val = is.readLong();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return val;
    }

    public static String byteArrayToString(byte[] arr) {
        if (arr == null) {
            return "";
        }
        String val = "";
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(arr));
        try {
            val = is.readUTF();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return val;
    }
}

