/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.physicsquiz;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.handyx.api.GMG;
import net.handyx.api.RecordManager;
import net.handyx.api.RunnableCanvas;
import net.handyx.physicsquiz.GameRes;
import net.handyx.physicsquiz.MenuCanvas;
import net.handyx.physicsquiz.Quiz;
import net.handyx.physicsquiz.Strings;

public class SettingsCanvas
extends RunnableCanvas {
    private int a = 30;
    private int b = 10;
    private int c = 4;
    private Quiz d;
    public static Image settingsTitleImage;
    public boolean resourcesLoaded = false;
    private int[] e = new int[Strings.OPTIONS_MENU_ITEM_DEFAULT.length];
    public int selectedIndex = 0;

    public SettingsCanvas(Quiz quiz) {
        this.d = quiz;
        for (int i = 0; i < this.e.length; ++i) {
            this.e[i] = Strings.OPTIONS_MENU_ITEM_DEFAULT[i];
        }
    }

    public void loadResources() {
        if (this.resourcesLoaded) {
            return;
        }
        settingsTitleImage = SettingsCanvas.loadImage("/settings_title.png");
        this.resourcesLoaded = true;
    }

    public void purgeResources() {
        settingsTitleImage = null;
        this.resourcesLoaded = false;
    }

    public void processFrame(int n) {
        GameRes.processToasts();
    }

    public void paintCanvas(Graphics graphics, int n, int n2) {
        if (!this.resourcesLoaded) {
            return;
        }
        graphics.setColor(204);
        graphics.fillRect(0, 0, n, n2);
        if (n2 < GameRes.bgImage.getHeight()) {
            graphics.drawImage(GameRes.bgImage, 0, 0, 20);
        } else {
            graphics.drawImage(GameRes.bgImage, 0, n2 - GameRes.bgImage.getHeight(), 20);
        }
        graphics.drawImage(settingsTitleImage, 0, 0, 20);
        int n3 = settingsTitleImage.getHeight() + this.c;
        int n4 = this.a - GameRes.gameFont.getHeight() >> 1;
        for (int i = 0; i < Strings.OPTIONS_MENU_ITEMS.length; ++i) {
            if (this.selectedIndex == i) {
                graphics.setClip(0, n3, n, this.a);
                graphics.drawImage(MenuCanvas.menuSelectedImage, 0, n3, 20);
                graphics.setClip(0, 0, n, n2);
            }
            GameRes.gameFont.drawString(graphics, Strings.OPTIONS_MENU_ITEMS[i], this.b, n3 + n4);
            String string = Strings.OPTIONS_MENU_ITEM_SETTINGS[i][this.e[i]];
            int n5 = n - this.b - GameRes.gameFont.stringWidth(string);
            GameRes.gameFont.drawString(graphics, string, n5, n3 + n4);
            if (i > 0 && i < Strings.MENU_ITEMS.length) {
                graphics.drawImage(MenuCanvas.menuSeparatorImage, n - MenuCanvas.menuSeparatorImage.getWidth() >> 1, n3, 20);
            }
            n3 += this.a;
        }
        graphics.drawImage(GameRes.menuBarImage, 0, n2 - GameRes.menuBarImage.getHeight(), 20);
        SettingsCanvas.drawLeftCommand(graphics, Strings.CMD_SELECT, GameRes.gameFont);
        SettingsCanvas.drawRightCommand(graphics, Strings.CMD_BACK, GameRes.gameFont);
    }

    public void keyPressedEvent(int n, int n2, int n3) {
        if (n2 == 6) {
            if (!GMG.DISPLAY_GET_MORE_GAMES_LINK && this.selectedIndex == 5) {
                this.selectedIndex += 2;
                return;
            }
            if (this.selectedIndex == Strings.OPTIONS_MENU_ITEMS.length - 1) {
                this.selectedIndex = 0;
                return;
            }
            ++this.selectedIndex;
            return;
        }
        if (n2 == 1) {
            if (!GMG.DISPLAY_GET_MORE_GAMES_LINK && this.selectedIndex == 7) {
                this.selectedIndex -= 2;
                return;
            }
            if (this.selectedIndex == 0) {
                this.selectedIndex = Strings.OPTIONS_MENU_ITEMS.length - 1;
                return;
            }
            --this.selectedIndex;
            return;
        }
        if (n2 == 8 || n3 == 1) {
            this.performMenuSelect();
            return;
        }
        if (n3 == 3 || n3 == 2) {
            this.applySettings();
            GameRes.displayToast("Modified difficulty settings will take effect when a new game is started");
            this.d.displayMainMenu();
        }
    }

    public void keyReleasedEvent(int n, int n2, int n3) {
    }

    public void pointerPressedEvent(int n, int n2) {
        n = settingsTitleImage.getHeight() + this.c;
        for (int i = 0; i < Strings.OPTIONS_MENU_ITEMS.length; ++i) {
            if (n2 >= n && n2 <= n + this.a) {
                if (this.selectedIndex == i) {
                    this.performMenuSelect();
                    return;
                }
                this.selectedIndex = i;
                return;
            }
            n += this.a;
        }
    }

    public void performMenuSelect() {
        this.changeSetting(this.selectedIndex, true);
    }

    public void changeSetting(int n, boolean bl) {
        if (bl) {
            if (this.e[n] == Strings.OPTIONS_MENU_ITEM_SETTINGS[n].length - 1) {
                this.e[n] = 0;
                return;
            }
            int n2 = n;
            this.e[n2] = this.e[n2] + 1;
            return;
        }
        if (this.e[n] == 0) {
            this.e[n] = Strings.OPTIONS_MENU_ITEM_SETTINGS[n].length - 1;
            return;
        }
        int n3 = n;
        this.e[n3] = this.e[n3] - 1;
    }

    public void loadSettings() {
        try {
            System.out.println("Loading settings");
            if (RecordManager.exists("quiz_settings")) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(RecordManager.load("quiz_settings")));
                for (int i = 0; i < this.e.length; ++i) {
                    this.e[i] = dataInputStream.readInt();
                }
            }
            this.applySettings();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void saveSettings() {
        try {
            System.out.println("Saving settings");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (int i = 0; i < this.e.length; ++i) {
                dataOutputStream.writeInt(this.e[i]);
            }
            RecordManager.save(byteArrayOutputStream.toByteArray(), "quiz_settings");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void applySettings() {
        System.out.println("Applying settings");
        GameRes.setting_sound = this.e[0] != 0;
        GameRes.setting_sound_volume = Strings.OPTIONS_MENU_ITEM_VALUES[0][this.e[0]];
        GameRes.setting_countdown = this.e[1] != 0;
        boolean bl = GameRes.setting_show_answers = this.e[2] != 0;
        if (GameRes.setting_sound) {
            GameRes.soundEnabled = true;
        }
        if (!GameRes.supportsSound()) {
            GameRes.soundEnabled = false;
        }
        System.out.println("anwers=" + GameRes.setting_show_answers);
    }
}

