/*
 * Decompiled with CFR 0.152.
 */
package net.handyx.api;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import net.handyx.api.FontRenderer;

public abstract class RunnableCanvas
extends Canvas {
    public static final int LSK = 1;
    public static final int RSK = 2;
    public static final int BACK_SK = 3;
    public static final int CLEAR_SK = 4;
    public static boolean FLIP_SOFT_KEYS = false;
    public static boolean SOFTKEYS_GENERATE_KEY_RELEASED = true;
    public static boolean DISABLE_SERVICE_REPAINTS = true;
    public static boolean ALLOW_LANDSCAPE = false;
    public static boolean USE_DOUBLE_BUFFER = false;
    public static final int[] LSK_VALUES = new int[]{-6, -21, -202, 21};
    public static final int[] RSK_VALUES = new int[]{-7, -22, -203, 22};
    public static final int[] BACK_KEY_VALUES = new int[]{-11};
    public static final int[] CLEAR_KEY_VALUES = new int[]{-8, -204};
    public boolean finishedRepainting = false;
    public boolean showNotifyCalled = false;
    private boolean a = false;
    public int pointerStartX;
    public int pointerStartY;
    public static int screenWidth = 0;
    public static int screenHeight = 0;
    private static Image b = null;

    public RunnableCanvas() {
        this.setFullScreenMode(true);
        screenWidth = this.getWidth();
        screenHeight = this.getHeight();
        if (USE_DOUBLE_BUFFER && (b == null || b.getWidth() != screenWidth || b.getHeight() != screenHeight)) {
            b = Image.createImage((int)screenWidth, (int)screenHeight);
        }
    }

    public final void showNotify() {
        if (!this.showNotifyCalled) {
            this.startNotify();
        }
        this.showNotifyCalled = true;
    }

    public final void hideNotify() {
        this.showNotifyCalled = false;
        this.stopNotify();
    }

    public final void paint(Graphics graphics) {
        if (this.getHeight() > screenHeight) {
            screenWidth = this.getWidth();
            screenHeight = this.getHeight();
        }
        if (!ALLOW_LANDSCAPE && this.getWidth() > this.getHeight()) {
            this.a = true;
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(0xFFFFFF);
            Font font = Font.getFont((int)0, (int)0, (int)8);
            graphics.setFont(font);
            graphics.drawString("Return handset to portrait mode to continue.", (this.getWidth() - font.stringWidth("Return handset to portrait mode to continue.")) / 2, (this.getHeight() - font.getHeight()) / 2, 20);
        } else if (USE_DOUBLE_BUFFER && b != null) {
            this.a = false;
            Graphics graphics2 = b.getGraphics();
            this.paintCanvas(graphics2, screenWidth, screenHeight);
            graphics.drawImage(b, 0, 0, 20);
        } else {
            this.a = false;
            this.paintCanvas(graphics, screenWidth, screenHeight);
        }
        this.finishedRepainting = true;
    }

    public void startNotify() {
    }

    public void stopNotify() {
    }

    public abstract void paintCanvas(Graphics var1, int var2, int var3);

    public void processFrame(int n) {
    }

    public void loadResources() {
    }

    public void purgeResources() {
    }

    public void keyPressedEvent(int n, int n2, int n3) {
    }

    public void keyReleasedEvent(int n, int n2, int n3) {
    }

    public void pointerPressedEvent(int n, int n2) {
    }

    public void pointerReleasedEvent(int n, int n2) {
    }

    public void pointerDraggedEvent(int n, int n2, int n3, int n4) {
    }

    public final void pointerPressed(int n, int n2) {
        if (this.a) {
            return;
        }
        this.pointerStartX = n;
        this.pointerStartY = n2;
        if (n2 > screenHeight - 30) {
            if (n > 0 && n < screenWidth >> 1) {
                this.keyPressedEvent(0, 0, 1);
                return;
            }
            this.keyPressedEvent(0, 0, 2);
            return;
        }
        this.pointerPressedEvent(n, n2);
    }

    public final void pointerReleased(int n, int n2) {
        if (this.a) {
            return;
        }
        if (n2 > screenHeight - 30) {
            if (n > 0 && n < screenWidth >> 1) {
                this.keyReleasedEvent(0, 0, 1);
                return;
            }
            this.keyReleasedEvent(0, 0, 2);
            return;
        }
        this.pointerReleasedEvent(n, n2);
    }

    public final void pointerDragged(int n, int n2) {
        this.pointerDraggedEvent(n, n2, n - this.pointerStartX, n2 - this.pointerStartY);
    }

    public final void keyPressed(int n) {
        if (this.a) {
            return;
        }
        this.a(n, true);
    }

    public final void keyReleased(int n) {
        if (this.a) {
            return;
        }
        this.a(n, false);
    }

    private final void a(int n, boolean bl) {
        int n2;
        int n3 = 0;
        try {
            n2 = this.getGameAction(n);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        switch (n) {
            case 50: {
                n2 = 1;
                break;
            }
            case 52: {
                n2 = 2;
                break;
            }
            case 53: {
                n2 = 8;
                break;
            }
            case 54: {
                n2 = 5;
                break;
            }
            case 56: {
                n2 = 6;
            }
        }
        if (n2 != 1 && n2 != 6 && n2 != 2 && n2 != 5) {
            int n4;
            for (n4 = 0; n4 < BACK_KEY_VALUES.length; ++n4) {
                if (n != BACK_KEY_VALUES[n4]) continue;
                n3 = 3;
            }
            for (n4 = 0; n4 < CLEAR_KEY_VALUES.length; ++n4) {
                if (n != CLEAR_KEY_VALUES[n4]) continue;
                n3 = 4;
            }
            for (n4 = 0; n4 < LSK_VALUES.length; ++n4) {
                if (n != LSK_VALUES[n4]) continue;
                n3 = FLIP_SOFT_KEYS ? 2 : 1;
            }
            for (n4 = 0; n4 < RSK_VALUES.length; ++n4) {
                if (n != RSK_VALUES[n4]) continue;
                n3 = FLIP_SOFT_KEYS ? 1 : 2;
            }
        }
        if (bl) {
            this.keyPressedEvent(n, n2, n3);
            return;
        }
        if (!SOFTKEYS_GENERATE_KEY_RELEASED) {
            n3 = 0;
        }
        this.keyReleasedEvent(n, n2, n3);
    }

    public static final Image loadImage(String string) {
        try {
            return Image.createImage((String)string);
        }
        catch (Exception exception) {
            System.out.println("WARNING: Unable to load image: " + string);
            return null;
        }
    }

    public static final void drawLeftCommand(Graphics graphics, String string, FontRenderer fontRenderer) {
        fontRenderer.drawString(graphics, string, 5, screenHeight - fontRenderer.getHeight() - 3);
    }

    public static final void drawRightCommand(Graphics graphics, String string, FontRenderer fontRenderer) {
        fontRenderer.drawString(graphics, string, screenWidth - 5 - fontRenderer.stringWidth(string), screenHeight - fontRenderer.getHeight() - 3);
    }

    public static void getJadParameters(MIDlet mIDlet) {
        try {
            String string = mIDlet.getAppProperty("Sprite-Flip-Softkeys");
            if (string != null && (string = string.toLowerCase().trim()).equals("true")) {
                FLIP_SOFT_KEYS = true;
            }
            if ((string = mIDlet.getAppProperty("Sprite-Allow-Landscape")) != null && (string = string.toLowerCase().trim()).equals("true")) {
                ALLOW_LANDSCAPE = true;
            }
            if ((string = mIDlet.getAppProperty("Sprite-Use-Double-Buffer")) != null && (string = string.toLowerCase().trim()).equals("true")) {
                USE_DOUBLE_BUFFER = true;
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }
}

