/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScoresCanvas
extends Canvas {
    static final int SCORE_Y = 54;
    private Image img = null;
    private boolean cleared = false;
    private Quiz home;
    private Vector strings;
    private boolean smallFont = false;
    private Quiz parent = null;
    public String leftCommand = null;
    public String rightCommand = null;
    private int backgroundColour = 0xFFFFFF;
    private int w;
    private int h;

    public ScoresCanvas() {
        this.setFullScreenMode(true);
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.strings = new Vector();
    }

    public ScoresCanvas(String string, Quiz quiz) {
        this.setFullScreenMode(true);
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.loadImage(string);
        this.home = quiz;
        this.strings = new Vector();
    }

    public void setParent(Quiz quiz) {
        this.parent = quiz;
    }

    public void setCommands(String string, String string2) {
        this.leftCommand = string;
        this.rightCommand = string2;
    }

    public void loadImage(String string) {
        try {
            this.img = Image.createImage((String)string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void smallFont(boolean bl) {
        this.smallFont = bl;
    }

    public void setImage(Image image) {
        this.img = image;
    }

    public void setBackgroundColour(int n) {
        this.backgroundColour = n;
    }

    public void paint(Graphics graphics) {
        this.setFullScreenMode(true);
        this.w = this.getWidth();
        this.h = this.getHeight();
        if (!this.cleared) {
            graphics.setColor(this.backgroundColour);
            graphics.fillRect(0, 0, this.w, this.h);
            this.cleared = true;
        }
        if (this.img != null) {
            graphics.drawImage(this.img, 0, 0, 0x10 | 4);
        }
        graphics.setColor(0xCC0000);
        Font font = Font.getFont((int)0, (int)1, (int)16);
        if (this.smallFont) {
            font = Font.getFont((int)0, (int)1, (int)0);
        }
        graphics.setFont(font);
        for (int i = 0; i < this.strings.size(); ++i) {
            String string = (String)this.strings.elementAt(i);
            Common.titleFontRenderer.drawString(graphics, string, (this.w - Common.titleFontRenderer.stringWidth(string)) / 2, 54 + (i * Common.titleFontRenderer.getHeight() + 1));
        }
        graphics.setClip(0, 0, this.w, this.h);
        graphics.setColor(0xD0D0D0);
        graphics.fillRect(0, this.h - Common.fontRenderer.getHeight() - 6, this.w, Common.fontRenderer.getHeight() + 6);
        Common.drawCommands(graphics, this.leftCommand, this.rightCommand, this.w, this.h);
    }

    protected void hideNotify() {
        this.cleared = false;
    }

    public void setText(String string) {
        this.strings = ScoresCanvas.splitString(string);
    }

    public static Vector splitString(String string) {
        Vector<String> vector = new Vector<String>();
        int n = string.trim().length();
        for (int i = 0; i < n; ++i) {
            int n2 = string.indexOf("\n");
            if (n2 < 0) {
                vector.addElement(string);
                break;
            }
            vector.addElement(string.substring(0, n2));
            string = string.substring(n2 + 1, string.length());
        }
        return vector;
    }

    public void keyPressed(int n) {
        if (Common.isLSK(n)) {
            this.parent.displayList();
        } else if (Common.isRSK(n)) {
            if (this.rightCommand != null) {
                this.parent.ontoNextRound();
            }
        } else if (Common.isBackKey(n)) {
            this.parent.displayList();
        }
    }
}

