/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuCanvas
extends Canvas {
    public int LINE_SPACING = 3;
    public Image topImage = null;
    public Quiz parent;
    public int selectedIndex = 0;
    private int w;
    private int h;
    public String alertTitle;
    public String alertText;
    public boolean displayAlert = false;

    public void displayAlert(String string, String string2) {
        this.displayAlert = true;
        this.alertTitle = string;
        this.alertText = string2;
        this.repaint();
    }

    public boolean alertOnDisplay() {
        return this.displayAlert;
    }

    public void hideAlert() {
        this.displayAlert = false;
        this.repaint();
    }

    public MenuCanvas(Image image, Quiz quiz) {
        this.setFullScreenMode(true);
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.topImage = image;
        this.parent = quiz;
    }

    public void paint(Graphics graphics) {
        this.setFullScreenMode(true);
        this.w = this.getWidth();
        this.h = this.getHeight();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.w, this.h);
        Font font = Font.getFont((int)0, (int)0, (int)0);
        graphics.setFont(font);
        graphics.setColor(0);
        int n = 0;
        graphics.drawImage(this.topImage, 0, 0, 0x10 | 4);
        n += this.topImage.getHeight() + this.LINE_SPACING;
        for (int i = 0; i < Strings.MENU_ITEMS.length; ++i) {
            String string = Strings.MENU_ITEMS[i];
            if (i == Strings.GMG_INDEX) {
                if (!GMG.DISPLAY_GET_MORE_GAMES_LINK) continue;
                string = GMG.GET_MORE_GAMES_LABEL;
            }
            if (i == this.selectedIndex) {
                graphics.setColor(0x333333);
                graphics.fillRect(0, n - this.LINE_SPACING / 2, this.w, Common.fontRenderer.getHeight() + this.LINE_SPACING);
                Common.inverseFontRenderer.drawString(graphics, string, 10, n);
                graphics.setColor(0xFFFFFF);
            } else {
                Common.fontRenderer.drawString(graphics, string, 10, n);
                graphics.setColor(0);
            }
            n += Common.fontRenderer.getHeight() + this.LINE_SPACING;
        }
        graphics.setClip(0, 0, this.w, this.h);
        graphics.setColor(0xD0D0D0);
        graphics.fillRect(0, this.h - Common.fontRenderer.getHeight() - 6, this.w, Common.fontRenderer.getHeight() + 6);
        if (this.displayAlert) {
            Common.drawAlert(graphics, this.alertTitle, this.alertText, this.getWidth(), this.getHeight());
            Common.drawCommands(graphics, null, "OK", this.getWidth(), this.getHeight());
        } else {
            Common.drawCommands(graphics, Strings.CMD_SELECT, Strings.CMD_EXIT, this.w, this.h);
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void keyPressed(int n) {
        if (this.displayAlert) {
            if (Common.isRSK(n)) {
                this.hideAlert();
            }
            return;
        }
        if (Common.isLSK(n)) {
            this.parent.mainMenuSelect(this.selectedIndex);
            return;
        }
        if (Common.isRSK(n)) {
            this.parent.exitApplication();
            return;
        }
        int n2 = this.getGameAction(n);
        if (n2 == 1 || n == 50) {
            --this.selectedIndex;
            if (this.selectedIndex < 0) {
                this.selectedIndex = Strings.MENU_ITEMS.length - 1;
            }
            if (this.selectedIndex == Strings.GMG_INDEX && !GMG.DISPLAY_GET_MORE_GAMES_LINK) {
                --this.selectedIndex;
            }
        } else if (n2 == 6 || n == 56) {
            ++this.selectedIndex;
            if (this.selectedIndex >= Strings.MENU_ITEMS.length) {
                this.selectedIndex = 0;
            }
            if (this.selectedIndex == Strings.GMG_INDEX && !GMG.DISPLAY_GET_MORE_GAMES_LINK) {
                ++this.selectedIndex;
            }
        } else if (n2 == 8 || n == 53) {
            this.parent.mainMenuSelect(this.selectedIndex);
        }
        this.repaint();
    }
}

