/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FontRenderer {
    private static final int UPPER_CHARS = 26;
    private static final int LOWER_CHARS = 26;
    private static final int NUMBER_CHARS = 17;
    private static final int SYMBOL_CHARS = 26;
    private int[] upperCharWidths;
    private int[] upperCharOffsets;
    private int[] lowerCharWidths;
    private int[] lowerCharOffsets;
    private int[] numCharWidths;
    private int[] numCharOffsets;
    private int[] symbolCharWidths;
    private int[] symbolCharOffsets;
    private boolean useAdvancedImageProcessing = false;
    private Image[] upperCharImage;
    private Image[] lowerCharImage;
    private Image[] numCharImage;
    private Image[] symbolCharImage;
    private Image fontImage;
    private int fontHeight;
    private int spaceWidth = 4;
    private int fontColour = 0;
    private int fontSpacing = 1;
    private int sourceCharacterSpacing = 1;
    private int baseline = 0;
    private int canvasY = 0;
    private int canvasWidth = 1000;
    private int canvasHeight = 1000;
    private boolean debug = true;
    private boolean useOldAIP = false;

    public FontRenderer(String string) {
        this(string, false);
    }

    public FontRenderer(String string, boolean bl) {
        String string2;
        String string3 = string + ".png";
        if (!string3.startsWith("/")) {
            string3 = "/" + string3;
        }
        if (!(string2 = string + ".dat").startsWith("/")) {
            string2 = "/" + string2;
        }
        this.useAdvancedImageProcessing = bl;
        if (this.debug) {
            if (this.useAdvancedImageProcessing) {
                System.out.println("Using Advanced Image Processing");
            } else {
                System.out.println("Using standard image processing");
            }
        }
        this.loadFont(string3, string2);
    }

    public FontRenderer(String string, Canvas canvas) {
        this(string, false);
        this.setCanvasDimensions(0, canvas.getWidth(), canvas.getHeight());
    }

    public FontRenderer(String string, int n, int n2) {
        this(string, false);
        this.setCanvasDimensions(0, n, n2);
    }

    public FontRenderer(String string, int n) {
        this(string, false);
        this.sourceCharacterSpacing = n;
    }

    public void setCanvasDimensions(int n, int n2, int n3) {
        this.canvasY = n;
        this.canvasWidth = n2;
        this.canvasHeight = n3;
    }

    private void loadFont(String string, String string2) {
        int n;
        if (this.debug) {
            System.out.println("Loading font " + string + " ...");
        }
        try {
            this.fontImage = Image.createImage((String)string);
        }
        catch (Exception exception) {
            System.out.println("Unable to load font resource: " + string);
            return;
        }
        this.baseline = this.fontHeight = this.fontImage.getHeight() - 3 >> 2;
        Vector vector = FontRenderer.splitString("\n", this.loadTextResource(string2));
        if (vector.size() == 0) {
            System.out.println(string2 + " contains no data or couldn't be opened (check filename case)");
            return;
        }
        int n2 = 0;
        while (((String)vector.elementAt(n2)).length() == 0 || ((String)vector.elementAt(n2)).startsWith("#") || ((String)vector.elementAt(n2)).startsWith("$")) {
            if (((String)vector.elementAt(n2)).startsWith("$")) {
                this.parseSetting((String)vector.elementAt(n2));
            }
            ++n2;
        }
        Vector vector2 = FontRenderer.splitString(",", (String)vector.elementAt(n2++));
        while (((String)vector.elementAt(n2)).length() == 0 || ((String)vector.elementAt(n2)).startsWith("#") || ((String)vector.elementAt(n2)).startsWith("$")) {
            if (((String)vector.elementAt(n2)).startsWith("$")) {
                this.parseSetting((String)vector.elementAt(n2));
            }
            ++n2;
        }
        Vector vector3 = FontRenderer.splitString(",", (String)vector.elementAt(n2++));
        while (((String)vector.elementAt(n2)).length() == 0 || ((String)vector.elementAt(n2)).startsWith("#") || ((String)vector.elementAt(n2)).startsWith("$")) {
            if (((String)vector.elementAt(n2)).startsWith("$")) {
                this.parseSetting((String)vector.elementAt(n2));
            }
            ++n2;
        }
        Vector vector4 = FontRenderer.splitString(",", (String)vector.elementAt(n2++));
        while (((String)vector.elementAt(n2)).length() == 0 || ((String)vector.elementAt(n2)).startsWith("#") || ((String)vector.elementAt(n2)).startsWith("$")) {
            if (((String)vector.elementAt(n2)).startsWith("$")) {
                this.parseSetting((String)vector.elementAt(n2));
            }
            ++n2;
        }
        Vector vector5 = FontRenderer.splitString(",", (String)vector.elementAt(n2++));
        this.upperCharWidths = new int[26];
        this.upperCharOffsets = new int[26];
        this.lowerCharWidths = new int[26];
        this.lowerCharOffsets = new int[26];
        this.numCharWidths = new int[17];
        this.numCharOffsets = new int[17];
        this.symbolCharWidths = new int[26];
        this.symbolCharOffsets = new int[26];
        for (n = 0; n < this.upperCharWidths.length; ++n) {
            this.upperCharOffsets[n] = 0;
            this.upperCharWidths[n] = 0;
        }
        for (n = 0; n < this.lowerCharWidths.length; ++n) {
            this.lowerCharOffsets[n] = 0;
            this.lowerCharWidths[n] = 0;
        }
        for (n = 0; n < this.numCharWidths.length; ++n) {
            this.numCharOffsets[n] = 0;
            this.numCharWidths[n] = 0;
        }
        for (n = 0; n < this.symbolCharWidths.length; ++n) {
            this.symbolCharOffsets[n] = 0;
            this.symbolCharWidths[n] = 0;
        }
        Enumeration enumeration = vector2.elements();
        int n3 = 0;
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            if (n3 >= this.upperCharWidths.length) {
                if (!this.debug) break;
                System.out.println("Warning: Too many character widths defined for uppercase characters");
                break;
            }
            this.upperCharWidths[n3] = Integer.parseInt(((String)enumeration.nextElement()).trim());
            this.upperCharOffsets[n3] = n4;
            n4 += this.upperCharWidths[n3++] + this.sourceCharacterSpacing;
        }
        if (n3 < this.upperCharWidths.length) {
            if (this.debug) {
                System.out.println("Warning: Missing " + (this.upperCharWidths.length - n3) + " character definitions for uppercase characters");
            }
        } else if (this.debug) {
            System.out.println("Successfully parsed " + n3 + " uppercase characters");
        }
        enumeration = vector3.elements();
        n3 = 0;
        n4 = 0;
        while (enumeration.hasMoreElements()) {
            if (n3 >= this.lowerCharWidths.length) {
                if (!this.debug) break;
                System.out.println("Warning: Too many character widths defined for lowercase characters");
                break;
            }
            this.lowerCharWidths[n3] = Integer.parseInt(((String)enumeration.nextElement()).trim());
            this.lowerCharOffsets[n3] = n4;
            n4 += this.lowerCharWidths[n3++] + this.sourceCharacterSpacing;
        }
        if (n3 < this.numCharWidths.length) {
            if (this.debug) {
                System.out.println("Warning: Missing " + (this.lowerCharWidths.length - n3) + " character definitions for lowercase characters");
            }
        } else if (this.debug) {
            System.out.println("Successfully parsed " + n3 + " lowercase characters");
        }
        enumeration = vector4.elements();
        n3 = 0;
        n4 = 0;
        while (enumeration.hasMoreElements()) {
            if (n3 >= this.numCharWidths.length) {
                if (!this.debug) break;
                System.out.println("Warning: Too many character widths defined for number characters");
                break;
            }
            this.numCharWidths[n3] = Integer.parseInt(((String)enumeration.nextElement()).trim());
            this.numCharOffsets[n3] = n4;
            n4 += this.numCharWidths[n3++] + this.sourceCharacterSpacing;
        }
        if (n3 < this.numCharWidths.length) {
            if (this.debug) {
                System.out.println("Warning: Missing " + (this.numCharWidths.length - n3) + " character definitions for number characters");
            }
        } else if (this.debug) {
            System.out.println("Successfully parsed " + n3 + " number characters");
        }
        enumeration = vector5.elements();
        n3 = 0;
        n4 = 0;
        while (enumeration.hasMoreElements()) {
            if (n3 >= this.symbolCharWidths.length) {
                if (!this.debug) break;
                System.out.println("Warning: Too many character widths defined for symbol characters");
                break;
            }
            this.symbolCharWidths[n3] = Integer.parseInt(((String)enumeration.nextElement()).trim());
            this.symbolCharOffsets[n3] = n4;
            n4 += this.symbolCharWidths[n3++] + this.sourceCharacterSpacing;
        }
        if (n3 < this.symbolCharWidths.length) {
            if (this.debug) {
                System.out.println("Warning: Missing " + (this.symbolCharWidths.length - n3) + " character definitions for symbol characters");
            }
        } else if (this.debug) {
            System.out.println("Successfully parsed " + n3 + " symbol characters");
        }
        vector5 = null;
        vector4 = null;
        vector3 = null;
        vector2 = null;
        vector = null;
        if (this.useAdvancedImageProcessing) {
            this.upperCharImage = new Image[26];
            this.lowerCharImage = new Image[26];
            this.numCharImage = new Image[17];
            this.symbolCharImage = new Image[26];
            int[] nArray = null;
            for (n3 = 0; n3 < this.upperCharWidths.length; ++n3) {
                try {
                    if (this.upperCharWidths[n3] > 0) {
                        if (this.useOldAIP) {
                            this.upperCharImage[n3] = Image.createImage((Image)this.fontImage, (int)this.upperCharOffsets[n3], (int)0, (int)this.upperCharWidths[n3], (int)this.fontHeight, (int)0);
                            continue;
                        }
                        nArray = new int[this.upperCharWidths[n3] * this.fontHeight];
                        this.fontImage.getRGB(nArray, 0, this.upperCharWidths[n3], this.upperCharOffsets[n3], 0, this.upperCharWidths[n3], this.fontHeight);
                        this.upperCharImage[n3] = Image.createRGBImage((int[])nArray, (int)this.upperCharWidths[n3], (int)this.fontHeight, (boolean)true);
                        continue;
                    }
                    this.upperCharImage[n3] = null;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            for (n3 = 0; n3 < this.lowerCharWidths.length; ++n3) {
                try {
                    if (this.lowerCharWidths[n3] > 0) {
                        if (this.useOldAIP) {
                            this.lowerCharImage[n3] = Image.createImage((Image)this.fontImage, (int)this.lowerCharOffsets[n3], (int)(this.fontHeight + 1), (int)this.lowerCharWidths[n3], (int)this.fontHeight, (int)0);
                            continue;
                        }
                        nArray = new int[this.lowerCharWidths[n3] * this.fontHeight];
                        this.fontImage.getRGB(nArray, 0, this.lowerCharWidths[n3], this.lowerCharOffsets[n3], this.fontHeight + 1, this.lowerCharWidths[n3], this.fontHeight);
                        this.lowerCharImage[n3] = Image.createRGBImage((int[])nArray, (int)this.lowerCharWidths[n3], (int)this.fontHeight, (boolean)true);
                        continue;
                    }
                    this.lowerCharImage[n3] = null;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            for (n3 = 0; n3 < this.numCharWidths.length; ++n3) {
                try {
                    if (this.numCharWidths[n3] > 0) {
                        if (this.useOldAIP) {
                            this.numCharImage[n3] = Image.createImage((Image)this.fontImage, (int)this.numCharOffsets[n3], (int)(this.fontHeight * 2 + 2), (int)this.numCharWidths[n3], (int)this.fontHeight, (int)0);
                            continue;
                        }
                        nArray = new int[this.numCharWidths[n3] * this.fontHeight];
                        this.fontImage.getRGB(nArray, 0, this.numCharWidths[n3], this.numCharOffsets[n3], this.fontHeight * 2 + 2, this.numCharWidths[n3], this.fontHeight);
                        this.numCharImage[n3] = Image.createRGBImage((int[])nArray, (int)this.numCharWidths[n3], (int)this.fontHeight, (boolean)true);
                        continue;
                    }
                    this.numCharImage[n3] = null;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            for (n3 = 0; n3 < this.symbolCharWidths.length; ++n3) {
                try {
                    if (this.symbolCharWidths[n3] > 0) {
                        if (this.useOldAIP) {
                            this.symbolCharImage[n3] = Image.createImage((Image)this.fontImage, (int)this.symbolCharOffsets[n3], (int)(this.fontHeight * 3 + 3), (int)this.symbolCharWidths[n3], (int)this.fontHeight, (int)0);
                            continue;
                        }
                        nArray = new int[this.symbolCharWidths[n3] * this.fontHeight];
                        this.fontImage.getRGB(nArray, 0, this.symbolCharWidths[n3], this.symbolCharOffsets[n3], this.fontHeight * 3 + 3, this.symbolCharWidths[n3], this.fontHeight);
                        this.symbolCharImage[n3] = Image.createRGBImage((int[])nArray, (int)this.symbolCharWidths[n3], (int)this.fontHeight, (boolean)true);
                        continue;
                    }
                    this.symbolCharImage[n3] = null;
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.fontImage = null;
            nArray = null;
        }
    }

    private void parseSetting(String string) {
        String string2 = "";
        String string3 = "";
        if (this.debug) {
            System.out.println("Parsing setting " + string);
        }
        if (string.startsWith("$")) {
            int n = (string = string.substring(1)).indexOf("=");
            if (n >= 0) {
                string2 = string.substring(0, n).toLowerCase().trim();
                string3 = string.substring(n + 1).toLowerCase().trim();
                if (string2.equals("baseline")) {
                    try {
                        this.baseline = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Warning: Illegal integer setting value $" + string);
                    }
                } else if (string2.equals("colour")) {
                    try {
                        this.fontColour = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Warning: Illegal integer setting value $" + string);
                    }
                } else if (string2.equals("png_character_spacing")) {
                    try {
                        this.sourceCharacterSpacing = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Warning: Illegal integer setting value $" + string);
                    }
                } else if (string2.equals("font_spacing")) {
                    try {
                        this.fontSpacing = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Warning: Illegal integer setting value $" + string);
                    }
                } else if (string2.equals("space_width")) {
                    try {
                        this.spaceWidth = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Warning: Illegal integer setting value $" + string);
                    }
                }
            } else {
                System.out.println("Warning: Invalid setting $" + string);
            }
        }
    }

    public int drawString(Graphics graphics, String string, int n, int n2) {
        return this.drawString(graphics, string, n, n2, -1, 0);
    }

    public int drawString(Graphics graphics, String string, int n, int n2, int n3) {
        return this.drawString(graphics, string, n, n2, n3, 0);
    }

    public int drawCenteredString(Graphics graphics, String string, int n, int n2) {
        return this.drawString(graphics, string, (n - this.stringWidth(string)) / 2, n2);
    }

    public int drawString(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        int n7 = 1;
        if (n4 > 0) {
            string = this.wrapString(string, n4);
        }
        char[] cArray = string.toCharArray();
        if (n3 >= 0) {
            n5 = this.stringWidth(cArray);
            graphics.setColor(n3);
            graphics.fillRect(n, n2, n5, this.fontHeight);
        }
        n5 = 1;
        int n8 = 0;
        if (this.useAdvancedImageProcessing) {
            for (int i = 0; i < cArray.length; ++i) {
                n8 = cArray[i];
                n5 = 1;
                if (n + n6 > this.canvasWidth || n + n6 < -15) {
                    n5 = 0;
                } else if (n2 < this.canvasY - this.fontHeight || n2 > this.canvasY + this.canvasHeight) {
                    n5 = 0;
                }
                if (cArray[i] == '\n') {
                    n2 += this.fontHeight;
                    n6 = 0;
                    ++n7;
                    continue;
                }
                if (n8 == 32) {
                    n6 += this.spaceWidth;
                    continue;
                }
                if (n8 >= 33 && n8 <= 47) {
                    if (n5 != 0 && this.symbolCharImage[n8 -= 33] != null) {
                        graphics.drawImage(this.symbolCharImage[n8], n + n6, n2, 0x10 | 4);
                    }
                    n6 += this.symbolCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                if (n8 >= 48 && n8 <= 64) {
                    if (n5 != 0 && this.numCharImage[n8 -= 48] != null) {
                        graphics.drawImage(this.numCharImage[n8], n + n6, n2, 0x10 | 4);
                    }
                    n6 += this.numCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                if (n8 >= 65 && n8 <= 90) {
                    if (n5 != 0 && this.upperCharImage[n8 -= 65] != null) {
                        graphics.drawImage(this.upperCharImage[n8], n + n6, n2, 0x10 | 4);
                    }
                    n6 += this.upperCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                if (n8 >= 91 && n8 <= 96) {
                    n8 = n8 - 91 + 15;
                    if (n5 != 0 && this.symbolCharImage[n8] != null) {
                        graphics.drawImage(this.symbolCharImage[n8], n + n6, n2, 0x10 | 4);
                    }
                    n6 += this.symbolCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                if (n8 >= 97 && n8 <= 122) {
                    if (n5 != 0 && this.lowerCharImage[n8 -= 97] != null) {
                        graphics.drawImage(this.lowerCharImage[n8], n + n6, n2, 0x10 | 4);
                    }
                    n6 += this.lowerCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                if (n8 >= 123 && n8 <= 126) {
                    n8 = n8 - 123 + 21;
                    if (n5 != 0 && this.symbolCharImage[n8] != null) {
                        graphics.drawImage(this.symbolCharImage[n8], n + n6, n2, 0x10 | 4);
                    }
                    n6 += this.symbolCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                if (n8 == 163) {
                    n8 = n8 - 163 + 25;
                    if (n5 != 0 && this.symbolCharImage[n8] != null) {
                        graphics.drawImage(this.symbolCharImage[n8], n + n6, n2, 0x10 | 4);
                    }
                    n6 += this.symbolCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                System.out.println("Warning: No symbol for " + cArray[i] + " (" + n8 + ")");
            }
        } else {
            int n9 = graphics.getClipX();
            int n10 = graphics.getClipY();
            int n11 = graphics.getClipWidth();
            int n12 = graphics.getClipHeight();
            for (int i = 0; i < cArray.length; ++i) {
                n8 = cArray[i];
                n5 = 1;
                if (n + n6 > this.canvasWidth || n + n6 < -15) {
                    n5 = 0;
                } else if (n2 < this.canvasY - this.fontHeight || n2 > this.canvasY + this.canvasHeight) {
                    n5 = 0;
                }
                if (cArray[i] == '\n') {
                    n2 += this.fontHeight;
                    n6 = 0;
                    ++n7;
                    continue;
                }
                if (n8 == 32) {
                    n6 += this.spaceWidth;
                    continue;
                }
                if (n8 >= 33 && n8 <= 47) {
                    n8 -= 33;
                    if (n5 != 0) {
                        graphics.setClip(n + n6, n2, this.symbolCharWidths[n8], this.fontHeight);
                        graphics.drawImage(this.fontImage, n - this.symbolCharOffsets[n8] + n6, n2 - (this.fontHeight << 1) - this.fontHeight - 3, 0x10 | 4);
                    }
                    n6 += this.symbolCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                if (n8 >= 48 && n8 <= 64) {
                    n8 -= 48;
                    if (n5 != 0) {
                        graphics.setClip(n + n6, n2, this.numCharWidths[n8], this.fontHeight);
                        graphics.drawImage(this.fontImage, n - this.numCharOffsets[n8] + n6, n2 - (this.fontHeight << 1) - 2, 0x10 | 4);
                    }
                    n6 += this.numCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                if (n8 >= 65 && n8 <= 90) {
                    n8 -= 65;
                    if (n5 != 0) {
                        graphics.setClip(n + n6, n2, this.upperCharWidths[n8], this.fontHeight);
                        graphics.drawImage(this.fontImage, n - this.upperCharOffsets[n8] + n6, n2, 0x10 | 4);
                    }
                    n6 += this.upperCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                if (n8 >= 91 && n8 <= 96) {
                    n8 = n8 - 91 + 15;
                    if (n5 != 0) {
                        graphics.setClip(n + n6, n2, this.symbolCharWidths[n8], this.fontHeight);
                        graphics.drawImage(this.fontImage, n - this.symbolCharOffsets[n8] + n6, n2 - (this.fontHeight << 1) - this.fontHeight - 3, 0x10 | 4);
                    }
                    n6 += this.symbolCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                if (n8 >= 97 && n8 <= 122) {
                    n8 -= 97;
                    if (n5 != 0) {
                        graphics.setClip(n + n6, n2, this.lowerCharWidths[n8], this.fontHeight);
                        graphics.drawImage(this.fontImage, n - this.lowerCharOffsets[n8] + n6, n2 - this.fontHeight - 1, 0x10 | 4);
                    }
                    n6 += this.lowerCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                if (n8 >= 123 && n8 <= 126) {
                    n8 = n8 - 123 + 21;
                    if (n5 != 0) {
                        graphics.setClip(n + n6, n2, this.symbolCharWidths[n8], this.fontHeight);
                        graphics.drawImage(this.fontImage, n - this.symbolCharOffsets[n8] + n6, n2 - (this.fontHeight << 1) - this.fontHeight - 3, 0x10 | 4);
                    }
                    n6 += this.symbolCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                if (n8 == 163) {
                    n8 = n8 - 163 + 25;
                    if (n5 != 0) {
                        graphics.setClip(n + n6, n2, this.symbolCharWidths[n8], this.fontHeight);
                        graphics.drawImage(this.fontImage, n - this.symbolCharOffsets[n8] + n6, n2 - (this.fontHeight << 1) - this.fontHeight - 3, 0x10 | 4);
                    }
                    n6 += this.symbolCharWidths[n8] + this.fontSpacing;
                    continue;
                }
                System.out.println("Warning: No symbol for " + cArray[i] + " (" + n8 + ")");
            }
            graphics.setClip(n9, n10, n11, n12);
        }
        return n7;
    }

    public int stringWidth(String string) {
        return this.stringWidth(string.toCharArray());
    }

    public int stringWidth(char[] cArray) {
        int n = 0;
        int n2 = 0;
        try {
            for (int i = cArray.length; i != 0; --i) {
                n2 = cArray[i - 1];
                if (n2 == 32) {
                    n += this.spaceWidth;
                    continue;
                }
                if (n2 >= 33 && n2 <= 47) {
                    n += this.symbolCharWidths[n2 -= 33] + this.fontSpacing;
                    continue;
                }
                if (n2 >= 48 && n2 <= 64) {
                    n += this.numCharWidths[n2 -= 48] + this.fontSpacing;
                    continue;
                }
                if (n2 >= 65 && n2 <= 90) {
                    n += this.upperCharWidths[n2 -= 65] + this.fontSpacing;
                    continue;
                }
                if (n2 >= 91 && n2 <= 96) {
                    n2 = n2 - 91 + 15;
                    n += this.symbolCharWidths[n2] + this.fontSpacing;
                    continue;
                }
                if (n2 >= 97 && n2 <= 122) {
                    n += this.lowerCharWidths[n2 -= 97] + this.fontSpacing;
                    continue;
                }
                if (n2 >= 123 && n2 <= 126) {
                    n2 = n2 - 123 + 21;
                    n += this.symbolCharWidths[n2] + this.fontSpacing;
                    continue;
                }
                if (n2 != 163) continue;
                n2 = n2 - 163 + 25;
                n += this.symbolCharWidths[n2] + this.fontSpacing;
            }
        }
        catch (Exception exception) {
            System.out.println("offset=" + n2);
        }
        return n;
    }

    public int charWidth(char n) {
        int n2 = 0;
        int n3 = n;
        if (n3 == 32) {
            n2 = this.spaceWidth;
        } else if (n3 >= 33 && n3 <= 47) {
            n2 = this.symbolCharWidths[n3 -= 33] + this.fontSpacing;
        } else if (n3 >= 48 && n3 <= 64) {
            n2 = this.numCharWidths[n3 -= 48] + this.fontSpacing;
        } else if (n3 >= 65 && n3 <= 90) {
            n2 = this.upperCharWidths[n3 -= 65] + this.fontSpacing;
        } else if (n3 >= 91 && n3 <= 96) {
            n3 = n3 - 91 + 15;
            n2 = this.symbolCharWidths[n3] + this.fontSpacing;
        } else if (n3 >= 97 && n3 <= 122) {
            n2 = this.lowerCharWidths[n3 -= 97] + this.fontSpacing;
        } else if (n3 >= 123 && n3 <= 126) {
            n3 = n3 - 123 + 21;
            n2 = this.symbolCharWidths[n3] + this.fontSpacing;
        } else if (n3 == 163) {
            n3 = n3 - 163 + 25;
            n2 = this.symbolCharWidths[n3] + this.fontSpacing;
        }
        return n2;
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public int getHeight() {
        return this.fontHeight;
    }

    public void setFontSpacing(int n) {
        this.fontSpacing = n;
    }

    public int getFontSpacing() {
        return this.fontSpacing;
    }

    public void setSpaceWidth(int n) {
        this.spaceWidth = n;
    }

    public int getSpaceWidth() {
        return this.spaceWidth;
    }

    private String loadTextResource(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            InputStream inputStream = null;
            inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream != null) {
                int n;
                while ((n = inputStream.read()) != -1) {
                    stringBuffer.append((char)n);
                }
            } else {
                System.out.println("Unable to load text resource: " + string);
                return "";
            }
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Unable to load text resource: " + string);
            return "";
        }
        return stringBuffer.toString();
    }

    public static Vector splitString(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = string2.trim().length();
        int n2 = 0;
        for (int i = n; i != 0; --i) {
            n2 = string2.indexOf(string);
            if (n2 < 0) {
                if (string2.length() <= 0) break;
                vector.addElement(string2);
                break;
            }
            vector.addElement(string2.substring(0, n2));
            string2 = string2.substring(n2 + string.length(), string2.length());
        }
        return vector;
    }

    public static String[] splitStringToArray(String string, String string2) {
        Vector vector = FontRenderer.splitString(string, string2);
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (!vector.isEmpty()) {
            stringArray[n++] = (String)vector.firstElement();
            vector.removeElementAt(0);
        }
        return stringArray;
    }

    private String arrayToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[i]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String[] wrap(String string, int n) {
        return FontRenderer.splitStringToArray("\n", this.wrapString(string, n));
    }

    public String wrapString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        Vector vector = FontRenderer.splitString("\n", string);
        int n2 = vector.size();
        Vector vector2 = null;
        String string2 = null;
        for (int i = 0; i < n2; ++i) {
            vector2 = FontRenderer.splitString(" ", ((String)vector.elementAt(i)).trim());
            int n3 = 0;
            int n4 = vector2.size();
            for (int j = 0; j < n4; ++j) {
                string2 = (String)vector2.elementAt(j);
                int n5 = this.stringWidth(string2);
                if (n3 + this.spaceWidth + n5 >= n) {
                    stringBuffer.append('\n');
                    if (n5 > n) {
                        stringBuffer.append(this.wrapWord(string2, n));
                        n3 = this.stringWidth(this.wrapWord(string2, n));
                        continue;
                    }
                    stringBuffer.append((String)vector2.elementAt(j));
                    n3 = n5;
                    continue;
                }
                if (n3 > 0) {
                    stringBuffer.append(' ');
                    n3 += this.spaceWidth;
                }
                stringBuffer.append((String)vector2.elementAt(j));
                n3 += n5;
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private String wrapWord(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = this.charWidth('-');
        int n3 = 0;
        int n4 = string.length();
        for (int i = 0; i < n4; ++i) {
            char c = string.charAt(i);
            int n5 = this.charWidth(c);
            if (n3 + n2 + this.charWidth(c) > n) {
                stringBuffer.append('-');
                stringBuffer.append('\n');
                stringBuffer.append(c);
                n3 = n5;
                continue;
            }
            stringBuffer.append(c);
            n3 += n5;
        }
        return stringBuffer.toString();
    }

    public void purge() {
        this.fontImage = null;
        this.upperCharWidths = null;
        this.upperCharOffsets = null;
        this.lowerCharWidths = null;
        this.lowerCharOffsets = null;
        this.numCharWidths = null;
        this.numCharOffsets = null;
        this.symbolCharWidths = null;
        this.symbolCharOffsets = null;
        if (this.useAdvancedImageProcessing) {
            int n;
            if (this.upperCharImage != null) {
                for (n = 0; n < this.upperCharImage.length; ++n) {
                    this.upperCharImage[n] = null;
                }
            }
            if (this.lowerCharImage != null) {
                for (n = 0; n < this.lowerCharImage.length; ++n) {
                    this.lowerCharImage[n] = null;
                }
            }
            if (this.numCharImage != null) {
                for (n = 0; n < this.numCharImage.length; ++n) {
                    this.numCharImage[n] = null;
                }
            }
            if (this.symbolCharImage != null) {
                for (n = 0; n < this.symbolCharImage.length; ++n) {
                    this.symbolCharImage[n] = null;
                }
            }
            this.symbolCharImage = null;
            this.numCharImage = null;
            this.lowerCharImage = null;
            this.upperCharImage = null;
        }
    }
}

