/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class SoundManager
implements Runnable,
PlayerListener {
    public static final int LOOP_FOREVER = -1;
    public static final String NONE = "uninitialized";
    public static final String STARTED = "started";
    public static final String STOPPED = "stopped";
    public static final String END_OF_MEDIA = "endOfMedia";
    public static final String DEVICE_UNAVAILABLE = "deviceUnavailable";
    public static final String DEVICE_AVAILABLE = "deviceAvailable";
    public static final String ERROR = "deviceAvailable";
    public static final String CLOSED = "deviceAvailable";
    public static final String VOLUME_CHANGED = "volumeChanged";
    private String currentState = "uninitialized";
    public String errLog = "";
    private String cachedSoundRes = "";
    private String cachedSoundMimeType = "";
    private String soundRes = "";
    private String soundMimeType = "audio/x-wav";
    private boolean preCacheSound = false;
    private boolean garbageCollectAfterDeAlloc = true;
    private Player p = null;
    private Thread t = null;
    private int playerVolume = 100;
    private boolean volumeControlEnabled = false;
    private int soundLoopCount = 1;
    private boolean playerListenerEnabled = false;
    private boolean waitForEndOfMedia = false;
    private boolean logState = false;
    private String statelog = "";
    private long logStartTime = 0L;

    public boolean playSound(String string, String string2) {
        return this.playSound(string, string2, 1);
    }

    public boolean playSound(String string, String string2, int n) {
        if (this.playerListenerEnabled && this.waitForEndOfMedia && (this.currentState.equals(STARTED) || this.currentState.equals(DEVICE_UNAVAILABLE))) {
            return false;
        }
        String string3 = this.checkMimeTypes(string2);
        if (string3 != null) {
            this.soundRes = string;
            this.soundMimeType = string3;
            this.soundLoopCount = n;
            this.killPlayer(false);
            this.t = new Thread(this);
            this.t.start();
            return true;
        }
        System.out.println("Unsupported mime-type: " + string2);
        return false;
    }

    public boolean forcePlaySound(String string, String string2) {
        return this.forcePlaySound(string, string2, 1);
    }

    public boolean forcePlaySound(String string, String string2, int n) {
        if (this.playerListenerEnabled && this.waitForEndOfMedia && (this.currentState.equals(STARTED) || this.currentState.equals(DEVICE_UNAVAILABLE))) {
            return false;
        }
        String string3 = this.checkMimeTypes(string2);
        if (string3 != null) {
            this.soundRes = string;
            this.soundMimeType = string3;
            this.soundLoopCount = n;
            this.killPlayer(true);
            this.t = new Thread(this);
            this.t.start();
            return true;
        }
        System.out.println("Unsupported mime-type: " + string2);
        return false;
    }

    public boolean cacheSound(String string, String string2) {
        this.preCacheSound = true;
        return this.playSound(string, string2, 1);
    }

    public boolean cacheSound(String string, String string2, int n) {
        this.preCacheSound = true;
        return this.playSound(string, string2, n);
    }

    public boolean stopSound() {
        return this.killPlayer(true);
    }

    public void purgeResources() {
        this.stopSound();
    }

    public void run() {
        block19: {
            try {
                if (this.preCacheSound) {
                    if (!this.soundRes.equals(this.cachedSoundRes)) {
                        this.createPlayer();
                        this.p.realize();
                        if (this.volumeControlEnabled && this.playerVolume != 100) {
                            System.out.println("Setting Volume to " + this.playerVolume);
                            try {
                                VolumeControl volumeControl = (VolumeControl)this.p.getControl("javax.microedition.media.control.VolumeControl");
                                volumeControl.setLevel(this.playerVolume);
                            }
                            catch (Exception exception) {
                                System.out.println("Unable to set volume: " + exception.toString());
                            }
                        }
                        this.p.prefetch();
                    }
                    this.preCacheSound = false;
                    break block19;
                }
                if (this.soundRes.equals(this.cachedSoundRes)) {
                    if (this.volumeControlEnabled && this.playerVolume != 100) {
                        System.out.println("Setting Volume to " + this.playerVolume);
                        try {
                            VolumeControl volumeControl = (VolumeControl)this.p.getControl("javax.microedition.media.control.VolumeControl");
                            volumeControl.setLevel(this.playerVolume);
                        }
                        catch (Exception exception) {
                            System.out.println("Unable to set volume: " + exception.toString());
                        }
                    }
                    if (this.cachedSoundMimeType.equals("audio/midi") || this.cachedSoundMimeType.equals("audio/mid")) {
                        try {
                            this.p.setMediaTime(-1L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.p.start();
                    break block19;
                }
                this.createPlayer();
                this.p.realize();
                if (this.volumeControlEnabled && this.playerVolume != 100) {
                    System.out.println("Setting Volume to " + this.playerVolume);
                    try {
                        VolumeControl volumeControl = (VolumeControl)this.p.getControl("javax.microedition.media.control.VolumeControl");
                        volumeControl.setLevel(this.playerVolume);
                    }
                    catch (Exception exception) {
                        System.out.println("Unable to set volume: " + exception.toString());
                    }
                }
                this.p.start();
            }
            catch (Exception exception) {
                System.out.println("SoundManager.run(): " + exception.toString());
                if (this.p == null) break block19;
                try {
                    this.p.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this.p.deallocate();
                this.p.close();
                this.p = null;
                if (!this.garbageCollectAfterDeAlloc) break block19;
                System.gc();
            }
        }
    }

    private void createPlayer() {
        block7: {
            try {
                if (this.logState) {
                    this.statelog = this.statelog + "-- createPlayer --\n";
                    this.statelog = this.statelog + this.soundRes + "\n";
                    this.statelog = this.statelog + this.soundMimeType + "\n";
                    this.statelog = this.statelog + "--------------------\n";
                }
                InputStream inputStream = this.getClass().getResourceAsStream(this.soundRes);
                this.p = Manager.createPlayer((InputStream)inputStream, (String)this.soundMimeType);
                if (this.playerListenerEnabled) {
                    this.p.addPlayerListener((PlayerListener)this);
                }
                if (this.soundLoopCount != 0 && this.soundLoopCount != 1) {
                    this.p.setLoopCount(this.soundLoopCount);
                }
                this.cachedSoundRes = this.soundRes;
                this.cachedSoundMimeType = this.soundMimeType;
            }
            catch (Exception exception) {
                System.out.println("SoundManager.createPlayer(): " + exception.toString());
                if (this.p == null) break block7;
                try {
                    this.p.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this.p.deallocate();
                this.p.close();
                this.p = null;
                if (!this.garbageCollectAfterDeAlloc) break block7;
                System.gc();
            }
        }
    }

    private boolean killPlayer(boolean bl) {
        try {
            if (this.playerListenerEnabled && this.waitForEndOfMedia && (this.currentState.equals(STARTED) || this.currentState.equals(DEVICE_UNAVAILABLE))) {
                return false;
            }
            if (this.p != null && (!this.soundRes.equals(this.cachedSoundRes) || bl)) {
                try {
                    this.p.stop();
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                this.p.deallocate();
                this.p.close();
                this.p = null;
                this.cachedSoundRes = "";
                this.cachedSoundMimeType = "";
                if (this.garbageCollectAfterDeAlloc) {
                    System.gc();
                }
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("SoundManager.killPlayer(): " + exception.toString());
            return false;
        }
    }

    public String checkMimeTypes(String string) {
        int n;
        string = string.toLowerCase().trim();
        String[] stringArray = Manager.getSupportedContentTypes(null);
        for (n = 0; n < stringArray.length; ++n) {
            if (!string.equals(stringArray[n])) continue;
            return stringArray[n];
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!(string.equals("audio/mpeg") || string.equals("audio/mp3") ? stringArray[n].equals("audio/mpeg") || stringArray[n].equals("audio/mp3") || stringArray[n].equals("audio/mpeg3") || stringArray[n].equals("audio/x-mpeg") : (string.equals("audio/x-wav") ? stringArray[n].equals("audio/wav") : (string.equals("audio/midi") ? stringArray[n].equals("audio/mid") || stringArray[n].equals("audio/x-midi") : (string.equals("audio/x-smaf") ? stringArray[n].equals("audio/mmf") || stringArray[n].equals("audio/x-mmf") || stringArray[n].equals("application/x-smaf") || stringArray[n].equals("application/x-smaf-audio") || stringArray[n].equals("application/vnd.smaf") : (string.equals("application/x-smaf-audio") || string.equals("application/x-smaf-phrase") ? stringArray[n].equals("audio/mmf") || stringArray[n].equals("audio/x-mmf") || stringArray[n].equals("audio/x-smaf") : !(!string.equals("audio/m4a") && !string.equals("audio/aac") || !stringArray[n].equals("audio/aac") && !stringArray[n].equals("audio/m4a") && !stringArray[n].equals("audio/mp4")))))))) continue;
            return stringArray[n];
        }
        return null;
    }

    public boolean supportsVolume(String string, String string2) {
        boolean bl = false;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            Player player = Manager.createPlayer((InputStream)inputStream, (String)string2);
            player.realize();
            VolumeControl volumeControl = (VolumeControl)player.getControl("javax.microedition.media.control.VolumeControl");
            volumeControl.setLevel(this.playerVolume);
            bl = true;
            try {
                player.stop();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
            player.deallocate();
            player.close();
            player = null;
            volumeControl = null;
            System.gc();
        }
        catch (MediaException mediaException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public void enableVolumeControl(boolean bl) {
        this.volumeControlEnabled = bl;
    }

    public void enableVolumeControl() {
        this.volumeControlEnabled = true;
    }

    public void disableVolumeControl() {
        this.volumeControlEnabled = false;
    }

    public void setVolume(int n) {
        if (n > 100) {
            n = 100;
        }
        if (n < 0) {
            n = 0;
        }
        this.playerVolume = n;
    }

    public int getVolume() {
        return this.playerVolume;
    }

    public void playerUpdate(Player player, String string, Object object) {
        this.currentState = string;
        if (this.logState) {
            this.statelog = this.statelog + string + " @ " + (System.currentTimeMillis() - this.logStartTime) + "ms\n";
        }
        System.out.println("SoundManager.currentState = " + string);
    }

    public String getState() {
        return this.currentState;
    }

    public boolean getState(String string) {
        return this.currentState.equals(string);
    }

    public String getStateLog() {
        return this.statelog;
    }

    public void startStateLogging() {
        this.statelog = "";
        this.logState = true;
        this.logStartTime = System.currentTimeMillis();
    }

    public void stopStateLogging() {
        this.logState = false;
    }

    public void disablePlayerListener() {
        this.playerListenerEnabled = false;
    }

    public void enablePlayerListener() {
        this.playerListenerEnabled = true;
    }

    public void enableWaitForEndOfMedia() {
        this.waitForEndOfMedia = true;
    }

    public void disableWaitForEndOfMedia() {
        this.waitForEndOfMedia = false;
    }
}

