/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;

public class Questions {
    public static final int NUMBER_OF_QUESTIONS = 1000;
    public static final int QUESTIONS_PER_FILE = 100;
    public static final int NUMBER_OF_ANSWERS = 3;
    public static final int QUESTIONS_PER_SET = 10;
    private static final String QUESTIONS_FILE_BASENAME = "/QA";
    private static final String QUESTIONS_FILE_EXT = ".txt";
    private static final String QUESTIONS_RECORD_STORE = "quiz_results";
    private Vector questions;
    private int[] questionSet;
    private byte[] questionsAnswered;
    private int currentQuestionSet = -1;
    private int score = 0;
    public boolean debug = false;
    private Quiz quiz;

    public Questions(Quiz quiz) {
        this.quiz = quiz;
        this.questionsAnswered = new byte[1000];
        this.questionSet = new int[10];
        if (RecordManager.exists(QUESTIONS_RECORD_STORE)) {
            this.questionsAnswered = RecordManager.load(QUESTIONS_RECORD_STORE);
            this.countScore();
        } else {
            for (int i = 0; i < 1000; ++i) {
                this.questionsAnswered[i] = 0;
            }
            RecordManager.save(this.questionsAnswered, QUESTIONS_RECORD_STORE);
        }
    }

    public Question get(int n) {
        return (Question)this.questions.elementAt(this.questionSet[n]);
    }

    public void loadQuestions(int n) {
        Object object;
        char[] cArray = new char[1024];
        Vector<Object> vector = new Vector<Object>();
        int n2 = 0;
        if (this.debug) {
            System.out.println("loadQuestions() Loading question set " + n);
        }
        try {
            InputStream inputStream = null;
            inputStream = this.getClass().getResourceAsStream(QUESTIONS_FILE_BASENAME + n + QUESTIONS_FILE_EXT);
            if (inputStream != null) {
                int n3;
                while ((n3 = inputStream.read()) != -1) {
                    if ((char)n3 != '\r' && (char)n3 != '\n') {
                        cArray[n2++] = (char)n3;
                        continue;
                    }
                    object = new String(cArray, 0, n2);
                    vector.addElement(object);
                    n2 = 0;
                }
                inputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.currentQuestionSet = n;
        this.questions = new Vector();
        n2 = 0;
        for (int i = 0; i < 100; ++i) {
            String string = (String)vector.elementAt(n2++);
            object = new Question();
            ((Question)object).setQuestion(string);
            for (int j = 0; j < 3; ++j) {
                String string2 = (String)vector.elementAt(n2);
                ((Question)object).setAnswer(j, string2);
                ++n2;
            }
            this.questions.addElement(object);
        }
        vector = null;
        System.gc();
    }

    public boolean getQandAs() {
        int n;
        int n2;
        int n3;
        int n4;
        Random random = new Random(System.currentTimeMillis());
        int n5 = 0;
        byte[] byArray = new byte[this.questionsAnswered.length];
        for (n4 = 0; n4 < 1000; ++n4) {
            byArray[n4] = this.questionsAnswered[n4];
            if (byArray[n4] != 0) continue;
            ++n5;
        }
        if (this.debug) {
            System.out.println("Unanswered Questions: " + n5);
        }
        if (n5 < 10) {
            return false;
        }
        n4 = 0;
        int n6 = 0;
        while (n4 == 0) {
            n3 = Math.abs(random.nextInt()) % 10;
            if (this.debug) {
                System.out.println("Randomly selected set " + n3);
            }
            n2 = 0;
            for (n = 0; n < 100; ++n) {
                n2 += byArray[n3 * 100 + n];
            }
            if (this.debug) {
                System.out.println("Total answered questions in set " + n3 + " is " + n2);
            }
            if (n2 > 90) continue;
            n4 = 1;
            n6 = n3;
        }
        if (n6 != this.currentQuestionSet) {
            this.loadQuestions(n6);
        } else if (this.debug) {
            System.out.println("Using cached question set " + this.currentQuestionSet);
        }
        for (n3 = 0; n3 < 10; ++n3) {
            n2 = 0;
            while (n2 == 0) {
                n = Math.abs(random.nextInt()) % 100;
                if (byArray[n6 * 100 + n] != 0) continue;
                if (this.debug) {
                    System.out.println("Selecting random question " + n);
                }
                byArray[n6 * 100 + n] = 1;
                this.questionSet[n3] = n;
                n2 = 1;
            }
        }
        return true;
    }

    public void saveScores() {
        for (int i = 0; i < 10; ++i) {
            int n = this.currentQuestionSet * 100 + this.questionSet[i];
            this.questionsAnswered[n] = 1;
        }
        RecordManager.save(this.questionsAnswered, QUESTIONS_RECORD_STORE);
    }

    public void resetScores() {
        for (int i = 0; i < 1000; ++i) {
            this.questionsAnswered[i] = 0;
        }
        RecordManager.save(this.questionsAnswered, QUESTIONS_RECORD_STORE);
    }

    public int getScore() {
        this.countScore();
        return this.score;
    }

    private void countScore() {
        this.score = 0;
        for (int i = 0; i < 1000; ++i) {
            this.score += this.questionsAnswered[i];
        }
    }

    public boolean answeredAllQuestions() {
        return this.getScore() >= 1000;
    }

    public int getQuestionSet() {
        return this.currentQuestionSet;
    }
}

