/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimatedImageCanvas
extends Canvas
implements Runnable {
    private Image img = null;
    private Image topImage = null;
    private boolean cleared = false;
    private CanvasEventListener listener = null;
    private int backgroundColour = 0xFFFFFF;
    private int delay = 50;
    private int frame = 0;
    private int frame_width = 0;
    private int frame_height = 0;
    private int source_rows = 0;
    private int frames_per_row = 0;
    private int frames = 0;
    private Thread thread;

    public AnimatedImageCanvas() {
        this.setFullScreenMode(true);
    }

    public AnimatedImageCanvas(String string) {
        this.setFullScreenMode(true);
        this.loadImage(string, 0, 0);
    }

    public AnimatedImageCanvas(String string, int n) {
        this.setFullScreenMode(true);
        this.loadImage(string, 0, 0, 1);
        this.backgroundColour = n;
    }

    public AnimatedImageCanvas(String string, int n, int n2) {
        this.setFullScreenMode(true);
        this.loadImage(string, n, n2, 1);
    }

    public AnimatedImageCanvas(String string, int n, int n2, int n3) {
        this.setFullScreenMode(true);
        this.loadImage(string, n, n2, 1);
        this.backgroundColour = n3;
    }

    public AnimatedImageCanvas(String string, int n, int n2, int n3, int n4) {
        this.setFullScreenMode(true);
        this.loadImage(string, n, n2, n4);
        this.backgroundColour = n3;
    }

    public void setTopImage(Image image) {
        this.topImage = image;
    }

    public void loadImage(String string, int n, int n2) {
        this.loadImage(string, n, n2, 1);
    }

    public void loadImage(String string, int n, int n2, int n3) {
        this.frame_width = n;
        this.frames = n2;
        this.source_rows = n3;
        this.frames_per_row = n2 / n3;
        try {
            this.img = Image.createImage((String)string);
        }
        catch (IOException iOException) {
            System.out.println("Cannot load PNG: " + string);
        }
        if (this.img != null) {
            this.frame_height = this.img.getHeight() / n3;
        }
    }

    public void setImage(Image image) {
        this.img = image;
        this.frame_height = image.getHeight();
        this.frame_width = 0;
        this.frames = 1;
        this.source_rows = 1;
        this.frames_per_row = 1;
    }

    public void setImage(Image image, int n, int n2) {
        this.setImage(image, n, n2, 1);
    }

    public void setImage(Image image, int n, int n2, int n3) {
        this.img = image;
        this.frame_width = n;
        this.frames = n2;
        this.frame_height = image.getHeight() / n3;
        this.source_rows = n3;
        this.frames_per_row = n2 / n3;
    }

    public void setImageRows(int n) {
        this.source_rows = n;
        this.frame_height /= this.source_rows;
        this.frames_per_row = this.frames / this.source_rows;
    }

    public void setEventListener(CanvasEventListener canvasEventListener) {
        this.listener = canvasEventListener;
    }

    public void animate() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.thread = null;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public void setBackgroundColour(int n) {
        this.backgroundColour = n;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (thread == this.thread) {
            try {
                this.frame = this.frame >= this.frames - 1 ? 0 : this.frame + 1;
                this.repaint();
                this.serviceRepaints();
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.backgroundColour);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.topImage != null) {
            graphics.drawImage(this.topImage, 0, 0, 0x10 | 4);
        }
        if (this.img != null) {
            if (this.frames > 1) {
                int n = (this.getWidth() >> 1) - (this.frame_width >> 1);
                int n2 = (this.getHeight() >> 1) - (this.frame_height >> 1);
                int n3 = n - this.frame % this.frames_per_row * this.frame_width;
                int n4 = n2 - this.frame / this.frames_per_row * this.frame_height;
                graphics.setClip(n, n2, this.frame_width, this.frame_height);
                graphics.drawImage(this.img, n3, n4, 0x10 | 4);
            } else {
                int n = (this.getWidth() >> 1) - (this.img.getWidth() >> 1);
                int n5 = (this.getHeight() >> 1) - (this.img.getHeight() >> 1);
                graphics.drawImage(this.img, n, n5, 0x10 | 4);
            }
        }
    }

    protected void hideNotify() {
        this.cleared = false;
    }

    protected void keyPressed(int n) {
        if (this.listener != null) {
            this.listener.triggeredEvent(this);
        }
    }

    protected void pointerPressed(int n, int n2) {
        if (this.listener != null) {
            this.listener.triggeredEvent(this);
        }
    }

    public void purge() {
        if (this.img != null) {
            this.img = null;
            System.gc();
        }
    }
}

