/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;

public class RecordManager {
    public static void save(byte[] byArray, String string) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            recordStore.setRecord(1, byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (InvalidRecordIDException invalidRecordIDException) {
            try {
                recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception2) {
                    System.out.println(exception.toString());
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public static void save(int n, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(n);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        RecordManager.save(byteArrayOutputStream.toByteArray(), string);
    }

    public static void save(long l, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        RecordManager.save(byteArrayOutputStream.toByteArray(), string);
    }

    public static void save(String string, String string2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(string);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        RecordManager.save(byteArrayOutputStream.toByteArray(), string2);
    }

    public static byte[] load(String string) {
        byte[] byArray = null;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            if (recordStore.getNumRecords() > 0) {
                byArray = recordStore.getRecord(1);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception2) {
                System.out.println(exception.toString());
            }
        }
        return byArray;
    }

    public static void delete(String string) {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public static boolean exists(String string) {
        String[] stringArray = RecordStore.listRecordStores();
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static int byteArrayToInt(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        if (byArray.length < 4) {
            return 0;
        }
        int n = 0;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            n = dataInputStream.readInt();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        return n;
    }

    public static long byteArrayToLong(byte[] byArray) {
        if (byArray == null) {
            return 0L;
        }
        if (byArray.length < 8) {
            return 0L;
        }
        long l = 0L;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            l = dataInputStream.readLong();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        return l;
    }

    public static String byteArrayToString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        String string = "";
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            string = dataInputStream.readUTF();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        return string;
    }
}

