/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class OptionCanvas
extends Canvas
implements Runnable {
    public static int NO_COMMAND = 0;
    public static int BACK_COMMAND = 1;
    public static int SELECT_COMMAND = 2;
    public static int LEFT_SOFTKEY = 3;
    public static int RIGHT_SOFTKEY = 4;
    public static int BACK_SOFTKEY = 5;
    public static final int SELECT_SINGLE = 0;
    public static final int SELECT_MULTI = 1;
    private static final int DEFAULT_COLOUR = -1;
    private static final int BACKGROUND_COLOUR = 0xFFFFFF;
    private static final int TITLE_COLOUR = 0xCC0000;
    private static final int TEXT_COLOUR = 0;
    private static final int ANSWER_COLOUR = 0;
    private static final int ROLLOVER_TEXT_COLOUR = 0xFFFFFF;
    private static final int ROLLOVER_BG_COLOUR = 0x333333;
    private static final int SCROLL_BAR_BACKGROUND = 28876;
    private static final int SCROLL_BAR_DRAGGER = 0xFFFFFF;
    private static final int SCROLL_INCREMENT = 30;
    private int LINE_SPACING = 2;
    private int LEFT_MARGIN = 5;
    private int TOP_MARGIN = 0;
    private int RADIO_WIDTH = 18;
    private int RADIO_HEIGHT = 12;
    private int SCROLL_BAR_WIDTH = 4;
    private int verticalPosition = 0;
    private int draggerHeight = 0;
    private int pageHeight = 0;
    private int w;
    private int h;
    private int sw;
    private int sh;
    private int selectedIndex = 0;
    private Vector checkedOptions;
    private int selectMode = 0;
    private Image radioButtonImage;
    private Image checkBoxImage;
    private Image topImage = null;
    private Image bodyImage = null;
    private Image loadingImage = null;
    private boolean displayLoading = false;
    private String body;
    private String title;
    private Vector titleLines;
    private Vector bodyLines;
    private Vector options;
    private Vector checkboxVerticalPositions;
    private int titleColour = 0xCC0000;
    private String leftCommand = null;
    private String rightCommand = null;
    public String alertTitle;
    public String alertText;
    public boolean displayAlert = false;
    private OptionCanvasListener listener = null;
    private Image timeLimit;
    private int countdown = 0;
    private boolean doCountdown = false;
    private long countdownStartTime = 0L;
    private Thread t = null;
    private Quiz parent = null;

    public void setCommands(String string, String string2) {
        this.leftCommand = string;
        this.rightCommand = string2;
        this.h = string != null || string2 != null ? this.sh - Common.fontRenderer.getHeight() - 6 : this.sh;
    }

    public void drawCommands(Graphics graphics) {
        Common.drawCommands(graphics, this.leftCommand, this.rightCommand, this.sw, this.sh);
    }

    public void displayAlert(String string, String string2) {
        this.displayAlert = true;
        this.alertTitle = string;
        this.alertText = string2;
        this.repaint();
    }

    public boolean alertOnDisplay() {
        return this.displayAlert;
    }

    public void hideAlert() {
        this.displayAlert = false;
        this.repaint();
    }

    public OptionCanvas() {
        this.construct(null);
    }

    public OptionCanvas(Image image) {
        this.construct(image);
    }

    public OptionCanvas(String string, String string2, Image image) {
        this.construct(image);
        this.setPageTitle(string);
        this.setText(string2);
    }

    public OptionCanvas(String string, String string2) {
        this.construct(null);
        this.setPageTitle(string);
        this.setText(string2);
    }

    public OptionCanvas(String string, String string2, String string3, String string4) {
        this.construct(null);
        this.setPageTitle(string);
        this.setText(string2);
        this.addOption(string3);
        this.addOption(string4);
    }

    private void construct(Image image) {
        this.setFullScreenMode(true);
        this.loadUIImages();
        this.topImage = image;
        this.w = this.getWidth();
        this.h = this.getHeight();
        this.selectMode = 0;
        this.selectedIndex = 0;
        this.checkedOptions = new Vector();
        this.init();
    }

    public void setOptionCanvasListener(OptionCanvasListener optionCanvasListener) {
        this.listener = optionCanvasListener;
    }

    private void init() {
        this.title = null;
        this.titleLines = new Vector();
        this.body = null;
        this.bodyLines = new Vector();
        this.selectedIndex = 0;
        this.options = new Vector();
        this.checkedOptions = new Vector();
        this.checkboxVerticalPositions = new Vector();
    }

    public void reset() {
        this.init();
    }

    private void measureCanvas() {
        this.verticalPosition = 0;
        this.selectedIndex = 0;
        int n = this.TOP_MARGIN;
        if (this.topImage != null) {
            n += this.topImage.getHeight();
        }
        if (this.bodyImage != null) {
            n += this.bodyImage.getHeight();
        }
        n += 3;
        n += this.titleLines.size() * (Common.titleFontRenderer.getHeight() + this.LINE_SPACING);
        n += Common.titleFontRenderer.getHeight();
        n += this.bodyLines.size() * (Common.fontRenderer.getHeight() + this.LINE_SPACING);
        if (this.options.size() > 0) {
            n += Common.fontRenderer.getHeight();
            int n2 = 0;
            Enumeration enumeration = this.options.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector = (Vector)enumeration.nextElement();
                this.checkboxVerticalPositions.setElementAt(new Integer(n += vector.size() * (Common.fontRenderer.getHeight() + this.LINE_SPACING) + this.LINE_SPACING * 2), n2++);
            }
        }
        this.pageHeight = n += Common.fontRenderer.getHeight() >> 2;
        try {
            this.draggerHeight = (this.h - 2) * 100 / (this.pageHeight * 100 / (this.h - 2));
            if (this.draggerHeight > this.h - 2) {
                this.draggerHeight = this.sh - 2;
            }
        }
        catch (Exception exception) {
            this.draggerHeight = this.h >> 1;
        }
        if (this.isShown()) {
            this.repaint();
        }
    }

    public void setOption(int n, String string) throws ArrayIndexOutOfBoundsException {
        this.options.setElementAt(string.trim(), n);
        this.measureCanvas();
    }

    public void addOption(String string) {
        this.options.addElement(FontRenderer.splitString("\n", Common.fontRenderer.wrapString(string, this.w - this.LEFT_MARGIN - this.RADIO_WIDTH - this.SCROLL_BAR_WIDTH)));
        this.checkboxVerticalPositions.addElement(new Integer(0));
        this.checkedOptions.addElement(new Boolean(false));
        this.measureCanvas();
    }

    public void removeAllOptions() {
        this.options = new Vector();
        this.checkboxVerticalPositions = new Vector();
        this.checkedOptions = new Vector();
        this.selectedIndex = 0;
        this.measureCanvas();
    }

    public void setText(String string) {
        if (string == null) {
            this.bodyLines = new Vector();
        } else {
            this.body = string.trim();
            this.bodyLines = FontRenderer.splitString("\n", Common.fontRenderer.wrapString(this.body, this.w - this.LEFT_MARGIN * 2 - this.SCROLL_BAR_WIDTH));
        }
        this.measureCanvas();
    }

    public void setImage(Image image) {
        this.topImage = image;
        this.measureCanvas();
    }

    public void setPageTitle(String string) {
        if (string == null) {
            this.titleLines = new Vector();
        } else {
            this.title = string.trim();
            this.titleLines = FontRenderer.splitString("\n", Common.titleFontRenderer.wrapString(this.title, this.w - this.LEFT_MARGIN - this.SCROLL_BAR_WIDTH));
        }
        this.measureCanvas();
    }

    public void setPageTitleColour(int n) {
        this.titleColour = n == -1 ? 0xCC0000 : n;
    }

    public void setBodyImage(Image image) {
        this.bodyImage = image;
        this.measureCanvas();
    }

    public void setSelectMode(int n) {
        this.selectMode = n;
        if (this.selectMode > 1) {
            this.selectMode = 0;
        }
    }

    public int getSelectMode() {
        return this.selectMode;
    }

    public int getCheckedOption() {
        int n = 0;
        Enumeration enumeration = this.checkedOptions.elements();
        while (enumeration.hasMoreElements()) {
            if (((Boolean)enumeration.nextElement()).booleanValue()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getSelectedIndex() {
        return this.getCheckedOption();
    }

    public boolean[] getCheckedOptions() {
        boolean[] blArray = new boolean[this.checkedOptions.size()];
        int n = 0;
        Enumeration enumeration = this.checkedOptions.elements();
        while (enumeration.hasMoreElements()) {
            blArray[n++] = (Boolean)enumeration.nextElement();
        }
        return blArray;
    }

    public void setCheckedOption(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
        if (this.selectMode == 0) {
            int n2;
            if (bl && (n2 = this.getCheckedOption()) > 0) {
                this.checkedOptions.setElementAt(new Boolean(false), n2);
            }
            this.checkedOptions.setElementAt(new Boolean(bl), n);
        } else {
            this.checkedOptions.setElementAt(new Boolean(bl), n);
        }
    }

    public void setSelectedIndex(int n) throws ArrayIndexOutOfBoundsException {
        this.setCheckedOption(n, true);
    }

    private void loadUIImages() {
        try {
            this.radioButtonImage = Image.createImage((String)"/ui_radio.png");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to load: /ui_radio.png");
        }
        try {
            this.checkBoxImage = Image.createImage((String)"/ui_check.png");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to load: /ui_check.png");
        }
        try {
            this.loadingImage = Image.createImage((String)"/ui_loading.png");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to load: /ui_loading.png");
        }
    }

    private void renderPage(Graphics graphics) {
        Enumeration enumeration;
        int n;
        int n2 = this.TOP_MARGIN + this.verticalPosition;
        if (this.topImage != null) {
            if (n2 + this.topImage.getHeight() > 0) {
                graphics.drawImage(this.topImage, 0, n2, 0x10 | 4);
            }
            n2 += this.topImage.getHeight();
        }
        n2 += 3;
        if (this.doCountdown) {
            n = this.w - this.LEFT_MARGIN - 32 - 2;
            graphics.setClip(n, n2 - 7, 32, 45);
            graphics.drawImage(this.timeLimit, this.w - this.LEFT_MARGIN - 32 - 2 - this.countdown * 32, n2 - 7, 0x10 | 4);
            graphics.setClip(0, 0, this.w, this.h);
        }
        if (this.titleLines.size() > 0) {
            enumeration = this.titleLines.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (n2 + Common.titleFontRenderer.getHeight() > 0 && n2 < this.h) {
                    Common.titleFontRenderer.drawString(graphics, string, this.LEFT_MARGIN, n2);
                }
                n2 += Common.titleFontRenderer.getHeight() + this.LINE_SPACING;
            }
        }
        n2 += Common.titleFontRenderer.getHeight();
        if (this.bodyImage != null) {
            if (n2 + this.bodyImage.getHeight() > 0) {
                graphics.drawImage(this.bodyImage, this.LEFT_MARGIN, n2, 0x10 | 4);
            }
            n2 += this.bodyImage.getHeight() + 3;
        }
        if (this.bodyLines.size() > 0) {
            enumeration = this.bodyLines.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (n2 + Common.fontRenderer.getHeight() > 0 && n2 + Common.fontRenderer.getHeight() < this.h) {
                    Common.fontRenderer.drawString(graphics, string, this.LEFT_MARGIN, n2);
                }
                n2 += Common.fontRenderer.getHeight() + this.LINE_SPACING;
            }
        }
        if (this.options.size() > 0) {
            n = 0;
            if (Common.fontRenderer.getHeight() + this.LINE_SPACING > this.RADIO_HEIGHT) {
                n = (Common.fontRenderer.getHeight() + this.LINE_SPACING - this.RADIO_HEIGHT) / 2;
            }
            n2 += Common.fontRenderer.getHeight();
            boolean bl = false;
            int n3 = 0;
            enumeration = this.options.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector = (Vector)enumeration.nextElement();
                if (this.selectedIndex == n3) {
                    graphics.setColor(0x333333);
                    graphics.fillRect(1, n2 - 3, this.w - 2, vector.size() * (Common.fontRenderer.getHeight() + this.LINE_SPACING) + 6);
                    graphics.setClip(this.LEFT_MARGIN, n2 + n, this.RADIO_HEIGHT, this.RADIO_HEIGHT);
                    if (this.selectMode == 0) {
                        if (((Boolean)this.checkedOptions.elementAt(n3)).booleanValue()) {
                            graphics.drawImage(this.radioButtonImage, this.LEFT_MARGIN - 3 * this.RADIO_HEIGHT, n2 + n, 0x10 | 4);
                        } else {
                            graphics.drawImage(this.radioButtonImage, this.LEFT_MARGIN - 2 * this.RADIO_HEIGHT, n2 + n, 0x10 | 4);
                        }
                    } else if (((Boolean)this.checkedOptions.elementAt(n3)).booleanValue()) {
                        graphics.drawImage(this.checkBoxImage, this.LEFT_MARGIN - 3 * this.RADIO_HEIGHT, n2 + n, 0x10 | 4);
                    } else {
                        graphics.drawImage(this.checkBoxImage, this.LEFT_MARGIN - 2 * this.RADIO_HEIGHT, n2 + n, 0x10 | 4);
                    }
                } else {
                    graphics.setClip(this.LEFT_MARGIN, n2 + n, this.RADIO_HEIGHT, this.RADIO_HEIGHT);
                    if (this.selectMode == 0) {
                        if (((Boolean)this.checkedOptions.elementAt(n3)).booleanValue()) {
                            graphics.drawImage(this.radioButtonImage, this.LEFT_MARGIN - this.RADIO_HEIGHT, n2 + n, 0x10 | 4);
                        } else {
                            graphics.drawImage(this.radioButtonImage, this.LEFT_MARGIN, n2 + n, 0x10 | 4);
                        }
                    } else if (((Boolean)this.checkedOptions.elementAt(n3)).booleanValue()) {
                        graphics.drawImage(this.checkBoxImage, this.LEFT_MARGIN - this.RADIO_HEIGHT, n2 + n, 0x10 | 4);
                    } else {
                        graphics.drawImage(this.checkBoxImage, this.LEFT_MARGIN, n2 + n, 0x10 | 4);
                    }
                }
                graphics.setClip(0, 0, this.w, this.h);
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    if (n2 + Common.fontRenderer.getHeight() > 0 && n2 < this.h) {
                        if (this.selectedIndex == n3) {
                            Common.inverseFontRenderer.drawString(graphics, string, this.LEFT_MARGIN + this.RADIO_WIDTH, n2 + 2);
                        } else {
                            Common.fontRenderer.drawString(graphics, string, this.LEFT_MARGIN + this.RADIO_WIDTH, n2 + 2);
                        }
                    }
                    n2 += Common.fontRenderer.getHeight() + this.LINE_SPACING;
                }
                n2 += this.LINE_SPACING * 2;
                ++n3;
            }
        }
    }

    public void paint(Graphics graphics) {
        this.setFullScreenMode(true);
        this.sw = this.getWidth();
        this.sh = this.getHeight();
        this.h = this.leftCommand != null || this.rightCommand != null ? this.sh - Common.fontRenderer.getHeight() - 6 : this.sh;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.sw, this.sh);
        int n = 0;
        int n2 = 0;
        if (this.verticalPosition < 0) {
            try {
                n = 100000 / (this.pageHeight - this.h) * Math.abs(this.verticalPosition) / 1000;
                n2 = (this.h - this.draggerHeight) * 10000 / 100 * n / 10000;
            }
            catch (Exception exception) {
                n = 0;
                n2 = 0;
            }
            if (n > 98) {
                n2 = this.h - this.draggerHeight - 2;
            }
            if (n2 + this.draggerHeight >= this.h - 3) {
                this.verticalPosition = -(this.pageHeight - this.h);
                n2 = this.h - this.draggerHeight - 2;
            }
        } else if (this.draggerHeight > this.h - 2) {
            this.draggerHeight = this.h - 2;
        }
        this.renderPage(graphics);
        graphics.setClip(0, 0, this.w, this.h);
        if (this.displayLoading) {
            graphics.drawImage(this.loadingImage, this.w - this.loadingImage.getWidth() - this.SCROLL_BAR_WIDTH - 1, 1, 0x10 | 4);
        }
        graphics.setColor(28876);
        graphics.fillRect(this.w - this.SCROLL_BAR_WIDTH, 0, this.SCROLL_BAR_WIDTH, this.h);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(this.w - this.SCROLL_BAR_WIDTH + 1, n2 + 1, this.SCROLL_BAR_WIDTH - 2, this.draggerHeight);
        graphics.setClip(0, 0, this.w, this.sh);
        graphics.setColor(0xD0D0D0);
        graphics.fillRect(0, this.h, this.w, this.sh - this.h);
        if (this.displayAlert) {
            Common.drawAlert(graphics, this.alertTitle, this.alertText, this.sw, this.h);
            Common.drawCommands(graphics, null, Strings.CMD_OK, this.sw, this.getHeight());
        } else {
            this.drawCommands(graphics);
        }
    }

    protected void keyPressed(int n) {
        if (!this.displayLoading) {
            this.handleScrolling(n);
        }
    }

    protected void keyRepeated(int n) {
        if (!this.displayLoading) {
            this.handleScrolling(n);
        }
    }

    protected void handleScrolling(int n) {
        int n2;
        if (Common.isLSK(n)) {
            if (this.listener != null) {
                this.listener.optionCanvasAction(this, LEFT_SOFTKEY);
                return;
            }
        } else {
            if (Common.isRSK(n)) {
                if (this.listener != null) {
                    this.listener.optionCanvasAction(this, RIGHT_SOFTKEY);
                }
                return;
            }
            if (Common.isBackKey(n) && this.listener != null) {
                this.listener.optionCanvasAction(this, BACK_SOFTKEY);
                return;
            }
        }
        if ((n2 = this.getGameAction(n)) == 6 || n == 56) {
            if (this.selectedIndex < this.options.size() - 1) {
                if (this.pageHeight <= this.h || Math.abs(this.verticalPosition) == Math.abs(this.pageHeight - this.h)) {
                    ++this.selectedIndex;
                } else {
                    this.verticalPosition -= 30;
                    this.checkConstraints();
                    if ((Integer)this.checkboxVerticalPositions.elementAt(this.selectedIndex + 1) - Math.abs(this.verticalPosition) < this.h >> 1 || (Integer)this.checkboxVerticalPositions.elementAt(this.selectedIndex) - Math.abs(this.verticalPosition) < 0) {
                        ++this.selectedIndex;
                    }
                }
            } else {
                this.verticalPosition -= 30;
                this.checkConstraints();
            }
            this.repaint();
        } else if (n2 == 1 || n == 50) {
            if (this.selectedIndex > 0) {
                if (this.pageHeight <= this.h || Math.abs(this.verticalPosition) == Math.abs(this.pageHeight - this.h)) {
                    --this.selectedIndex;
                    if ((Integer)this.checkboxVerticalPositions.elementAt(this.selectedIndex) - Math.abs(this.verticalPosition) < 10) {
                        this.verticalPosition += 30;
                        this.checkConstraints();
                    }
                } else {
                    this.verticalPosition += 30;
                    this.checkConstraints();
                    if ((Integer)this.checkboxVerticalPositions.elementAt(this.selectedIndex - 1) - Math.abs(this.verticalPosition) >= 10) {
                        --this.selectedIndex;
                    }
                }
            } else {
                this.verticalPosition += 30;
                this.checkConstraints();
            }
            this.repaint();
        } else if (n2 == 8 || n == 53) {
            if (this.options.size() > 0) {
                this.manualSelect();
                if (this.listener != null) {
                    this.listener.optionCanvasAction(this, SELECT_COMMAND);
                }
            }
        } else if (n2 == 2 || n == 52) {
            if (this.listener != null) {
                this.listener.optionCanvasAction(this, BACK_COMMAND);
            }
        } else if (this.listener != null) {
            this.listener.optionCanvasAction(this, n);
        }
    }

    public void manualSelect() {
        if (this.selectMode == 0) {
            int n = this.getCheckedOption();
            if (n >= 0) {
                this.checkedOptions.setElementAt(new Boolean(false), this.getCheckedOption());
            }
            this.checkedOptions.setElementAt(new Boolean(true), this.selectedIndex);
        } else if (((Boolean)this.checkedOptions.elementAt(this.selectedIndex)).booleanValue()) {
            this.checkedOptions.setElementAt(new Boolean(false), this.selectedIndex);
        } else {
            this.checkedOptions.setElementAt(new Boolean(true), this.selectedIndex);
        }
        this.repaint();
    }

    protected void checkConstraints() {
        if (this.pageHeight <= this.h) {
            this.verticalPosition = 0;
            return;
        }
        if (this.verticalPosition > 0) {
            this.verticalPosition = 0;
        }
        if (Math.abs(this.verticalPosition) > Math.abs(this.pageHeight - this.h)) {
            this.verticalPosition = -(this.pageHeight - this.h);
        }
    }

    public void resetScrolling() {
        this.verticalPosition = 0;
        this.selectedIndex = 0;
        this.repaint();
    }

    public void setLoading(boolean bl) {
        this.displayLoading = bl;
        if (this.loadingImage == null) {
            this.displayLoading = false;
        }
        this.repaint();
    }

    public void displayCountdown(boolean bl) {
        this.doCountdown = bl;
        try {
            if (this.timeLimit == null) {
                this.timeLimit = Image.createImage((String)"/countdown.png");
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to load timer image");
        }
    }

    public void resetCountdown() {
        this.countdown = 0;
    }

    public void startCountdown() {
        if (this.t == null && this.doCountdown) {
            this.t = new Thread(this);
            this.t.start();
        }
        this.countdownStartTime = System.currentTimeMillis();
    }

    public void stopCountdown() {
        this.t = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.t == thread) {
            try {
                this.repaint();
                this.serviceRepaints();
                Thread.sleep(60L);
                if (this.countdown >= 10) continue;
                this.countdown = (int)((System.currentTimeMillis() - this.countdownStartTime) / 1200L);
                if (this.countdown < 10) continue;
                this.parent.ontoNextQuestion();
            }
            catch (Exception exception) {}
        }
    }

    public void setParent(Quiz quiz) {
        this.parent = quiz;
    }
}

