/*
 * Decompiled with CFR 0.152.
 */
package sol;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import main.Debug;
import main.Defines;
import main.Fonts;
import main.GFont;
import main.IScreen;
import main.Keys;
import main.MainCanvas;
import main.Resources;
import main.ScreenMenu;
import main.Settings;
import main.X;
import main.stateSol;
import sol.Card;
import sol.Game;

public class ScreenGameSol
implements IScreen {
    public static Game Game;
    public static int[] pointerArray;
    public static int iWaitTime;
    public static int DEFAULT_WAIT_TIME;
    private static int iWinFrame;
    private static Canvas canvas;
    public static int mode;
    public static int old_mode;
    static final int MODE_LOADING_RES = 0;
    static final int MODE_NEW_ROUND = 1;
    static final int MODE_PLAY = 2;
    static final int MODE_DISTRIBUTION = 3;
    static final int MODE_PAUSE = 4;
    static final int MODE_GAME_OVER = 5;
    static final int ACTION_1 = 0;
    static final int ACTION_2 = 1;
    private static char[] gFontNumsChars;
    private static short[] gFontNumsWidth;
    private static short spaceBetweenScoreNumChars;
    public static GFont gFontNums;
    public static int currentX;
    public static int currentY;
    public static boolean bLastPrFire;
    public static int iLastPrFireTime;
    private static int iSelectedAction;
    private static int iDistributionX;
    private static int iDistributionY;
    private static String[] menuStrings;
    private static String[] actionStrings;
    private static String[] gameModeStrings;
    private static String sGameMenu;
    private static int iSelectedSubMenuItem;
    static final int ITEM_CONTINUE = 0;
    static final int ITEM_RESTART = 1;
    static final int ITEM_MAIN_MENU = 2;
    public int[] iHiddenCards = new int[7];

    private void loadStrings() {
        ScreenGameSol.menuStrings[0] = X.texts.getHashedString("CONTINUE").toUpperCase();
        ScreenGameSol.menuStrings[1] = X.texts.getHashedString("RESTART").toUpperCase();
        ScreenGameSol.menuStrings[2] = X.texts.getHashedString("MAIN_MENU").toUpperCase();
        ScreenGameSol.gameModeStrings[2] = X.texts.getHashedString("YOU_WIN").toUpperCase();
        sGameMenu = X.texts.getHashedString("GAME_MENU").toUpperCase();
    }

    public ScreenGameSol(Canvas canvas, boolean newGame) {
        Debug.traceIn("> ScreenGame.ScreenGame()");
        System.out.println("screengame");
        pointerArray = new int[]{0, 0, 0};
        ScreenGameSol.canvas = canvas;
        Game = new Game();
        this.loadStrings();
        bLastPrFire = false;
        if (newGame) {
            mode = 0;
        } else {
            this.loadGame();
        }
    }

    private void setScoreNumCharsWidth_multiRes() {
        int charsImgHeight = Resources.imgFont2.getHeight();
        if (charsImgHeight == 7) {
            spaceBetweenScoreNumChars = 1;
            gFontNumsWidth = new short[]{3, 5, 4, 4, 4, 5, 4, 5, 5, 5, 7, 7};
        } else if (charsImgHeight == 9) {
            spaceBetweenScoreNumChars = (short)2;
            gFontNumsWidth = new short[]{5, 7, 7, 8, 7, 7, 7, 7, 7, 6, 11, 9};
        } else if (charsImgHeight == 15) {
            spaceBetweenScoreNumChars = (short)2;
            gFontNumsWidth = new short[]{7, 9, 9, 10, 9, 10, 9, 10, 9, 9, 17, 13};
        } else if (charsImgHeight == 21) {
            spaceBetweenScoreNumChars = (short)2;
            gFontNumsWidth = new short[]{10, 13, 14, 15, 13, 14, 14, 13, 14, 14, 23, 17};
        } else if (charsImgHeight == 29) {
            spaceBetweenScoreNumChars = (short)2;
            gFontNumsWidth = new short[]{12, 17, 16, 18, 16, 18, 18, 17, 18, 17, 29, 23};
        } else if (charsImgHeight == 33) {
            spaceBetweenScoreNumChars = (short)2;
            gFontNumsWidth = new short[]{14, 20, 20, 22, 20, 21, 21, 21, 21, 20, 35, 27};
        }
    }

    public void loadGame() {
        Resources.loadGameSolResources();
        pointerArray = new int[]{0, 0, 0};
        Game.generateCards();
        stateSol.loadGame(this);
        this.setScoreNumCharsWidth_multiRes();
        gFontNums = new GFont(Resources.imgFont2, gFontNumsChars, gFontNumsWidth, spaceBetweenScoreNumChars, gFontNumsWidth[1]);
        if (Settings.bMusic) {
            X.soundManager.Stop();
            X.soundManager.SetSoundOn(true);
            X.soundManager.Play(X.MUSIC_MENU_ID, -1);
        } else {
            X.soundManager.Stop();
            X.soundManager.SetSoundOn(false);
        }
        mode = 2;
    }

    private void resetDistributionCoordinates() {
        iDistributionX = 0;
        iDistributionY = 0;
    }

    public String getActualModeName() {
        return "Screen game";
    }

    public void invokeGameMenu() {
        stateSol.saveGame(this);
        mode = 4;
        sol.Game.bRun = false;
        X.soundManager.Stop();
        canvas.repaint();
        canvas.serviceRepaints();
    }

    public void update(long tick) {
        switch (mode) {
            case 0: {
                Resources.loadGameSolResources();
                this.setScoreNumCharsWidth_multiRes();
                gFontNums = new GFont(Resources.imgFont2, gFontNumsChars, gFontNumsWidth, spaceBetweenScoreNumChars, gFontNumsWidth[1]);
                mode = 1;
                canvas.repaint();
                canvas.serviceRepaints();
                if (Settings.bMusic) {
                    X.soundManager.Stop();
                    X.soundManager.SetSoundOn(true);
                    X.soundManager.Play(X.MUSIC_MENU_ID, -1);
                    break;
                }
                X.soundManager.Stop();
                X.soundManager.SetSoundOn(false);
                break;
            }
            case 1: {
                Game.generateCards();
                canvas.repaint();
                canvas.serviceRepaints();
                mode = 2;
                break;
            }
            case 2: {
                canvas.repaint();
                canvas.serviceRepaints();
                if (!this.isGameOver()) break;
                mode = 5;
                sol.Game.bRun = false;
                stateSol.deleteGame();
            }
        }
        canvas.repaint();
        canvas.serviceRepaints();
    }

    private boolean isGameOver() {
        for (int i = 8; i < 12; ++i) {
            if (sol.Game.cardStacks[i] == 13) continue;
            return false;
        }
        return true;
    }

    public static void waiter() {
        int start = (int)System.currentTimeMillis() / 1000;
        int end = (int)System.currentTimeMillis() / 1000;
        while (end - start < iWaitTime) {
            end = (int)System.currentTimeMillis() / 1000;
        }
    }

    private boolean isOnTable(Card card) {
        return false;
    }

    public void paint(Graphics g) {
        switch (mode) {
            case 0: {
                this.paintGameLoading(g);
                break;
            }
            case 1: {
                Resources.paintSolBackground(g);
                break;
            }
            case 2: {
                Resources.paintSolBackground(g);
                this.paintCards(g);
                this.paintTouchPointer(g);
                this.paintScore(g);
                Resources.paintControls(g, 11);
                break;
            }
            case 5: {
                this.paintGameOver(g);
                break;
            }
            case 4: {
                this.paintPause(g);
            }
        }
    }

    public void paintScore(Graphics g) {
        int width = gFontNums.stringWidth(("S" + sol.Game.iScore).toCharArray());
        int x = (Defines.WIDTH / 2 - Resources.iIconsW - width) / 2 + Resources.iIconsW;
        gFontNums.drawString(g, ("S" + sol.Game.iScore).toCharArray(), x, Defines.HEIGHT - Resources.iFont2H - Resources.iFont2H / 2, 4);
        width = gFontNums.stringWidth(("T" + sol.Game.iSeconds).toCharArray());
        x = (Defines.WIDTH / 2 - width) / 2 + Defines.WIDTH / 2 - Resources.iIconsW;
        gFontNums.drawString(g, ("T" + sol.Game.iSeconds).toCharArray(), x, Defines.HEIGHT - Resources.iFont2H - Resources.iFont2H / 2, 4);
    }

    public void paintPointer(Graphics g) {
        int iWidth4OneCard = Defines.WIDTH / 7;
        if (pointerArray[0] == 0) {
            Resources.sprPointer.setFrame(0);
        } else {
            Resources.sprPointer.setFrame(1);
        }
        int xPos = 0;
        int yPos = 0;
        if (pointerArray[1] == 0) {
            xPos = Resources.MAINSTACK_X + Resources.POINTER_OFFSET;
            yPos = Resources.ACE_STACK_Y + Resources.POINTER_OFFSET;
        }
        if (pointerArray[1] == 1) {
            xPos = Resources.MAINSTACK_X + Resources.POINTER_OFFSET + iWidth4OneCard;
            yPos = Resources.ACE_STACK_Y + Resources.POINTER_OFFSET;
        }
        if (pointerArray[1] == 9) {
            xPos = Resources.ACE_STACK_X1;
            yPos = Resources.ACE_STACK_Y + Resources.POINTER_OFFSET;
        }
        if (pointerArray[1] == 10) {
            xPos = Resources.ACE_STACK_X2;
            yPos = Resources.ACE_STACK_Y + Resources.POINTER_OFFSET;
        }
        if (pointerArray[1] == 11) {
            xPos = Resources.ACE_STACK_X3;
            yPos = Resources.ACE_STACK_Y + Resources.POINTER_OFFSET;
        }
        if (pointerArray[1] == 12) {
            xPos = Resources.ACE_STACK_X4;
            yPos = Resources.ACE_STACK_Y + Resources.POINTER_OFFSET;
        }
        if (pointerArray[1] > 1 && pointerArray[1] < 9) {
            xPos = (pointerArray[1] - 2) * iWidth4OneCard + (iWidth4OneCard - Resources.iPointerW) / 2 + Resources.POINTER_OFFSET;
            yPos = this.iHiddenCards[pointerArray[1] - 2] * Resources.iCardH / 8;
            yPos += (pointerArray[2] - 1 - this.iHiddenCards[pointerArray[1] - 2]) * Resources.iCardH / 4 + Resources.SOL_Y + Resources.POINTER_OFFSET;
            if (pointerArray[0] == 1) {
                yPos = this.iHiddenCards[pointerArray[1] - 2] * Resources.iCardH / 8;
                yPos += (pointerArray[2] - this.iHiddenCards[pointerArray[1] - 2]) * Resources.iCardH / 4 + Resources.SOL_Y + Resources.POINTER_OFFSET;
            }
        }
        Sprite sprTmpCards = null;
        if (pointerArray[0] == 1) {
            switch (sol.Game.cardsArray[sol.Game.iHoldingCard].getColNr()) {
                case 0: {
                    sprTmpCards = Resources.sprHearts;
                    break;
                }
                case 1: {
                    sprTmpCards = Resources.sprDiamonds;
                    break;
                }
                case 2: {
                    sprTmpCards = Resources.sprClubs;
                    break;
                }
                case 3: {
                    sprTmpCards = Resources.sprSpades;
                }
            }
            sprTmpCards.setFrame(sol.Game.cardsArray[sol.Game.iHoldingCard].getValue() - 1);
            sprTmpCards.setPosition(xPos, yPos);
            sprTmpCards.paint(g);
            int i = 1;
            while (true) {
                if (i >= sol.Game.iHoldingCount) break;
                for (int j = 0; j < 52; ++j) {
                    if (sol.Game.cardsArray[j].iStackNr != sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr) continue;
                    if (sol.Game.cardsArray[j].iOrderInStack != sol.Game.cardsArray[sol.Game.iHoldingCard].iOrderInStack + i) continue;
                    switch (sol.Game.cardsArray[j].getColNr()) {
                        case 0: {
                            sprTmpCards = Resources.sprHearts;
                            break;
                        }
                        case 1: {
                            sprTmpCards = Resources.sprDiamonds;
                            break;
                        }
                        case 2: {
                            sprTmpCards = Resources.sprClubs;
                            break;
                        }
                        case 3: {
                            sprTmpCards = Resources.sprSpades;
                        }
                    }
                    sprTmpCards.setFrame(sol.Game.cardsArray[j].getValue() - 1);
                    sprTmpCards.setPosition(xPos, yPos + i * Resources.iCardH / 3);
                    sprTmpCards.paint(g);
                }
                ++i;
            }
        }
        Resources.sprPointer.setPosition(xPos, yPos);
        Resources.sprPointer.paint(g);
    }

    public void paintTouchPointer(Graphics g) {
        Sprite sprTmpCards = null;
        if (pointerArray[0] == 1) {
            switch (sol.Game.cardsArray[sol.Game.iHoldingCard].getColNr()) {
                case 0: {
                    sprTmpCards = Resources.sprHearts;
                    break;
                }
                case 1: {
                    sprTmpCards = Resources.sprDiamonds;
                    break;
                }
                case 2: {
                    sprTmpCards = Resources.sprClubs;
                    break;
                }
                case 3: {
                    sprTmpCards = Resources.sprSpades;
                }
            }
            sprTmpCards.setFrame(sol.Game.cardsArray[sol.Game.iHoldingCard].getValue() - 1);
            sprTmpCards.setPosition(currentX - Resources.iCardW / 2, currentY - Resources.iCardH / 2);
            sprTmpCards.paint(g);
            int i = 1;
            while (true) {
                if (i >= sol.Game.iHoldingCount) break;
                for (int j = 0; j < 52; ++j) {
                    if (sol.Game.cardsArray[j].iStackNr != sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr) continue;
                    if (sol.Game.cardsArray[j].iOrderInStack != sol.Game.cardsArray[sol.Game.iHoldingCard].iOrderInStack + i) continue;
                    switch (sol.Game.cardsArray[j].getColNr()) {
                        case 0: {
                            sprTmpCards = Resources.sprHearts;
                            break;
                        }
                        case 1: {
                            sprTmpCards = Resources.sprDiamonds;
                            break;
                        }
                        case 2: {
                            sprTmpCards = Resources.sprClubs;
                            break;
                        }
                        case 3: {
                            sprTmpCards = Resources.sprSpades;
                        }
                    }
                    sprTmpCards.setFrame(sol.Game.cardsArray[j].getValue() - 1);
                    sprTmpCards.setPosition(currentX - Resources.iCardW / 2, currentY - Resources.iCardH / 2 + i * Resources.iCardH / 4);
                    sprTmpCards.paint(g);
                }
                ++i;
            }
        }
    }

    public void paintCards(Graphics g) {
        int i;
        Sprite sprTmpCards = null;
        if (sol.Game.visibleInMainStack == sol.Game.cardStacks[0]) {
            g.drawImage(Resources.imgEmptyStack, Resources.MAINSTACK_X + (Resources.iCardW - Resources.iEmptyStackW) / 2, Resources.MAINSTACK_Y + (Resources.iCardH - Resources.iEmptyStackH) / 2, 0);
        } else {
            for (int i2 = 0; i2 < 3; ++i2) {
                Resources.sprCardRub.setFrame(0);
                Resources.sprCardRub.setPosition(Resources.MAINSTACK_X + i2, Resources.MAINSTACK_Y + i2);
                Resources.sprCardRub.paint(g);
            }
        }
        for (int k = 0; k < 52; ++k) {
            if (sol.Game.cardsArray[k].iStackNr != 0) continue;
            if (sol.Game.cardsArray[k].iOrderInStack != sol.Game.visibleInMainStack - 1) continue;
            if (k != 0) {
                for (int j = 0; j < 52; ++j) {
                    if (sol.Game.cardsArray[j].iStackNr != 0) continue;
                    if (sol.Game.cardsArray[j].iOrderInStack != sol.Game.visibleInMainStack - 2) continue;
                    switch (sol.Game.cardsArray[j].getColNr()) {
                        case 0: {
                            sprTmpCards = Resources.sprHearts;
                            break;
                        }
                        case 1: {
                            sprTmpCards = Resources.sprDiamonds;
                            break;
                        }
                        case 2: {
                            sprTmpCards = Resources.sprClubs;
                            break;
                        }
                        case 3: {
                            sprTmpCards = Resources.sprSpades;
                        }
                    }
                    sprTmpCards.setFrame(sol.Game.cardsArray[j].getValue() - 1);
                    sprTmpCards.setPosition((Resources.ACE_STACK_X1 - Resources.MAINSTACK_X) / 2, Resources.ACE_STACK_Y);
                    sprTmpCards.paint(g);
                }
            }
            switch (sol.Game.cardsArray[k].getColNr()) {
                case 0: {
                    sprTmpCards = Resources.sprHearts;
                    break;
                }
                case 1: {
                    sprTmpCards = Resources.sprDiamonds;
                    break;
                }
                case 2: {
                    sprTmpCards = Resources.sprClubs;
                    break;
                }
                case 3: {
                    sprTmpCards = Resources.sprSpades;
                }
            }
            sprTmpCards.setFrame(sol.Game.cardsArray[k].getValue() - 1);
            sprTmpCards.setPosition((Resources.ACE_STACK_X1 - Resources.MAINSTACK_X) / 2, Resources.ACE_STACK_Y);
            if (pointerArray[0] == 0) {
                sprTmpCards.paint(g);
                continue;
            }
            if (sol.Game.iHoldingCard == -1) continue;
            if (sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr == 0) continue;
            sprTmpCards.paint(g);
        }
        int iWidth4OneCard = Defines.WIDTH / 7;
        for (i = 0; i < 7; ++i) {
            int hiddenCards = 0;
            int j = 0;
            while (true) {
                if (j >= sol.Game.cardStacks[i + 1]) break;
                for (int k = 0; k < 52; ++k) {
                    if (pointerArray[0] == 1) {
                        if (sol.Game.iHoldingCard == k) continue;
                    }
                    if (pointerArray[0] == 1) {
                        if (sol.Game.cardsArray[k].iStackNr == sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr) {
                            if (sol.Game.cardsArray[k].iOrderInStack > sol.Game.cardsArray[sol.Game.iHoldingCard].iOrderInStack) continue;
                        }
                    }
                    if (sol.Game.cardsArray[k].iStackNr != i + 1) continue;
                    if (sol.Game.cardsArray[k].iOrderInStack != j) continue;
                    if (!sol.Game.cardsArray[k].shown) {
                        Resources.sprCardRub.setFrame(0);
                        Resources.sprCardRub.setPosition(i * iWidth4OneCard + (iWidth4OneCard - Resources.iCardW) / 2, Resources.SOL_Y + j * Resources.iCardH / 8);
                        Resources.sprCardRub.paint(g);
                        ++hiddenCards;
                        continue;
                    }
                    switch (sol.Game.cardsArray[k].getColNr()) {
                        case 0: {
                            sprTmpCards = Resources.sprHearts;
                            break;
                        }
                        case 1: {
                            sprTmpCards = Resources.sprDiamonds;
                            break;
                        }
                        case 2: {
                            sprTmpCards = Resources.sprClubs;
                            break;
                        }
                        case 3: {
                            sprTmpCards = Resources.sprSpades;
                        }
                    }
                    sprTmpCards.setFrame(sol.Game.cardsArray[k].getValue() - 1);
                    sprTmpCards.setPosition(i * iWidth4OneCard + (iWidth4OneCard - Resources.iCardW) / 2, Resources.SOL_Y + hiddenCards * Resources.iCardH / 8 + (j - hiddenCards) * Resources.iCardH / 3);
                    sprTmpCards.paint(g);
                }
                ++j;
            }
            this.iHiddenCards[i] = hiddenCards;
        }
        for (i = 0; i < 4; ++i) {
            for (int k = 0; k < 52; ++k) {
                if (sol.Game.cardsArray[k].iStackNr != i + 8) continue;
                if (sol.Game.cardsArray[k].iOrderInStack != sol.Game.cardStacks[i + 8] - 1) continue;
                switch (sol.Game.cardsArray[k].getColNr()) {
                    case 0: {
                        sprTmpCards = Resources.sprHearts;
                        break;
                    }
                    case 1: {
                        sprTmpCards = Resources.sprDiamonds;
                        break;
                    }
                    case 2: {
                        sprTmpCards = Resources.sprClubs;
                        break;
                    }
                    case 3: {
                        sprTmpCards = Resources.sprSpades;
                    }
                }
                if (sol.Game.cardsArray[k].getValue() - 1 > 0) {
                    sprTmpCards.setFrame(sol.Game.cardsArray[k].getValue() - 2);
                    if (i == 0) {
                        sprTmpCards.setPosition(Resources.ACE_STACK_X1, Resources.ACE_STACK_Y);
                    }
                    if (i == 1) {
                        sprTmpCards.setPosition(Resources.ACE_STACK_X2, Resources.ACE_STACK_Y);
                    }
                    if (i == 2) {
                        sprTmpCards.setPosition(Resources.ACE_STACK_X3, Resources.ACE_STACK_Y);
                    }
                    if (i == 3) {
                        sprTmpCards.setPosition(Resources.ACE_STACK_X4, Resources.ACE_STACK_Y);
                    }
                    sprTmpCards.paint(g);
                }
                sprTmpCards.setFrame(sol.Game.cardsArray[k].getValue() - 1);
                if (i == 0) {
                    sprTmpCards.setPosition(Resources.ACE_STACK_X1, Resources.ACE_STACK_Y);
                }
                if (i == 1) {
                    sprTmpCards.setPosition(Resources.ACE_STACK_X2, Resources.ACE_STACK_Y);
                }
                if (i == 2) {
                    sprTmpCards.setPosition(Resources.ACE_STACK_X3, Resources.ACE_STACK_Y);
                }
                if (i == 3) {
                    sprTmpCards.setPosition(Resources.ACE_STACK_X4, Resources.ACE_STACK_Y);
                }
                if (k == sol.Game.iHoldingCard) continue;
                sprTmpCards.paint(g);
            }
        }
    }

    public void paintRestart(Graphics g) {
        this.paintGame(g);
        Resources.paintStatusBar(g, 7);
        Resources.paintTextIntoTable(15, 10, g);
    }

    public void paintGameOver(Graphics g) {
        Resources.paintBackground(g);
        this.paintRaster(g);
        int xParts = Defines.WIDTH / Resources.iInfoBarW - 2;
        int yParts = (Defines.HEIGHT - Resources.iBorderOffH - Resources.iIconsH) / Resources.iInfoBarH - 5;
        Resources.paintMenuBG(xParts, yParts, gameModeStrings[2], g);
        Resources.iGameOverW = Resources.imgGameOverWin.getWidth();
        Resources.iGameOverH = Resources.imgGameOverWin.getHeight();
        g.drawImage(Resources.imgGameOverWin, (Defines.WIDTH - Resources.iGameOverW) / 2, (Defines.HEIGHT - Resources.iGameOverH) / 2, 0);
        int iPosX = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        int iPosY = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2;
        int iWidth = Resources.iInfoBarW * 12;
        int iHeight = Resources.iInfoBarH * 12;
        String sValue = "";
        boolean switchIndex = false;
        int iPosXButt = (Defines.WIDTH - Resources.iInfoBarW * xParts) / 2;
        int iPosYButt = (Defines.HEIGHT - Resources.iInfoBarH * yParts) / 2;
        if (iSelectedAction == 0) {
            Resources.sprIconsON.setFrame(0);
            Resources.sprIconsON.setPosition(iPosXButt + Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsON.paint(g);
        } else {
            Resources.sprIconsOFF.setFrame(0);
            Resources.sprIconsOFF.setPosition(iPosXButt + Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsOFF.paint(g);
        }
        if (iSelectedAction == 1) {
            Resources.sprIconsON.setFrame(3);
            Resources.sprIconsON.setPosition(Defines.WIDTH - iPosXButt - Resources.iIconsW - Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsON.paint(g);
        } else {
            Resources.sprIconsOFF.setFrame(3);
            Resources.sprIconsOFF.setPosition(Defines.WIDTH - iPosXButt - Resources.iIconsW - Resources.iIconsW / 4, Defines.HEIGHT - iPosYButt - Resources.iIconsH - Resources.iIconsW / 4);
            Resources.sprIconsOFF.paint(g);
        }
    }

    public void paintWin(Graphics g) {
    }

    public void paintRaster(Graphics g) {
        int x = 0;
        for (int y = 0; y <= Defines.HEIGHT; y += Resources.iRasterH) {
            while (x <= Defines.WIDTH) {
                g.drawImage(Resources.imgRaster, x, y, 0);
                x += Resources.iRasterW;
            }
            x = 0;
        }
    }

    public void paintPause(Graphics g) {
        Resources.paintBackground(g);
        Resources.paintSolBackground(g);
        this.paintCards(g);
        this.paintPointer(g);
        this.paintScore(g);
        this.paintRaster(g);
        Resources.paintMenuBG(12, 10, sGameMenu, g);
        int iPosX = 0;
        int iPosY = 0;
        int x = (Defines.WIDTH - Resources.iBorderOnW * 8) / 2;
        int submenuPos = Resources.SUBMENU_POS_Y;
        for (int i = 0; i < 3; ++i) {
            if (i == iSelectedSubMenuItem) {
                Resources.paintBorder(2, true, 8, x, submenuPos + i * (Resources.iBorderOnH + Resources.MENU_BUTTONS_OFFSET), g);
            } else {
                Resources.paintBorder(2, false, 8, x, submenuPos + i * (Resources.iBorderOnH + Resources.MENU_BUTTONS_OFFSET), g);
            }
            iPosX = (Defines.WIDTH - Fonts.strWidth(menuStrings[i])) / 2;
            iPosY = submenuPos + i * (Resources.iBorderOnH + Resources.MENU_BUTTONS_OFFSET) + (Resources.iBorderOnH - Resources.iFont1H) / 2;
            Fonts.drawStr(menuStrings[i], iPosX, iPosY, g);
        }
    }

    public void paintGameLoading(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Defines.WIDTH, Defines.HEIGHT);
        Resources.paintLoading(g);
    }

    public void paintGame(Graphics g) {
        Resources.paintBackground(g);
    }

    public void paintCardDistribution(Graphics g) {
        boolean iDefinedPositionX = false;
        boolean iDefinedPositionY = false;
        boolean deltaX = false;
        boolean deltaY = false;
    }

    public static void nextPlayer() {
    }

    public void keyPressed(int keyCode) {
        switch (mode) {
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                this.playKeyPr(keyCode);
                break;
            }
            case 4: {
                this.keyPrPause(keyCode);
                break;
            }
            case 5: {
                this.keyPrGameOver(keyCode);
            }
        }
        canvas.repaint();
        canvas.serviceRepaints();
    }

    public void keyPrGameOver(int keyCode) {
        if ((Keys.key_up || Keys.key_num2 || Keys.key_left || Keys.key_num4) && --iSelectedAction < 0) {
            iSelectedAction = 1;
        }
        if ((Keys.key_down || Keys.key_num8 || Keys.key_right || Keys.key_num6) && ++iSelectedAction > 1) {
            iSelectedAction = 0;
        }
        if (Keys.key_fire || Keys.key_num5) {
            switch (iSelectedAction) {
                case 0: {
                    mode = -1;
                    stateSol.deleteGame();
                    Game = new Game();
                    ScreenGameSol.pointerArray[0] = 0;
                    ScreenGameSol.pointerArray[1] = 0;
                    ScreenGameSol.pointerArray[2] = 0;
                    mode = 0;
                    old_mode = 1;
                    break;
                }
                case 1: {
                    stateSol.deleteGame();
                    Resources.releaseGameSolResources();
                    MainCanvas.scrMenu = new ScreenMenu(canvas, 2);
                    MainCanvas.activeScreen = MainCanvas.scrMenu;
                    MainCanvas.scrGameSol = null;
                }
            }
        }
    }

    public void keyPrPause(int keyCode) {
        if (Keys.key_right || Keys.key_up || Keys.key_num6 || Keys.key_num2) {
            iSelectedSubMenuItem = iSelectedSubMenuItem - 1 < 0 ? 2 : --iSelectedSubMenuItem;
        }
        if (Keys.key_left || Keys.key_down || Keys.key_num4 || Keys.key_num8) {
            iSelectedSubMenuItem = iSelectedSubMenuItem + 1 > 2 ? 0 : ++iSelectedSubMenuItem;
        }
        if (Keys.key_fire || Keys.key_num5) {
            if (iSelectedSubMenuItem == 0) {
                mode = 2;
                sol.Game.bRun = false;
                sol.Game.time = new Thread(Game);
                if (Settings.bMusic) {
                    X.soundManager.Stop();
                    X.soundManager.SetSoundOn(true);
                    X.soundManager.Play(X.MUSIC_MENU_ID, -1);
                } else {
                    X.soundManager.Stop();
                    X.soundManager.SetSoundOn(false);
                }
            }
            if (iSelectedSubMenuItem == 1) {
                mode = -1;
                stateSol.deleteGame();
                Game = new Game();
                ScreenGameSol.pointerArray[0] = 0;
                ScreenGameSol.pointerArray[1] = 0;
                ScreenGameSol.pointerArray[2] = 0;
                mode = 0;
                old_mode = 1;
            }
            if (iSelectedSubMenuItem == 2) {
                Resources.releaseGameSolResources();
                MainCanvas.scrMenu = new ScreenMenu(canvas, 2);
                MainCanvas.activeScreen = MainCanvas.scrMenu;
                MainCanvas.scrGamePok = null;
                return;
            }
        }
    }

    public void control() {
        for (int i = 0; i < 52; ++i) {
            System.out.println(i + ". " + sol.Game.cardsArray[i].getCardString() + ", stack: " + sol.Game.cardsArray[i].iStackNr + ", order: " + sol.Game.cardsArray[i].iOrderInStack + ", " + sol.Game.cardsArray[i].shown);
        }
        System.out.println(sol.Game.cardStacks[8] + ", " + sol.Game.cardStacks[9] + ", " + sol.Game.cardStacks[10] + ", " + sol.Game.cardStacks[11]);
    }

    public void playKeyPr(int keyCode) {
        int oldOrder;
        int oldStack;
        int i;
        if (Keys.key_num0) {
            this.control();
        }
        if (Keys.key_fn1) {
            if (pointerArray[0] == 0) {
                Game.stepBack();
                if (pointerArray[1] > 1) {
                    ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                }
            }
            bLastPrFire = false;
        }
        if (Keys.key_fn2 && mode != 5 && mode != 4) {
            old_mode = mode;
            ScreenGameSol.pointerArray[0] = 0;
            sol.Game.iHoldingCard = -1;
            sol.Game.iHoldingCount = 0;
            stateSol.saveGame(this);
            mode = 4;
            sol.Game.bRun = false;
            X.soundManager.Stop();
            return;
        }
        if (!sol.Game.bRun) {
            sol.Game.bRun = true;
            sol.Game.time.start();
        }
        if (Keys.key_num5 || Keys.key_fire) {
            if (pointerArray[0] == 0) {
                if (pointerArray[1] != 0) {
                    for (i = 0; i < 52; ++i) {
                        if (sol.Game.cardsArray[i].iStackNr != pointerArray[1] - 1) continue;
                        if (pointerArray[1] == 1) {
                            if (sol.Game.cardsArray[i].iOrderInStack == sol.Game.visibleInMainStack - 1) {
                                sol.Game.iHoldingCard = i;
                            }
                        }
                        if (pointerArray[1] != 1) {
                            if (pointerArray[1] - 1 == sol.Game.cardsArray[i].iStackNr) {
                                if (sol.Game.cardsArray[i].iOrderInStack == pointerArray[2] - 1) {
                                    sol.Game.iHoldingCard = i;
                                }
                            }
                        }
                        if (pointerArray[1] <= 8 || pointerArray[1] == 1) continue;
                        if (pointerArray[1] - 1 != sol.Game.cardsArray[i].iStackNr) continue;
                        if (sol.Game.cardsArray[i].iOrderInStack != pointerArray[2]) continue;
                        sol.Game.iHoldingCard = i;
                    }
                    if (sol.Game.iHoldingCard != -1) {
                        ScreenGameSol.pointerArray[0] = 1;
                        ++sol.Game.iHoldingCount;
                        for (i = 0; i < 52; ++i) {
                            if (sol.Game.cardsArray[i].iStackNr != pointerArray[1] - 1) continue;
                            if (sol.Game.cardsArray[i].iStackNr <= 0) continue;
                            if (sol.Game.cardsArray[i].iStackNr >= 8) continue;
                            if (sol.Game.cardsArray[i].iOrderInStack <= sol.Game.cardsArray[sol.Game.iHoldingCard].iOrderInStack) continue;
                            ++sol.Game.iHoldingCount;
                        }
                    }
                    bLastPrFire = true;
                    iLastPrFireTime = sol.Game.iSeconds;
                } else {
                    Game.saveOld();
                    if (++sol.Game.visibleInMainStack > sol.Game.cardStacks[0]) {
                        sol.Game.visibleInMainStack = 0;
                    }
                }
            } else {
                if (this.canReleaseCard()) {
                    Game.saveOld();
                    if (sol.Game.iHoldingCard > 0) {
                        if (sol.Game.cardsArray[sol.Game.iHoldingCard - 1].iStackNr == sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr) {
                            sol.Game.cardsArray[sol.Game.iHoldingCard - 1].shown = true;
                            if (sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr != 0) {
                                sol.Game.iScore += 5;
                            }
                        }
                    }
                    if (pointerArray[1] > 1 && pointerArray[1] < 9) {
                        oldStack = sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr;
                        oldOrder = sol.Game.cardsArray[sol.Game.iHoldingCard].iOrderInStack;
                        int n = sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr;
                        sol.Game.cardStacks[n] = sol.Game.cardStacks[n] - 1;
                        sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr = pointerArray[1] - 1;
                        sol.Game.cardsArray[sol.Game.iHoldingCard].iOrderInStack = pointerArray[2];
                        int n2 = pointerArray[1] - 1;
                        sol.Game.cardStacks[n2] = sol.Game.cardStacks[n2] + 1;
                        pointerArray[2] = pointerArray[2] + 1;
                        if (oldStack == 0) {
                            sol.Game.iScore += 5;
                            --sol.Game.visibleInMainStack;
                            Game.reorganizeMainStack();
                        }
                        if (oldStack > 7) {
                            sol.Game.iScore -= 10;
                        }
                        int i2 = 1;
                        while (true) {
                            if (i2 < sol.Game.iHoldingCount) {
                                for (int j = 0; j < 52; ++j) {
                                    if (sol.Game.cardsArray[j].iStackNr != oldStack) continue;
                                    if (sol.Game.cardsArray[j].iOrderInStack != oldOrder + i2) continue;
                                    int n3 = sol.Game.cardsArray[j].iStackNr;
                                    sol.Game.cardStacks[n3] = sol.Game.cardStacks[n3] - 1;
                                    sol.Game.cardsArray[j].iStackNr = pointerArray[1] - 1;
                                    sol.Game.cardsArray[j].iOrderInStack = pointerArray[2];
                                    int n4 = pointerArray[1] - 1;
                                    sol.Game.cardStacks[n4] = sol.Game.cardStacks[n4] + 1;
                                    pointerArray[2] = pointerArray[2] + 1;
                                }
                                ++i2;
                                continue;
                            }
                            break;
                        }
                    } else if (pointerArray[1] > 8) {
                        if (sol.Game.iHoldingCount == 1) {
                            oldStack = sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr;
                            int n = sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr;
                            sol.Game.cardStacks[n] = sol.Game.cardStacks[n] - 1;
                            sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr = pointerArray[1] - 1;
                            int n5 = pointerArray[1] - 1;
                            sol.Game.cardStacks[n5] = sol.Game.cardStacks[n5] + 1;
                            sol.Game.cardsArray[sol.Game.iHoldingCard].iOrderInStack = sol.Game.cardStacks[pointerArray[1] - 1] - 1;
                            if (oldStack < 8) {
                                sol.Game.iScore += 10;
                            }
                            if (oldStack == 0) {
                                --sol.Game.visibleInMainStack;
                                Game.reorganizeMainStack();
                            }
                            ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                        }
                    }
                } else if (bLastPrFire) {
                    int targetStack;
                    if (sol.Game.iSeconds - iLastPrFireTime < 3 && (targetStack = Game.canPutCardUp()) != 0) {
                        Game.saveOld();
                        if (sol.Game.iHoldingCard > 0) {
                            if (sol.Game.cardsArray[sol.Game.iHoldingCard - 1].iStackNr == sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr) {
                                sol.Game.cardsArray[sol.Game.iHoldingCard - 1].shown = true;
                            }
                        }
                        int oldStack2 = sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr;
                        int n = sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr;
                        sol.Game.cardStacks[n] = sol.Game.cardStacks[n] - 1;
                        sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr = targetStack;
                        int n6 = targetStack;
                        sol.Game.cardStacks[n6] = sol.Game.cardStacks[n6] + 1;
                        sol.Game.cardsArray[sol.Game.iHoldingCard].iOrderInStack = sol.Game.cardStacks[targetStack] - 1;
                        if (oldStack2 < 8) {
                            sol.Game.iScore += 10;
                        }
                        if (oldStack2 == 0) {
                            --sol.Game.visibleInMainStack;
                            Game.reorganizeMainStack();
                        }
                        pointerArray[2] = pointerArray[2] - 1;
                    }
                }
                ScreenGameSol.pointerArray[0] = 0;
                sol.Game.iHoldingCard = -1;
                sol.Game.iHoldingCount = 0;
            }
        }
        if (Keys.key_num2 || Keys.key_up) {
            if (pointerArray[1] == 0) {
                ScreenGameSol.pointerArray[1] = 2;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[1];
            } else if (pointerArray[1] == 1) {
                ScreenGameSol.pointerArray[1] = 3;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[2];
            } else if (pointerArray[1] == 9) {
                ScreenGameSol.pointerArray[1] = 5;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[4];
            } else if (pointerArray[1] == 10) {
                ScreenGameSol.pointerArray[1] = 6;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[5];
            } else if (pointerArray[1] == 11) {
                ScreenGameSol.pointerArray[1] = 7;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[6];
            } else if (pointerArray[1] == 12) {
                ScreenGameSol.pointerArray[1] = 8;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[7];
            } else if (pointerArray[1] > 1 && pointerArray[1] < 9) {
                if (pointerArray[0] == 1) {
                    if (sol.Game.iHoldingCount == 1) {
                        if (pointerArray[1] <= 4) {
                            ScreenGameSol.pointerArray[1] = 9;
                            ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                        } else if (pointerArray[1] > 4) {
                            pointerArray[1] = pointerArray[1] + 4;
                            ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                        }
                    }
                    return;
                }
                pointerArray[2] = pointerArray[2] - 1;
                if (pointerArray[2] < 0) {
                    if (pointerArray[1] < 4) {
                        pointerArray[1] = pointerArray[1] - 2;
                    }
                    if (pointerArray[1] == 4) {
                        ScreenGameSol.pointerArray[1] = 1;
                    }
                    if (pointerArray[1] > 4) {
                        pointerArray[1] = pointerArray[1] + 4;
                        ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                    }
                    return;
                }
                for (i = 0; i < 52; ++i) {
                    if (sol.Game.cardsArray[i].iStackNr != pointerArray[1] - 1) continue;
                    if (sol.Game.cardsArray[i].iOrderInStack != pointerArray[2] - 1 && pointerArray[2] >= 0) continue;
                    if (sol.Game.cardsArray[i].shown) continue;
                    if (pointerArray[0] == 1) {
                        return;
                    }
                    if (pointerArray[1] < 4) {
                        pointerArray[1] = pointerArray[1] - 2;
                    }
                    if (pointerArray[1] == 4) {
                        ScreenGameSol.pointerArray[1] = 1;
                    }
                    if (pointerArray[1] > 4) {
                        pointerArray[1] = pointerArray[1] + 4;
                        ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                    }
                    return;
                }
                if (pointerArray[2] < 1) {
                    if (pointerArray[1] < 4) {
                        pointerArray[1] = pointerArray[1] - 2;
                    }
                    if (pointerArray[1] == 4) {
                        ScreenGameSol.pointerArray[1] = 1;
                    }
                    if (pointerArray[1] > 4) {
                        pointerArray[1] = pointerArray[1] + 4;
                        ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                    }
                }
            }
            bLastPrFire = false;
        }
        if (Keys.key_num8 || Keys.key_down) {
            if (pointerArray[1] == 0) {
                ScreenGameSol.pointerArray[1] = 2;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[1];
            } else if (pointerArray[1] == 1) {
                ScreenGameSol.pointerArray[1] = 3;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[2];
            } else if (pointerArray[1] == 9) {
                ScreenGameSol.pointerArray[1] = 5;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[4];
            } else if (pointerArray[1] == 10) {
                ScreenGameSol.pointerArray[1] = 6;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[5];
            } else if (pointerArray[1] == 11) {
                ScreenGameSol.pointerArray[1] = 7;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[6];
            } else if (pointerArray[1] == 12) {
                ScreenGameSol.pointerArray[1] = 8;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[7];
            } else if (pointerArray[1] > 1 && pointerArray[1] < 9) {
                if (pointerArray[0] == 1) {
                    if (sol.Game.iHoldingCount == 1) {
                        if (pointerArray[1] <= 4) {
                            ScreenGameSol.pointerArray[1] = 9;
                            ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                        } else if (pointerArray[1] > 4) {
                            pointerArray[1] = pointerArray[1] + 4;
                            ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                        }
                    }
                    return;
                }
                pointerArray[2] = pointerArray[2] + 1;
                if (sol.Game.cardStacks[pointerArray[1] - 1] < pointerArray[2]) {
                    if (pointerArray[1] < 4) {
                        pointerArray[1] = pointerArray[1] - 2;
                    }
                    if (pointerArray[1] == 4) {
                        ScreenGameSol.pointerArray[1] = 1;
                    }
                    if (pointerArray[1] > 4) {
                        pointerArray[1] = pointerArray[1] + 4;
                        ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                    }
                }
            }
            bLastPrFire = false;
        }
        if (Keys.key_num6 || Keys.key_right) {
            if (pointerArray[1] == 12) {
                ScreenGameSol.pointerArray[1] = 0;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1]];
                if (pointerArray[0] == 1) {
                    ScreenGameSol.pointerArray[1] = sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr != 0 ? 9 : 1;
                    ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                }
            } else if (pointerArray[1] > 8 && pointerArray[1] < 12) {
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                pointerArray[1] = pointerArray[1] + 1;
            } else if (pointerArray[1] == 1) {
                ScreenGameSol.pointerArray[1] = 9;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[8];
            } else if (pointerArray[1] == 0) {
                ScreenGameSol.pointerArray[1] = 1;
            } else if (pointerArray[1] > 1 && pointerArray[1] < 8) {
                pointerArray[1] = pointerArray[1] + 1;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                if (pointerArray[0] == 1) {
                    oldStack = sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr;
                    oldOrder = sol.Game.cardsArray[sol.Game.iHoldingCard].iOrderInStack;
                    if (pointerArray[1] == oldStack + 1) {
                        ScreenGameSol.pointerArray[2] = oldOrder;
                    }
                }
            } else if (pointerArray[1] == 8) {
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[1];
                ScreenGameSol.pointerArray[1] = 2;
                if (pointerArray[0] == 1) {
                    oldStack = sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr;
                    oldOrder = sol.Game.cardsArray[sol.Game.iHoldingCard].iOrderInStack;
                    if (pointerArray[1] == oldStack + 1) {
                        ScreenGameSol.pointerArray[2] = oldOrder;
                    }
                }
            }
            bLastPrFire = false;
        }
        if (Keys.key_num4 || Keys.key_left) {
            if (pointerArray[1] == 0) {
                ScreenGameSol.pointerArray[1] = 12;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
            } else if (pointerArray[1] > 9 && pointerArray[1] < 13) {
                pointerArray[1] = pointerArray[1] - 1;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
            } else if (pointerArray[1] == 9) {
                ScreenGameSol.pointerArray[1] = 1;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1]];
                if (pointerArray[0] == 1) {
                    ScreenGameSol.pointerArray[1] = sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr != 0 ? 12 : 1;
                }
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
            } else if (pointerArray[1] == 1) {
                ScreenGameSol.pointerArray[1] = 0;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1]];
                if (pointerArray[0] == 1) {
                    ScreenGameSol.pointerArray[1] = 12;
                    ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                }
            } else if (pointerArray[1] > 2 && pointerArray[1] < 9) {
                pointerArray[1] = pointerArray[1] - 1;
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
                if (pointerArray[0] == 1) {
                    oldStack = sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr;
                    oldOrder = sol.Game.cardsArray[sol.Game.iHoldingCard].iOrderInStack;
                    if (pointerArray[1] == oldStack + 1) {
                        ScreenGameSol.pointerArray[2] = oldOrder;
                    }
                }
            } else if (pointerArray[1] == 2) {
                ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[7];
                ScreenGameSol.pointerArray[1] = 8;
                if (pointerArray[0] == 1) {
                    oldStack = sol.Game.cardsArray[sol.Game.iHoldingCard].iStackNr;
                    oldOrder = sol.Game.cardsArray[sol.Game.iHoldingCard].iOrderInStack;
                    if (pointerArray[1] == oldStack + 1) {
                        ScreenGameSol.pointerArray[2] = oldOrder;
                    }
                }
            }
            bLastPrFire = false;
        }
    }

    public boolean canReleaseCard() {
        if (sol.Game.cardsArray[sol.Game.iHoldingCard].getValue() == 13) {
            if (sol.Game.cardStacks[pointerArray[1] - 1] == 0 && pointerArray[1] > 1 && pointerArray[1] < 9) {
                return true;
            }
        }
        for (int i = 0; i < 52; ++i) {
            if (pointerArray[1] > 1 && pointerArray[1] < 9) {
                if (sol.Game.cardsArray[i].iStackNr == pointerArray[1] - 1) {
                    if (sol.Game.cardsArray[i].iOrderInStack == pointerArray[2] - 1) {
                        if (sol.Game.cardsArray[i].canRelease(sol.Game.cardsArray[sol.Game.iHoldingCard])) {
                            return true;
                        }
                    }
                }
            }
            if (pointerArray[1] <= 8 || pointerArray[1] >= 13) continue;
            if (sol.Game.cardsArray[sol.Game.iHoldingCard].getValue() == 1) {
                if (sol.Game.cardStacks[pointerArray[1] - 1] == 0) {
                    return true;
                }
            }
            if (sol.Game.cardsArray[i].iStackNr != pointerArray[1] - 1) continue;
            if (sol.Game.cardsArray[i].iOrderInStack != pointerArray[2] - 1) continue;
            if (!sol.Game.cardsArray[i].canReleaseToUpStack(sol.Game.cardsArray[sol.Game.iHoldingCard])) continue;
            return true;
        }
        return false;
    }

    public void restartKeyPr(int keyCode) {
        if (Keys.key_fn2) {
            // empty if block
        }
        if (Keys.key_fn1) {
            iSelectedSubMenuItem = -10;
        }
    }

    public void GameOverKeyPr(int keyCode) {
        if (Keys.key_fire || Keys.key_num5) {
            Resources.releaseGameSolResources();
            MainCanvas.scrMenu = new ScreenMenu(canvas, 2);
            MainCanvas.activeScreen = MainCanvas.scrMenu;
            MainCanvas.scrGameBJ = null;
            canvas.repaint();
            canvas.serviceRepaints();
        }
    }

    public void RoundOverKeyPr(int keyCode) {
        if ((Keys.key_right || Keys.key_up || Keys.key_fn2 || Keys.key_num6 || Keys.key_num2) && ++iSelectedAction > 7) {
            iSelectedAction = 6;
        }
        if ((Keys.key_left || Keys.key_down || Keys.key_fn1 || Keys.key_num4 || Keys.key_num8) && --iSelectedAction < 6) {
            iSelectedAction = 7;
        }
    }

    public void PauseKeyPr(int keyCode) {
        if (Keys.key_right || Keys.key_up || Keys.key_fn2 || Keys.key_num6 || Keys.key_num2) {
            iSelectedSubMenuItem = iSelectedSubMenuItem - 1 < 0 ? 2 : --iSelectedSubMenuItem;
        }
        if (Keys.key_left || Keys.key_down || Keys.key_fn1 || Keys.key_num4 || Keys.key_num8) {
            iSelectedSubMenuItem = iSelectedSubMenuItem + 1 > 2 ? 0 : ++iSelectedSubMenuItem;
        }
    }

    public void continuePlaying() {
        iWaitTime = DEFAULT_WAIT_TIME;
    }

    public void keyReleased(int keyCode) {
    }

    public void pointerPressed(int x, int y) {
        if (Resources.isInLeftButton(x, y)) {
            Keys.key_fn1 = true;
            this.keyPressed(Keys.iLeftKey);
            Keys.key_fn1 = false;
        }
        if (Resources.isInRightButton(x, y)) {
            Keys.key_fn2 = true;
            this.keyPressed(Keys.iRightKey);
            Keys.key_fn2 = false;
        }
        if (mode == 2) {
            this.pointerPrGame(x, y);
        }
        if (mode == 4) {
            int buttonPressed = Resources.whichSubMenuButton(x, y);
            switch (buttonPressed) {
                case 1: {
                    iSelectedSubMenuItem = 0;
                    break;
                }
                case 2: {
                    iSelectedSubMenuItem = 1;
                    break;
                }
                case 3: {
                    iSelectedSubMenuItem = 2;
                    break;
                }
                default: {
                    iSelectedSubMenuItem = -1;
                }
            }
            Keys.key_fire = true;
            this.keyPressed(Keys.iEnterKey);
            Keys.key_fire = false;
        }
        if (mode == 5) {
            iSelectedAction = Resources.WhichWelcomeButton(x, y);
            if (iSelectedAction == 1) {
                iSelectedAction = -1;
            }
            if (iSelectedAction == 2) {
                iSelectedAction = 1;
            }
            System.out.println(iSelectedAction);
            Keys.key_fire = true;
            this.keyPressed(Keys.iEnterKey);
            Keys.key_fire = false;
        }
    }

    public void pointerPrGame(int x, int y) {
        currentX = x;
        currentY = y;
        if (this.setPointer(x, y)) {
            Keys.key_fire = true;
            this.keyPressed(Keys.iEnterKey);
            Keys.key_fire = false;
        }
        currentX = x;
        currentY = y;
        canvas.repaint();
        canvas.serviceRepaints();
    }

    public void pointerReleased(int x, int y) {
        if (mode == 4) {
            Keys.key_fire = true;
            this.keyPressed(Keys.iEnterKey);
            Keys.key_fire = false;
            iSelectedSubMenuItem = -1;
            canvas.repaint();
            canvas.serviceRepaints();
        } else if (pointerArray[0] == 1) {
            this.setPointer(x, y);
            Keys.key_fire = true;
            this.keyPressed(Keys.iEnterKey);
            Keys.key_fire = false;
        }
    }

    public boolean setPointer(int x, int y) {
        int i;
        int xCard = Resources.MAINSTACK_X;
        int yCard = Resources.MAINSTACK_Y;
        if (x > xCard && x < xCard + Resources.iCardW && y > yCard && y < yCard + Resources.iCardH) {
            ScreenGameSol.pointerArray[1] = 0;
            return true;
        }
        xCard = (Resources.ACE_STACK_X1 - Resources.MAINSTACK_X) / 2;
        yCard = Resources.ACE_STACK_Y;
        if (x > xCard && x < xCard + Resources.iCardW && y > yCard && y < yCard + Resources.iCardH) {
            ScreenGameSol.pointerArray[1] = 1;
            return true;
        }
        xCard = (Resources.ACE_STACK_X1 - Resources.MAINSTACK_X) / 2;
        yCard = Resources.ACE_STACK_Y;
        if (x > xCard && x < xCard + Resources.iCardW && y > yCard && y < yCard + Resources.iCardH) {
            ScreenGameSol.pointerArray[1] = 1;
            return true;
        }
        int iWidth4OneCard = Defines.WIDTH / 7;
        for (i = 0; i < 7; ++i) {
            int k;
            int hiddenCards = 0;
            int j = 0;
            while (true) {
                if (j >= sol.Game.cardStacks[i + 1]) break;
                for (k = 0; k < 52; ++k) {
                    if (sol.Game.cardsArray[k].iStackNr != i + 1) continue;
                    if (sol.Game.cardsArray[k].iOrderInStack != j) continue;
                    if (sol.Game.cardsArray[k].shown) continue;
                    ++hiddenCards;
                }
                ++j;
            }
            for (j = sol.Game.cardStacks[i + 1]; j >= 0; --j) {
                for (k = 0; k < 52; ++k) {
                    if (sol.Game.cardsArray[k].iStackNr != i + 1) continue;
                    if (sol.Game.cardsArray[k].iOrderInStack != j) continue;
                    if (!sol.Game.cardsArray[k].shown) continue;
                    xCard = i * iWidth4OneCard + (iWidth4OneCard - Resources.iCardW) / 2;
                    yCard = Resources.SOL_Y + hiddenCards * Resources.iCardH / 8 + (j - hiddenCards) * Resources.iCardH / 3;
                    if (x <= xCard || x >= xCard + Resources.iCardW) continue;
                    System.out.println(yCard + ", " + y);
                    if (y <= yCard || y >= yCard + Resources.iCardH) continue;
                    ScreenGameSol.pointerArray[1] = i + 2;
                    ScreenGameSol.pointerArray[2] = j + 1;
                    System.out.println(pointerArray[1] + "  " + pointerArray[2]);
                    return true;
                }
                this.iHiddenCards[i] = hiddenCards;
            }
            if (pointerArray[0] != 1) continue;
            if (sol.Game.cardStacks[i + 1] != 0) continue;
            xCard = i * iWidth4OneCard + (iWidth4OneCard - Resources.iCardW) / 2;
            yCard = Resources.SOL_Y;
            if (x <= xCard || x >= xCard + Resources.iCardW) continue;
            System.out.println(yCard + ", " + y);
            if (y <= yCard || y >= yCard + Resources.iCardH) continue;
            ScreenGameSol.pointerArray[1] = i + 2;
            ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
            System.out.println(pointerArray[1] + "......  " + pointerArray[2]);
            return true;
        }
        for (i = 0; i < 4; ++i) {
            if (i == 0) {
                xCard = Resources.ACE_STACK_X1;
                yCard = Resources.ACE_STACK_Y;
            }
            if (i == 1) {
                xCard = Resources.ACE_STACK_X2;
                yCard = Resources.ACE_STACK_Y;
            }
            if (i == 2) {
                xCard = Resources.ACE_STACK_X3;
                yCard = Resources.ACE_STACK_Y;
            }
            if (i == 3) {
                xCard = Resources.ACE_STACK_X4;
                yCard = Resources.ACE_STACK_Y;
            }
            if (x <= xCard || x >= xCard + Resources.iCardW) continue;
            System.out.println(yCard + ", " + y);
            if (y <= yCard || y >= yCard + Resources.iCardH) continue;
            ScreenGameSol.pointerArray[1] = i + 9;
            ScreenGameSol.pointerArray[2] = sol.Game.cardStacks[pointerArray[1] - 1];
            System.out.println(pointerArray[1] + ",  " + pointerArray[2]);
            return true;
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        int ab = 3;
        if (Defines.HEIGHT > 430) {
            ab = 15;
        }
        if (Defines.HEIGHT > 650) {
            ab = 20;
        }
        if (Math.abs(currentX - x) > ab || Math.abs(currentY - y) > ab) {
            currentX = x;
            currentY = y;
            canvas.repaint();
        }
    }

    public int getActualMode() {
        return mode;
    }

    static {
        DEFAULT_WAIT_TIME = 2;
        gFontNumsChars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'S', 'T'};
        iDistributionX = 0;
        iDistributionY = 0;
        menuStrings = new String[3];
        actionStrings = new String[8];
        gameModeStrings = new String[4];
        iSelectedSubMenuItem = -1;
    }
}

