/*
 * Decompiled with CFR 0.152.
 */
package bj;

import bj.Card;
import bj.Game;

public class BJPlayer {
    public int iChips = 1000;
    public int iActualBet = 0;
    public boolean b2Hands = false;
    public boolean bDD = false;
    public boolean b2HandDD = false;
    public Card[] cards = new Card[9];
    public int iCardsCount = 0;
    public int iCardsValue1 = 0;
    public int iCardsValue2 = 0;
    public int iFinalCardsValue;
    public Card[] hand2Cards = new Card[9];
    public int i2HandCardsCount;
    public int i2HandCardsValue1;
    public int i2HandCardsValue2;
    public int i2HandFinalCardsValue;
    public int iPlayerAction = 0;
    public boolean bWin = false;
    public boolean bWin2Hand = false;
    public boolean bHaveAce = false;
    public boolean bHaveAce2Hand = false;

    public void removeChips(int ch) {
        this.iChips -= ch;
    }

    public void addChips(int ch) {
        this.iChips += ch;
    }

    public void addBet(int b) {
        this.iActualBet += b;
        this.removeChips(b);
    }

    public void DoubleDown() {
        if (this.b2Hands) {
            if (Game.bPlayingLeftHand) {
                this.bDD = true;
            } else {
                this.b2HandDD = true;
            }
            this.removeChips(this.iActualBet);
            return;
        }
        System.out.println("DD-BET:  +" + this.iActualBet);
        Game.iBet += this.iActualBet;
        this.removeChips(this.iActualBet);
        this.iActualBet *= 2;
    }

    public void insurance() {
        int ins = this.iActualBet / 2;
        if (ins % 10 != 0) {
            ins -= 5;
        }
        this.removeChips(ins);
        Game.iInsurance += ins;
        System.out.println("INSUR:    " + ins);
    }

    public void split() {
        System.out.println("SPLITED");
        this.b2Hands = true;
        if (this.bHaveAce) {
            this.bHaveAce2Hand = true;
        }
        this.hand2Cards[0] = this.cards[1];
        this.cards[1] = null;
        this.iCardsCount = 1;
        this.i2HandCardsCount = 1;
        Game.bPlayingLeftHand = true;
        if (this.cards[0].getValueAceModif() != 14) {
            this.iCardsValue1 /= 2;
            this.iCardsValue2 /= 2;
            this.i2HandCardsValue1 = this.iCardsValue1;
            this.i2HandCardsValue2 = this.iCardsValue2;
        } else {
            this.iCardsValue1 = 11;
            this.iCardsValue2 = 1;
            this.i2HandCardsValue1 = 11;
            this.i2HandCardsValue2 = 1;
        }
        this.iChips -= this.iActualBet;
    }

    public String getChipsString() {
        return this.iChips + " $";
    }

    public void receiveCard(Card card) {
        if (!this.b2Hands || Game.bPlayingLeftHand) {
            this.cards[this.iCardsCount] = card;
            this.cards[this.iCardsCount].setDistrib(true);
            ++this.iCardsCount;
            if (card.getValueAceModif() > 9) {
                if (card.getValueAceModif() == 14) {
                    this.iCardsValue1 = !this.bHaveAce ? (this.iCardsValue1 += 11) : ++this.iCardsValue1;
                    ++this.iCardsValue2;
                } else {
                    this.iCardsValue1 += 10;
                    this.iCardsValue2 += 10;
                }
            } else {
                this.iCardsValue1 += card.getValueAceModif();
                this.iCardsValue2 += card.getValueAceModif();
            }
            if (!this.bHaveAce && card.getValueAceModif() == 14) {
                this.bHaveAce = true;
            }
        } else {
            this.hand2Cards[this.i2HandCardsCount] = card;
            this.hand2Cards[this.i2HandCardsCount].setDistrib(true);
            ++this.i2HandCardsCount;
            if (card.getValueAceModif() > 9) {
                if (card.getValueAceModif() == 14) {
                    this.i2HandCardsValue1 = !this.bHaveAce2Hand ? (this.i2HandCardsValue1 += 11) : ++this.i2HandCardsValue1;
                    ++this.i2HandCardsValue2;
                } else {
                    this.i2HandCardsValue1 += 10;
                    this.i2HandCardsValue2 += 10;
                }
            } else {
                this.i2HandCardsValue1 += card.getValueAceModif();
                this.i2HandCardsValue2 += card.getValueAceModif();
            }
            if (!this.bHaveAce2Hand && card.getValueAceModif() == 14) {
                this.bHaveAce2Hand = true;
            }
        }
    }

    public boolean haveBJ() {
        if (this.b2Hands && this.cards[0].getValueAceModif() == 14) {
            return false;
        }
        return this.iCardsCount == 2 && this.iCardsValue1 == 21 && this.iCardsValue1 != this.iCardsValue2;
    }

    public boolean haveBJ2Hand() {
        if (this.b2Hands && this.cards[0].getValueAceModif() == 14) {
            return false;
        }
        return this.i2HandCardsCount == 2 && this.i2HandCardsValue1 == 21 && this.i2HandCardsValue1 != this.i2HandCardsValue2;
    }

    public void setFinalCardValue() {
        this.iFinalCardsValue = this.iCardsValue1 <= 21 ? this.iCardsValue1 : this.iCardsValue2;
    }

    public Card[] getCards() {
        return this.cards;
    }
}

