/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerState;

public class StateIntroduction
extends PokerState {
    public static final byte kUndefined = -1;
    public static final byte kDisplayWelcomeToMessage = 0;
    public static final byte kStartSharedCardsRectAnim = 1;
    public static final byte kStartStretchingPotAnim = 2;
    public static final byte kDisplayRoundMessage = 3;
    public static final byte kLeavingIntroduction = 4;
    public byte mStateStage = (byte)-1;
    public boolean mNeedToResumeState;

    public StateIntroduction(PokerGame pokerGame) {
        super(pokerGame);
    }

    public void destruct() {
    }

    public byte GetID() {
        return 0;
    }

    public void OnEntry() {
        this.InitializeTable();
        if (this.mStateStage == -1) {
            this.SetStage((byte)0);
        } else {
            this.mNeedToResumeState = true;
        }
    }

    public void OnTime(int n2, int n3) {
        if (this.mNeedToResumeState) {
            this.ResumeGame();
        }
        this.ManageState();
        super.OnTime(n2, n3);
    }

    public void OnSkip() {
        this.HidePopup();
        this.ManageState();
        if (this.mPokerGame.IsGamePaused()) {
            this.mNeedToResumeState = true;
        }
        super.OnSkip();
    }

    public void Read(FileSegmentStream fileSegmentStream) {
        this.mStateStage = fileSegmentStream.ReadByte();
    }

    public void Write(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteByte(this.mStateStage);
    }

    public void OnExit() {
        this.mStateStage = (byte)-1;
    }

    public void InitializeTable() {
        this.mGameScene.GetPlayerViewportManager().SetAllPlayersState((byte)4);
        this.mGameScene.GetCommunityCardManager().ShowCommunityCards((byte)0);
        this.mGameScene.GetPotManager().Refresh();
    }

    public void ManageState() {
        switch (this.mStateStage) {
            case 0: {
                if (!this.mNeedToResumeState) {
                    this.HandlePopup((byte)11);
                    int n2 = GameApp.Get().GetGameSettings().GetLocation();
                    GameApp.Get().GetMediaPlayer().PlayMusic(18 + n2);
                }
                this.SetStage((byte)1);
                break;
            }
            case 1: {
                this.SetStage((byte)2);
                break;
            }
            case 2: {
                this.SetStage((byte)3);
                break;
            }
            case 3: {
                if (GameApp.Get().GetGameSettings().GetCurrentGameMode() == 2 && !this.mNeedToResumeState) {
                    this.HandlePopup((byte)13);
                }
                this.SetStage((byte)4);
                break;
            }
            case 4: {
                this.SetNextState((byte)1);
                break;
            }
        }
    }

    public void ResumeGame() {
        byte by = this.mStateStage;
        this.SetStage((byte)0);
        while (by != this.mStateStage) {
            this.ManageState();
            super.OnSkip();
        }
        this.mNeedToResumeState = false;
    }

    public void SetStage(byte by, int n2) {
        this.mStateStage = by;
        this.SetWaitingTime(n2);
    }

    public void SetStage(byte by) {
        this.SetStage(by, -1);
    }
}

