/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlBitmapMap;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.IndexedSprite;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Viewport;
import ca.jamdat.texasholdem09.CardViewport;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.PlayerDecision;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.TexasGameManager;

public class PlayerViewport
extends Viewport {
    public static final byte faceUp = 0;
    public static final byte faceDown = 1;
    public static final byte hidden = 2;
    public static final byte firstCardFaceDown = 3;
    public static final byte secondCardFaceDown = 4;
    public static final byte holeCardsFaceUp = 0;
    public static final byte holeCardsFaceDown = 1;
    public static final byte holeCardsMucked = 2;
    public static final byte playerOut = 3;
    public static final byte holeCardsHidden = 4;
    public static final byte newGame = 5;
    public static final byte newBettingTurn = 6;
    public Viewport mPlayerViewport;
    public byte mPlayerSeat;
    public Text mMoneyText;
    public Viewport mCardsViewport;
    public Component mFaceDownCardsComponent;
    public CardViewport mLeftCardViewport;
    public CardViewport mRightCardViewport;
    public byte mHoleCardsState;
    public IndexedSprite mDealerButtonSprite;
    public boolean mIsDealer;
    public boolean mIsOut;
    public boolean mIsAllIn;
    public int mPackageID;

    public PlayerViewport(byte by) {
        this.mPlayerSeat = by;
        this.mPackageID = 55;
    }

    public void destruct() {
    }

    public void Initialize() {
    }

    public void InitializeMembers(int n2, int n3) {
        int n4;
        MetaPackage metaPackage = GameLibrary.GetPackage(1081377);
        Package package_ = metaPackage.GetPackage();
        if (this.mLeftCardViewport == null) {
            this.mLeftCardViewport = new CardViewport(package_, n3);
        }
        if (this.mRightCardViewport == null) {
            n4 = n3 + 4;
            this.mRightCardViewport = new CardViewport(package_, n4);
        }
        n4 = n2;
        Text text = null;
        this.mDealerButtonSprite = IndexedSprite.Cast(package_.GetEntryPoint(n4++), null);
        text = Text.Cast(package_.GetEntryPoint(n4++), null);
        this.mCardsViewport = Viewport.Cast(package_.GetEntryPoint(n4++), null);
        this.mFaceDownCardsComponent = Component.Cast(package_.GetEntryPoint(n4++), null);
        this.mPlayerViewport = Viewport.Cast(package_.GetEntryPoint(n4++), null);
        this.mMoneyText = text;
        this.PrepareForNewDeal();
        GameLibrary.ReleasePackage(metaPackage);
    }

    public void UnloadResources() {
        this.mMoneyText = null;
        this.mLeftCardViewport = null;
        this.mRightCardViewport = null;
    }

    public void OnMoneyWon(PokerPlayer pokerPlayer) {
    }

    public void SetAsDealer() {
        this.mIsDealer = true;
        this.mDealerButtonSprite.SetCurrentFrame(0);
        this.SetButtonVisible(true);
    }

    public void SetButtonVisible(boolean bl) {
        this.mDealerButtonSprite.SetVisible(bl);
    }

    public void DetermineBlindButton(byte by) {
        if (by == 6) {
            this.SetBlindButton(false);
        } else {
            this.SetBlindButton(true);
        }
    }

    public void SetBlindButton(boolean bl) {
        if (!this.mIsDealer) {
            int n2 = 2;
            if (bl) {
                n2 = 1;
            }
            this.mDealerButtonSprite.SetCurrentFrame(n2);
            this.SetButtonVisible(true);
        }
    }

    public void SetCards(byte by, byte by2) {
        this.mLeftCardViewport.SetCard(by);
        this.mRightCardViewport.SetCard(by2);
    }

    public void SetPlayerAction(byte by, PlayerDecision playerDecision) {
        byte by2;
        if (by == 4) {
            this.mIsAllIn = true;
        }
        if ((by2 = playerDecision.GetPlayerAction()) == 6 || by2 == 7) {
            this.DetermineBlindButton(by2);
        }
    }

    public void SetHoleCardsState(byte by) {
        this.mHoleCardsState = by;
        switch (by) {
            case 0: {
                this.mFaceDownCardsComponent.SetVisible(false);
                this.mLeftCardViewport.ShowFaceUpCard(true);
                this.mRightCardViewport.ShowFaceUpCard(true);
                break;
            }
            case 1: {
                if (!this.mIsOut) {
                    this.mFaceDownCardsComponent.SetVisible(true);
                    ((Viewport)this.mFaceDownCardsComponent).GetChild(0).SetVisible(true);
                    ((Viewport)this.mFaceDownCardsComponent).GetChild(1).SetVisible(true);
                }
                this.mLeftCardViewport.ShowFaceUpCard(false);
                this.mRightCardViewport.ShowFaceUpCard(false);
                break;
            }
            case 2: {
                this.mFaceDownCardsComponent.SetVisible(false);
                this.mLeftCardViewport.ShowFaceUpCard(false);
                this.mRightCardViewport.ShowFaceUpCard(false);
                break;
            }
            case 3: {
                this.mFaceDownCardsComponent.SetVisible(true);
                ((Viewport)this.mFaceDownCardsComponent).GetChild(0).SetVisible(true);
                ((Viewport)this.mFaceDownCardsComponent).GetChild(1).SetVisible(false);
                break;
            }
            case 4: {
                ((Viewport)this.mFaceDownCardsComponent).GetChild(1).SetVisible(true);
                break;
            }
        }
    }

    public byte GetHoleCardsState() {
        return this.mHoleCardsState;
    }

    public void SetCardsBitmap(FlBitmapMap flBitmapMap, FlBitmapMap flBitmapMap2, FlBitmapMap flBitmapMap3) {
        this.SetLeftCardBitmap(flBitmapMap, flBitmapMap2, flBitmapMap3);
        this.SetRightCardBitmap(flBitmapMap, flBitmapMap2, flBitmapMap3);
    }

    public void SetLeftCardBitmap(FlBitmapMap flBitmapMap, FlBitmapMap flBitmapMap2, FlBitmapMap flBitmapMap3) {
        this.mLeftCardViewport.SetBitmap(flBitmapMap, flBitmapMap2, flBitmapMap3);
    }

    public void SetRightCardBitmap(FlBitmapMap flBitmapMap, FlBitmapMap flBitmapMap2, FlBitmapMap flBitmapMap3) {
        this.mRightCardViewport.SetBitmap(flBitmapMap, flBitmapMap2, flBitmapMap3);
    }

    public void UpdatePlayerState(byte by, boolean bl) {
        switch (by) {
            case 1: {
                this.SetHoleCardsState((byte)1);
                break;
            }
            case 0: {
                TexasGameManager.Get().GetPokerTable().GetPlayerSeatedAt(this.mPlayerSeat).SetCardsShown();
                this.SetHoleCardsState((byte)0);
                if (bl) break;
                GameApp.Get().GetMediaPlayer().PlayGameSceneSoundFX(7);
                break;
            }
            case 3: {
                this.RemovePlayerFromTable();
                break;
            }
            case 4: {
                this.SetHoleCardsState((byte)2);
                break;
            }
            case 5: {
                this.PrepareForNewDeal();
                break;
            }
        }
    }

    public void NewPlayerOnTable() {
        this.mIsOut = false;
        this.UpdatePlayerState((byte)5, false);
    }

    public void SetStackText(int n2) {
        this.mMoneyText.SetCaption(new FlString(n2));
    }

    public boolean IsOut() {
        return this.mIsOut;
    }

    public boolean IsAllIn() {
        return this.mIsAllIn;
    }

    public void ResetCardsViewport() {
        this.SetCardsViewportVisible(true);
    }

    public void SetCardsViewportVisible(boolean bl) {
        this.mCardsViewport.SetVisible(bl);
    }

    public Text GetMoneyText() {
        return this.mMoneyText;
    }

    public void PrepareForNewDeal() {
        this.mIsAllIn = false;
        this.mIsDealer = false;
        this.SetButtonVisible(false);
    }

    public void RemovePlayerFromTable() {
        this.mFaceDownCardsComponent.SetVisible(false);
        this.mIsOut = true;
    }
}

