/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlMath;
import ca.jamdat.texasholdem09.BaseController;
import ca.jamdat.texasholdem09.Cheat;
import ca.jamdat.texasholdem09.CheatContainer;
import ca.jamdat.texasholdem09.Controllable;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.InputMapper;
import ca.jamdat.texasholdem09.Utilities;

public class CheatActivationController
extends BaseController {
    public static final int statusUnmatched = 0;
    public static final int statusMatching = 1;
    public static final int statusMatched = 2;
    public Controllable mTimeControlled = new Controllable();
    public int mHeldKey = 0;
    public int mInputCheatActivationTimerMs;
    public int mInputCheatDeactivationTimerMs;
    public boolean mCheatInputActivated;
    public int[] mInputKeys = null;
    public int mInputCount;

    public CheatActivationController() {
        this.mTimeControlled.SetController(this);
        this.mInputKeys = new int[18];
    }

    public void destruct() {
        this.mTimeControlled.UnRegisterInGlobalTime();
        this.mTimeControlled = null;
        this.mInputKeys = null;
    }

    public void OnTime(int n2, int n3) {
        if (this.mHeldKey == 17 && !this.mCheatInputActivated) {
            this.mInputCheatActivationTimerMs += n3;
            if (this.mInputCheatActivationTimerMs >= 3000) {
                this.ActivateInput();
            }
        } else if (this.mHeldKey != 17 && !this.mCheatInputActivated) {
            this.mTimeControlled.UnRegisterInGlobalTime();
        } else if (this.mHeldKey != 17) {
            this.mInputCheatDeactivationTimerMs += n3;
            if (this.mInputCheatDeactivationTimerMs >= 3000) {
                this.DeactivateInput();
            }
        }
    }

    public boolean OnKey(int n2, int n3, boolean bl) {
        boolean bl2 = false;
        if (!bl) {
            if (this.mCheatInputActivated) {
                this.mInputCheatDeactivationTimerMs = 0;
                this.DetectCheatActivation(n3);
                bl2 = true;
            } else if (n3 == 17 && this.mHeldKey == 0) {
                this.mHeldKey = n3;
                this.mInputCheatActivationTimerMs = 0;
                this.mTimeControlled.RegisterInGlobalTime();
            }
        } else {
            this.mHeldKey = 0;
        }
        return bl2;
    }

    public void Terminate() {
        this.mTimeControlled.UnRegisterInGlobalTime();
    }

    public void DisableAllCheats() {
        CheatContainer cheatContainer = GameApp.Get().GetCheatContainer();
        for (int i2 = 0; i2 < 20; ++i2) {
            Cheat cheat = cheatContainer.GetCheat(i2);
            if (cheat == null) continue;
            cheat.Deactivate();
        }
    }

    public void ActivateInput() {
        InputMapper.ChangeMapping(2);
        this.mCheatInputActivated = true;
        this.mInputCount = 0;
        this.mInputCheatDeactivationTimerMs = 0;
    }

    public void DeactivateInput() {
        if (this.mCheatInputActivated) {
            this.mCheatInputActivated = false;
            InputMapper.ChangeMapping(GameApp.Get().GetTranslatedKey(14) == 6 ? 0 : 1);
        }
        this.mHeldKey = 0;
        this.mTimeControlled.UnRegisterInGlobalTime();
    }

    public void DetectCheatActivation(int n2) {
        boolean bl = true;
        if (n2 >= 17 && n2 <= 26) {
            this.mInputKeys[this.mInputCount++] = n2;
            CheatContainer cheatContainer = GameApp.Get().GetCheatContainer();
            for (int i2 = 0; i2 < 20; ++i2) {
                Cheat cheat = cheatContainer.GetCheat(i2);
                if (cheat == null) continue;
                int n3 = CheatActivationController.GetMatchStatus(cheat, this.mInputKeys, this.mInputCount);
                if (n3 == 2) {
                    if (cheat.IsActivated()) {
                        cheat.Deactivate();
                    } else {
                        cheat.Activate(CheatActivationController.ExtractCheatParam(cheat, this.mInputKeys, this.mInputCount));
                    }
                    this.DeactivateInput();
                    return;
                }
                if (n3 != 1) continue;
                bl = false;
            }
        }
        if (bl) {
            this.DeactivateInput();
        }
    }

    public static int GetMatchStatus(Cheat cheat, int[] nArray, int n2) {
        int[] nArray2 = cheat.GetCode();
        int n3 = cheat.GetCodeLength();
        int n4 = cheat.GetParamLength();
        int n5 = FlMath.Minimum(n2, n3);
        for (int i2 = 0; i2 < n5; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return 0;
        }
        if (n2 == n3 + n4) {
            return 2;
        }
        return 1;
    }

    public static int ExtractCheatParam(Cheat cheat, int[] nArray, int n2) {
        int n3 = cheat.GetParamLength();
        int n4 = 0;
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            n4 *= 10;
            n4 += Utilities.GetKeyValue(nArray[n2 - 1 - i2]);
        }
        return n4;
    }

    public static CheatActivationController[] InstArrayCheatActivationController(int n2) {
        CheatActivationController[] cheatActivationControllerArray = new CheatActivationController[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cheatActivationControllerArray[i2] = new CheatActivationController();
        }
        return cheatActivationControllerArray;
    }

    public static CheatActivationController[][] InstArrayCheatActivationController(int n2, int n3) {
        CheatActivationController[][] cheatActivationControllerArray = new CheatActivationController[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            cheatActivationControllerArray[i2] = new CheatActivationController[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                cheatActivationControllerArray[i2][i3] = new CheatActivationController();
            }
        }
        return cheatActivationControllerArray;
    }

    public static CheatActivationController[][][] InstArrayCheatActivationController(int n2, int n3, int n4) {
        CheatActivationController[][][] cheatActivationControllerArray = new CheatActivationController[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            cheatActivationControllerArray[i2] = new CheatActivationController[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                cheatActivationControllerArray[i2][i3] = new CheatActivationController[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    cheatActivationControllerArray[i2][i3][i4] = new CheatActivationController();
                }
            }
        }
        return cheatActivationControllerArray;
    }
}

