/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.PlayerViewportManager;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerTable;
import ca.jamdat.texasholdem09.StageProcess;
import ca.jamdat.texasholdem09.TexasPokerTable;

public class CardsFlipProcess
extends StageProcess {
    public static final byte kUndefined = -1;
    public static final byte kFlippingPlayerCards = 0;
    public byte mProcessStep = (byte)-1;
    public int mNbOfPlayersInCurrentPot;
    public boolean mIsFirstPlayerToFlip = true;
    public int mCurrentProcessedSeat = -1;
    public int mNbCardsProcessedCnt;

    public CardsFlipProcess(PokerGame pokerGame) {
        super(pokerGame);
    }

    public void destruct() {
    }

    public boolean RunProcess() {
        if (GameApp.Get().GetCheatContainer().GetCheat(15).IsActivated()) {
            return true;
        }
        if (this.mPokerGame.IsInSkipMode()) {
            this.SkipProcess();
        } else {
            switch (this.mProcessStep) {
                case -1: {
                    this.DetermineNbOfPlayersInCurrentPot();
                    this.SetStep((byte)0);
                    break;
                }
                case 0: {
                    this.FlipNextPairOfCardsIfNeeded();
                }
            }
        }
        if (this.mIsProcessComplete) {
            this.ResetCardsFlipFlags();
            return true;
        }
        return false;
    }

    public void OnPairOfCardsFlipped() {
        if (!this.mPokerGame.IsInSkipMode()) {
            ++this.mNbCardsProcessedCnt;
            PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
            playerViewportManager.RevealHoleCards((byte)this.mCurrentProcessedSeat);
            this.DetermineIfDoneFlippingCards();
        }
    }

    public void SetStep(byte by, int n2) {
        this.mPokerGame.SetWaitingTime(n2);
        this.mProcessStep = by;
    }

    public void SkipProcess() {
        PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
        PokerTable pokerTable = this.mTexasManager.GetPokerTable();
        int n2 = pokerTable.GetNbOfStartingAIPlayers();
        PokerPlayer pokerPlayer = null;
        boolean bl = this.mTexasManager.IsEveryoneInTheHandAllInExceptMaxOne();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!bl && !pokerTable.IsPlayerInvolvedInCurrentPot((byte)i2) || !(pokerPlayer = pokerTable.GetPlayerSeatedAt((byte)i2)).IsPlayerInTheHand()) continue;
            if (pokerPlayer.GetState() == 3 && !pokerPlayer.AreCardsShown()) {
                playerViewportManager.MuckCards((byte)i2);
                continue;
            }
            playerViewportManager.RevealHoleCards((byte)i2);
        }
        this.mIsProcessComplete = true;
    }

    public void DetermineNbOfPlayersInCurrentPot() {
        PokerTable pokerTable = this.mTexasManager.GetPokerTable();
        this.mNbOfPlayersInCurrentPot = this.mTexasManager.IsEveryoneInTheHandAllInExceptMaxOne() ? pokerTable.GetNbOfPlayersInTheHand() : pokerTable.GetNbOfPlayersInCurrentPot();
    }

    public void FlipNextPairOfCardsIfNeeded() {
        PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
        TexasPokerTable texasPokerTable = this.mPokerGame.GetTexasPokerTable();
        PokerPlayer pokerPlayer = null;
        byte by = texasPokerTable.GetSeatOfPlayer(this.mTexasManager.GetLastPlayerToBetOrRaiseForCurrentPot());
        int n2 = -1;
        byte by2 = PokerTable.GetSeatOfHumanPlayer();
        if (this.mIsFirstPlayerToFlip) {
            this.mCurrentProcessedSeat = by;
            if (this.mCurrentProcessedSeat == -1) {
                this.mCurrentProcessedSeat = texasPokerTable.GetSeatOfPlayer(texasPokerTable.GetLeftPlayer(this.mTexasManager.GetDealerPlayer()));
            }
            --this.mCurrentProcessedSeat;
            this.mIsFirstPlayerToFlip = false;
        }
        boolean bl = false;
        boolean bl2 = this.mTexasManager.IsEveryoneInTheHandAllInExceptMaxOne();
        do {
            ++this.mCurrentProcessedSeat;
            if (this.mCurrentProcessedSeat > by2) {
                this.mCurrentProcessedSeat = 0;
            }
            pokerPlayer = texasPokerTable.GetPlayerSeatedAt((byte)this.mCurrentProcessedSeat);
            if (bl2) {
                bl = pokerPlayer.IsPlayerInTheHand();
                continue;
            }
            boolean bl3 = bl = texasPokerTable.IsPlayerInvolvedInCurrentPot((byte)this.mCurrentProcessedSeat) && pokerPlayer.IsPlayerInTheHand();
        } while (!bl);
        n2 = pokerPlayer.GetState();
        if (pokerPlayer.IsPlayerHuman() || pokerPlayer.AreCardsShown() || by != (byte)this.mCurrentProcessedSeat && n2 == 3) {
            if (!pokerPlayer.IsPlayerHuman() && !pokerPlayer.AreCardsShown()) {
                playerViewportManager.MuckCards((byte)this.mCurrentProcessedSeat);
            }
            ++this.mNbCardsProcessedCnt;
            this.DetermineIfDoneFlippingCards();
        } else {
            this.OnPairOfCardsFlipped();
        }
    }

    public void DetermineIfDoneFlippingCards() {
        if (this.mNbCardsProcessedCnt == this.mNbOfPlayersInCurrentPot) {
            this.mIsProcessComplete = true;
        } else {
            this.SetStep((byte)0, 1000);
        }
    }

    public void ResetCardsFlipFlags() {
        this.mIsFirstPlayerToFlip = true;
        this.mCurrentProcessedSeat = -1;
        this.mNbCardsProcessedCnt = 0;
        this.mProcessStep = (byte)-1;
        this.mNbOfPlayersInCurrentPot = 0;
        this.mIsProcessComplete = false;
    }

    public void SetStep(byte by) {
        this.SetStep(by, -1);
    }
}

