/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlDisplayContext;
import ca.jamdat.flight.FlDisplayManager;
import ca.jamdat.flight.FlKeyManager;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.J2MEApp;
import ca.jamdat.flight.MIDPDisplayContextImp;
import ca.jamdat.flight.SpecConstants;
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Graphics;

public class J2MEScene
extends FullCanvas {
    public boolean mIsSoundManagerMuted;
    public short mScreenRect_left;
    public short mScreenRect_top;
    public short mScreenRect_width;
    public short mScreenRect_height;
    public boolean mScreenRectInitialized;
    public static final int SCREEN_WIDTH = 176;
    public static final int SCREEN_HEIGHT = 208;
    public static final int ACCEPT_KEY_CODE = -6;
    public static final int DECLINE_KEY_CODE = -7;
    public static final int KEY_POUND_KEY_CODE = 35;
    public static final int KEY_STAR_KEY_CODE = 42;
    public static final int FIRE_KEY_CODE = -5;
    public static final int MENU_KEY_CODE = -12;
    public static boolean repaintScene = true;
    protected static J2MEApp mApp;
    private MIDPDisplayContextImp mDisplayContextImp;
    public int mLastGameTime;

    public J2MEScene() {
        FlDisplayContext flDisplayContext = FlDisplayManager.GetMainDisplayContext();
        this.mDisplayContextImp = (MIDPDisplayContextImp)flDisplayContext;
    }

    public void destruct() {
    }

    protected final void hideNotify() {
        mApp.pause();
        J2MEScene.mApp.mResumeNextIsShown = true;
    }

    protected final void showNotify() {
        mApp.start();
        mApp.AddEvent((short)7);
    }

    public final int getOsWidth() {
        return super.getWidth();
    }

    public final int getOsHeight() {
        return super.getHeight();
    }

    public void sizeChanged(int n2, int n3) {
    }

    public void updateSoftKey(int n2, String string) {
    }

    protected final void keyPressed(int n2) {
        mApp.AddEvent((short)1, n2);
    }

    protected final void keyReleased(int n2) {
        mApp.AddEvent((short)2, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Object object = J2MEApp.paintLock;
        synchronized (object) {
            this.onDraw(graphics);
        }
        repaintScene = false;
        if (J2MEScene.mApp.mDoublePaint) {
            repaintScene = true;
            J2MEApp.mFrameworkGlobals.application.Invalidate();
            J2MEScene.mApp.mDoublePaint = false;
        }
    }

    protected void OnFlightKeyPressed(int n2) {
        if (J2MEApp.mApplication.mLastKeyDown != n2) {
            J2MEApp.mApplication.OnKeyFromOS(n2, false);
        }
    }

    protected void OnFlightKeyReleased(int n2) {
        J2MEApp.mApplication.OnKeyFromOS(n2, true);
    }

    protected void OnKeyPressed(int n2) {
        this.OnFlightKeyPressed(this.TranslateKey(n2, false));
    }

    protected void OnKeyReleased(int n2) {
        this.OnFlightKeyReleased(this.TranslateKey(n2, true));
    }

    protected void onDraw(Graphics graphics) {
        FlRect flRect = FlDisplayManager.GetVideoModeRect();
        this.mScreenRect_left = flRect.GetLeft();
        this.mScreenRect_top = flRect.GetTop();
        this.mScreenRect_width = flRect.GetWidth();
        this.mScreenRect_height = flRect.GetHeight();
        this.mScreenRectInitialized = true;
        this.mDisplayContextImp.SetClippingRect(this.mScreenRect_left, this.mScreenRect_top, this.mScreenRect_width, this.mScreenRect_height);
        this.mDisplayContextImp.SetGraphics(graphics);
        FlDisplayManager.RenderApplication();
    }

    public void onTime(int n2) {
        FlApplication.GetInstance().Iteration(n2, n2 - this.mLastGameTime);
        this.mLastGameTime = n2;
        repaintScene = true;
    }

    public int TranslateKey(int n2, boolean bl) {
        if (n2 == SpecConstants.GetKeyCodeUp()) {
            return 1;
        }
        if (n2 == SpecConstants.GetKeyCodeDown()) {
            return 2;
        }
        if (n2 == SpecConstants.GetKeyCodeLeft()) {
            return 3;
        }
        if (n2 == SpecConstants.GetKeyCodeRight()) {
            return 4;
        }
        if (n2 == SpecConstants.GetKeyCodeBack()) {
            return 9;
        }
        if (n2 == SpecConstants.GetKeyCodeBackspace()) {
            return 10;
        }
        if (n2 == SpecConstants.GetKeyCodeStar()) {
            return 16;
        }
        if (n2 == SpecConstants.GetKeyCodePound()) {
            return 15;
        }
        if (n2 == SpecConstants.GetFlightKeyCodeFire()) {
            return 7;
        }
        if (n2 == SpecConstants.GetKeyCodeAccept()) {
            return 13;
        }
        if (n2 == SpecConstants.GetKeyCodeDecline()) {
            return 14;
        }
        if (n2 == SpecConstants.GetKeyCodeSend()) {
            return 0;
        }
        if (n2 == SpecConstants.GetKeyCodeEnd()) {
            return 0;
        }
        if (n2 == SpecConstants.GetKeyCodeVolumeUp()) {
            return 0;
        }
        if (n2 == SpecConstants.GetKeyCodeVolumeDown()) {
            return 0;
        }
        if (n2 == SpecConstants.GetKeyCodeMediaPlayer()) {
            return 0;
        }
        if (n2 == SpecConstants.GetKeyCodeUnused1()) {
            return 0;
        }
        return FlKeyManager.ConstToFlightKey(n2);
    }

    public static J2MEScene[] InstArrayJ2MEScene(int n2) {
        J2MEScene[] j2MESceneArray = new J2MEScene[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            j2MESceneArray[i2] = new J2MEScene();
        }
        return j2MESceneArray;
    }

    public static J2MEScene[][] InstArrayJ2MEScene(int n2, int n3) {
        J2MEScene[][] j2MESceneArray = new J2MEScene[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            j2MESceneArray[i2] = new J2MEScene[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                j2MESceneArray[i2][i3] = new J2MEScene();
            }
        }
        return j2MESceneArray;
    }

    public static J2MEScene[][][] InstArrayJ2MEScene(int n2, int n3, int n4) {
        J2MEScene[][][] j2MESceneArray = new J2MEScene[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            j2MESceneArray[i2] = new J2MEScene[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                j2MESceneArray[i2][i3] = new J2MEScene[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    j2MESceneArray[i2][i3][i4] = new J2MEScene();
                }
            }
        }
        return j2MESceneArray;
    }
}

