/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Box3;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.FVec3T_F32;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Sphere;

public class HalfSpace {
    public FVec3T_F32 outwardNormal;
    public F32 pointOnPlaneDotOutwardNormal;

    public static HalfSpace Cast(Object object, HalfSpace halfSpace) {
        return (HalfSpace)object;
    }

    public void OnSerialize(Package package_) {
    }

    public HalfSpace() {
        this.outwardNormal = new FVec3T_F32();
        this.pointOnPlaneDotOutwardNormal = new F32();
    }

    public HalfSpace(FVec3T_F32 fVec3T_F32, FVec3T_F32 fVec3T_F322) {
        this.outwardNormal = new FVec3T_F32(fVec3T_F322);
        this.pointOnPlaneDotOutwardNormal = new F32();
        this.pointOnPlaneDotOutwardNormal = fVec3T_F32.Dot(this.outwardNormal, 16);
    }

    public void Init(FVec3T_F32 fVec3T_F32, FVec3T_F32 fVec3T_F322) {
        this.outwardNormal.Assign(fVec3T_F322);
        this.pointOnPlaneDotOutwardNormal = fVec3T_F32.Dot(this.outwardNormal, 16);
    }

    public byte WhichSideOfPlane(Box3 box3) {
        if (this.Intersects(box3)) {
            if (this.Contains(box3)) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public byte WhichSideOfPlane(Box3 box3, F32 f32) {
        FVec3T_F32 fVec3T_F32 = new FVec3T_F32();
        FVec3T_F32 fVec3T_F322 = new FVec3T_F32();
        if (this.outwardNormal.x.GreaterOrEqual(F32.Zero(16))) {
            fVec3T_F32.x = box3.minCorner.x;
            fVec3T_F322.x = box3.maxCorner.x;
        } else {
            fVec3T_F32.x = box3.maxCorner.x;
            fVec3T_F322.x = box3.minCorner.x;
        }
        if (this.outwardNormal.y.GreaterOrEqual(F32.Zero(16))) {
            fVec3T_F32.y = box3.minCorner.y;
            fVec3T_F322.y = box3.maxCorner.y;
        } else {
            fVec3T_F32.y = box3.maxCorner.y;
            fVec3T_F322.y = box3.minCorner.y;
        }
        if (this.outwardNormal.z.GreaterOrEqual(F32.Zero(16))) {
            fVec3T_F32.z = box3.minCorner.z;
            fVec3T_F322.z = box3.maxCorner.z;
        } else {
            fVec3T_F32.z = box3.maxCorner.z;
            fVec3T_F322.z = box3.minCorner.z;
        }
        F32 f322 = new F32(fVec3T_F32.Dot(this.outwardNormal, 16).Sub(f32));
        if (f322.LessOrEqual(this.pointOnPlaneDotOutwardNormal)) {
            F32 f323 = new F32(fVec3T_F322.Dot(this.outwardNormal, 16).Add(f32));
            if (f323.LessOrEqual(this.pointOnPlaneDotOutwardNormal)) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public F32 DistanceToPlane(FVec3T_F32 fVec3T_F32) {
        return fVec3T_F32.Dot(this.outwardNormal, 16).Sub(this.pointOnPlaneDotOutwardNormal).Abs();
    }

    public boolean PlaneContains(FVec3T_F32 fVec3T_F32) {
        return fVec3T_F32.Dot(this.outwardNormal, 16).Equals(this.pointOnPlaneDotOutwardNormal);
    }

    public boolean GetIntersection_LineWithPlane(FVec3T_F32 fVec3T_F32, FVec3T_F32 fVec3T_F322, FVec3T_F32 fVec3T_F323) {
        fVec3T_F323.Assign(fVec3T_F32);
        if (fVec3T_F32.Equals(fVec3T_F322)) {
            return this.PlaneContains(fVec3T_F32);
        }
        F32 f32 = new F32(F32.Zero(16));
        F32 f322 = new F32(F32.One(16));
        FVec3T_F32 fVec3T_F324 = new FVec3T_F32(fVec3T_F322.Sub(fVec3T_F32));
        FVec3T_F32 fVec3T_F325 = new FVec3T_F32(fVec3T_F32);
        FVec3T_F32 fVec3T_F326 = new FVec3T_F32(this.outwardNormal);
        F32 f323 = new F32(this.pointOnPlaneDotOutwardNormal.Neg());
        F32 f324 = new F32(fVec3T_F326.x.Mul(fVec3T_F324.x, 16).Add(fVec3T_F326.y.Mul(fVec3T_F324.y, 16)).Add(fVec3T_F326.z.Mul(fVec3T_F324.z, 16)));
        if (f324.Equals(f32)) {
            return false;
        }
        F32 f325 = new F32(fVec3T_F326.x.Mul(fVec3T_F325.x, 16).Add(fVec3T_F326.y.Mul(fVec3T_F325.y, 16)).Add(fVec3T_F326.z.Mul(fVec3T_F325.z, 16)).Add(f323).Neg());
        F32 f326 = new F32(f325.Div(f324, 16));
        if (f326.LessThan(f32) || f326.GreaterThan(f322)) {
            return false;
        }
        fVec3T_F323.Assign(fVec3T_F324.Mul(f326, 16).Add(fVec3T_F325));
        return true;
    }

    public boolean Contains(FVec3T_F32 fVec3T_F32) {
        return fVec3T_F32.Dot(this.outwardNormal, 16).LessOrEqual(this.pointOnPlaneDotOutwardNormal);
    }

    public boolean Intersects(Box3 box3) {
        boolean bl = this.outwardNormal.x.GreaterOrEqual(F32.Zero(16));
        boolean bl2 = this.outwardNormal.y.GreaterOrEqual(F32.Zero(16));
        boolean bl3 = this.outwardNormal.z.GreaterOrEqual(F32.Zero(16));
        F32 f32 = new F32(bl ? box3.minCorner.x : box3.maxCorner.x);
        F32 f322 = new F32(bl2 ? box3.minCorner.y : box3.maxCorner.y);
        F32 f323 = new F32(bl3 ? box3.minCorner.z : box3.maxCorner.z);
        FVec3T_F32 fVec3T_F32 = new FVec3T_F32(f32, f322, f323);
        return this.Contains(fVec3T_F32);
    }

    public boolean Contains(Box3 box3) {
        boolean bl = this.outwardNormal.x.GreaterOrEqual(F32.Zero(16));
        boolean bl2 = this.outwardNormal.y.GreaterOrEqual(F32.Zero(16));
        boolean bl3 = this.outwardNormal.z.GreaterOrEqual(F32.Zero(16));
        FVec3T_F32 fVec3T_F32 = new FVec3T_F32(bl ? box3.maxCorner.x : box3.minCorner.x, bl2 ? box3.maxCorner.y : box3.minCorner.y, bl3 ? box3.maxCorner.z : box3.minCorner.z);
        return this.Contains(fVec3T_F32);
    }

    public byte WhichSideOfPlane(Sphere sphere) {
        F32 f32 = new F32(sphere.GetCenter().Dot(this.outwardNormal, 16).Sub(this.pointOnPlaneDotOutwardNormal));
        if (f32.LessOrEqual(sphere.GetRadius())) {
            if (f32.LessOrEqual(sphere.GetRadius().Neg())) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public boolean Intersects(Sphere sphere) {
        return sphere.GetCenter().Dot(this.outwardNormal, 16).Sub(sphere.GetRadius()).LessOrEqual(this.pointOnPlaneDotOutwardNormal);
    }

    public boolean Contains(Sphere sphere) {
        return sphere.GetCenter().Dot(this.outwardNormal, 16).Add(sphere.GetRadius()).LessOrEqual(this.pointOnPlaneDotOutwardNormal);
    }

    public HalfSpace Assign(HalfSpace halfSpace) {
        this.outwardNormal.Assign(halfSpace.outwardNormal);
        this.pointOnPlaneDotOutwardNormal = halfSpace.pointOnPlaneDotOutwardNormal;
        return this;
    }

    public static HalfSpace[] InstArrayHalfSpace(int n2) {
        HalfSpace[] halfSpaceArray = new HalfSpace[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            halfSpaceArray[i2] = new HalfSpace();
        }
        return halfSpaceArray;
    }

    public static HalfSpace[][] InstArrayHalfSpace(int n2, int n3) {
        HalfSpace[][] halfSpaceArray = new HalfSpace[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            halfSpaceArray[i2] = new HalfSpace[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                halfSpaceArray[i2][i3] = new HalfSpace();
            }
        }
        return halfSpaceArray;
    }

    public static HalfSpace[][][] InstArrayHalfSpace(int n2, int n3, int n4) {
        HalfSpace[][][] halfSpaceArray = new HalfSpace[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            halfSpaceArray[i2] = new HalfSpace[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                halfSpaceArray[i2][i3] = new HalfSpace[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    halfSpaceArray[i2][i3][i4] = new HalfSpace();
                }
            }
        }
        return halfSpaceArray;
    }
}

