/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.F32;
import ca.jamdat.flight.FQuaternionT_F32;
import ca.jamdat.flight.FVec3T_F32;
import ca.jamdat.flight.FlColor;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.Memory;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.TimeControlled;
import ca.jamdat.flight.Vector2_short;

public abstract class Controller
extends TimeControlled {
    public static final byte typeNumber = 87;
    public static final byte typeID = 87;
    public static final boolean supportsDynamicSerialization = true;
    public static final byte ValueTypeNone = 0;
    public static final byte ValueTypeBool = 1;
    public static final byte ValueTypeInt = 2;
    public static final byte ValueTypeFloat = 3;
    public static final byte ValueTypeCoord2 = 4;
    public static final byte ValueTypeRect = 5;
    public static final byte ValueTypeColor = 6;
    public static final byte ValueTypeVec3 = 7;
    public static final byte ValueTypeQuaternion = 8;
    public static final byte absolute = 0;
    public static final byte relative = 1;
    public static final byte uninitialized = 0;
    public static final byte initialized = 1;
    public TimeControlled mControllee;
    public int mControlledValueCode;
    public byte mAbsolute;
    public byte mCacheState;
    public byte mStartState;
    public int[] mValueBuffer = new int[12];

    public static Controller Cast(Object object, Controller controller) {
        return (Controller)object;
    }

    public byte GetTypeID() {
        return 87;
    }

    public static Class AsClass() {
        return null;
    }

    public void destruct() {
        this.mControllee = null;
    }

    public Vector2_short GetCoord2Value() {
        return new Vector2_short(this.GetCoord2ValueX(), this.GetCoord2ValueY());
    }

    public short GetCoord2ValueX() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return (short)(nArray[0] + nArray[4]);
        }
        return (short)nArray[0];
    }

    public short GetCoord2ValueY() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return (short)(nArray[1] + nArray[5]);
        }
        return (short)nArray[1];
    }

    public int GetLongValue() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return nArray[0] + nArray[4];
        }
        return nArray[0];
    }

    public boolean GetBoolValue() {
        return (this.GetLongValue() & 1) != 0;
    }

    public FlRect GetRectValue() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return new FlRect((short)(nArray[0] + nArray[4]), (short)(nArray[1] + nArray[5]), (short)(nArray[2] + nArray[6]), (short)(nArray[3] + nArray[7]));
        }
        return new FlRect((short)nArray[0], (short)nArray[1], (short)nArray[2], (short)nArray[3]);
    }

    public FlColor GetColorValue() {
        int[] nArray = this.mValueBuffer;
        FlColor flColor = new FlColor();
        if (this.mAbsolute != 0) {
            flColor.SetRed(Memory.MakeUnsignedByte((byte)(nArray[0] + nArray[4])));
            flColor.SetGreen(Memory.MakeUnsignedByte((byte)(nArray[1] + nArray[5])));
            flColor.SetBlue(Memory.MakeUnsignedByte((byte)(nArray[2] + nArray[6])));
        } else {
            flColor.SetRed(Memory.MakeUnsignedByte((byte)nArray[0]));
            flColor.SetGreen(Memory.MakeUnsignedByte((byte)nArray[1]));
            flColor.SetBlue(Memory.MakeUnsignedByte((byte)nArray[2]));
        }
        return flColor;
    }

    public FVec3T_F32 GetFVec3Value() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return new FVec3T_F32(new F32(nArray[0] + nArray[4], 16), new F32(nArray[1] + nArray[5], 16), new F32(nArray[2] + nArray[6], 16));
        }
        return new FVec3T_F32(new F32(nArray[0], 16), new F32(nArray[1], 16), new F32(nArray[2], 16));
    }

    public FQuaternionT_F32 GetFQuaternionValue() {
        int[] nArray = this.mValueBuffer;
        F32 f32 = new F32(nArray[0], 28);
        FQuaternionT_F32 fQuaternionT_F32 = new FQuaternionT_F32(f32, new FVec3T_F32(new F32(nArray[1], 28), new F32(nArray[2], 28), new F32(nArray[3], 28)));
        if (this.mAbsolute != 0) {
            f32 = new F32(nArray[4], 28);
            FQuaternionT_F32 fQuaternionT_F322 = new FQuaternionT_F32(f32, new FVec3T_F32(new F32(nArray[5], 28), new F32(nArray[6], 28), new F32(nArray[7], 28)));
            fQuaternionT_F32.Assign(fQuaternionT_F322.Mul(fQuaternionT_F32));
        }
        return fQuaternionT_F32;
    }

    public F32 GetF32Value() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return new F32(nArray[0] + nArray[4], 16);
        }
        return new F32(nArray[0], 16);
    }

    public void SetValue(short s2, short s3) {
        this.mValueBuffer[4] = s2;
        this.mValueBuffer[5] = s3;
    }

    public void SetValue(short s2, short s3, short s4, short s5) {
        int[] nArray = this.mValueBuffer;
        nArray[4] = s2;
        nArray[5] = s3;
        nArray[6] = s4;
        nArray[7] = s5;
    }

    public void SetValue(FlColor flColor) {
        int[] nArray = this.mValueBuffer;
        nArray[4] = flColor.GetRed();
        nArray[5] = flColor.GetGreen();
        nArray[6] = flColor.GetBlue();
    }

    public void SetValue(boolean bl) {
        this.mValueBuffer[4] = bl ? 1 : 0;
    }

    public void SetValue(int n2) {
        this.mValueBuffer[4] = n2;
    }

    public void SetValue(FVec3T_F32 fVec3T_F32) {
        int[] nArray = this.mValueBuffer;
        nArray[4] = fVec3T_F32.x.ToFixedPoint(16);
        nArray[5] = fVec3T_F32.y.ToFixedPoint(16);
        nArray[6] = fVec3T_F32.z.ToFixedPoint(16);
    }

    public void SetValue(FQuaternionT_F32 fQuaternionT_F32) {
        int[] nArray = this.mValueBuffer;
        nArray[4] = fQuaternionT_F32.GetS().ToFixedPoint(28);
        nArray[5] = fQuaternionT_F32.GetVx().ToFixedPoint(28);
        nArray[6] = fQuaternionT_F32.GetVy().ToFixedPoint(28);
        nArray[7] = fQuaternionT_F32.GetVz().ToFixedPoint(28);
    }

    public void SetValue(F32 f32) {
        this.mValueBuffer[4] = f32.ToFixedPoint(16);
    }

    public void GetControlledValue(int[] nArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.mValueBuffer[i2];
            if (this.mAbsolute == 0) continue;
            int n3 = i2;
            nArray[n3] = nArray[n3] + this.mValueBuffer[4 + i2];
        }
    }

    public void SetRequestedValue(int[] nArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mValueBuffer[4 + i2] = nArray[i2];
        }
    }

    public void Restore() {
        if (this.mStartState != 0) {
            this.CopyValue(0, 4);
            byte by = this.mAbsolute;
            this.mAbsolute = 0;
            this.mControllee.ControlValue(this.mControlledValueCode, true, this);
            this.mAbsolute = by;
        }
        this.Refresh();
    }

    public void Refresh() {
        this.mCacheState = 0;
    }

    public abstract void OnTime(int var1, int var2);

    public void SetControlParameters(TimeControlled timeControlled, int n2) {
        this.mControllee = timeControlled;
        this.mControlledValueCode = n2;
        this.mStartState = 0;
        this.mCacheState = 0;
    }

    public void SetControllee(TimeControlled timeControlled) {
        this.SetControlParameters(timeControlled, this.mControlledValueCode);
    }

    public void SetControlledValueCode(int n2) {
        this.SetControlParameters(this.mControllee, n2);
    }

    public TimeControlled GetControllee() {
        return this.mControllee;
    }

    public boolean IsAbsolute() {
        return this.mAbsolute == 0;
    }

    public void SetIsAbsolute(boolean bl) {
        if (bl != (this.mAbsolute == 0)) {
            this.mAbsolute = bl ? (byte)0 : 1;
            this.mStartState = 0;
        }
    }

    public void ResetControllee() {
        this.mStartState = 0;
    }

    public void OnSerialize(Package package_) {
        this.mControllee = TimeControlled.Cast(package_.SerializePointer((byte)0, true, false), null);
        this.mControlledValueCode = package_.SerializeIntrinsic(this.mControlledValueCode);
        boolean bl = this.IsAbsolute();
        bl = package_.SerializeIntrinsic(bl);
        this.SetIsAbsolute(bl);
    }

    public void DefaultOnTime(int n2, int n3) {
        if (this.mControllee == null) {
            return;
        }
        if (this.mStartState == 0) {
            this.GetCurrentValue();
            this.mStartState = 1;
        }
        if (this.NeedsUpdate()) {
            this.mControllee.ControlValue(this.mControlledValueCode, true, this);
            this.UpdateCache();
        }
    }

    public void GetCurrentValue() {
        this.mControllee.ControlValue(this.mControlledValueCode, false, this);
    }

    public boolean NeedsUpdate() {
        if (this.mCacheState == 0) {
            return true;
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            if (this.mValueBuffer[8 + i2] == this.mValueBuffer[i2]) continue;
            return true;
        }
        return false;
    }

    public void UpdateCache() {
        this.CopyValue(8, 0);
        this.mCacheState = 1;
    }

    public void CopyValue(int n2, int n3) {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.mValueBuffer[n2 + i2] = this.mValueBuffer[n3 + i2];
        }
    }
}

