/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

public class Characters {
    public static final byte space = 32;
    public static final byte tabulation = 9;
    public static final byte endOfString = 0;
    public static final byte hardReturn = 13;
    public static final byte carriageReturn = 13;
    public static final byte lineFeed = 10;
    public static final byte pageBreak = 12;
    public static final byte optionalWordBreak = 31;
    public static final byte softHyphenChar = -83;
    public static final byte zeroWidthSpace = 29;
    public static final byte nonBreakingSpace = -96;
    public static final short typeInfoCanWrapBefore = 2;
    public static final short typeInfoCanWrapAfter = 4;
    public static final short typeInfoIsWordSeparator = 8;
    public static final short typeInfoIsLineSeparator = 16;
    public static final short typeInfoIsOptionalWordBreak = 32;
    public static final short typeInfoIsFullwidth = 64;
    public static final short typeInfoIsAlphabet = 128;
    public static final short typeInfoIsAsianCharacter = 256;
    public static final short typeInfoIsLetter = 512;
    public static final short typeInfoIsNumber = 1024;
    public static final short typeInfoIsSymbol = 2048;
    public static final int typeOptionalWordBreak = 32;
    public static final int typeWordSeparator = 14;
    public static final int typeCarriageReturn = 30;
    public static final int typeLineSeparator = 30;
    public static final int typeEndOfString = 14;
    public static final int typeAlphabetLetter = 644;
    public static final int typeAlphabetNumber = 1156;
    public static final int typeAlphabetSymbol = 2180;
    public static final int typeFullwidthAlphabetLetter = 646;
    public static final int typeFullwidthAlphabetNumber = 1158;
    public static final int typeFullwidthAlphabetSymbol = 2182;
    public static final int typeFullwidthPunctuation = 2180;
    public static final int typeThaiConsonant = 6;
    public static final int typeThaiLeadingVowel = 6;
    public static final int typeThaiFollowingVowel = 6;
    public static final int typeThaiBelowVowel = 4;
    public static final int typeThaiAboveVowel = 4;
    public static final int typeThaiTonemark = 4;
    public static final int typeThaiAboveDiacritic = 4;
    public static final int typeThaiBelowDiacritic = 4;
    public static final int typeThaiDigit = 1030;
    public static final int typeThaiSpecialCharacter = 6;
    public static final int typeAsianCharacter = 260;
    public static final int typeHalfWidthAsianCharacter = 260;
    public static final int typeFullWidthAsianCharacter = 324;
    public static final int typeAsianPunctuation = 324;
    public static final int typeAsianIdeogram = 326;
    public static final int typeChineseHanzi = 326;
    public static final int typeJapaneseKanji = 326;
    public static final int typeJapaneseHiragana = 326;
    public static final int typeJapaneseKatakana = 326;
    public static final int typeJapaneseHalfWidthKatakana = 260;

    public static int GetCharType(byte by) {
        int n2 = Characters.CharToInt(by);
        int n3 = by == 0 ? 14 : (by == 32 || by == 29 || by == -83 || by == 9 ? 14 : (by == 13 || by == 10 || by == 13 ? 30 : (by == 31 ? 32 : (by == 13 ? 30 : (n2 <= 47 ? 2180 : (n2 <= 57 ? 1156 : (n2 <= 64 ? 2180 : (n2 <= 90 ? 644 : (n2 <= 96 ? 2180 : (n2 <= 122 ? 644 : (n2 <= 191 ? 2180 : (n2 <= 255 ? 644 : 2180))))))))))));
        return n3;
    }

    public static boolean CanWrapAfter(int n2) {
        return Characters.TypesFlagAndTest(n2, 4);
    }

    public static boolean CanWrapBefore(int n2) {
        return Characters.TypesFlagAndTest(n2, 2);
    }

    public static boolean IsOptionalWordBreak(int n2) {
        return Characters.TypesFlagAndTest(n2, 32);
    }

    public static boolean IsWordSeparator(int n2) {
        return Characters.TypesFlagAndTest(n2, 8);
    }

    public static boolean IsLineSeparator(int n2) {
        return Characters.TypesFlagAndTest(n2, 16);
    }

    public static int CharToInt(byte by) {
        return by & 0xFF;
    }

    public static byte Undefined() {
        return -1;
    }

    public static boolean TypesFlagAndTest(int n2, int n3) {
        return (n2 & n3) != 0;
    }

    public static Characters[] InstArrayCharacters(int n2) {
        Characters[] charactersArray = new Characters[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            charactersArray[i2] = new Characters();
        }
        return charactersArray;
    }

    public static Characters[][] InstArrayCharacters(int n2, int n3) {
        Characters[][] charactersArray = new Characters[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            charactersArray[i2] = new Characters[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                charactersArray[i2][i3] = new Characters();
            }
        }
        return charactersArray;
    }

    public static Characters[][][] InstArrayCharacters(int n2, int n3, int n4) {
        Characters[][][] charactersArray = new Characters[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            charactersArray[i2] = new Characters[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                charactersArray[i2][i3] = new Characters[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    charactersArray[i2][i3][i4] = new Characters();
                }
            }
        }
        return charactersArray;
    }
}

