/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BlMath;

public class BlFixed {
    public static final int FP_8 = 8;
    public static final int FP_16 = 16;
    public static final int FP_24 = 24;
    public static final int FP_32 = 32;
    public static final int FP_40 = 40;
    public static final int FP_48 = 48;
    public static final int FP_56 = 56;

    public static int ToFixed32(int n2, int n3) {
        return n2 << n3;
    }

    public static int ToInt32(int n2, int n3) {
        return n2 >> n3;
    }

    public static int ToFixed32(float f2, int n2) {
        return (int)(f2 * (float)(1 << n2));
    }

    public static float ToFloat(int n2, int n3) {
        return (float)n2 / (float)(1 << n3);
    }

    public static int ToFixed32(double d2, int n2) {
        return (int)(d2 * (double)(1 << n2));
    }

    public static double ToDouble(int n2, int n3) {
        return (double)n2 / (double)(1 << n3);
    }

    public static int Abs(int n2) {
        return BlMath.Abs(n2);
    }

    public static int Signum(int n2) {
        return BlMath.Signum(n2);
    }

    public static int Min(int n2, int n3) {
        return BlMath.Min(n2, n3);
    }

    public static int Min(int[] nArray, int n2) {
        return BlMath.Min(nArray, n2);
    }

    public static int Max(int n2, int n3) {
        return BlMath.Max(n2, n3);
    }

    public static int Max(int[] nArray, int n2) {
        return BlMath.Max(nArray, n2);
    }

    public static int Ceil(int n2, int n3) {
        return -(-n2 >> n3 << n3);
    }

    public static int Floor(int n2, int n3) {
        return n2 >> n3 << n3;
    }

    public static int Mul(int n2, int n3, int n4) {
        return (int)((long)n2 * (long)n3 >> n4);
    }

    public static int MulPower2(int n2, int n3) {
        return n2 << n3;
    }

    public static int Div(int n2, int n3, int n4) {
        return (int)(((long)n2 << n4) / (long)n3);
    }

    public static int DivPower2(int n2, int n3) {
        return n2 >> n3;
    }

    public static int Inverse(int n2, int n3) {
        long l2 = 0x4000000000000000L;
        l2 /= (long)n2;
        return (int)(l2 >>= 62 - 2 * n3);
    }

    public static int Square(int n2, int n3) {
        return BlFixed.Mul(n2, n2, n3);
    }

    public static int Pow(int n2, int n3, int n4) {
        return 0;
    }

    public static int Sqrt(int n2, int n3) {
        int n4 = 0;
        long l2 = n2;
        n4 = (int)Math.sqrt(l2 <<= n3);
        return n4;
    }

    public static int Sin(int n2, int n3) {
        int n4 = BlFixed.Pi(n3);
        int n5 = BlFixed.DivPower2(n4, 1);
        int n6 = BlFixed.MulPower2(n4, 1);
        if (n2 < 0) {
            while ((n2 += n6) < 0) {
            }
        } else if (n2 > n6) {
            while ((n2 -= n6) > n6) {
            }
        }
        int n7 = 1;
        if (n2 > n4) {
            if (n2 > n4 + n5) {
                n2 = (n4 << 1) - n2;
                n7 = -1;
            } else {
                n2 -= n4;
                n7 = -1;
            }
        } else if (n2 > n5) {
            n2 = n4 - n2;
        }
        int n8 = BlFixed.Square(n2, n3);
        int n9 = BlFixed.ConvertFP16(498, n3);
        n9 = BlFixed.Mul(n9, n8, n3);
        n9 -= BlFixed.ConvertFP16(10882, n3);
        n9 = BlFixed.Mul(n9, n8, n3);
        n9 += 1 << n3;
        n9 = BlFixed.Mul(n9, n2, n3);
        return n9 *= n7;
    }

    public static int Cos(int n2, int n3) {
        int n4 = BlFixed.Pi(n3);
        int n5 = BlFixed.DivPower2(n4, 1);
        int n6 = BlFixed.MulPower2(n4, 1);
        if (n2 < 0) {
            while ((n2 += n6) < 0) {
            }
        } else if (n2 > n6) {
            while ((n2 -= n6) > n6) {
            }
        }
        int n7 = 1;
        if (n2 > n4) {
            if (n2 > n4 + n5) {
                n2 = (n4 << 1) - n2;
            } else {
                n2 -= n4;
                n7 = -1;
            }
        } else if (n2 > n5) {
            n2 = n4 - n2;
            n7 = -1;
        }
        int n8 = BlFixed.Square(n2, n3);
        int n9 = BlFixed.Mul(BlFixed.ConvertFP16(2428, n3), n8, n3);
        n9 -= BlFixed.ConvertFP16(32551, n3);
        n9 = BlFixed.Mul(n9, n8, n3);
        n9 += 1 << n3;
        return n9 *= n7;
    }

    public static int Tan(int n2, int n3) {
        int n4 = BlFixed.MulPower2(BlFixed.Pi(n3), 1);
        while (n2 > n4) {
            n2 -= n4;
        }
        while (n2 < 0) {
            n2 += n4;
        }
        int n5 = BlFixed.Square(n2, n3);
        int n6 = BlFixed.ConvertFP16(13323, n3);
        n6 = BlFixed.Mul(n6, n5, n3);
        n6 += BlFixed.ConvertFP16(20810, n3);
        n6 = BlFixed.Mul(n6, n5, n3);
        n6 += BlFixed.One(n3);
        n6 = BlFixed.Mul(n2, n6, n3);
        return n6;
    }

    public static int Asin(int n2, int n3) {
        if (n2 < 0) {
            return -BlFixed.Asin(-n2, n3);
        }
        int n4 = BlFixed.Sqrt(BlFixed.One(n3) - n2, n3);
        int n5 = BlFixed.ConvertFP16(-1228, n3);
        n5 = BlFixed.Mul(n2, n5, n3);
        n5 += BlFixed.ConvertFP16(4866, n3);
        n5 = BlFixed.Mul(n2, n5, n3);
        n5 -= BlFixed.ConvertFP16(13901, n3);
        n5 = BlFixed.Mul(n2, n5, n3);
        n5 += BlFixed.ConvertFP16(102939, n3);
        n5 = BlFixed.DivPower2(BlFixed.Pi(n3), 1) - BlFixed.Mul(n5, n4, n3);
        return n5;
    }

    public static int Acos(int n2, int n3) {
        if (n2 < 0) {
            return -(BlFixed.Acos(-n2, n3) - BlFixed.Pi(n3));
        }
        if (n2 >= BlFixed.One(n3)) {
            return 0;
        }
        int n4 = BlFixed.Sqrt(BlFixed.One(n3) - n2, n3);
        int n5 = BlFixed.ConvertFP16(-1228, n3);
        n5 = BlFixed.Mul(n2, n5, n3);
        n5 += BlFixed.ConvertFP16(4866, n3);
        n5 = BlFixed.Mul(n2, n5, n3);
        n5 -= BlFixed.ConvertFP16(13901, n3);
        n5 = BlFixed.Mul(n2, n5, n3);
        n5 += BlFixed.ConvertFP16(102939, n3);
        n5 = BlFixed.Mul(n5, n4, n3);
        return n5;
    }

    public static int Atan(int n2, int n3) {
        if (BlFixed.Abs(n2) > BlFixed.One(n3)) {
            if (n2 > 0) {
                return BlFixed.DivPower2(BlFixed.Pi(n3), 1) - BlFixed.Atan(BlFixed.Inverse(n2, n3), n3);
            }
            return -BlFixed.DivPower2(BlFixed.Pi(n3), 1) - BlFixed.Atan(BlFixed.Inverse(n2, n3), n3);
        }
        int n4 = BlFixed.Square(n2, n3);
        int n5 = BlFixed.ConvertFP16(1365, n3);
        n5 = BlFixed.Mul(n5, n4, n3);
        n5 -= BlFixed.ConvertFP16(5579, n3);
        n5 = BlFixed.Mul(n5, n4, n3);
        n5 += BlFixed.ConvertFP16(11805, n3);
        n5 = BlFixed.Mul(n5, n4, n3);
        n5 -= BlFixed.ConvertFP16(21646, n3);
        n5 = BlFixed.Mul(n5, n4, n3);
        n5 += BlFixed.ConvertFP16(65527, n3);
        n5 = BlFixed.Mul(n2, n5, n3);
        return n5;
    }

    public static int Atan2(int n2, int n3, int n4) {
        if (BlFixed.Abs(n3) < BlFixed.Epsilon()) {
            if (BlFixed.Abs(n2) < BlFixed.Epsilon()) {
                return 0;
            }
            if (n2 >= 0) {
                return BlFixed.DivPower2(BlFixed.Pi(n4), 1);
            }
            return -BlFixed.DivPower2(BlFixed.Pi(n4), 1);
        }
        int n5 = BlFixed.Div(n2, n3, n4);
        if (n3 < 0) {
            int n6 = BlFixed.Atan(BlFixed.Abs(n5), n4);
            n6 = BlFixed.Pi(n4) - n6;
            if (n2 < 0) {
                return -n6;
            }
            return n6;
        }
        return BlFixed.Atan(n5, n4);
    }

    public static int Exp(int n2, int n3) {
        return 0;
    }

    public static int Log(int n2, int n3) {
        return 0;
    }

    public static int Log10(int n2, int n3) {
        return 0;
    }

    public static int IncreaseFractionalPartSize(int n2, int n3) {
        return n2 << n3;
    }

    public static int DecreaseFractionalPartSize(int n2, int n3) {
        return n2 >> n3;
    }

    public static int Round(int n2, int n3) {
        return BlFixed.ToInt32(BlFixed.Floor(n2 + BlFixed.Half(n3), n3), n3);
    }

    public static int Zero() {
        return 0;
    }

    public static int Epsilon() {
        return 10;
    }

    public static int OneHundredth(int n2) {
        return BlFixed.Inverse(BlFixed.ToFixed32(100, n2), n2);
    }

    public static int Quarter(int n2) {
        return 1 << n2 - 2;
    }

    public static int Half(int n2) {
        return 1 << n2 - 1;
    }

    public static int ThreeQuarters(int n2) {
        return 1 << n2 - 1 | 1 << n2 - 2;
    }

    public static int One(int n2) {
        return 1 << n2;
    }

    public static int QuarterPi(int n2) {
        return BlFixed.ConvertFP16(51472, n2);
    }

    public static int HalfPi(int n2) {
        return BlFixed.ConvertFP16(102944, n2);
    }

    public static int ThreeQuarterPi(int n2) {
        return BlFixed.ConvertFP16(154416, n2);
    }

    public static int Pi(int n2) {
        return BlFixed.ConvertFP16(205887, n2);
    }

    public static int TwoPi(int n2) {
        return BlFixed.ConvertFP16(411775, n2);
    }

    public static int DegreesPerRadian(int n2) {
        return BlFixed.ConvertFP16(1144, n2);
    }

    public static int RadiansPerDegree(int n2) {
        return BlFixed.ConvertFP16(3754936, n2);
    }

    public static int E(int n2) {
        return BlFixed.ConvertFP16(178145, n2);
    }

    public static int ConvertFP16(int n2, int n3) {
        if (n3 == 16) {
            return n2;
        }
        if (n3 < 16) {
            return n2 >> 16 - n3;
        }
        return n2 << n3 - 16;
    }

    public static int ToFixed32(int n2) {
        return BlFixed.ToFixed32(n2, 16);
    }

    public static int ToInt32(int n2) {
        return BlFixed.ToInt32(n2, 16);
    }

    public static int ToFixed32(float f2) {
        return BlFixed.ToFixed32(f2, 16);
    }

    public static float ToFloat(int n2) {
        return BlFixed.ToFloat(n2, 16);
    }

    public static int ToFixed32(double d2) {
        return BlFixed.ToFixed32(d2, 16);
    }

    public static double ToDouble(int n2) {
        return BlFixed.ToDouble(n2, 16);
    }

    public static int Ceil(int n2) {
        return BlFixed.Ceil(n2, 16);
    }

    public static int Floor(int n2) {
        return BlFixed.Floor(n2, 16);
    }

    public static int Mul(int n2, int n3) {
        return BlFixed.Mul(n2, n3, 16);
    }

    public static int Div(int n2, int n3) {
        return BlFixed.Div(n2, n3, 16);
    }

    public static int Inverse(int n2) {
        return BlFixed.Inverse(n2, 16);
    }

    public static int Square(int n2) {
        return BlFixed.Square(n2, 16);
    }

    public static int Pow(int n2, int n3) {
        return BlFixed.Pow(n2, n3, 16);
    }

    public static int Sqrt(int n2) {
        return BlFixed.Sqrt(n2, 16);
    }

    public static int Sin(int n2) {
        return BlFixed.Sin(n2, 16);
    }

    public static int Cos(int n2) {
        return BlFixed.Cos(n2, 16);
    }

    public static int Tan(int n2) {
        return BlFixed.Tan(n2, 16);
    }

    public static int Asin(int n2) {
        return BlFixed.Asin(n2, 16);
    }

    public static int Acos(int n2) {
        return BlFixed.Acos(n2, 16);
    }

    public static int Atan(int n2) {
        return BlFixed.Atan(n2, 16);
    }

    public static int Atan2(int n2, int n3) {
        return BlFixed.Atan2(n2, n3, 16);
    }

    public static int Exp(int n2) {
        return BlFixed.Exp(n2, 16);
    }

    public static int Log(int n2) {
        return BlFixed.Log(n2, 16);
    }

    public static int Log10(int n2) {
        return BlFixed.Log10(n2, 16);
    }

    public static int Round(int n2) {
        return BlFixed.Round(n2, 16);
    }

    public static int OneHundredth() {
        return BlFixed.OneHundredth(16);
    }

    public static int Quarter() {
        return BlFixed.Quarter(16);
    }

    public static int Half() {
        return BlFixed.Half(16);
    }

    public static int ThreeQuarters() {
        return BlFixed.ThreeQuarters(16);
    }

    public static int One() {
        return BlFixed.One(16);
    }

    public static int QuarterPi() {
        return BlFixed.QuarterPi(16);
    }

    public static int HalfPi() {
        return BlFixed.HalfPi(16);
    }

    public static int ThreeQuarterPi() {
        return BlFixed.ThreeQuarterPi(16);
    }

    public static int Pi() {
        return BlFixed.Pi(16);
    }

    public static int TwoPi() {
        return BlFixed.TwoPi(16);
    }

    public static int DegreesPerRadian() {
        return BlFixed.DegreesPerRadian(16);
    }

    public static int RadiansPerDegree() {
        return BlFixed.RadiansPerDegree(16);
    }

    public static int E() {
        return BlFixed.E(16);
    }

    public static BlFixed[] InstArrayBlFixed(int n2) {
        BlFixed[] blFixedArray = new BlFixed[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            blFixedArray[i2] = new BlFixed();
        }
        return blFixedArray;
    }

    public static BlFixed[][] InstArrayBlFixed(int n2, int n3) {
        BlFixed[][] blFixedArray = new BlFixed[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            blFixedArray[i2] = new BlFixed[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                blFixedArray[i2][i3] = new BlFixed();
            }
        }
        return blFixedArray;
    }

    public static BlFixed[][][] InstArrayBlFixed(int n2, int n3, int n4) {
        BlFixed[][][] blFixedArray = new BlFixed[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            blFixedArray[i2] = new BlFixed[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                blFixedArray[i2][i3] = new BlFixed[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    blFixedArray[i2][i3][i4] = new BlFixed();
                }
            }
        }
        return blFixedArray;
    }
}

