/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.BaseController;
import ca.jamdat.texasholdem09.BaseScene;
import ca.jamdat.texasholdem09.Controllable;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.Hourglass;
import ca.jamdat.texasholdem09.SceneTransitionListener;
import ca.jamdat.texasholdem09.SharedResourcesHandler;

public class SceneTransitionController
extends BaseController {
    public Controllable mTimeControlled = new Controllable();
    public BaseScene mLoadingScene;
    public BaseScene mUnloadingScene;
    public BaseScene mLoadedScene;
    public BaseScene mPendingTransitionScene;
    public SharedResourcesHandler mSharedResourcesHandler = new SharedResourcesHandler();
    public boolean mTerminated;

    public SceneTransitionController() {
        this.mTimeControlled.SetController(this);
    }

    public void destruct() {
        this.mTimeControlled = null;
        this.mSharedResourcesHandler = null;
    }

    public void EnqueueTransition(BaseScene baseScene) {
        boolean bl = false;
        if (!this.mTerminated) {
            SceneTransitionController.AcquireScene(baseScene);
            if (!this.IsTransiting()) {
                this.StartTransition(baseScene, this.mLoadedScene);
            } else if (this.HasPendingTransition()) {
                SceneTransitionController.ReleaseScene(this.mPendingTransitionScene);
                this.mPendingTransitionScene = baseScene;
            } else {
                this.mPendingTransitionScene = baseScene;
            }
        } else {
            SceneTransitionController.ReleaseScene(baseScene);
        }
        if (bl) {
            this.mPendingTransitionScene = null;
        }
    }

    public void Terminate() {
        this.mTimeControlled.UnRegisterInGlobalTime();
        if (this.mLoadingScene != null) {
            this.UnloadAndReleaseScene(this.mLoadingScene);
            this.mLoadingScene = null;
        }
        if (this.mUnloadingScene != null) {
            this.UnloadAndReleaseScene(this.mUnloadingScene);
            this.mUnloadingScene = null;
            this.mLoadedScene = null;
        }
        if (this.mPendingTransitionScene != null) {
            SceneTransitionController.ReleaseScene(this.mPendingTransitionScene);
            this.mPendingTransitionScene = null;
        }
        if (this.mLoadedScene != null) {
            this.UnloadAndReleaseScene(this.mLoadedScene);
            this.mLoadedScene = null;
        }
        this.mSharedResourcesHandler.UnloadMenuSharedPackages();
        this.mSharedResourcesHandler.UnloadAppSharedPackages();
        this.mTerminated = true;
    }

    public void OnTime(int n2, int n3) {
        BaseScene baseScene;
        GameApp gameApp = GameApp.Get();
        Hourglass hourglass = gameApp.GetHourglass();
        if (this.IsUnloading()) {
            baseScene = this.mUnloadingScene;
            if (baseScene.GetTransitionState() == 7) {
                SceneTransitionListener.SceneUnloadingStarted(baseScene);
                baseScene.StartClosingAnims(this.mLoadingScene == null ? 0 : this.mLoadingScene.GetId());
                baseScene.SetTransitionState(8);
            }
            if (baseScene.GetTransitionState() == 8 && baseScene.IsClosingAnimsEnded()) {
                hourglass.SetVisible(true);
                baseScene.SetTransitionState(2);
            } else if (baseScene.GetTransitionState() == 2 && baseScene.SaveFiles(1)) {
                baseScene.SetTransitionState(3);
            }
            if (baseScene.GetTransitionState() == 3) {
                this.UnloadAndReleaseScene(this.mUnloadingScene);
                this.mUnloadingScene = null;
                baseScene = null;
            }
            if (baseScene == null && this.HasPendingTransition()) {
                SceneTransitionController.ReleaseScene(this.mLoadingScene);
                this.mLoadingScene = this.mPendingTransitionScene;
                this.mPendingTransitionScene = null;
            }
        }
        if (this.IsLoading() && !this.IsUnloading()) {
            baseScene = this.mLoadingScene;
            if (baseScene.GetTransitionState() == 0) {
                GameLibrary gameLibrary = gameApp.GetLibrary();
                boolean bl = gameLibrary.SetImmediateLoadModeEnabled(true);
                this.mSharedResourcesHandler.LoadAppSharedPackages();
                if (baseScene.IsTypeOf(4)) {
                    this.mSharedResourcesHandler.UnloadMenuSharedPackages();
                } else {
                    this.mSharedResourcesHandler.LoadMenuSharedPackages();
                }
                baseScene.SerializeObjects(0);
                SceneTransitionListener.SceneLoadingStarted(baseScene);
                baseScene.Load();
                baseScene.SetTransitionState(1);
                gameLibrary.SetImmediateLoadModeEnabled(bl);
            }
            if (baseScene.GetTransitionState() == 1 && baseScene.IsLoaded()) {
                baseScene.SetTransitionState(2);
            }
            if (baseScene.GetTransitionState() == 2 && baseScene.SaveFiles(0)) {
                baseScene.SetTransitionState(4);
            } else if (baseScene.GetTransitionState() == 4) {
                baseScene.Initialize();
                baseScene.SetTransitionState(5);
            }
            if (baseScene.GetTransitionState() == 5) {
                this.AttachScene(baseScene);
                hourglass.SetVisible(false);
                baseScene.SetTransitionState(6);
                if (this.mPendingTransitionScene == null) {
                    baseScene.SetupAnims();
                    baseScene.StartOpeningAnims(this.mUnloadingScene == null ? 0 : this.mUnloadingScene.GetId());
                }
            } else if (baseScene.GetTransitionState() == 6 && baseScene.IsOpeningAnimsEnded()) {
                gameApp.ResetDownKeys();
                this.mLoadedScene = baseScene;
                this.mLoadingScene = null;
                baseScene.SetTransitionState(7);
                if (this.HasPendingTransition()) {
                    this.StartTransition(this.mPendingTransitionScene, baseScene);
                    this.mPendingTransitionScene = null;
                } else {
                    baseScene.ReceiveFocus();
                }
            }
        }
        if (!this.IsTransiting()) {
            this.mTimeControlled.UnRegisterInGlobalTime();
        }
    }

    public boolean IsTransiting() {
        return this.mLoadedScene == null && (this.IsLoading() || this.IsUnloading());
    }

    public BaseScene GetLoadedScene() {
        return this.mLoadedScene;
    }

    public void StartTransition(BaseScene baseScene, BaseScene baseScene2) {
        GameApp.Get().TakeFocus();
        this.mLoadingScene = baseScene;
        this.mUnloadingScene = baseScene2;
        this.mLoadedScene = null;
        this.mTimeControlled.RegisterInGlobalTime();
        if (baseScene2 != null) {
            baseScene2.SerializeObjects(1);
        }
    }

    public boolean HasPendingTransition() {
        return this.mPendingTransitionScene != null;
    }

    public void UnloadAndReleaseScene(BaseScene baseScene) {
        this.DetachScene(baseScene);
        baseScene.Unload();
        baseScene.SetTransitionState(0);
        baseScene.DeleteView();
        SceneTransitionController.ReleaseScene(baseScene);
    }

    public boolean IsLoading() {
        return this.mLoadingScene != null;
    }

    public boolean IsUnloading() {
        return this.mUnloadingScene != null;
    }

    public void AttachScene(BaseScene baseScene) {
        baseScene.SetViewport(GameApp.Get());
        baseScene.OnSceneAttached();
    }

    public void DetachScene(BaseScene baseScene) {
        baseScene.SetViewport(null);
    }

    public static void AcquireScene(BaseScene baseScene) {
        baseScene.AddRef();
    }

    public static void ReleaseScene(BaseScene baseScene) {
        baseScene.RemoveRef();
    }

    public static SceneTransitionController[] InstArraySceneTransitionController(int n2) {
        SceneTransitionController[] sceneTransitionControllerArray = new SceneTransitionController[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sceneTransitionControllerArray[i2] = new SceneTransitionController();
        }
        return sceneTransitionControllerArray;
    }

    public static SceneTransitionController[][] InstArraySceneTransitionController(int n2, int n3) {
        SceneTransitionController[][] sceneTransitionControllerArray = new SceneTransitionController[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            sceneTransitionControllerArray[i2] = new SceneTransitionController[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                sceneTransitionControllerArray[i2][i3] = new SceneTransitionController();
            }
        }
        return sceneTransitionControllerArray;
    }

    public static SceneTransitionController[][][] InstArraySceneTransitionController(int n2, int n3, int n4) {
        SceneTransitionController[][][] sceneTransitionControllerArray = new SceneTransitionController[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            sceneTransitionControllerArray[i2] = new SceneTransitionController[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                sceneTransitionControllerArray[i2][i3] = new SceneTransitionController[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    sceneTransitionControllerArray[i2][i3][i4] = new SceneTransitionController();
                }
            }
        }
        return sceneTransitionControllerArray;
    }
}

