/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.MetaPackage;

public class Cursor {
    public MetaPackage mMetaPackage;
    public Component mCursorComponent;

    public void destruct() {
    }

    public void Load() {
        this.mMetaPackage = GameLibrary.GetPackage(32769);
    }

    public void GetEntryPoints() {
        this.mCursorComponent = Component.Cast(this.mMetaPackage.GetPackage().GetEntryPoint(0), null);
    }

    public void SetViewport(Viewport viewport) {
        if (this.mCursorComponent != null) {
            this.mCursorComponent.SetViewport(viewport);
        }
    }

    public void Unload() {
        if (this.mMetaPackage != null) {
            if (this.mMetaPackage.IsLoaded()) {
                this.SetVisible(false);
                this.SetViewport(null);
            }
            GameLibrary.ReleasePackage(this.mMetaPackage);
            this.mMetaPackage = null;
        }
        this.mCursorComponent = null;
    }

    public void StartAnim() {
    }

    public void StopAnim() {
    }

    public boolean IsLoaded() {
        return GameLibrary.IsPackageLoaded(this.mMetaPackage);
    }

    public void SetVisible(boolean bl) {
        if (this.mCursorComponent != null) {
            this.mCursorComponent.SetVisible(bl);
        }
    }

    public boolean IsVisible() {
        return this.mCursorComponent != null && this.mCursorComponent.IsVisible();
    }

    public void SetSelectedItem(Component component) {
        if (component instanceof Selection) {
            int n2 = ((Selection)component).GetSubtype();
            if (n2 == -1 || n2 == 6 || n2 == 5 || n2 == 3 || n2 == 4 || n2 == 2) {
                Vector2_short vector2_short = new Vector2_short(component.GetAbsoluteTopLeft());
                this.mCursorComponent.SetTopLeft(vector2_short.GetX(), (short)(vector2_short.GetY() + component.GetRectHeight() / 2 - this.mCursorComponent.GetRectHeight() / 2));
                this.mCursorComponent.BringToFront();
            } else if (n2 == -3) {
                Vector2_short vector2_short = new Vector2_short(component.GetAbsoluteTopLeft());
                short s2 = component.GetRectWidth();
                Text text = (Text)((Selection)component).GetChild(0);
                short s3 = text.GetFont().GetLineSize(text.GetCaption()).GetX();
                this.mCursorComponent.SetTopLeft((short)(vector2_short.GetX() + (s2 - s3) / 2 - this.mCursorComponent.GetRectWidth()), (short)(vector2_short.GetY() + component.GetRectHeight() / 2 - this.mCursorComponent.GetRectHeight() / 2));
            }
        }
    }

    public static Cursor[] InstArrayCursor(int n2) {
        Cursor[] cursorArray = new Cursor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cursorArray[i2] = new Cursor();
        }
        return cursorArray;
    }

    public static Cursor[][] InstArrayCursor(int n2, int n3) {
        Cursor[][] cursorArray = new Cursor[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            cursorArray[i2] = new Cursor[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                cursorArray[i2][i3] = new Cursor();
            }
        }
        return cursorArray;
    }

    public static Cursor[][][] InstArrayCursor(int n2, int n3, int n4) {
        Cursor[][][] cursorArray = new Cursor[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            cursorArray[i2] = new Cursor[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                cursorArray[i2][i3] = new Cursor[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    cursorArray[i2][i3][i4] = new Cursor();
                }
            }
        }
        return cursorArray;
    }
}

