/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlBrowser;
import ca.jamdat.flight.FlString;
import ca.jamdat.texasholdem09.BaseScene;
import ca.jamdat.texasholdem09.CareerStatisticsMenu;
import ca.jamdat.texasholdem09.EASplash;
import ca.jamdat.texasholdem09.EnableSoundMenu;
import ca.jamdat.texasholdem09.FileManager;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameFactory;
import ca.jamdat.texasholdem09.GameMenu;
import ca.jamdat.texasholdem09.GameScene;
import ca.jamdat.texasholdem09.GameSettings;
import ca.jamdat.texasholdem09.GameSplash;
import ca.jamdat.texasholdem09.HelpMenu;
import ca.jamdat.texasholdem09.MainMenu;
import ca.jamdat.texasholdem09.MoreGames15;
import ca.jamdat.texasholdem09.MoreGames15ProductsMenu;
import ca.jamdat.texasholdem09.OptionsMenu;
import ca.jamdat.texasholdem09.PauseMenu;
import ca.jamdat.texasholdem09.PracticeMenu;
import ca.jamdat.texasholdem09.SceneStack;
import ca.jamdat.texasholdem09.SceneTransitionController;
import ca.jamdat.texasholdem09.Settings;

public class CommandHandler {
    public SceneStack mSceneStack;
    public SceneTransitionController mSceneTransitionController;

    public void destruct() {
    }

    public void Initialize(SceneTransitionController sceneTransitionController, SceneStack sceneStack) {
        this.mSceneTransitionController = sceneTransitionController;
        this.mSceneStack = sceneStack;
    }

    public boolean Execute(int n2) {
        return this.ExecuteImpl(n2);
    }

    public boolean ExecuteSlideShowCommand(int n2) {
        return false;
    }

    public boolean ExecuteImpl(int n2) {
        boolean bl = this.ExecuteInterruptionCommand(n2);
        if (!bl) {
            bl = this.ExecuteAnimationCommand(n2);
        }
        if (!bl) {
            bl = this.ExecuteNavigationCommand(n2);
        }
        if (!bl) {
            bl = this.ExecuteApplicationCommand(n2);
        }
        if (!bl) {
            bl = this.ExecutePopupCommand(n2);
        }
        return bl;
    }

    public boolean ExecuteApplicationCommand(int n2) {
        GameApp gameApp = GameApp.Get();
        FileManager fileManager = gameApp.GetFileManager();
        GameFactory gameFactory = gameApp.GetGameFactory();
        Settings settings = gameApp.GetSettings();
        GameSettings gameSettings = gameApp.GetGameSettings();
        boolean bl = true;
        switch (n2) {
            case -74: {
                gameFactory.CreateNewGame();
                this.Execute(-87);
                break;
            }
            case -81: {
                gameFactory.ResumeSavedGame();
                this.Execute(-87);
                break;
            }
            case -78: {
                if (!gameFactory.IsPokerGameValid() || gameFactory.GetGame() == null || !fileManager.GetInputSegmentStream(gameSettings.GetSerializedGameObjectId()).HasValidData()) break;
                if (!gameSettings.IsPractice()) {
                    gameApp.GetCareerState().OnSaveCurrentGame();
                }
                gameFactory.SaveCurrentGame();
                break;
            }
            case -79: {
                this.Execute(-78);
                this.Execute(-86);
                break;
            }
            case -80: {
                this.Execute(-78);
                this.Execute(-63);
                break;
            }
            case -82: {
                gameApp.GetCareerState().OnAbandonGame();
                gameApp.GetStatistics().Reset();
                gameFactory.DeleteSavedGame();
                this.HidePopupAndExecute(-17);
                break;
            }
            case -83: {
                gameApp.GetStatistics().Reset();
                gameFactory.DeleteSavedGame();
                this.HidePopupAndExecute(-26);
                break;
            }
            case -84: {
                gameApp.Reset();
                ((OptionsMenu)this.mSceneStack.GetTop()).UpdateBankRoll();
                this.Execute(-68);
                break;
            }
            case -66: {
                this.Execute(-78);
                this.WriteSerializableObjects();
                break;
            }
            case -63: {
                gameApp.Quit();
                break;
            }
            case -97: {
                int n3 = -17;
                if (gameSettings.IsPractice()) {
                    n3 = -26;
                }
                if (fileManager.GetInputSegmentStream(gameSettings.GetSerializedGameObjectId()).HasValidData()) {
                    this.Execute(-25);
                    break;
                }
                this.Execute(n3);
                break;
            }
            case -54: {
                settings.SetSoundEnabled(true);
                break;
            }
            case -55: {
                settings.SetSoundEnabled(false);
                break;
            }
            case -61: {
                settings.SetVibrationEnabled(true);
                break;
            }
            case -62: {
                settings.SetVibrationEnabled(false);
                break;
            }
            case 11: {
                settings.SetTutorialEnabled(true);
                break;
            }
            case 12: {
                settings.SetTutorialEnabled(false);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean ExecuteNavigationCommand(int n2) {
        boolean bl = true;
        SceneStack sceneStack = this.mSceneStack;
        switch (n2) {
            case -65: {
                this.PopAndLaunchScene();
                break;
            }
            case -53: {
                sceneStack.PopAll();
                break;
            }
            case -87: {
                sceneStack.PopAll();
                this.PushAndLaunchScene(this.CreateScene(-18));
                break;
            }
            case -86: {
                sceneStack.PopAll();
                this.PushAndLaunchScene(this.CreateScene(-16));
                break;
            }
            case -88: {
                sceneStack.PopAll();
                this.PushAndLaunchScene(this.CreateScene(-17));
                break;
            }
            case -89: {
                this.PushBootSequenceScenesAndLaunch();
                break;
            }
            case -90: {
                this.PopAndLaunchScene();
                break;
            }
            case -85: {
                this.ReloadCurrentScene();
                break;
            }
            case -37: 
            case -36: {
                boolean bl2;
                MoreGames15 moreGames15 = GameApp.Get().GetMoreGames();
                boolean bl3 = moreGames15.IsWapBrowserExitApp();
                FlString flString = new FlString(moreGames15.GetBuyUriAttributeName(moreGames15.GetSelectedProductId()));
                if (n2 == -37) {
                    flString.Assign(moreGames15.GetCatUriAttributeName(moreGames15.GetSelectedProductId()));
                }
                if (bl2 = FlBrowser.GetInstance().LaunchWAP(flString, bl3)) break;
                this.Execute(-86);
                break;
            }
            default: {
                BaseScene baseScene = this.CreateScene(n2);
                if (baseScene != null) {
                    this.PushAndLaunchScene(baseScene);
                    break;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean ExecuteInterruptionCommand(int n2) {
        boolean bl = true;
        SceneStack sceneStack = this.mSceneStack;
        if (n2 == -67) {
            this.SuspendScene(sceneStack.GetTop());
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean ExecuteAnimationCommand(int n2) {
        BaseScene baseScene = this.mSceneStack.GetTop();
        if (baseScene == null) {
            return false;
        }
        boolean bl = true;
        switch (n2) {
            case -70: {
                baseScene.OnPopupHidden();
                break;
            }
            case -69: {
                baseScene.OnPopupShown();
                break;
            }
            case 13: {
                baseScene.OnCommand(n2);
                break;
            }
            case 10: {
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl && baseScene.GetId() == 28 && !baseScene.IsHandlingPopup()) {
            ((GameScene)baseScene).SetState((byte)1);
        }
        return bl;
    }

    public boolean ExecutePopupCommand(int n2) {
        boolean bl = true;
        BaseScene baseScene = this.mSceneStack.GetTop();
        GameSettings gameSettings = GameApp.Get().GetGameSettings();
        switch (n2) {
            case -24: {
                this.Execute(-79);
                break;
            }
            case -25: {
                int n3 = -82;
                if (gameSettings.IsPractice()) {
                    n3 = -83;
                } else if (gameSettings.IsGameMenuModeHeadsUp() || gameSettings.IsGameMenuModeTournament() || gameSettings.IsGameMenuModeProGame()) {
                    n3 = 8;
                }
                baseScene.AddPromptPopup(-81, n3, 10, true);
                break;
            }
            case 8: {
                this.HidePopupAndExecute(9);
                break;
            }
            case 9: {
                int n4 = 14;
                if (gameSettings.IsGameMenuModeHeadsUp()) {
                    n4 = 16;
                } else if (gameSettings.IsGameMenuModeProGame()) {
                    n4 = 15;
                }
                baseScene.AddPromptPopup(-82, -81, n4, true);
                break;
            }
            case -39: {
                baseScene.AddPromptPopup(-84, -68, 11, true);
                break;
            }
            case -23: {
                baseScene.AddPromptPopup(-80, -68, 9, true);
                break;
            }
            case 14: {
                this.HidePopupAndExecute(15);
                break;
            }
            case 16: {
                this.HidePopupAndExecute(17);
                break;
            }
            case 18: {
                this.HidePopupAndExecute(19);
                break;
            }
            case 20: {
                this.HidePopupAndExecute(21);
                break;
            }
            case -68: {
                baseScene.HidePopup();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public BaseScene CreateScene(int n2) {
        BaseScene baseScene = null;
        switch (n2) {
            case -15: {
                baseScene = new GameSplash(4, 655380, 3000);
                break;
            }
            case -17: {
                baseScene = new GameMenu(11, 786456);
                break;
            }
            case -16: {
                baseScene = new MainMenu(9, 753687);
                break;
            }
            case -28: {
                break;
            }
            case -26: {
                baseScene = new PracticeMenu(16, 1015839);
                break;
            }
            case -27: {
                baseScene = new CareerStatisticsMenu(10, 0x110022);
                break;
            }
            case -22: {
                baseScene = new HelpMenu(12, 819225);
                break;
            }
            case -21: {
                baseScene = new OptionsMenu(13, 851994);
                break;
            }
            case -20: {
                baseScene = new PauseMenu(15, 884763);
                break;
            }
            case -18: {
                baseScene = new GameScene(28, 1081377);
                break;
            }
            case -3: {
                baseScene = new EASplash(2, 688149, 3000);
                break;
            }
            case -14: {
                baseScene = new EnableSoundMenu(6, 917532);
            }
        }
        if (baseScene == null) {
            baseScene = this.CreateMoreGamesScene(n2);
        }
        return baseScene;
    }

    public void PushAndLaunchScene(BaseScene baseScene) {
        this.PushScene(baseScene);
        this.LaunchScene(baseScene);
    }

    public void PopAndLaunchScene() {
        SceneStack sceneStack = this.mSceneStack;
        sceneStack.Pop();
        BaseScene baseScene = sceneStack.GetTop();
        if (baseScene != null) {
            int n2 = baseScene.GetId();
            this.LaunchScene(baseScene);
        }
    }

    public void HidePopupAndExecute(int n2) {
        this.mSceneStack.GetTop().HidePopup(n2);
    }

    public void LaunchScene(BaseScene baseScene) {
        this.mSceneTransitionController.EnqueueTransition(baseScene);
    }

    public void ReloadCurrentScene() {
        BaseScene baseScene = this.mSceneStack.GetTop();
        if (baseScene != null) {
            this.mSceneTransitionController.EnqueueTransition(baseScene);
        }
    }

    public void SuspendScene(BaseScene baseScene) {
        if (baseScene != null) {
            baseScene.Suspend();
        }
    }

    public boolean PushPauseMenuAfterGameScene() {
        boolean bl = false;
        SceneStack sceneStack = this.mSceneStack;
        BaseScene baseScene = sceneStack.GetTop();
        if (baseScene != null && baseScene.GetId() == 28) {
            this.PushScene(this.CreateScene(-20));
            bl = true;
        }
        return bl;
    }

    public boolean PushBootSequenceScenesAndLaunch() {
        int[] nArray = new int[]{-16, -15, -3, -14, 0};
        int n2 = 0;
        while (nArray[n2] != 0) {
            BaseScene baseScene = this.CreateScene(nArray[n2]);
            if (baseScene != null) {
                this.PushScene(baseScene);
            }
            ++n2;
        }
        this.LaunchScene(this.mSceneStack.GetTop());
        return true;
    }

    public void WriteSerializableObjects() {
        GameApp.Get().GetFileManager().WriteApplicationObjects();
        BaseScene baseScene = this.mSceneTransitionController.GetLoadedScene();
        if (baseScene != null) {
            baseScene.SerializeObjects(1);
        }
    }

    public void PushScene(BaseScene baseScene) {
        this.mSceneStack.Push(baseScene);
    }

    public BaseScene CreateMoreGamesScene(int n2) {
        BaseScene baseScene = null;
        if (n2 == -31) {
            baseScene = new MoreGames15ProductsMenu(18, 1507374);
        } else if (n2 == -29) {
            baseScene = this.CreateMoreGamesScene(-31);
        }
        return baseScene;
    }

    public static CommandHandler[] InstArrayCommandHandler(int n2) {
        CommandHandler[] commandHandlerArray = new CommandHandler[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            commandHandlerArray[i2] = new CommandHandler();
        }
        return commandHandlerArray;
    }

    public static CommandHandler[][] InstArrayCommandHandler(int n2, int n3) {
        CommandHandler[][] commandHandlerArray = new CommandHandler[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            commandHandlerArray[i2] = new CommandHandler[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                commandHandlerArray[i2][i3] = new CommandHandler();
            }
        }
        return commandHandlerArray;
    }

    public static CommandHandler[][][] InstArrayCommandHandler(int n2, int n3, int n4) {
        CommandHandler[][][] commandHandlerArray = new CommandHandler[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            commandHandlerArray[i2] = new CommandHandler[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                commandHandlerArray[i2][i3] = new CommandHandler[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    commandHandlerArray[i2][i3][i4] = new CommandHandler();
                }
            }
        }
        return commandHandlerArray;
    }
}

