/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Viewport;
import ca.jamdat.texasholdem09.AdvisorPopup;
import ca.jamdat.texasholdem09.BaseController;
import ca.jamdat.texasholdem09.Cursor;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.MessagePopup;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.Popup;
import ca.jamdat.texasholdem09.PopupManager;
import ca.jamdat.texasholdem09.PromptPopup;
import ca.jamdat.texasholdem09.Softkey;
import ca.jamdat.texasholdem09.SubtypeHandler;
import ca.jamdat.texasholdem09.TutorialPopup;
import ca.jamdat.texasholdem09.View;

public class BaseScene
extends BaseController {
    public static final int stateUnloaded = 0;
    public static final int stateLoading = 1;
    public static final int stateSavingFiles = 2;
    public static final int stateUnloading = 3;
    public static final int stateInitializing = 4;
    public static final int stateAttaching = 5;
    public static final int statePlayingOpeningAnim = 6;
    public static final int stateReady = 7;
    public static final int statePlayingClosingAnim = 8;
    public static final int stateCount = 9;
    public static final int ctxLoading = 0;
    public static final int ctxUnloading = 1;
    public int mPackageId;
    public int mType;
    public View mView;
    public MetaPackage mMetaPackage;
    public Package mPackage;
    public Viewport mViewport;
    public Softkey mSelectSoftKey;
    public Softkey mClearSoftKey;
    public byte mCurrentPopupId;
    public Popup mCurrentPopup;
    public int mSelectSoftKeyDefaultCommand;
    public int mClearSoftKeyDefaultCommand;
    public FlString mSelectSoftKeyDefaultCaption;
    public FlString mClearSoftKeyDefaultCaption;
    public Cursor mCursor;
    public PopupManager mPopupManager;
    public int mId;
    public int mTransitionState;
    public int mRefCount;
    public BaseScene mPrevScene;
    public BaseScene mNextScene;

    public BaseScene(int n2, int n3) {
        this.mPackageId = n3;
        this.mType = 0;
        this.mCurrentPopupId = (byte)-1;
        this.mSelectSoftKeyDefaultCommand = 0;
        this.mClearSoftKeyDefaultCommand = 0;
        this.mPopupManager = GameApp.Get().GetPopupManager();
        this.mId = n2;
        this.mTransitionState = 0;
        this.mSelectSoftKeyDefaultCaption = new FlString();
        this.mClearSoftKeyDefaultCaption = new FlString();
        this.mSelectSoftKey = new Softkey();
        this.mClearSoftKey = new Softkey();
    }

    public void destruct() {
        this.mSelectSoftKey = null;
        this.mClearSoftKey = null;
        this.mCursor = null;
    }

    public int GetId() {
        return this.mId;
    }

    public boolean IsTypeOf(int n2) {
        return (this.mType & n2) != 0;
    }

    public void AddType(int n2) {
        this.mType |= n2;
    }

    public void SetViewport(Viewport viewport) {
        if (this.mView != null) {
            this.mView.SetViewport(viewport);
        }
    }

    public void OnSceneAttached() {
    }

    public void Suspend() {
    }

    public boolean OnMsg(Component component, int n2, int n3) {
        boolean bl = false;
        if (!(n2 != -127 && n2 != -126 && n2 != -128 && n2 != -125 && n2 != -122 || n2 == -122 && n3 == 0)) {
            SubtypeHandler.OnSubtype(this, component, n2, n3);
        }
        switch (n2) {
            case -121: 
            case -120: 
            case -119: {
                bl = this.OnKeyMsg(component, n2, n3);
                break;
            }
            case -125: {
                bl = this.OnPushedMsg((Selection)component, n2, n3);
            }
        }
        return bl;
    }

    public void OnTime(int n2, int n3) {
        if (this.mCurrentPopup == null && this.IsPopupPending()) {
            this.mCurrentPopup = this.mPopupManager.GetNextPopup();
            this.LoadPopup();
        }
    }

    public boolean OnCommand(int n2) {
        return GameApp.Get().GetCommandHandler().Execute(n2);
    }

    public void SetTransitionState(int n2) {
        this.mTransitionState = n2;
    }

    public int GetTransitionState() {
        return this.mTransitionState;
    }

    public void Load() {
        this.mMetaPackage = GameLibrary.GetPackage(this.mPackageId);
        this.mPackage = this.mMetaPackage.GetPackage();
        if (this.mCursor != null) {
            this.mCursor.Load();
        }
    }

    public boolean IsLoaded() {
        return GameLibrary.IsPackageLoaded(this.mMetaPackage) && (this.mCursor == null || this.mCursor.IsLoaded());
    }

    public void GetEntryPoints() {
        Package package_ = this.mPackage;
        this.mViewport = Viewport.Cast(package_.GetEntryPoint(0), null);
        package_.SetNextEntryPointIndex(3);
        if (this.mCursor != null) {
            this.mCursor.GetEntryPoints();
        }
    }

    public void CreateView() {
        this.mView = new View();
    }

    public void DeleteView() {
        this.mView = null;
    }

    public View GetView() {
        return this.mView;
    }

    public void Initialize() {
        Viewport viewport;
        if (this.mView == null) {
            viewport = GameApp.Get();
            this.CreateView();
            this.mView.SetController(this);
            this.mView.SetRect(viewport.GetRectLeft(), viewport.GetRectTop(), viewport.GetRectWidth(), viewport.GetRectHeight());
            this.GetEntryPoints();
        }
        if (this.mViewport != null) {
            viewport = null;
            viewport = Selection.Cast(this.mPackage.GetEntryPoint(1), null);
            this.mSelectSoftKey.Initialize(13, (Selection)viewport);
            viewport = Selection.Cast(this.mPackage.GetEntryPoint(2), null);
            this.mClearSoftKey.Initialize(14, (Selection)viewport);
            this.mViewport.SetViewport(this.mView);
        }
        if (this.mCursor != null) {
            this.mCursor.SetViewport(this.mView);
            this.mCursor.SetVisible(false);
        }
    }

    public void StartOpeningAnims(int n2) {
    }

    public void SetupAnims() {
    }

    public boolean IsOpeningAnimsEnded() {
        return true;
    }

    public void ReceiveFocus() {
        this.mView.TakeFocus();
        if (this.mPopupManager.IsPopupPending()) {
            this.mView.RegisterInGlobalTime();
        }
    }

    public void StartClosingAnims(int n2) {
    }

    public boolean IsClosingAnimsEnded() {
        return true;
    }

    public void Unload() {
        if (this.mView != null) {
            this.mView.UnRegisterInGlobalTime();
        }
        if (this.mCurrentPopup != null) {
            this.SetDefaultSoftkeys();
        }
        this.ReleaseCurrentPopup();
        this.mSelectSoftKey.Uninitialize();
        this.mClearSoftKey.Uninitialize();
        if (this.mViewport != null) {
            this.mViewport.SetViewport(null);
            this.mViewport = null;
        }
        if (this.mCursor != null) {
            this.mCursor.Unload();
        }
        this.ReleaseAllPopups();
        if (this.mPackage != null) {
            GameLibrary.ReleasePackage(this.mMetaPackage);
            this.mMetaPackage = null;
            this.mPackage = null;
        }
    }

    public boolean SaveFiles(int n2) {
        return true;
    }

    public void SerializeObjects(int n2) {
    }

    public BaseScene GetPreviousScene() {
        return this.mPrevScene;
    }

    public BaseScene GetNextScene() {
        return this.mNextScene;
    }

    public void AddPopup(Popup popup, boolean bl) {
        if (this.mCurrentPopup != null && bl) {
            this.mPopupManager.AddPopup(this.mCurrentPopup, bl);
            this.mCurrentPopup.SetOnHideCommand(0);
            this.mCurrentPopup.Hide();
        }
        this.mPopupManager.AddPopup(popup, bl);
        if (this.mView.DescendentOrSelfHasFocus()) {
            this.mView.RegisterInGlobalTime();
        }
    }

    public void AddExitPromptPopup(int n2, int n3, int n4, boolean bl, int n5) {
        this.mClearSoftKey.SetCommand(-63);
        this.AddPopup(new PromptPopup(this, this.mSelectSoftKey, this.mClearSoftKey, n2, n3, n4, n5), bl);
    }

    public void AddPromptPopup(int n2, int n3, int n4, boolean bl, int n5) {
        this.AddPopup(new PromptPopup(this, this.mSelectSoftKey, this.mClearSoftKey, n2, n3, n4, n5), bl);
    }

    public void AddPromptPopup(int n2, int n3, FlString flString, boolean bl, int n4) {
        this.AddPopup(new PromptPopup(this, this.mSelectSoftKey, this.mClearSoftKey, n2, n3, flString, n4), bl);
    }

    public void AddMessagePopup(FlString flString, int n2, boolean bl) {
        this.AddPopup(new MessagePopup(this, this.mSelectSoftKey, this.mClearSoftKey, flString, n2), bl);
    }

    public void AddTutorialPopup(byte by, boolean bl, int n2) {
        if (by == 2) {
            this.AddPopup(new AdvisorPopup(this, this.mSelectSoftKey, this.mClearSoftKey, 1), bl);
        } else {
            this.AddPopup(new TutorialPopup(this, this.mSelectSoftKey, this.mClearSoftKey, by, n2), bl);
        }
    }

    public void HidePopup(int n2) {
        if (this.mCurrentPopup != null) {
            this.RemoveSoftKeysCommand();
            this.mCurrentPopup.SetOnHideCommand(n2);
            if (this.mCurrentPopup.IsInitializingStateReached()) {
                this.mCurrentPopup.Hide();
            } else {
                this.OnPopupHidden();
            }
        }
    }

    public void OnPopupHidden() {
        this.mCurrentPopup.Hidden();
        int n2 = this.mCurrentPopup.GetOnHideCommand();
        this.mCurrentPopupId = (byte)-1;
        this.SetDefaultSoftkeys();
        if (this.mCurrentPopup.IsKeepInstance()) {
            this.mCurrentPopup = null;
        } else {
            this.ReleaseCurrentPopup();
        }
        this.OnCommand(n2);
    }

    public void OnPopupShown() {
        this.GetCurrentPopup().Shown();
    }

    public Popup GetCurrentPopup() {
        return this.mCurrentPopup;
    }

    public boolean IsPopupPending() {
        return this.mPopupManager.IsPopupPending();
    }

    public boolean IsHandlingPopup() {
        return this.mCurrentPopup != null || this.IsPopupPending();
    }

    public boolean IsPopupAdded(Popup popup) {
        return this.mPopupManager.IsPopupAdded(popup);
    }

    public void SetDefaultSoftkeys() {
        if (this.mSelectSoftKey != null) {
            this.mSelectSoftKey.SetCommand(this.mSelectSoftKeyDefaultCommand);
            this.mSelectSoftKey.SetCaption(new FlString(this.mSelectSoftKeyDefaultCaption));
        }
        if (this.mClearSoftKey != null) {
            this.mClearSoftKey.SetCommand(this.mClearSoftKeyDefaultCommand);
            this.mClearSoftKey.SetCaption(new FlString(this.mClearSoftKeyDefaultCaption));
        }
    }

    public void RemoveSoftKeysCommand() {
        this.mSelectSoftKey.SetCommand(0);
        this.mClearSoftKey.SetCommand(0);
    }

    public Viewport GetViewport() {
        return this.mViewport;
    }

    public void SetCursor(Cursor cursor) {
        this.mCursor = cursor;
    }

    public Cursor GetCursor() {
        return this.mCursor;
    }

    public Scroller GetPenMoveHScrollingComponent() {
        return null;
    }

    public Scroller GetPenMoveVScrollingComponent() {
        return null;
    }

    public boolean OnKeyDown(int n2) {
        return false;
    }

    public boolean OnKeyUp(int n2) {
        return false;
    }

    public boolean OnKeyDownOrRepeat(int n2) {
        return false;
    }

    public void ReleaseAllPopups() {
        this.mPopupManager.ReleasePopups();
    }

    public void LoadPopup() {
        this.mSelectSoftKeyDefaultCommand = this.mSelectSoftKey.GetCommand();
        this.mClearSoftKeyDefaultCommand = this.mClearSoftKey.GetCommand();
        this.mSelectSoftKeyDefaultCaption.Assign(this.mSelectSoftKey.GetSoftkeyTextField().GetCaption());
        this.mClearSoftKeyDefaultCaption.Assign(this.mClearSoftKey.GetSoftkeyTextField().GetCaption());
        this.mCurrentPopupId = this.mCurrentPopup.GetId();
        this.mCurrentPopup.Load();
    }

    public boolean OnPushedMsg(Selection selection, int n2, int n3) {
        boolean bl = false;
        if (n3 == 0) {
            bl = this.OnCommand(selection.GetCommand());
        }
        return bl;
    }

    public boolean OnKeyMsg(Component component, int n2, int n3) {
        int n4 = n3;
        boolean bl = n2 == -121;
        boolean bl2 = false;
        if (!bl2 && n2 != -119) {
            bl2 = GameApp.Get().GetCheatActivationController().OnKey(this.GetId(), n4, bl);
        }
        if (!bl2) {
            bl2 = bl ? this.OnKeyUp(n4) : (n2 == -119 ? this.OnKeyDownOrRepeat(n4) : this.OnKeyDown(n4));
        }
        if (!bl2) {
            if (n4 == 6) {
                this.mClearSoftKey.SetPushed(!bl);
                return true;
            }
            if (n4 == 5) {
                this.mSelectSoftKey.SetPushed(!bl);
                return true;
            }
        }
        return bl2;
    }

    public void AddRef() {
    }

    public void RemoveRef() {
    }

    public void ReleaseCurrentPopup() {
        if (this.mCurrentPopup != null) {
            this.mCurrentPopup.Unload();
        }
        this.mCurrentPopup = null;
    }

    public void AddExitPromptPopup(int n2, int n3, int n4, boolean bl) {
        this.AddExitPromptPopup(n2, n3, n4, bl, -1);
    }

    public void AddPromptPopup(int n2, int n3, int n4, boolean bl) {
        this.AddPromptPopup(n2, n3, n4, bl, -1);
    }

    public void AddPromptPopup(int n2, int n3, FlString flString, boolean bl) {
        this.AddPromptPopup(n2, n3, flString, bl, -1);
    }

    public void AddMessagePopup(FlString flString) {
        this.AddMessagePopup(flString, -68);
    }

    public void AddMessagePopup(FlString flString, int n2) {
        this.AddMessagePopup(flString, n2, true);
    }

    public void AddTutorialPopup(byte by) {
        this.AddTutorialPopup(by, true);
    }

    public void AddTutorialPopup(byte by, boolean bl) {
        this.AddTutorialPopup(by, bl, -68);
    }

    public void HidePopup() {
        this.HidePopup(0);
    }
}

