/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Characters;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlDisplayContext;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public class TextField
extends Viewport {
    public static final byte typeNumber = 99;
    public static final byte typeID = 99;
    public static final boolean supportsDynamicSerialization = true;
    public static final byte charRemoval = 0;
    public static final byte charAppend = 1;
    public static final byte charCycle = 2;
    public Component mCursor;
    public Text mText;
    public FlString mString;
    public boolean mIsFocused;
    public short mMaxLength;
    public boolean mIsCapitalised;
    public boolean mIsCapitalisedLock;
    public boolean mIsDigitsOnly;
    public byte mCursorRecedeOnLastChar;
    public int mCursorBlinkTimeLeft;
    public FlString mKeysString;
    public int mCurrentKeysStringIndex;
    public int mCursorPosition;
    public int mLastKey;
    public int mCycleTimeLeft;
    public int[] mFirstIndices = new int[13];

    public static TextField Cast(Object object, TextField textField) {
        return (TextField)object;
    }

    public byte GetTypeID() {
        return 99;
    }

    public static Class AsClass() {
        return null;
    }

    public TextField() {
        this.mString = new FlString();
        this.Initialize();
    }

    public TextField(Viewport viewport) {
        super(viewport);
        this.mString = new FlString();
        this.Initialize();
    }

    public TextField(Viewport viewport, FlFont flFont, FlString flString, short s2, short s3, short s4, short s5, byte by, boolean bl) {
        super(viewport);
        this.mString = new FlString();
        this.Initialize();
        this.SetRect(s2, s3, s4, s5);
        this.mString.Assign(flString);
        this.mText = new Text(this, flFont, new FlString(this.mString), 0, 0, s4, s5, by);
        this.mText.SetMultiline(bl);
        this.mText.KeepTrailingWhiteSpaces(true);
    }

    public void destruct() {
        this.mText.SetViewportNull();
        if (this.mCursor != null) {
            this.mCursor.SetViewportNull();
        }
        this.mCursor = null;
        this.mText = null;
        this.mKeysString = null;
    }

    public void OnTime(int n2, int n3) {
        if (this.mIsFocused) {
            this.mCursorBlinkTimeLeft -= n3;
            if (this.mCursor != null && this.mCursorBlinkTimeLeft <= 0) {
                this.ResetCursor(!this.mCursor.IsVisible());
            }
            if (this.mCycleTimeLeft > 0) {
                this.mCycleTimeLeft -= n3;
                if (this.mCycleTimeLeft <= 0) {
                    this.UpdateCursorPosition(1);
                }
            }
        }
    }

    public boolean OnDefaultMsg(Component component, int n2, int n3) {
        if (n2 == -128) {
            this.SetFocus(n3 == 1);
            return true;
        }
        if (n2 < -121 || n2 > -119) {
            return super.OnDefaultMsg(component, n2, n3);
        }
        int n4 = n3;
        if (!this.IsKeySupported(n4)) {
            return super.OnDefaultMsg(component, n2, n3);
        }
        if ((n4 == 6 || n4 == 10) && this.mString.GetLength() == 0) {
            this.StopCycling();
            return false;
        }
        if (n2 == -121) {
            switch (n4) {
                case 6: 
                case 10: {
                    this.StopCycling();
                    if (this.mCursorPosition <= 0) break;
                    this.mString.RemoveCharAt(this.mCursorPosition - 1);
                    this.UpdateDisplay();
                    this.UpdateCursorPosition(-1);
                    this.SendMsg(this, -110, 0);
                    break;
                }
                case 15: {
                    this.StopCycling();
                    this.SetCapitalised(!this.mIsCapitalised);
                    break;
                }
                default: {
                    if (this.mIsDigitsOnly && (n4 < 17 || n4 > 26)) {
                        return true;
                    }
                    if (this.mCycleTimeLeft > 0 && n4 == this.mLastKey) {
                        ++this.mCurrentKeysStringIndex;
                        this.mCycleTimeLeft = 800;
                        if (this.mCurrentKeysStringIndex == this.GetKeysStringIndexFor(this.mLastKey + 1)) {
                            this.mCurrentKeysStringIndex = this.GetKeysStringIndexFor(this.mLastKey);
                        }
                        this.mString.RemoveCharAt(this.mCursorPosition);
                        this.mString.InsertCharAt(this.mCursorPosition, this.GetCurrentChar());
                        this.UpdateDisplay();
                        this.UpdateCursorPosition(0);
                        this.SendMsg(this, -110, 2);
                        break;
                    }
                    this.InsertChar(n4);
                }
            }
        }
        return true;
    }

    public void OnSerialize(Package package_) {
        super.OnSerialize(package_);
        this.mCursor = Component.Cast(package_.SerializePointer((byte)67, true, false), null);
        this.mText = Text.Cast(package_.SerializePointer((byte)71, true, false), null);
        this.mString.Assign(this.mText.GetCaption());
        this.mText.SetViewport(this);
        this.mText.KeepTrailingWhiteSpaces(true);
        this.mMaxLength = package_.SerializeIntrinsic(this.mMaxLength);
        this.mIsCapitalised = package_.SerializeIntrinsic(this.mIsCapitalised);
        this.mIsCapitalisedLock = package_.SerializeIntrinsic(this.mIsCapitalisedLock);
        this.mIsDigitsOnly = package_.SerializeIntrinsic(this.mIsDigitsOnly);
        this.mCursorRecedeOnLastChar = package_.SerializeIntrinsic(this.mCursorRecedeOnLastChar);
        this.SetCursor(this.mCursor);
    }

    public void SetFocus(boolean bl) {
        if (bl == this.mIsFocused) {
            return;
        }
        this.mIsFocused = bl;
        this.mCycleTimeLeft = 0;
        this.mCursorPosition = this.mString.GetLength();
        this.UpdateCursorPosition(0);
        this.ResetCursor(bl);
        if (this.mIsFocused) {
            this.TakeFocus();
            this.RegisterInGlobalTime();
        } else {
            this.UnRegisterInGlobalTime();
        }
    }

    public void SetMaxCharacters(short s2) {
        this.mMaxLength = s2;
    }

    public void SetCapitalised(boolean bl) {
        this.mIsCapitalised = this.mIsCapitalisedLock || bl;
    }

    public void SetLockCapitalised(boolean bl) {
        this.mIsCapitalisedLock = bl;
    }

    public void SetCursor(Component component) {
        if (this.mCursor != null) {
            this.mCursor.SetViewportNull();
            this.mCursor = null;
        }
        this.mCursor = component;
        if (this.mCursor != null) {
            this.mCursor.SetViewport(this);
            this.mCursor.SetVisible(this.mIsFocused);
            this.UpdateCursorPosition(0);
            if (this.mCursorRecedeOnLastChar == -1) {
                this.mCursorRecedeOnLastChar = (byte)this.mCursor.GetRectWidth();
            }
        }
    }

    public void SetIsDigitOnly(boolean bl) {
        this.mIsDigitsOnly = bl;
    }

    public void SetCursorRecedeOnLastChar(byte by) {
        this.mCursorRecedeOnLastChar = by;
    }

    public Component GetCursor() {
        return this.mCursor;
    }

    public Text GetText() {
        return this.mText;
    }

    public short GetMaxCharacters() {
        return this.mMaxLength;
    }

    public boolean IsDigitOnly() {
        return this.mIsDigitsOnly;
    }

    public Text BeginTextChange() {
        return this.mText;
    }

    public void EndTextChange() {
        this.mString.Assign(this.mText.GetCaption());
        this.mCursorPosition = this.mString.GetLength();
        this.UpdateDisplay();
        this.UpdateCursorPosition(0);
    }

    public void InsertCharacterInSet(byte by, int n2) {
        if (this.mKeysString.FindChar(by) == -1) {
            this.mKeysString.InsertCharAt(this.mFirstIndices[n2 - 15 + 1], by);
            int n3 = n2 - 15 + 1;
            while (n3 < 13) {
                int n4 = n3++;
                this.mFirstIndices[n4] = this.mFirstIndices[n4] + 1;
            }
        }
    }

    public void RemoveCharacterFromSet(byte by) {
        int n2 = this.mKeysString.FindChar(by);
        if (n2 >= 0) {
            this.mKeysString.RemoveCharAt(n2);
            for (int i2 = 0; i2 < 13; ++i2) {
                if (this.mFirstIndices[i2] <= n2) continue;
                int n3 = i2;
                this.mFirstIndices[n3] = this.mFirstIndices[n3] - 1;
            }
        }
    }

    public void CloneCharacterSets(TextField textField) {
        this.mKeysString.Assign(textField.mKeysString);
        for (int i2 = 0; i2 < 13; ++i2) {
            this.mFirstIndices[i2] = textField.mFirstIndices[i2];
        }
    }

    public void Initialize() {
        this.mMaxLength = (short)255;
        this.mCursorRecedeOnLastChar = (byte)-1;
        this.mKeysString = new FlString("#* 0.,?!1abc2def3ghi4jkl5mno6pqrs7tuv8wxyz9");
        this.SetFirstIndex(17, 2);
        this.SetFirstIndex(18, 4);
        this.SetFirstIndex(19, 9);
        this.SetFirstIndex(20, 13);
        this.SetFirstIndex(21, 17);
        this.SetFirstIndex(22, 21);
        this.SetFirstIndex(23, 25);
        this.SetFirstIndex(24, 29);
        this.SetFirstIndex(25, 34);
        this.SetFirstIndex(26, 38);
        this.SetFirstIndex(16, 1);
        this.SetFirstIndex(15, 0);
        this.SetFirstIndex(27, 43);
    }

    public void ResetCursor(boolean bl) {
        if (this.mCursor != null) {
            this.mCursorBlinkTimeLeft = 800;
            this.mCursor.SetVisible(bl);
        }
    }

    public void UpdateCursorPosition(int n2) {
        this.mCursorPosition += n2;
        this.ResetCursor(this.mIsFocused);
        Vector2_short vector2_short = new Vector2_short(this.mText.GetCharIndex2DPosition(this.mCursorPosition));
        FlString flString = new FlString(this.mText.GetLineString(vector2_short.GetY()));
        int n3 = this.mText.GetFont().GetLineWidth(flString, 0, flString.GetLength(), false);
        int n4 = this.mText.GetFont().GetLineWidth(flString, 0, vector2_short.GetX(), false);
        short s2 = FlDisplayContext.GetAlignmentOffsetX(this.mText.GetAlignment(), this.mText.GetRectWidth(), (short)n3);
        if (this.mCursor != null) {
            if (flString.GetLength() == this.mMaxLength && n4 >= n3 || this.mText.GetAlignment() == 2) {
                n4 -= this.mCursorRecedeOnLastChar;
            }
            this.mCursor.SetTopLeft((short)FlMath.Minimum(n4 + s2, (int)this.mText.GetRectWidth()), (short)(vector2_short.GetY() * this.mText.GetFont().GetLineHeight()));
        }
    }

    public void UpdateDisplay() {
        FlString flString = new FlString(this.mString);
        this.mText.SetCaption(flString, false);
        short s2 = 0;
        if (this.mCursor != null) {
            s2 = this.mCursor.GetRectWidth();
        }
        if (!this.mText.IsMultiline()) {
            this.mText.ComputeLineWidth(false);
        } else {
            this.SetSize((short)(this.mText.GetRectWidth() + s2), this.mText.GetRectHeight());
        }
    }

    public byte GetCurrentChar() {
        int n2;
        if (this.mIsDigitsOnly) {
            return (byte)(48 + (this.mLastKey - 17));
        }
        byte by = this.mKeysString.GetCharAt(this.mCurrentKeysStringIndex);
        if (this.mIsCapitalised && (n2 = by - 97) >= 0 && n2 <= 26) {
            by = (byte)(65 + n2);
        }
        return by;
    }

    public void InsertChar(int n2) {
        if (this.mString.GetLength() < this.mMaxLength) {
            this.StopCycling();
            this.mLastKey = n2;
            this.mCurrentKeysStringIndex = this.GetKeysStringIndexFor(this.mLastKey);
            if (this.mCurrentKeysStringIndex == this.GetKeysStringIndexFor(this.mLastKey + 1)) {
                return;
            }
            byte by = this.GetCurrentChar();
            this.mString.InsertCharAt(this.mCursorPosition, by);
            this.UpdateDisplay();
            if (this.CanCycle()) {
                this.mCycleTimeLeft = 800;
                this.UpdateCursorPosition(0);
            } else {
                this.UpdateCursorPosition(1);
            }
            this.SendMsg(this, -110, 1);
        }
    }

    public boolean IsKeySupported(int n2) {
        if (n2 == 14 || n2 == 10 || n2 == 6) {
            return true;
        }
        return n2 >= 15 && n2 < 27;
    }

    public boolean FontContainCharacter(byte by) {
        FlFont flFont = this.mText.GetFont();
        return flFont.GetFontBlob().GetIndexOfChar(by) != Characters.CharToInt(Characters.Undefined());
    }

    public void StopCycling() {
        if (this.mCycleTimeLeft > 0) {
            this.mCycleTimeLeft = -1;
            this.UpdateCursorPosition(1);
        }
    }

    public boolean CanCycle() {
        if (this.mIsDigitsOnly) {
            return false;
        }
        return this.GetKeysStringIndexFor(this.mLastKey) != this.GetKeysStringIndexFor(this.mLastKey + 1) - 1;
    }

    public int GetKeysStringIndexFor(int n2) {
        return this.mFirstIndices[n2 - 15];
    }

    public void SetFirstIndex(int n2, int n3) {
        this.mFirstIndices[n2 - 15] = n3;
    }

    public static TextField[] InstArrayTextField(int n2) {
        TextField[] textFieldArray = new TextField[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            textFieldArray[i2] = new TextField();
        }
        return textFieldArray;
    }

    public static TextField[][] InstArrayTextField(int n2, int n3) {
        TextField[][] textFieldArray = new TextField[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            textFieldArray[i2] = new TextField[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                textFieldArray[i2][i3] = new TextField();
            }
        }
        return textFieldArray;
    }

    public static TextField[][][] InstArrayTextField(int n2, int n3, int n4) {
        TextField[][][] textFieldArray = new TextField[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            textFieldArray[i2] = new TextField[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                textFieldArray[i2][i3] = new TextField[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    textFieldArray[i2][i3][i4] = new TextField();
                }
            }
        }
        return textFieldArray;
    }
}

