/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ForceInline;

public class FlDrawPropertyUtil {
    public static final int BitmapStencilNone = 0;
    public static final int BitmapStencilPositive = 512;
    public static final int BitmapStencilNegative = 1024;
    public static final int TransformNone = 0;
    public static final int TransformMirrorRot180 = 65536;
    public static final int TransformMirror = 131072;
    public static final int TransformRot180 = 196608;
    public static final int TransformMirrorRot270 = 262144;
    public static final int TransformRot90 = 327680;
    public static final int TransformRot270 = 393216;
    public static final int TransformMirrorRot90 = 458752;
    public static final int TileNone = 0;
    public static final int TileX = 524288;
    public static final int TileY = 0x100000;
    public static final int TileXY = 0x180000;

    public static int GetDefaultDrawProperty() {
        ForceInline.v();
        return 255;
    }

    public static int BmpTransformToTransform(byte by) {
        ForceInline.v();
        switch (by) {
            case 2: {
                return 131072;
            }
            case 1: {
                return 65536;
            }
            case 3: {
                return 196608;
            }
        }
        return 0;
    }

    public static int FlipXYToTransform(boolean bl, boolean bl2) {
        ForceInline.v();
        if (!bl) {
            return bl2 ? 65536 : 0;
        }
        return bl2 ? 196608 : 131072;
    }

    public static int MIDPTransformToTransform(int n2) {
        ForceInline.v();
        return n2 << 16;
    }

    public static int TransformToMIDPTransform(int n2) {
        ForceInline.v();
        return n2 >>> 16;
    }

    public static byte GetBmpTransform(int n2) {
        ForceInline.v();
        switch (FlDrawPropertyUtil.GetTransform(n2)) {
            case 131072: {
                return 2;
            }
            case 65536: {
                return 1;
            }
            case 196608: {
                return 3;
            }
        }
        return 0;
    }

    public static boolean IsFlippedX(int n2) {
        int n3 = FlDrawPropertyUtil.GetTransform(n2);
        return n3 == 196608 || n3 == 131072;
    }

    public static boolean IsFlippedY(int n2) {
        int n3 = FlDrawPropertyUtil.GetTransform(n2);
        return n3 == 196608 || n3 == 65536;
    }

    public static int ApplyTransform(int n2, int n3) {
        ForceInline.v();
        return n2 & 0xFFF8FFFF | n3;
    }

    public static int GetTransform(int n2) {
        ForceInline.v();
        return n2 & 0x70000;
    }

    public static boolean IsInitialOrientation(int n2) {
        ForceInline.v();
        switch (FlDrawPropertyUtil.GetTransform(n2)) {
            case 0: 
            case 65536: 
            case 131072: 
            case 196608: {
                return true;
            }
        }
        return false;
    }

    public static short GetAlpha(int n2) {
        ForceInline.v();
        return 255;
    }

    public static int GetBitmapStencil(int n2) {
        ForceInline.v();
        return 0;
    }

    public static int GetTile(int n2) {
        ForceInline.v();
        return n2 & 0x180000;
    }

    public static int GetJ2METransform(int n2) {
        ForceInline.v();
        return FlDrawPropertyUtil.GetTransform(n2) >>> 16;
    }

    public static int ApplyTile(int n2, int n3) {
        ForceInline.v();
        return n2 & 0xFFE7FFFF | n3;
    }

    public static int ApplyTile(int n2, boolean bl, boolean bl2) {
        int n3 = 0;
        if (bl) {
            n3 = 524288;
        }
        if (bl2) {
            n3 |= 0x100000;
        }
        return FlDrawPropertyUtil.ApplyTile(n2, n3);
    }

    public static FlDrawPropertyUtil[] InstArrayFlDrawPropertyUtil(int n2) {
        FlDrawPropertyUtil[] flDrawPropertyUtilArray = new FlDrawPropertyUtil[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            flDrawPropertyUtilArray[i2] = new FlDrawPropertyUtil();
        }
        return flDrawPropertyUtilArray;
    }

    public static FlDrawPropertyUtil[][] InstArrayFlDrawPropertyUtil(int n2, int n3) {
        FlDrawPropertyUtil[][] flDrawPropertyUtilArray = new FlDrawPropertyUtil[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            flDrawPropertyUtilArray[i2] = new FlDrawPropertyUtil[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                flDrawPropertyUtilArray[i2][i3] = new FlDrawPropertyUtil();
            }
        }
        return flDrawPropertyUtilArray;
    }

    public static FlDrawPropertyUtil[][][] InstArrayFlDrawPropertyUtil(int n2, int n3, int n4) {
        FlDrawPropertyUtil[][][] flDrawPropertyUtilArray = new FlDrawPropertyUtil[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            flDrawPropertyUtilArray[i2] = new FlDrawPropertyUtil[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                flDrawPropertyUtilArray[i2][i3] = new FlDrawPropertyUtil[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    flDrawPropertyUtilArray[i2][i3][i4] = new FlDrawPropertyUtil();
                }
            }
        }
        return flDrawPropertyUtilArray;
    }
}

