/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ForceInline;
import ca.jamdat.flight.Package;

public class F32 {
    public int value;

    public F32() {
        ForceInline.v();
    }

    public F32(float f2, int n2) {
        ForceInline.v();
        this.value = (int)(f2 * (float)(1 << n2));
    }

    public F32(int n2, int n3) {
        ForceInline.v();
        this.value = n2;
    }

    public F32(F32 f32) {
        ForceInline.v();
        this.value = f32.value;
    }

    public F32 Mul(F32 f32, int n2) {
        ForceInline.v();
        long l2 = (long)this.value * (long)f32.value;
        return new F32((int)(l2 >> n2), n2);
    }

    public F32 Div(F32 f32, int n2) {
        ForceInline.v();
        long l2 = (long)this.value << n2;
        return new F32((int)(l2 /= (long)f32.value), n2);
    }

    public F32 MulLP(F32 f32, int n2) {
        ForceInline.v();
        return new F32((this.value >> n2 / 2) * (f32.value >> n2 / 2), n2);
    }

    public F32 DivLP(F32 f32, int n2) {
        ForceInline.v();
        return new F32((this.value << n2 / 4) / (f32.value >> n2 - n2 / 4), n2);
    }

    public F32 MulPower2(int n2) {
        ForceInline.v();
        return new F32(this.value << n2, 0);
    }

    public F32 DivPower2(int n2) {
        ForceInline.v();
        return new F32(this.value >> n2, 0);
    }

    public F32 Inverse(int n2) {
        ForceInline.v();
        long l2 = 0x4000000000000000L;
        l2 /= (long)this.value;
        return new F32((int)(l2 >>= 62 - 2 * n2), n2);
    }

    public F32 Square(int n2) {
        ForceInline.v();
        return this.Mul(this, n2);
    }

    public F32 Round(int n2) {
        ForceInline.v();
        return this.Add(F32.Half(n2)).Floor(n2);
    }

    public F32 Floor(int n2) {
        ForceInline.v();
        F32 f32 = new F32(this);
        f32.value = this.value >> n2 << n2;
        return f32;
    }

    public F32 Ceiling(int n2) {
        ForceInline.v();
        F32 f32 = new F32(this);
        f32.value = -(-this.value >> n2 << n2);
        return f32;
    }

    public F32 Abs() {
        ForceInline.v();
        if (this.value < 0) {
            return this.Neg();
        }
        return this;
    }

    public F32 Sqrt(int n2) {
        int n3 = 0;
        long l2 = this.value;
        n3 = (int)Math.sqrt(l2 <<= n2);
        return new F32(n3, n2);
    }

    public F32 InvSqrt(int n2) {
        return this.Sqrt(n2).Inverse(n2);
    }

    public F32 Sin(int n2) {
        F32 f32 = new F32(F32.Pi(n2));
        F32 f322 = new F32(F32.PiOver2(n2));
        F32 f323 = new F32(this);
        F32 f324 = new F32(F32.TwoPi(n2));
        if (f323.value < 0) {
            do {
                f323 = f323.Add(f324);
            } while (f323.value < 0);
        } else if (f323.GreaterThan(f324)) {
            while ((f323 = f323.Sub(f324)).GreaterThan(f324)) {
            }
        }
        int n3 = 1;
        if (f323.value > f32.value) {
            if (f323.value > f32.value + f322.value) {
                f323.value = (f32.value << 1) - f323.value;
                n3 = -1;
            } else {
                f323.value -= f32.value;
                n3 = -1;
            }
        } else if (f323.value > f322.value) {
            f323.value = f32.value - f323.value;
        }
        F32 f325 = new F32(f323.Square(n2));
        F32 f326 = new F32(F32.ConvertConstant16(498, n2));
        f326 = f326.Mul(f325, n2);
        f326 = f326.Sub(F32.ConvertConstant16(10882, n2));
        f326 = f326.Mul(f325, n2);
        f326.value += 1 << n2;
        f326 = f326.Mul(f323, n2);
        f326.value *= n3;
        return f326;
    }

    public F32 Cos(int n2) {
        F32 f32 = new F32(F32.Pi(n2));
        F32 f322 = new F32(F32.PiOver2(n2));
        F32 f323 = new F32(this);
        F32 f324 = new F32(F32.TwoPi(n2));
        if (f323.value < 0) {
            do {
                f323 = f323.Add(f324);
            } while (f323.value < 0);
        } else if (f323.GreaterThan(f324)) {
            while ((f323 = f323.Sub(f324)).GreaterThan(f324)) {
            }
        }
        int n3 = 1;
        if (f323.value > f32.value) {
            if (f323.value > f32.value + f322.value) {
                f323.value = (f32.value << 1) - f323.value;
            } else {
                f323.value -= f32.value;
                n3 = -1;
            }
        } else if (f323.value > f322.value) {
            f323.value = f32.value - f323.value;
            n3 = -1;
        }
        F32 f325 = new F32(f323.Square(n2));
        F32 f326 = new F32(F32.ConvertConstant16(2428, n2).Mul(f325, n2));
        f326 = f326.Sub(F32.ConvertConstant16(32551, n2));
        f326 = f326.Mul(f325, n2);
        f326.value += 1 << n2;
        f326.value *= n3;
        return f326;
    }

    public F32 Tan(int n2) {
        F32 f32 = new F32(this);
        F32 f322 = new F32(F32.TwoPi(n2));
        while (f32.GreaterThan(f322)) {
            f32 = f32.Sub(f322);
        }
        while (f32.value < 0) {
            f32 = f32.Add(f322);
        }
        F32 f323 = new F32(f32.Square(n2));
        F32 f324 = new F32(F32.ConvertConstant16(13323, n2));
        f324 = f324.Mul(f323, n2);
        f324 = f324.Add(F32.ConvertConstant16(20810, n2));
        f324 = f324.Mul(f323, n2);
        f324 = f324.Add(F32.One(n2));
        f324 = f32.Mul(f324, n2);
        return f324;
    }

    public F32 ArcSin(int n2) {
        if (this.IsNegative()) {
            return this.Neg().ArcSin(n2).Neg();
        }
        F32 f32 = new F32(F32.One(n2).Sub(this).Sqrt(n2));
        F32 f322 = new F32(F32.ConvertConstant16(-1228, n2));
        f322 = this.Mul(f322, n2);
        f322 = f322.Add(F32.ConvertConstant16(4866, n2));
        f322 = this.Mul(f322, n2);
        f322 = f322.Sub(F32.ConvertConstant16(13901, n2));
        f322 = this.Mul(f322, n2);
        f322 = f322.Add(F32.ConvertConstant16(102939, n2));
        f322 = F32.PiOver2(n2).Sub(f322.Mul(f32, n2));
        return f322;
    }

    public F32 ArcCos(int n2) {
        if (this.IsNegative()) {
            return this.Neg().ArcCos(n2).Sub(F32.Pi(n2)).Neg();
        }
        if (this.GreaterOrEqual(F32.One(n2))) {
            return F32.Zero(n2);
        }
        F32 f32 = new F32(F32.One(n2).Sub(this).Sqrt(n2));
        F32 f322 = new F32(F32.ConvertConstant16(-1228, n2));
        f322 = this.Mul(f322, n2);
        f322 = f322.Add(F32.ConvertConstant16(4866, n2));
        f322 = this.Mul(f322, n2);
        f322 = f322.Sub(F32.ConvertConstant16(13901, n2));
        f322 = this.Mul(f322, n2);
        f322 = f322.Add(F32.ConvertConstant16(102939, n2));
        f322 = f322.Mul(f32, n2);
        return f322;
    }

    public F32 ArcTan(int n2) {
        if (this.Abs().GreaterThan(F32.One(n2))) {
            if (this.IsPositive()) {
                return F32.PiOver2(n2).Sub(this.Inverse(n2).ArcTan(n2));
            }
            return F32.PiOver2(n2).Neg().Sub(this.Inverse(n2).ArcTan(n2));
        }
        F32 f32 = new F32(this.Square(n2));
        F32 f322 = new F32(F32.ConvertConstant16(1365, n2));
        f322 = f322.Mul(f32, n2);
        f322 = f322.Sub(F32.ConvertConstant16(5579, n2));
        f322 = f322.Mul(f32, n2);
        f322 = f322.Add(F32.ConvertConstant16(11805, n2));
        f322 = f322.Mul(f32, n2);
        f322 = f322.Sub(F32.ConvertConstant16(21646, n2));
        f322 = f322.Mul(f32, n2);
        f322 = f322.Add(F32.ConvertConstant16(65527, n2));
        f322 = this.Mul(f322, n2);
        return f322;
    }

    public static F32 ArcTan2(F32 f32, F32 f322, int n2) {
        ForceInline.v();
        if (f32.Abs().LessThan(F32.Epsilon(n2))) {
            if (f322.Abs().LessThan(F32.Epsilon(n2))) {
                return F32.Zero(n2);
            }
            if (f322.IsPositive()) {
                return F32.PiOver2(n2);
            }
            return F32.PiOver2(n2).Neg();
        }
        F32 f323 = new F32(f322.Div(f32, n2));
        if (f32.IsNegative()) {
            F32 f324 = new F32(f323.Abs().ArcTan(n2));
            f324 = F32.Pi(n2).Sub(f324);
            if (f322.IsNegative()) {
                return f324.Neg();
            }
            return f324;
        }
        return f323.ArcTan(n2);
    }

    public F32 SqrtApproximation7(int n2) {
        ForceInline.v();
        F32 f32 = new F32(F32.One(n2));
        f32 = f32.Add(this.Div(f32, n2)).DivPower2(1);
        f32 = f32.Add(this.Div(f32, n2)).DivPower2(1);
        f32 = f32.Add(this.Div(f32, n2)).DivPower2(1);
        f32 = f32.Add(this.Div(f32, n2)).DivPower2(1);
        f32 = f32.Add(this.Div(f32, n2)).DivPower2(1);
        f32 = f32.Add(this.Div(f32, n2)).DivPower2(1);
        return f32;
    }

    public F32 SqrtApproximation3(int n2) {
        ForceInline.v();
        F32 f32 = new F32(F32.One(n2).Add(this.Mul(this.Add(F32.FromInt(6, n2)), n2)));
        F32 f322 = new F32(this.Add(F32.One(n2)).MulPower2(2));
        F32 f323 = new F32(f32.Div(f322, n2));
        return f323;
    }

    public F32 SqrtInvApproximation3(int n2) {
        ForceInline.v();
        F32 f32 = new F32(this.Add(F32.One(n2)).MulPower2(2));
        F32 f322 = new F32(F32.One(n2).Add(this.Mul(this.Add(F32.FromInt(6, n2)), n2)));
        F32 f323 = new F32(f32.Div(f322, n2));
        return f323;
    }

    public F32 ArcCos5(int n2) {
        F32 f32 = new F32();
        F32 f322 = new F32();
        boolean bl = this.LessThan(F32.Half(n2));
        f322 = bl ? this : F32.One(n2).Sub(this.Square(n2)).Sqrt(n2);
        F32 f323 = new F32(f322.Mul(f322, n2).Mul(f322, n2));
        F32 f324 = new F32(f323.Mul(f322, n2).Mul(f322, n2));
        F32 f325 = new F32(f324.Mul(f322, n2).Mul(f322, n2));
        F32 f326 = new F32(f325.Mul(f322, n2).Mul(f322, n2));
        F32 f327 = new F32(f322);
        F32 f328 = new F32(f323.Div(6));
        F32 f329 = new F32(f324.Mul(3).Div(40));
        F32 f3210 = new F32(f325.Mul(15).Div(336));
        F32 f3211 = new F32(f326.Mul(105).Div(3024));
        if (bl) {
            F32 f3212 = new F32(f327.Add(f328).Add(f329).Add(f3210).Add(f3211));
            f32 = F32.PiOver2(n2).Sub(f3212);
        } else {
            f32 = f327.Add(f328).Add(f329).Add(f3210).Add(f3211);
        }
        return f32;
    }

    public F32 DecreasePrecision(int n2) {
        ForceInline.v();
        F32 f32 = new F32(this);
        f32.value = this.value >> n2;
        return f32;
    }

    public F32 IncreasePrecision(int n2) {
        ForceInline.v();
        F32 f32 = new F32(this);
        f32.value = this.value << n2;
        return f32;
    }

    public F32 Add(F32 f32) {
        ForceInline.v();
        F32 f322 = new F32(this.value + f32.value);
        return f322;
    }

    public F32 Sub(F32 f32) {
        ForceInline.v();
        F32 f322 = new F32(this.value - f32.value);
        return f322;
    }

    public F32 Mul(int n2) {
        ForceInline.v();
        return new F32(this.value * n2, 0);
    }

    public F32 Div(int n2) {
        ForceInline.v();
        return new F32(this.value / n2, 0);
    }

    public F32 Neg() {
        ForceInline.v();
        return new F32(-this.value, 0);
    }

    public boolean LessThan(F32 f32) {
        ForceInline.v();
        return this.value < f32.value;
    }

    public boolean LessOrEqual(F32 f32) {
        ForceInline.v();
        return this.value <= f32.value;
    }

    public boolean GreaterThan(F32 f32) {
        ForceInline.v();
        return this.value > f32.value;
    }

    public boolean GreaterOrEqual(F32 f32) {
        ForceInline.v();
        return this.value >= f32.value;
    }

    public boolean Equals(F32 f32) {
        ForceInline.v();
        return this.value == f32.value;
    }

    public F32 NotAllowed(F32 f32) {
        ForceInline.v();
        this.value = f32.value;
        return this;
    }

    public boolean IsNegative() {
        ForceInline.v();
        return this.value < 0;
    }

    public boolean IsPositive() {
        ForceInline.v();
        return !this.IsNegative();
    }

    public int ToInt(int n2) {
        ForceInline.v();
        return this.value >> n2;
    }

    public static F32 FromInt(int n2, int n3) {
        ForceInline.v();
        return new F32(n2 << n3, n3);
    }

    public F32 DegreeToRadian(int n2) {
        return this.Div(F32.Number180OverPi(n2), n2);
    }

    public F32 RadianToDegree(int n2) {
        return this.Mul(F32.Number180OverPi(n2), n2);
    }

    public static F32 Pi(int n2) {
        ForceInline.v();
        return F32.ConvertConstant16(205887, n2);
    }

    public static F32 TwoPi(int n2) {
        ForceInline.v();
        return F32.Pi(n2).MulPower2(1);
    }

    public static F32 PiOver2(int n2) {
        ForceInline.v();
        return F32.Pi(n2).DivPower2(1);
    }

    public static F32 PiOver4(int n2) {
        ForceInline.v();
        return F32.Pi(n2).DivPower2(2);
    }

    public static F32 Number180OverPi(int n2) {
        ForceInline.v();
        return F32.FromInt(180, n2).Div(F32.Pi(n2), n2);
    }

    public static F32 Epsilon(int n2) {
        ForceInline.v();
        return new F32(10, n2);
    }

    public static F32 One(int n2) {
        ForceInline.v();
        return new F32(1 << n2, n2);
    }

    public static F32 Zero(int n2) {
        ForceInline.v();
        return new F32(0, n2);
    }

    public static F32 Half(int n2) {
        ForceInline.v();
        return new F32(1 << n2 - 1, n2);
    }

    public static F32 Quarter(int n2) {
        ForceInline.v();
        return new F32(1 << n2 - 2, n2);
    }

    public static F32 ThreeQuarter(int n2) {
        ForceInline.v();
        return new F32(1 << n2 - 1 | 1 << n2 - 2, n2);
    }

    public static F32 OneHundredth(int n2) {
        ForceInline.v();
        return F32.FromInt(100, n2).Inverse(n2);
    }

    public static F32 MaxValue(int n2) {
        ForceInline.v();
        int n3 = Integer.MAX_VALUE;
        return new F32(n3, n2);
    }

    public static F32 MinValue(int n2) {
        ForceInline.v();
        return F32.MaxValue(n2).Neg();
    }

    public int GetInternalRep(int n2) {
        ForceInline.v();
        return this.value;
    }

    public int ToFixedPoint(int n2) {
        ForceInline.v();
        return this.value;
    }

    public static int FromFixedPoint(int n2, int n3) {
        ForceInline.v();
        return n2;
    }

    public static void ConvertArrayToBaseType(int[] nArray, F32[] f32Array, int n2, int n3) {
        ForceInline.v();
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = f32Array[i2].ToFixedPoint(n3);
        }
    }

    public void OnSerialize(Package package_) {
        this.value = package_.SerializeIntrinsic(this.value);
    }

    public static long GetRightMask(int n2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 <<= 1;
            l2 |= 1L;
        }
        return l2;
    }

    public static long GetLeftMask(int n2) {
        ForceInline.v();
        return F32.GetRightMask(64 - n2) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static F32 ConvertConstant16(int n2, int n3) {
        ForceInline.v();
        if (n3 == 16) {
            return new F32(n2, 16);
        }
        if (n3 < 16) {
            return new F32(n2 >> 16 - n3, n3);
        }
        return new F32(n2 << n3 - 16, n3);
    }

    public F32(int n2) {
        ForceInline.v();
        this.value = n2;
    }

    public static F32[] InstArrayF32(int n2) {
        F32[] f32Array = new F32[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            f32Array[i2] = new F32();
        }
        return f32Array;
    }

    public static F32[][] InstArrayF32(int n2, int n3) {
        F32[][] f32Array = new F32[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            f32Array[i2] = new F32[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                f32Array[i2][i3] = new F32();
            }
        }
        return f32Array;
    }

    public static F32[][][] InstArrayF32(int n2, int n3, int n4) {
        F32[][][] f32Array = new F32[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            f32Array[i2] = new F32[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                f32Array[i2][i3] = new F32[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    f32Array[i2][i3][i4] = new F32();
                }
            }
        }
        return f32Array;
    }
}

