/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlDisplayContext;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Viewport;

public class BaseButton
extends Component {
    public FlFont[] mFonts = null;
    public byte[] mAligns = null;
    public byte mStateCount;
    public byte[] mStateMap = new byte[5];
    public Text mTextCaption;
    public int mState = 0;
    public byte mStateIndex;

    public BaseButton() {
        this.InitBaseButton();
    }

    public BaseButton(Viewport viewport) {
        this.SetViewport(viewport);
        this.InitBaseButton();
    }

    public BaseButton(Viewport viewport, FlString flString, FlFont flFont, int n2) {
        this.SetViewport(viewport);
        this.InitBaseButton();
        int n3 = 0;
        int n4 = 1;
        for (n3 = 0; n3 < 5; ++n3) {
            if ((n2 & n4) != 0) {
                this.mStateMap[n3] = this.mStateCount;
                this.mStateCount = (byte)(this.mStateCount + 1);
            }
            n4 <<= 4;
        }
        this.CreateArrays();
        if (flFont != null) {
            for (n3 = 0; n3 < this.mStateCount; ++n3) {
                this.mFonts[n3] = flFont;
            }
        }
        if (!flString.IsEmpty()) {
            this.SetCaption(flString);
        }
    }

    public void destruct() {
        this.mFonts = null;
        this.mAligns = null;
        this.mTextCaption = null;
    }

    public void SetCaption(FlString flString, boolean bl) {
        if (this.mTextCaption == null) {
            this.mTextCaption = new Text(null, null, new FlString(flString), this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height, 0);
        }
        this.mTextCaption.SetFont(this.mFonts[this.mStateIndex]);
        this.mTextCaption.SetAlignment(this.mAligns[this.mStateIndex]);
        this.mTextCaption.OnRectChange();
        this.mTextCaption.SetMultiline(bl);
        this.mTextCaption.SetCaption(new FlString(flString));
        this.mTextCaption.SetVisible(true);
        this.Invalidate();
    }

    public FlString GetCaption() {
        if (this.mTextCaption == null) {
            this.mTextCaption = new Text(null, null, new FlString(), this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height, 0);
        }
        return this.mTextCaption.GetCaption();
    }

    public void SetFont(FlFont flFont, int n2) {
        this.mFonts[this.mStateMap[n2]] = flFont;
        if (this.mTextCaption != null && n2 == this.mState) {
            this.mTextCaption.SetFont(flFont);
        }
    }

    public FlFont GetFont(int n2) {
        return this.mFonts[this.mStateMap[n2]];
    }

    public void SetAlignment(byte by, int n2) {
        this.mAligns[this.mStateMap[n2]] = by;
        if (this.mTextCaption != null && n2 == this.mState) {
            this.mTextCaption.SetAlignment(by);
        }
    }

    public byte GetAlignment(int n2) {
        return this.mAligns[this.mStateMap[n2]];
    }

    public void SetState(int n2) {
        this.mState = n2;
        this.mStateIndex = this.mStateMap[n2];
        if (this.mStateIndex == -1) {
            this.mStateIndex = 0;
        }
        if (this.mTextCaption != null) {
            this.mTextCaption.SetFont(this.mFonts[this.mStateIndex]);
            this.mTextCaption.SetAlignment(this.mAligns[this.mStateIndex]);
            this.mTextCaption.OnRectChange();
        }
        this.OnStateChange(n2);
        this.Invalidate();
    }

    public int GetState() {
        return this.mState;
    }

    public Text GetTextSubComponent() {
        return this.mTextCaption;
    }

    public void Activate() {
        this.GetViewport().OnChildEvent(this);
    }

    public boolean OnDefaultMsg(Component component, int n2, int n3) {
        if (n2 < -121 || n2 > -119 || n3 != 5) {
            return super.OnDefaultMsg(component, n2, n3);
        }
        if (n2 != -119) {
            this.OnPress(n2 == -121);
        }
        return true;
    }

    public void OnPress(boolean bl) {
        if (this.IsVisible() && this.GetState() != 3) {
            if (bl) {
                this.SetState(0);
                this.Activate();
            } else {
                this.SetState(2);
            }
        }
    }

    public void OnStateChange(int n2) {
    }

    public void OnDraw(FlDisplayContext flDisplayContext) {
        if (this.mTextCaption != null && this.mTextCaption.IsVisible()) {
            this.mTextCaption.OnDraw(flDisplayContext);
        }
    }

    public void OnRectChange() {
        if (this.mTextCaption != null) {
            this.mTextCaption.SetRect(this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height);
        }
    }

    public void InitBaseButton() {
        for (int i2 = 0; i2 < 5; ++i2) {
            this.mStateMap[i2] = -1;
        }
    }

    public void CreateArrays() {
        this.mFonts = new FlFont[this.mStateCount];
        this.mAligns = new byte[this.mStateCount];
    }

    public void SetCaption(FlString flString) {
        this.SetCaption(flString, false);
    }

    public static BaseButton[] InstArrayBaseButton(int n2) {
        BaseButton[] baseButtonArray = new BaseButton[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            baseButtonArray[i2] = new BaseButton();
        }
        return baseButtonArray;
    }

    public static BaseButton[][] InstArrayBaseButton(int n2, int n3) {
        BaseButton[][] baseButtonArray = new BaseButton[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            baseButtonArray[i2] = new BaseButton[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                baseButtonArray[i2][i3] = new BaseButton();
            }
        }
        return baseButtonArray;
    }

    public static BaseButton[][][] InstArrayBaseButton(int n2, int n3, int n4) {
        BaseButton[][][] baseButtonArray = new BaseButton[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            baseButtonArray[i2] = new BaseButton[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                baseButtonArray[i2][i3] = new BaseButton[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    baseButtonArray[i2][i3][i4] = new BaseButton();
                }
            }
        }
        return baseButtonArray;
    }
}

