/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.BaseScene;
import ca.jamdat.texasholdem09.Popup;
import ca.jamdat.texasholdem09.Softkey;
import ca.jamdat.texasholdem09.TexasGameManager;

public abstract class TimedPopup
extends Popup {
    public TexasGameManager mTexasGameManager = TexasGameManager.Get();
    public int mAutoHideTime;
    public int mDelayLoadingTime;

    public TimedPopup(BaseScene baseScene, Softkey softkey, Softkey softkey2, byte by) {
        super(baseScene, softkey, softkey2, by, Popup.IsKeepGameScenePopupInMemory());
    }

    public void destruct() {
    }

    public void Load() {
        if (this.mDelayLoadingTime > 0) {
            this.RegisterInGlobalTime();
        } else {
            super.Load();
            if (this.mContentMetaPackage == null) {
                this.LoadMetaPackage();
            }
        }
    }

    public void Unload() {
        this.mAutoHideTime = 0;
        this.mDelayLoadingTime = 0;
        super.Unload();
    }

    public void Hide() {
        if (this.mState == 3 || this.mState == 4 || this.mState == 6) {
            this.mAutoHideTime = 0;
            this.UnRegisterInGlobalTime();
        }
        this.mDelayLoadingTime = 0;
        super.Hide();
    }

    public void Shown() {
        if (this.mAutoHideTime > 0) {
            this.RegisterInGlobalTime();
        }
        super.Shown();
    }

    public void Hidden() {
        this.UnRegisterInGlobalTime();
        super.Hidden();
    }

    public void SetDelayLoadingTime(int n2) {
        this.mDelayLoadingTime = n2;
    }

    public void OnTime(int n2, int n3) {
        if (this.mAutoHideTime > 0) {
            this.mAutoHideTime -= n3;
            if (this.mAutoHideTime <= 0) {
                this.mParentScene.OnCommand(-68);
                this.UnRegisterInGlobalTime();
            }
        } else if (this.mDelayLoadingTime > 0) {
            this.mDelayLoadingTime -= n3;
            if (this.mDelayLoadingTime <= 0) {
                this.Load();
            }
        } else {
            super.OnTime(n2, n3);
        }
    }

    public void SetAutoHideTime(int n2) {
        this.mAutoHideTime = n2;
    }

    public abstract void LoadMetaPackage();
}

