/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.Deck;
import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.PokerPlayerAI;
import ca.jamdat.texasholdem09.PokerTable;
import ca.jamdat.texasholdem09.StaticCard;

public class TexasPokerTable
extends PokerTable {
    public byte[] mCommunityCard = new byte[5];
    public byte[] mNextCommunityCard = new byte[5];
    public int mCommunityCardCount;

    public TexasPokerTable() {
        StaticCard.Clear(this.mCommunityCard, 5);
        StaticCard.Clear(this.mNextCommunityCard, 5);
    }

    public void destruct() {
        this.mCommunityCard = null;
        this.mNextCommunityCard = null;
    }

    public static TexasPokerTable Get() {
        return GameApp.Get().GetGameFactory().GetGame().GetTexasPokerTable();
    }

    public void Save(FileSegmentStream fileSegmentStream) {
        super.Save(fileSegmentStream);
        fileSegmentStream.WriteByte((byte)this.mCommunityCardCount);
        int n2 = 0;
        for (n2 = 0; n2 < 5; ++n2) {
            fileSegmentStream.WriteByte(this.mCommunityCard[n2]);
        }
        for (n2 = 0; n2 < 5; ++n2) {
            fileSegmentStream.WriteByte(this.mNextCommunityCard[n2]);
        }
    }

    public void Load(FileSegmentStream fileSegmentStream) {
        super.Load(fileSegmentStream);
        this.mCommunityCardCount = fileSegmentStream.ReadByte();
        int n2 = 0;
        for (n2 = 0; n2 < 5; ++n2) {
            this.mCommunityCard[n2] = fileSegmentStream.ReadByte();
        }
        for (n2 = 0; n2 < 5; ++n2) {
            this.mNextCommunityCard[n2] = fileSegmentStream.ReadByte();
        }
    }

    public void AddCard() {
        short s2 = (short)this.mCommunityCardCount;
        this.mCommunityCard[s2] = this.mNextCommunityCard[s2];
        ++this.mCommunityCardCount;
    }

    public byte[] GetCommunityCards() {
        return this.mCommunityCard;
    }

    public byte[] GetNextCommunityCards() {
        return this.mNextCommunityCard;
    }

    public void ResetForNextHand() {
        super.ResetForNextHand();
        StaticCard.Clear(this.mCommunityCard, 5);
        this.mCommunityCardCount = 0;
    }

    public void ResetNextData() {
        Deck deck = new Deck();
        deck.Shuffle();
        int n2 = 0;
        int n3 = this.GetNbOfStartingPlayers();
        for (n2 = 0; n2 < 2; ++n2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                this.mPlayers[i2].AddNextCard(deck.GetTopCard(), n2);
            }
        }
        for (n2 = 0; n2 < 5; ++n2) {
            this.mNextCommunityCard[n2] = deck.GetTopCard();
        }
    }

    public boolean ApplyHeadsupModifIfNeeded() {
        PokerPlayerAI pokerPlayerAI = null;
        int n2 = 0;
        int n3 = this.GetNbOfStartingPlayers();
        for (int n4 = 0; n4 < n3; n4 = (int)((byte)(n4 + 1))) {
            if (this.mPlayers[n4].GetState() != 1) continue;
            ++n2;
            if (this.mPlayers[n4].IsPlayerHuman()) continue;
            pokerPlayerAI = (PokerPlayerAI)this.mPlayers[n4];
        }
        if (n2 == 2) {
            pokerPlayerAI.ApplyHeadsupModif();
            return true;
        }
        return false;
    }

    public int GetCommunityCardsCount() {
        return this.mCommunityCardCount;
    }

    public static TexasPokerTable[] InstArrayTexasPokerTable(int n2) {
        TexasPokerTable[] texasPokerTableArray = new TexasPokerTable[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            texasPokerTableArray[i2] = new TexasPokerTable();
        }
        return texasPokerTableArray;
    }

    public static TexasPokerTable[][] InstArrayTexasPokerTable(int n2, int n3) {
        TexasPokerTable[][] texasPokerTableArray = new TexasPokerTable[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            texasPokerTableArray[i2] = new TexasPokerTable[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                texasPokerTableArray[i2][i3] = new TexasPokerTable();
            }
        }
        return texasPokerTableArray;
    }

    public static TexasPokerTable[][][] InstArrayTexasPokerTable(int n2, int n3, int n4) {
        TexasPokerTable[][][] texasPokerTableArray = new TexasPokerTable[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            texasPokerTableArray[i2] = new TexasPokerTable[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                texasPokerTableArray[i2][i3] = new TexasPokerTable[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    texasPokerTableArray[i2][i3][i4] = new TexasPokerTable();
                }
            }
        }
        return texasPokerTableArray;
    }
}

