/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlString;
import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.MetaPackage;

public class GameSettings {
    public static final int headsUpMode = 0;
    public static final int standardMode = 1;
    public static final int tournamentMode = 2;
    public static final int proGameMode = 3;
    public static final int gameModeCount = 4;
    public static final int undefinedMode = 5;
    public static final int aiLevelEasy = 0;
    public static final int aiLevelMedium = 1;
    public static final int aiLevelHard = 2;
    public static final int aiLevelCount = 3;
    public static final int blind1 = 0;
    public static final int blind2 = 1;
    public static final int blind3 = 2;
    public static final int tournamentRoundBlindCap1 = 3;
    public static final int blind4 = 3;
    public static final int blindCount = 4;
    public static final int blind5 = 4;
    public static final int tournamentRoundBlindCap2 = 5;
    public static final int blind6 = 5;
    public static final int tournamentRoundBlindCap3 = 6;
    public static final int blind7 = 6;
    public static final int tournamentBlindCount = 7;
    public static final int blindIncreaseCount = 3;
    public static final int tournamentBlindIncreaseCount = 6;
    public static final int jimmysDive = 0;
    public static final int firstLockedCasino = 1;
    public static final int elGranTaco = 1;
    public static final int klondike = 2;
    public static final int sphinx = 3;
    public static final int neptune = 4;
    public static final int casinoCount = 5;
    public static final int undefinedLocation = 6;
    public static final int firstPlace = 0;
    public static final int secondPlace = 1;
    public static final int thirdPlace = 2;
    public static final int fourthPlace = 3;
    public static final int fifthPlace = 4;
    public static final int firstInTheMoneyPlace = 4;
    public static final int rankCount = 5;
    public static final int noRank = 6;
    public int mCurrentGameMode;
    public int mGameMenuGameMode;
    public boolean mIsPractice;
    public int mNbOfOpponents;
    public int mLocation;
    public int mPracticeLocation;
    public int mDifficulty;
    public int mBlind;
    public int mTournamentRound;

    public GameSettings() {
        this.Reset();
    }

    public void destruct() {
    }

    public void Reset() {
        this.mCurrentGameMode = 5;
        this.mGameMenuGameMode = 5;
        this.mIsPractice = false;
        this.mNbOfOpponents = 4;
        this.mLocation = 0;
        this.mPracticeLocation = 0;
        this.mDifficulty = 0;
        this.mBlind = 0;
        this.mTournamentRound = 0;
    }

    public void Read(FileSegmentStream fileSegmentStream) {
        if (fileSegmentStream.HasValidData()) {
            this.mCurrentGameMode = fileSegmentStream.ReadByte();
            this.mGameMenuGameMode = fileSegmentStream.ReadByte();
            this.mNbOfOpponents = fileSegmentStream.ReadByte();
            this.mLocation = fileSegmentStream.ReadByte();
            this.mPracticeLocation = fileSegmentStream.ReadByte();
            this.mDifficulty = fileSegmentStream.ReadByte();
            this.mBlind = fileSegmentStream.ReadByte();
            this.mTournamentRound = fileSegmentStream.ReadByte();
        }
    }

    public void Write(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteByte((byte)this.mCurrentGameMode);
        fileSegmentStream.WriteByte((byte)this.mGameMenuGameMode);
        fileSegmentStream.WriteByte((byte)this.mNbOfOpponents);
        fileSegmentStream.WriteByte((byte)this.mLocation);
        fileSegmentStream.WriteByte((byte)this.mPracticeLocation);
        fileSegmentStream.WriteByte((byte)this.mDifficulty);
        fileSegmentStream.WriteByte((byte)this.mBlind);
        fileSegmentStream.WriteByte((byte)this.mTournamentRound);
        fileSegmentStream.SetValidDataFlag(true);
    }

    public int GetSerializedGameObjectId() {
        int n2 = 2;
        if (this.IsPractice()) {
            n2 = 3;
        }
        return n2;
    }

    public int GetCurrentGameMode() {
        return this.mCurrentGameMode;
    }

    public void SetCurrentGameMode(int n2) {
        this.mCurrentGameMode = n2;
    }

    public boolean IsCurrentModeHeadsUp() {
        return this.mCurrentGameMode == 0;
    }

    public boolean IsCurrentModeProGame() {
        return this.mCurrentGameMode == 3;
    }

    public boolean IsCurrentModeStandard() {
        return this.mCurrentGameMode == 1;
    }

    public boolean IsCurrentModeTournament() {
        return this.mCurrentGameMode == 2;
    }

    public int GetGameMenuGameMode() {
        return this.mGameMenuGameMode;
    }

    public void SetGameMenuGameMode(int n2) {
        this.mGameMenuGameMode = n2;
        this.SetCurrentGameMode(n2);
    }

    public boolean IsGameMenuModeHeadsUp() {
        return this.mGameMenuGameMode == 0;
    }

    public boolean IsGameMenuModeProGame() {
        return this.mGameMenuGameMode == 3;
    }

    public boolean IsGameMenuModeTournament() {
        return this.mGameMenuGameMode == 2;
    }

    public void SetIsPractice(boolean bl) {
        this.mIsPractice = bl;
    }

    public boolean IsPractice() {
        return this.mIsPractice;
    }

    public void SetNbOfOpponents(int n2) {
        this.mNbOfOpponents = n2;
    }

    public int GetNbOfOpponents() {
        return this.mNbOfOpponents;
    }

    public void SetLocation(int n2) {
        if (this.IsPractice()) {
            this.mPracticeLocation = n2;
        } else {
            this.mLocation = n2;
        }
    }

    public int GetLocation() {
        if (this.IsPractice()) {
            return this.mPracticeLocation;
        }
        return this.mLocation;
    }

    public void SetDifficulty(int n2) {
        this.mDifficulty = n2;
    }

    public int GetDifficulty() {
        return this.mDifficulty;
    }

    public void SetBlind(int n2) {
        this.mBlind = n2;
    }

    public int GetBlind() {
        return this.mBlind;
    }

    public void NextTournamentRound() {
        ++this.mTournamentRound;
    }

    public int GetTournamentRound() {
        return this.mTournamentRound;
    }

    public void SetTournamentRound(int n2) {
        this.mTournamentRound = n2;
    }

    public int GetTournamentRoundBlindCap() {
        int n2 = 3;
        switch (this.mTournamentRound) {
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 5;
                break;
            }
            case 3: {
                n2 = 6;
                break;
            }
        }
        return n2;
    }

    public int GetBuyInCost() {
        return GameSettings.GetBuyInCostStatic(this.mLocation, this.GetCurrentGameMode());
    }

    public int GetBigBlindCost(int n2, int n3) {
        return GameSettings.GetBigBlindCostStatic(n2, n3, this.GetCurrentGameMode(), this.mIsPractice);
    }

    public int GetSmallBlindCost(int n2, int n3) {
        return GameSettings.GetSmallBlindCostStatic(n2, n3, this.GetCurrentGameMode(), this.mIsPractice);
    }

    public static int GetBuyInCostStatic(int n2, int n3) {
        int n4 = 0;
        if (n3 != 3) {
            MetaPackage metaPackage = GameLibrary.GetPackage(557073);
            int n5 = 0;
            if (n3 == 2) {
                n5 = 25;
            }
            n4 = metaPackage.GetPackage().GetEntryPoint(n5 + n2, (int[])null);
            GameLibrary.ReleasePackage(metaPackage);
            if (n3 == 0) {
                n4 = 5 * n4;
            }
        }
        return n4;
    }

    public static int GetTournamentPrize(int n2, int n3) {
        MetaPackage metaPackage = GameLibrary.GetPackage(557073);
        int n4 = metaPackage.GetPackage().GetEntryPoint(30 + n2 * 5 + n3, (int[])null);
        GameLibrary.ReleasePackage(metaPackage);
        return n4;
    }

    public static int GetTournamentOccurenceChance(int n2, int n3) {
        int n4 = 0;
        if (n3 != -1) {
            MetaPackage metaPackage = GameLibrary.GetPackage(557073);
            n4 = metaPackage.GetPackage().GetEntryPoint(55 + n2 * 5 + n3, (int[])null);
            GameLibrary.ReleasePackage(metaPackage);
        }
        return n4;
    }

    public static int GetBigBlindCostStatic(int n2, int n3, int n4, boolean bl) {
        MetaPackage metaPackage = GameLibrary.GetPackage(557073);
        int n5 = 0;
        if (bl && n4 != 2) {
            n5 = metaPackage.GetPackage().GetEntryPoint(92 + n3, (int[])null);
        } else {
            switch (n4) {
                case 2: 
                case 3: {
                    n5 = metaPackage.GetPackage().GetEntryPoint(80 + n3, (int[])null);
                    break;
                }
                case 0: 
                case 1: {
                    n5 = metaPackage.GetPackage().GetEntryPoint(5 + n2 * 4 + n3, (int[])null);
                    if (n4 != 0) break;
                    n5 *= 5;
                }
            }
        }
        GameLibrary.ReleasePackage(metaPackage);
        return n5;
    }

    public static int GetSmallBlindCostStatic(int n2, int n3, int n4, boolean bl) {
        return GameSettings.GetBigBlindCostStatic(n2, n3, n4, bl) / 2;
    }

    public static int GetBlindIncreasePeriod(int n2) {
        int n3 = 0;
        switch (n2) {
            case 2: {
                n3 = 5;
                break;
            }
            case 3: {
                n3 = 5;
                break;
            }
            case 1: {
                n3 = 10;
                break;
            }
            case 0: {
                n3 = 5;
                break;
            }
        }
        return n3;
    }

    public static int GetBlindIncreaseCount(int n2) {
        int n3 = 0;
        switch (n2) {
            case 2: 
            case 3: {
                n3 = 6;
                break;
            }
            case 0: 
            case 1: {
                n3 = 3;
                break;
            }
        }
        return n3;
    }

    public static FlString GetLocationName(int n2) {
        MetaPackage metaPackage = GameLibrary.GetPackage(557073);
        int n3 = 87;
        FlString flString = null;
        flString = FlString.Cast(metaPackage.GetPackage().GetEntryPoint(n3 + n2), null);
        GameLibrary.ReleasePackage(metaPackage);
        return flString;
    }

    public static int GetBigBlindCostStatic(int n2, int n3, int n4) {
        return GameSettings.GetBigBlindCostStatic(n2, n3, n4, false);
    }

    public static int GetSmallBlindCostStatic(int n2, int n3, int n4) {
        return GameSettings.GetSmallBlindCostStatic(n2, n3, n4, false);
    }

    public static GameSettings[] InstArrayGameSettings(int n2) {
        GameSettings[] gameSettingsArray = new GameSettings[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            gameSettingsArray[i2] = new GameSettings();
        }
        return gameSettingsArray;
    }

    public static GameSettings[][] InstArrayGameSettings(int n2, int n3) {
        GameSettings[][] gameSettingsArray = new GameSettings[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            gameSettingsArray[i2] = new GameSettings[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                gameSettingsArray[i2][i3] = new GameSettings();
            }
        }
        return gameSettingsArray;
    }

    public static GameSettings[][][] InstArrayGameSettings(int n2, int n3, int n4) {
        GameSettings[][][] gameSettingsArray = new GameSettings[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            gameSettingsArray[i2] = new GameSettings[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                gameSettingsArray[i2][i3] = new GameSettings[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    gameSettingsArray[i2][i3][i4] = new GameSettings();
                }
            }
        }
        return gameSettingsArray;
    }
}

