/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlMath;
import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameSettings;
import ca.jamdat.texasholdem09.TexasGameManager;

public class CareerState {
    public static final int startingBankRollLevel = -1;
    public static final int minBankRollLevel = 0;
    public static final int lowerMidBankRollLevel = 1;
    public static final int middleBankRollLevel = 2;
    public static final int upperMidBankRollLevel = 3;
    public static final int maxBankRollLevel = 4;
    public static final int bankRollLevelCount = 5;
    public static final int undefinedGameResult = 0;
    public static final int firstGameResult = 1;
    public static final int tournamentVictory = 1;
    public static final int tournamentFinalRoundElimination = 2;
    public static final int tournamentElimination = 3;
    public static final int abandonGame = 4;
    public static final int gameLostCausingBankruptcy = 5;
    public static final int tournamentLostCausingBankruptcy = 6;
    public static final int abandonGameCausingBankruptcy = 7;
    public static final int gameResultCount = 8;
    public int mBankRoll = 500;
    public int mMaxBankRoll = 500;
    public int mPreviousBankRoll = -1;
    public int mLatestChipsIncome;
    public int mInGameStack = -1;
    public int mInGameRank = 6;
    public int mNextTournament = 6;
    public boolean[] mUnlockedCasinos = new boolean[5];
    public int mLastGameResult = 0;
    public int mHeadsUpHeroCharacterPortrait = -1;
    public int mProGameChallengeProbability = 25;
    public boolean mIsChallengedToProGame;
    public boolean mHackFirstTimeMinBankRollLevel;

    public CareerState() {
        for (int i2 = 0; i2 < 5; ++i2) {
            this.mUnlockedCasinos[i2] = i2 == 0;
        }
    }

    public void destruct() {
        this.mUnlockedCasinos = null;
    }

    public void Read(FileSegmentStream fileSegmentStream) {
        if (fileSegmentStream.HasValidData()) {
            this.mBankRoll = fileSegmentStream.ReadLong();
            this.mMaxBankRoll = fileSegmentStream.ReadLong();
            this.mPreviousBankRoll = fileSegmentStream.ReadLong();
            this.mLatestChipsIncome = fileSegmentStream.ReadLong();
            this.mInGameStack = fileSegmentStream.ReadLong();
            this.mInGameRank = fileSegmentStream.ReadByte();
            this.mNextTournament = fileSegmentStream.ReadByte();
            this.mLastGameResult = fileSegmentStream.ReadByte();
            this.mHeadsUpHeroCharacterPortrait = fileSegmentStream.ReadByte();
            this.mProGameChallengeProbability = fileSegmentStream.ReadLong();
            this.mIsChallengedToProGame = fileSegmentStream.ReadBoolean();
            this.mHackFirstTimeMinBankRollLevel = fileSegmentStream.ReadBoolean();
            for (int i2 = 0; i2 < 5; ++i2) {
                this.mUnlockedCasinos[i2] = fileSegmentStream.ReadBoolean();
            }
        }
    }

    public void Write(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteLong(this.mBankRoll);
        fileSegmentStream.WriteLong(this.mMaxBankRoll);
        fileSegmentStream.WriteLong(this.mPreviousBankRoll);
        fileSegmentStream.WriteLong(this.mLatestChipsIncome);
        fileSegmentStream.WriteLong(this.mInGameStack);
        fileSegmentStream.WriteByte((byte)this.mInGameRank);
        fileSegmentStream.WriteByte((byte)this.mNextTournament);
        fileSegmentStream.WriteByte((byte)this.mLastGameResult);
        fileSegmentStream.WriteByte((byte)this.mHeadsUpHeroCharacterPortrait);
        fileSegmentStream.WriteLong(this.mProGameChallengeProbability);
        fileSegmentStream.WriteBoolean(this.mIsChallengedToProGame);
        fileSegmentStream.WriteBoolean(this.mHackFirstTimeMinBankRollLevel);
        for (int i2 = 0; i2 < 5; ++i2) {
            fileSegmentStream.WriteBoolean(this.mUnlockedCasinos[i2]);
        }
        fileSegmentStream.SetValidDataFlag(true);
    }

    public int GetBankRoll() {
        return this.mBankRoll;
    }

    public void IncreaseBankRoll(int n2) {
        this.mPreviousBankRoll = this.mBankRoll;
        this.mLatestChipsIncome = n2;
        this.mBankRoll += n2;
        if (this.mBankRoll > 99999999) {
            this.mBankRoll = 99999999;
        }
        if (this.mBankRoll > this.mMaxBankRoll) {
            this.mHackFirstTimeMinBankRollLevel = this.mBankRoll >= 750 && this.mMaxBankRoll < 750;
            this.mMaxBankRoll = this.mBankRoll;
        }
    }

    public void DecreaseBankRoll(int n2) {
        this.mBankRoll -= n2;
        this.mPreviousBankRoll = this.mBankRoll;
        this.mLatestChipsIncome = 0;
    }

    public int GetMaxBankRoll() {
        return this.mMaxBankRoll;
    }

    public void ResetPreviousBankRoll() {
        this.mPreviousBankRoll = -1;
    }

    public int GetPreviousBankRoll() {
        return this.mPreviousBankRoll;
    }

    public int GetBankRollLevel() {
        int n2 = this.mBankRoll;
        int n3 = -1;
        if (n2 >= 750 && n2 < 5000) {
            n3 = 0;
        } else if (n2 >= 5000 && n2 < 25000) {
            n3 = 1;
        } else if (n2 >= 25000 && n2 < 100000) {
            n3 = 2;
        } else if (n2 > 100000 && n2 < 350000) {
            n3 = 3;
        } else if (n2 >= 350000) {
            n3 = 4;
        }
        return n3;
    }

    public int GetInGameRank() {
        return this.mInGameRank;
    }

    public int GetInGameStack() {
        return this.mInGameStack;
    }

    public void SetInGameStack(int n2) {
        this.mInGameStack = n2;
    }

    public void ResetInGameStack() {
        this.mInGameStack = -1;
    }

    public int GetLatestChipsIncome() {
        return this.mLatestChipsIncome;
    }

    public int ResetLatestChipsIncome() {
        int n2 = this.mLatestChipsIncome;
        this.mLatestChipsIncome = 0;
        return n2;
    }

    public int GetNextTournament() {
        return this.mNextTournament;
    }

    public boolean IsNextTournament(int n2) {
        return n2 == this.GetNextTournament();
    }

    public void ResetNextTournament() {
        this.mNextTournament = 6;
    }

    public boolean IsLocationAvailable(int n2) {
        return this.mBankRoll >= GameSettings.GetBuyInCostStatic(n2, 1);
    }

    public boolean IsCasinoUnlocked(int n2) {
        return this.mUnlockedCasinos[n2];
    }

    public boolean IsCasinoNewlyUnlocked(int n2) {
        boolean bl = false;
        if (!this.mUnlockedCasinos[n2] && this.mBankRoll >= GameSettings.GetBuyInCostStatic(n2, 1)) {
            this.mUnlockedCasinos[n2] = true;
            bl = true;
        }
        return bl;
    }

    public boolean IsLastGameResult(int n2) {
        return this.mLastGameResult == n2;
    }

    public int GetLastGameResult() {
        return this.mLastGameResult;
    }

    public void ResetLastGameResult() {
        this.mLastGameResult = 0;
    }

    public void HandleBankruptcy() {
        if (this.mBankRoll < this.GetBankruptcyBankRoll()) {
            this.mLatestChipsIncome = this.mBankRoll = this.GetBankruptcyBankRoll();
            this.mLastGameResult = this.IsLastGameResult(3) ? 6 : (this.IsLastGameResult(4) ? 7 : 5);
        }
    }

    public void OnAbandonGame() {
        GameApp gameApp = GameApp.Get();
        GameSettings gameSettings = gameApp.GetGameSettings();
        if (gameSettings.IsCurrentModeTournament()) {
            if (this.mInGameRank != 6) {
                this.IncreaseBankRoll(GameSettings.GetTournamentPrize(gameSettings.GetLocation(), this.mInGameRank));
            }
        } else if (gameSettings.IsCurrentModeStandard() && this.mInGameStack > -1) {
            this.IncreaseBankRoll(this.mInGameStack);
        }
        this.mLastGameResult = 4;
        this.HandleBankruptcy();
        if (gameApp.GetStatistics().GetInGameStat((byte)0) > 5) {
            this.UpdateNextSetOfGames();
        } else {
            this.mIsChallengedToProGame = false;
        }
        this.ResetInGameStack();
        this.mInGameRank = 6;
    }

    public void OnElimination() {
        GameApp gameApp = GameApp.Get();
        GameSettings gameSettings = gameApp.GetGameSettings();
        if (gameSettings.IsCurrentModeTournament()) {
            if (gameSettings.GetTournamentRound() == 3) {
                this.mInGameRank = gameApp.GetGameFactory().GetGame().GetTexasPokerTable().ComputeUserPosition();
                this.IncreaseBankRoll(GameSettings.GetTournamentPrize(gameSettings.GetLocation(), this.mInGameRank));
                this.mLastGameResult = 2;
            } else {
                this.mLastGameResult = 3;
            }
        }
        this.ResetInGameStack();
        this.HandleBankruptcy();
        this.UpdateNextSetOfGames();
    }

    public void OnSaveCurrentGame() {
        GameApp gameApp = GameApp.Get();
        if (gameApp.GetGameSettings().IsCurrentModeTournament()) {
            this.mInGameRank = 6;
            if (gameApp.GetGameSettings().GetTournamentRound() == 3) {
                this.mInGameRank = TexasGameManager.Get().GetPokerTable().ComputeUserPosition();
            }
            this.ResetInGameStack();
        } else {
            this.mInGameRank = 6;
        }
    }

    public void OnVictory(int n2) {
        GameApp gameApp = GameApp.Get();
        GameSettings gameSettings = gameApp.GetGameSettings();
        if (gameSettings.IsCurrentModeProGame()) {
            this.IncreaseBankRoll(1000000);
            gameApp.GetCareerState().ChangeProGameChallengeProbability();
        } else if (gameSettings.IsCurrentModeTournament()) {
            this.mInGameRank = 0;
            this.IncreaseBankRoll(GameSettings.GetTournamentPrize(gameSettings.GetLocation(), 0));
            this.mLastGameResult = 1;
        } else {
            this.IncreaseBankRoll(this.mInGameStack);
        }
        if (!(gameSettings.IsCurrentModeHeadsUp() || gameSettings.IsCurrentModeProGame() || gameSettings.IsPractice())) {
            this.SetHeadsUpHeroCharacterPortrait(n2);
        }
        this.UpdateNextSetOfGames();
    }

    public void ResetGameMenuGameMode() {
        GameSettings gameSettings = GameApp.Get().GetGameSettings();
        if (!gameSettings.IsPractice()) {
            gameSettings.SetGameMenuGameMode(5);
        }
    }

    public void SetHeadsUpHeroCharacterPortrait(int n2) {
        this.mHeadsUpHeroCharacterPortrait = n2;
    }

    public int GetHeadsUpHeroCharacterPortrait() {
        return this.mHeadsUpHeroCharacterPortrait;
    }

    public boolean IsChallengedToHeadsUpGame() {
        GameSettings gameSettings = GameApp.Get().GetGameSettings();
        if (this.GetHeadsUpHeroCharacterPortrait() != -1) {
            if (this.GetBankRoll() >= GameSettings.GetBuyInCostStatic(gameSettings.GetLocation(), 0)) {
                return true;
            }
        }
        return false;
    }

    public void ProGameChallengeDeclined() {
        this.mIsChallengedToProGame = false;
    }

    public void ChangeProGameChallengeProbability() {
        this.mProGameChallengeProbability = 5;
    }

    public boolean IsChallengedToProGame() {
        return this.mIsChallengedToProGame;
    }

    public void UpdateNextSetOfGames() {
        this.UpdateNextTournament();
        this.UpdateNextProGame();
    }

    public void UpdateNextProGame() {
        int n2;
        this.mIsChallengedToProGame = this.IsLocationAvailable(4) ? (n2 = FlMath.Random(0, 99)) < this.mProGameChallengeProbability : false;
    }

    public void UpdateNextTournament() {
        if (this.mNextTournament != 6 && this.mBankRoll < GameSettings.GetBuyInCostStatic(this.mNextTournament, 2)) {
            this.mNextTournament = 6;
        }
        if (this.mNextTournament == 6 && this.mBankRoll >= GameSettings.GetBuyInCostStatic(0, 2)) {
            if (this.mHackFirstTimeMinBankRollLevel) {
                this.mNextTournament = 0;
                this.mHackFirstTimeMinBankRollLevel = false;
            } else {
                short s2 = FlMath.Random((short)1, (short)100);
                short s3 = 1;
                for (int i2 = 0; i2 < 5 && this.mNextTournament == 6; ++i2) {
                    short s4 = s3;
                    if (s2 < s4 || s2 >= (s3 += GameSettings.GetTournamentOccurenceChance(i2, this.GetBankRollLevel()))) continue;
                    this.mNextTournament = i2;
                }
            }
        }
    }

    public int GetBankruptcyBankRoll() {
        int n2 = 500;
        if (this.mMaxBankRoll >= 1000000) {
            n2 = 500000;
        } else if (this.mMaxBankRoll >= 100000) {
            n2 = 50000;
        } else if (this.mMaxBankRoll >= 10000) {
            n2 = 5000;
        } else if (this.mMaxBankRoll >= 1000) {
            n2 = 500;
        }
        return n2;
    }

    public static CareerState[] InstArrayCareerState(int n2) {
        CareerState[] careerStateArray = new CareerState[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            careerStateArray[i2] = new CareerState();
        }
        return careerStateArray;
    }

    public static CareerState[][] InstArrayCareerState(int n2, int n3) {
        CareerState[][] careerStateArray = new CareerState[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            careerStateArray[i2] = new CareerState[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                careerStateArray[i2][i3] = new CareerState();
            }
        }
        return careerStateArray;
    }

    public static CareerState[][][] InstArrayCareerState(int n2, int n3, int n4) {
        CareerState[][][] careerStateArray = new CareerState[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            careerStateArray[i2] = new CareerState[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                careerStateArray[i2][i3] = new CareerState[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    careerStateArray[i2][i3][i4] = new CareerState();
                }
            }
        }
        return careerStateArray;
    }
}

