/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.TimeControlled;
import ca.jamdat.flight.Viewport;
import ca.jamdat.texasholdem09.CareerState;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.MetaPackage;

public class BankRoll
extends TimeControlled {
    public Viewport mComponentViewport;
    public MetaPackage mPackage;
    public Text mAmount;
    public Viewport mBankrollBackgroundViewport;
    public Viewport mBankRollTextViewport;

    public void destruct() {
    }

    public void Load() {
        this.mPackage = GameLibrary.GetPackage(622611);
    }

    public void GetEntryPoints() {
        Text text = null;
        this.mComponentViewport = Viewport.Cast(this.mPackage.GetPackage().GetEntryPoint(0), null);
        text = Text.Cast(this.mPackage.GetPackage().GetEntryPoint(2), null);
        this.mBankRollTextViewport = Viewport.Cast(this.mPackage.GetPackage().GetEntryPoint(1), null);
        this.mBankrollBackgroundViewport = Viewport.Cast(this.mPackage.GetPackage().GetEntryPoint(3), null);
        this.mAmount = text;
    }

    public void Init(Viewport viewport) {
        this.mComponentViewport.SetViewport(viewport);
        this.SetAmountText();
    }

    public void Unload() {
        this.mAmount = null;
        if (this.mComponentViewport != null) {
            this.mComponentViewport.SetViewport(null);
            this.mComponentViewport = null;
        }
        GameLibrary.ReleasePackage(this.mPackage);
    }

    public void StartAnimation(boolean bl) {
        if (!this.IsBankRollUpToDate(bl)) {
            this.mAmount.SetCaption(new FlString(GameApp.Get().GetCareerState().GetBankRoll()));
        }
    }

    public void SetBankRollVisibility(boolean bl) {
        this.mComponentViewport.SetVisible(bl);
    }

    public boolean IsBankRollUpToDate(boolean bl) {
        int n2 = bl ? this.GetBankroll() : GameApp.Get().GetCareerState().GetBankRoll();
        return n2 - this.mAmount.GetCaption().ToLong() == 0;
    }

    public void SetAmountText() {
        this.mAmount.SetCaption(new FlString(this.GetBankroll()));
    }

    public int GetBankroll() {
        CareerState careerState = GameApp.Get().GetCareerState();
        int n2 = careerState.GetPreviousBankRoll();
        if (n2 == -1) {
            n2 = careerState.GetBankRoll();
        }
        return n2;
    }

    public void StartAnimation() {
        this.StartAnimation(false);
    }

    public boolean IsBankRollUpToDate() {
        return this.IsBankRollUpToDate(false);
    }

    public static BankRoll[] InstArrayBankRoll(int n2) {
        BankRoll[] bankRollArray = new BankRoll[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            bankRollArray[i2] = new BankRoll();
        }
        return bankRollArray;
    }

    public static BankRoll[][] InstArrayBankRoll(int n2, int n3) {
        BankRoll[][] bankRollArray = new BankRoll[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            bankRollArray[i2] = new BankRoll[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                bankRollArray[i2][i3] = new BankRoll();
            }
        }
        return bankRollArray;
    }

    public static BankRoll[][][] InstArrayBankRoll(int n2, int n3, int n4) {
        BankRoll[][][] bankRollArray = new BankRoll[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            bankRollArray[i2] = new BankRoll[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                bankRollArray[i2][i3] = new BankRoll[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    bankRollArray[i2][i3][i4] = new BankRoll();
                }
            }
        }
        return bankRollArray;
    }
}

