/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.F32;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.Interpolator;
import ca.jamdat.flight.Package;

public class KeyFrameSequence {
    public static final byte typeNumber = 89;
    public static final byte typeID = 89;
    public static final boolean supportsDynamicSerialization = false;
    public static final byte FieldKeysPerChannel = 0;
    public static final byte FieldValuesPerKey = 1;
    public static final byte FieldBytesPerValue = 2;
    public static final byte FieldPointPosition = 3;
    public static final byte FieldTimePointPosition = 4;
    public static final byte FieldSingleInterpolator = 5;
    public static final byte FieldLoopingPeriod = 6;
    public static final byte FieldLastIndex = 7;
    public static final byte FieldTimeValues = 8;
    public short[] mValues = null;
    public static int[] mValueBuffer = new int[8];

    public static KeyFrameSequence Cast(Object object, KeyFrameSequence keyFrameSequence) {
        return (KeyFrameSequence)object;
    }

    public KeyFrameSequence() {
    }

    public KeyFrameSequence(short s2, byte by, byte by2, byte by3) {
        int n2 = s2 * by * by3;
        short[] sArray = new short[8 + s2 + (n2 + 1 >> 1)];
        sArray[0] = s2;
        sArray[2] = by;
        sArray[3] = by2;
        sArray[4] = 0;
        sArray[1] = by3;
        sArray[5] = 1;
        sArray[6] = 0;
        sArray[7] = -1;
        this.mValues = sArray;
    }

    public void destruct() {
        this.mValues = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void GetObjectValue(int n2, int[] nArray) {
        int n3;
        int[] nArray2;
        int n4;
        block16: {
            int n5;
            int n6;
            int n7;
            int n8;
            block17: {
                int n9;
                block14: {
                    block15: {
                        n4 = this.mValues[1];
                        int n10 = this.mValues[6] << this.mValues[4];
                        nArray2 = mValueBuffer;
                        if (n10 != 0) {
                            n2 = FlMath.Modulo(n2, n10);
                        }
                        n9 = this.GetKeyFrameIndex(n2);
                        this.GetKeyFrameValue(n9, nArray2, 0);
                        if (this.mValues[5] != 1) break block14;
                        this.GetKeyFrameValue(n9 + 1, nArray2, 4);
                        if (this.mValues[2] > 2) break block15;
                        n3 = this.GetCorrectedIndex(n9);
                        int n11 = this.GetCorrectedIndex(n9 + 1);
                        n8 = this.mValues[8 + n3] << this.mValues[4];
                        n7 = this.mValues[8 + n11] << this.mValues[4];
                        if (n3 > n11) {
                            if (n2 < n7) {
                                n2 += n10;
                            }
                            n7 += n10;
                        }
                        if ((n6 = n7 - n8) == 0) break block16;
                        n5 = FlMath.Absolute(n6 >> 1);
                        break block17;
                    }
                    F32 f32 = new F32(this.GetTimeRatio(n2, n9, n9 + 1));
                    int n12 = 0;
                    while (true) {
                        if (n12 >= n4) {
                            return;
                        }
                        nArray[n12] = Interpolator.InterpolateLinear(new F32(nArray2[n12], (int)this.mValues[3]), new F32(nArray2[4 + n12], (int)this.mValues[3]), f32).ToFixedPoint(this.mValues[3]);
                        ++n12;
                    }
                }
                if (this.mValues[5] == 5) {
                    this.GetKeyFrameValue(n9 + 1, nArray2, 4);
                    F32 f32 = new F32(this.GetTimeRatio(n2, n9, n9 + 1));
                    int n13 = 0;
                    while (true) {
                        if (n13 >= n4) {
                            return;
                        }
                        nArray[n13] = Interpolator.InterpolateEaseIn(new F32(nArray2[n13], (int)this.mValues[3]), new F32(nArray2[4 + n13], (int)this.mValues[3]), f32).ToFixedPoint(this.mValues[3]);
                        ++n13;
                    }
                }
                if (this.mValues[5] == 6) {
                    this.GetKeyFrameValue(n9 + 1, nArray2, 4);
                    F32 f32 = new F32(this.GetTimeRatio(n2, n9, n9 + 1));
                    int n14 = 0;
                    while (true) {
                        if (n14 >= n4) {
                            return;
                        }
                        nArray[n14] = Interpolator.InterPolateEaseOut(new F32(nArray2[n14], (int)this.mValues[3]), new F32(nArray2[4 + n14], (int)this.mValues[3]), f32).ToFixedPoint(this.mValues[3]);
                        ++n14;
                    }
                }
                break block16;
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                int n15;
                nArray2[i2] = (n15 += (n15 = (n7 - n2) * nArray2[i2] + (n2 - n8) * nArray2[4 + i2]) < 0 ? -n5 + 1 : n5) / n6;
            }
        }
        n3 = 0;
        while (n3 < n4) {
            nArray[n3] = nArray2[n3];
            ++n3;
        }
        return;
    }

    public void SetKeyFrame(int n2, int n3, int[] nArray) {
        this.ExtendTimeValues(n3);
        this.mValues[8 + n2] = (short)(n3 >> this.mValues[4]);
        int n4 = 0;
        while (n4 < this.mValues[1]) {
            int n5 = n4++;
            nArray[n5] = nArray[n5] >> -this.mValues[3];
        }
        this.SetKeyFrameValue(n2, nArray);
    }

    public void SetKeyFrame(int n2, int n3, F32[] f32Array, int n4) {
        this.ExtendTimeValues(n3);
        this.mValues[8 + n2] = (short)(n3 >> this.mValues[4]);
        int[] nArray = new int[this.mValues[1]];
        int n5 = n4 - this.mValues[3];
        for (int i2 = 0; i2 < this.mValues[1]; ++i2) {
            nArray[i2] = n5 < 0 ? f32Array[i2].ToFixedPoint(this.mValues[3]) << -n5 : f32Array[i2].ToFixedPoint(this.mValues[3]) >> n5;
        }
        this.SetKeyFrameValue(n2, nArray);
    }

    public byte GetInterpolator() {
        return (byte)this.mValues[5];
    }

    public void SetInterpolator(byte by) {
        this.mValues[5] = by;
    }

    public boolean IsLooping() {
        return this.mValues[6] != 0;
    }

    public int GetPeriod() {
        return this.mValues[6] << this.mValues[4];
    }

    public void SetPeriod(int n2) {
        this.ExtendTimeValues(n2);
        this.mValues[6] = (short)(n2 >> this.mValues[4]);
    }

    public KeyFrameSequence OnSerialize(Package package_) {
        short[] sArray = this.mValues;
        short s2 = 0;
        s2 = package_.SerializeIntrinsic(s2);
        this.mValues = sArray = package_.SerializeIntrinsics(sArray, (int)s2);
        return this;
    }

    public short GetNbKeys() {
        return this.mValues[0];
    }

    public int GetTime(int n2) {
        return this.mValues[8 + n2] << this.mValues[4];
    }

    public void ExtendTimeValues(int n2) {
        short s2 = 0;
        while (n2 < Short.MIN_VALUE || n2 >= 32768) {
            s2 = (short)(s2 + 1);
            n2 >>= 1;
        }
        if (s2 > this.mValues[4]) {
            for (int i2 = 0; i2 < this.mValues[0]; ++i2) {
                int n3 = 8 + i2;
                this.mValues[n3] = (short)(this.mValues[n3] >> s2 - this.mValues[4]);
            }
            this.mValues[6] = (short)(this.mValues[6] >> s2 - this.mValues[4]);
            this.mValues[4] = s2;
        }
    }

    public int GetKeyFrameIndex(int n2) {
        int n3;
        int n4;
        int n5;
        short[] sArray = this.mValues;
        if (sArray[7] != -1) {
            n5 = sArray[7];
            int n6 = n4 = n5 < sArray[0] - 1 ? (int)(n5 + 1) : 0;
            if (sArray[8 + n5] << this.mValues[4] <= n2 && (n4 == 0 || sArray[8 + n4] << this.mValues[4] > n2)) {
                return n5;
            }
            int n7 = n3 = n4 < sArray[0] - 1 ? (int)(n4 + 1) : 0;
            if (sArray[8 + n4] << this.mValues[4] <= n2 && (n3 == 0 || sArray[8 + n3] << this.mValues[4] > n2)) {
                sArray[7] = n4;
                return n4;
            }
        }
        n5 = sArray[0] >> 1;
        n4 = sArray[0] - 1;
        n3 = 0;
        while (n4 != n3) {
            int n8;
            int n9 = sArray[8 + n5] << this.mValues[4];
            if (n9 < n2) {
                n5 += (n8 = n4 - (n3 = n5) >> 1) > 0 ? n8 : 1;
                continue;
            }
            if (n9 > n2) {
                n4 = n5 - 1;
                n8 = n4 - n3 >> 1;
                n5 = n4 - n8;
                continue;
            }
            sArray[7] = (short)n5;
            return n5;
        }
        if (n3 == 0 && sArray[8] << this.mValues[4] > n2) {
            sArray[7] = -1;
            return sArray[6] != 0 && sArray[6] != n2 ? this.GetKeyFrameIndex(sArray[6]) : -1;
        }
        sArray[7] = (short)n3;
        return n3;
    }

    public void GetKeyFrameValue(int n2, int[] nArray, int n3) {
        short[] sArray = this.mValues;
        short s2 = sArray[0];
        short s3 = sArray[2];
        int n4 = sArray[1];
        int n5 = 8 + s2;
        n2 = this.GetCorrectedIndex(n2) * s3 * n4;
        if (s3 > 1) {
            n2 = (n2 >> 1) + n5;
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            int n6 = 0;
            if (s3 == 4) {
                n6 = sArray[n2++] << 16;
                n6 |= sArray[n2] & 0xFFFF;
            } else {
                n6 = s3 == 2 ? sArray[n2] : (int)((byte)(sArray[n5 + (n2 >> 1)] >> ((~n2 & 1) << 3)));
            }
            ++n2;
            nArray[i2 + n3] = n6;
        }
    }

    public void SetKeyFrameValue(int n2, int[] nArray) {
        short[] sArray = this.mValues;
        int n3 = 8 + sArray[0];
        short s2 = sArray[2];
        n2 *= s2 * sArray[1];
        if (s2 > 1) {
            n2 = (n2 >> 1) + n3;
        }
        for (int i2 = 0; i2 < sArray[1]; ++i2) {
            int n4 = nArray[i2];
            if (s2 == 4) {
                sArray[n2++] = (short)(n4 >> 16);
                sArray[n2] = (short)n4;
            } else if (s2 == 2) {
                sArray[n2] = (short)n4;
            } else {
                int n5 = n3 + (n2 >> 1);
                sArray[n5] = (short)(sArray[n5] & 255 << ((n2 & 1) << 3) | (n4 & 0xFF) << ((~n2 & 1) << 3));
            }
            ++n2;
        }
    }

    public F32 GetTimeRatio(int n2, int n3, int n4) {
        short[] sArray = this.mValues;
        int n5 = sArray[8 + n3] << this.mValues[4];
        int n6 = 0;
        if (n4 >= sArray[0]) {
            if (sArray[6] != 0) {
                n6 = (sArray[6] << this.mValues[4]) - n5 + (sArray[8] << this.mValues[4]);
                if (n2 < n5) {
                    n2 += sArray[6] << this.mValues[4];
                }
            }
        } else {
            n6 = (sArray[8 + n4] << this.mValues[4]) - n5;
        }
        if (n6 == 0) {
            return F32.One(16);
        }
        return F32.FromInt(n2 - n5, 16).Div(n6);
    }

    public int GetCorrectedIndex(int n2) {
        short s2 = this.mValues[0];
        if (n2 < 0) {
            n2 = this.mValues[6] != 0 ? s2 - 1 : 0;
        } else if (n2 >= s2) {
            n2 = this.mValues[6] != 0 ? 0 : s2 - 1;
        }
        return n2;
    }

    public static KeyFrameSequence[] InstArrayKeyFrameSequence(int n2) {
        KeyFrameSequence[] keyFrameSequenceArray = new KeyFrameSequence[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            keyFrameSequenceArray[i2] = new KeyFrameSequence();
        }
        return keyFrameSequenceArray;
    }

    public static KeyFrameSequence[][] InstArrayKeyFrameSequence(int n2, int n3) {
        KeyFrameSequence[][] keyFrameSequenceArray = new KeyFrameSequence[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            keyFrameSequenceArray[i2] = new KeyFrameSequence[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                keyFrameSequenceArray[i2][i3] = new KeyFrameSequence();
            }
        }
        return keyFrameSequenceArray;
    }

    public static KeyFrameSequence[][][] InstArrayKeyFrameSequence(int n2, int n3, int n4) {
        KeyFrameSequence[][][] keyFrameSequenceArray = new KeyFrameSequence[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            keyFrameSequenceArray[i2] = new KeyFrameSequence[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                keyFrameSequenceArray[i2][i3] = new KeyFrameSequence[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    keyFrameSequenceArray[i2][i3][i4] = new KeyFrameSequence();
                }
            }
        }
        return keyFrameSequenceArray;
    }
}

