/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Controller;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlDisplayContext;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.TimeControlled;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public abstract class Component
extends TimeControlled {
    public static final byte typeNumber = 67;
    public static final byte typeID = 67;
    public static final boolean supportsDynamicSerialization = true;
    public static final byte focusMsg = -128;
    public static final byte selectedMsg = -127;
    public static final byte enabledMsg = -126;
    public static final byte pushedMsg = -125;
    public static final byte synchronizeSelectorMsg = -124;
    public static final byte buttonMsg = -123;
    public static final byte attachMsg = -122;
    public static final byte keyUpMsg = -121;
    public static final byte keyDownMsg = -120;
    public static final byte keyDownOrRepeatMsg = -119;
    public static final byte returnedFromSceneMsg = -118;
    public static final byte startTransitionMsg = -117;
    public static final byte completedTransitionMsg = -116;
    public static final byte quitTransitionMsg = -115;
    public static final byte resetAncestorScrollerMsg = -114;
    public static final byte slideMsg = -113;
    public static final byte slideStateMsg = -112;
    public static final byte scrollerUpdatedMsg = -111;
    public static final byte textFieldInputMsg = -110;
    public static final byte IPSPGetMessageError = -109;
    public static final byte IPSPUnknownError = -108;
    public static final byte IPSPServerError = -107;
    public static final byte IPSPSocialServerError = -106;
    public static final byte IPSPGeneralError = -105;
    public static final byte IPSPGetFBLoginButtonDone = -104;
    public static final byte IPSPGetFBLoginButtonError = -103;
    public static final byte IPSPFBDialogCancelled = -102;
    public static final byte IPSPFBDialogWillAppear = -101;
    public static final byte IPSPFBDialogWillDisappear = -100;
    public static final byte IPSPFBDialogFailedToLoad = -99;
    public static final byte IPSPLoginDone = -98;
    public static final byte IPSPLoginError = -97;
    public static final byte IPSPLogoutDone = -96;
    public static final byte IPSPLogoutError = -95;
    public static final byte IPSPAskPermissionDone = -94;
    public static final byte IPSPAskPermissionError = -93;
    public static final byte IPSPAskPermissionCancelled = -92;
    public static final byte IPSPGetEAMobileUIdDone = -91;
    public static final byte IPSPGetEAMobileUIdError = -90;
    public static final byte IPSPGetFriendsScoresDone = -89;
    public static final byte IPSPGetFriendsScoresError = -88;
    public static final byte IPSPGetFriendsDone = -87;
    public static final byte IPSPGetFriendsError = -86;
    public static final byte IPSPGetSocialUserPictureDone = -85;
    public static final byte IPSPPostScoreDone = -84;
    public static final byte IPSPPostScoreError = -83;
    public static final byte IPSPPublishFeedDone = -82;
    public static final byte IPSPPublishFeedError = -81;
    public static final byte IPSPPublishFeedCancelled = -80;
    public static final byte IPSPGetUserFeedsDone = -79;
    public static final byte IPSPGetUserFeedsNoUpdate = -78;
    public static final byte IPSPGetUserFeedsError = -77;
    public static final byte IPSPPostStoryDone = -76;
    public static final byte IPSPPostStoryError = -75;
    public static final byte IPSPRegisterTokenDone = -74;
    public static final byte IPSPRegisterTokenError = -73;
    public static final byte IPSPSendPushNotificationDone = -72;
    public static final byte IPSPSendPushNotificationError = -71;
    public static final byte IPSPGetAnonEAMobileIdDone = -70;
    public static final byte IPSPGetAnonEAMobileIdError = -69;
    public static final byte IPSPGetAppSellIdDone = -68;
    public static final byte IPSPGetAppSellIdError = -67;
    public static final byte IPSPIsFacebookEnabledDone = -66;
    public static final byte IPSPIsFacebookEnabledError = -65;
    public static final byte IPSPServerUnavailable = -64;
    public static final byte IPSPCustomMayhemRequestDone = -63;
    public static final byte IPSPCustomMayhemRequestError = -62;
    public static final byte IPSPFBAccessTokenExpired = -61;
    public static final byte IPSPGetFBLikeStateDone = -60;
    public static final byte IPSPGetFBLikeStateError = -59;
    public static final byte IPSPFBLoginResuming = -58;
    public static final byte IPSPLoginCancelled = -57;
    public static final byte quitRequestMsg = -56;
    public static final byte reservedMsg = 0;
    public static final byte firstApplicationMsg = 1;
    public static final byte isDetached = 0;
    public static final byte isAttached = 1;
    public static final byte isLeaving = 0;
    public static final byte isEntering = 1;
    public short mRect_left;
    public short mRect_top;
    public short mRect_width;
    public short mRect_height;
    public Viewport m_pViewport;
    public boolean mVisible = true;
    public Component m_pPreviousSibling;

    public static Component Cast(Object object, Component component) {
        return (Component)object;
    }

    public byte GetTypeID() {
        return 67;
    }

    public static Class AsClass() {
        return null;
    }

    public Component() {
    }

    public Component(Viewport viewport) {
        this.SetViewport(viewport);
    }

    public void destruct() {
        if (this.m_pViewport != null) {
            this.SetViewportNull();
        }
    }

    public void SetViewport(Viewport viewport) {
        Viewport viewport2 = this.m_pViewport;
        if (viewport2 != null) {
            this.UpdateAttach(false);
            viewport2.RemoveChild(this);
        }
        this.m_pViewport = viewport;
        if (viewport != null) {
            viewport.AddChild(this);
            this.UpdateAttach(true);
        }
    }

    public void SetViewportNull() {
        this.SetViewport(null);
    }

    public Viewport GetViewport() {
        return this.m_pViewport;
    }

    public void TakeFocus() {
        FlApplication.GetInstance().SetCurrentFocus(this);
    }

    public void OnFocusChange(boolean bl) {
        this.SendMsg(this, -128, bl ? 1 : 0);
    }

    public Component ForwardFocus() {
        return this;
    }

    public boolean DescendentOrSelfHasFocus() {
        Component component = FlApplication.GetInstance().GetCurrentFocus();
        return this.IsSelfOrAncestorOf(component);
    }

    public boolean IsSelfOrAncestorOf(Component component) {
        while (component != null) {
            if (component == this) {
                return true;
            }
            component = component.GetViewport();
        }
        return false;
    }

    public int GetDepth() {
        Component component = this;
        int n2 = 0;
        do {
            ++n2;
        } while ((component = component.GetViewport()) != null);
        return n2;
    }

    public void SendMsg(Component component, int n2, int n3) {
        Component component2 = this;
        do {
            if (component2.OnMsg(component, n2, n3)) {
                return;
            }
            if (!component2.OnDefaultMsg(component, n2, n3)) continue;
            return;
        } while ((component2 = component2.GetViewport()) != null);
    }

    public void SendMsg(Component component, int n2) {
        this.SendMsg(component, n2, -1);
    }

    public boolean OnMsg(Component component, int n2, int n3) {
        return false;
    }

    public boolean OnDefaultMsg(Component component, int n2, int n3) {
        return false;
    }

    public void SetRect(short s2, short s3, short s4, short s5) {
        this.Invalidate();
        this.mRect_left = s2;
        this.mRect_top = s3;
        this.mRect_width = s4;
        this.mRect_height = s5;
        this.OnRectChange();
        this.Invalidate();
    }

    public short GetRectLeft() {
        return this.mRect_left;
    }

    public short GetRectTop() {
        return this.mRect_top;
    }

    public short GetRectWidth() {
        return this.mRect_width;
    }

    public short GetRectHeight() {
        return this.mRect_height;
    }

    public void SetRect(FlRect flRect) {
        this.SetRect(flRect.GetLeft(), flRect.GetTop(), flRect.GetWidth(), flRect.GetHeight());
    }

    public FlRect GetRect() {
        return new FlRect(this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height);
    }

    public void SetTopLeft(Vector2_short vector2_short) {
        this.SetTopLeft(vector2_short.GetX(), vector2_short.GetY());
    }

    public Vector2_short GetSize() {
        return new Vector2_short(this.GetRectWidth(), this.GetRectHeight());
    }

    public void SetSize(Vector2_short vector2_short) {
        this.SetSize(vector2_short.GetX(), vector2_short.GetY());
    }

    public Vector2_short GetTopLeft() {
        return new Vector2_short(this.GetRectLeft(), this.GetRectTop());
    }

    public Vector2_short GetAbsoluteTopLeft() {
        return new Vector2_short(this.GetAbsoluteLeft(), this.GetAbsoluteTop());
    }

    public void SetTopLeft(short s2, short s3) {
        this.Invalidate();
        this.mRect_left = s2;
        this.mRect_top = s3;
        this.OnRectChange();
        this.Invalidate();
    }

    public short GetAbsoluteTop() {
        Viewport viewport = this.m_pViewport;
        return viewport == null ? this.mRect_top : (short)(this.mRect_top + viewport.GetAbsoluteTop() - viewport.GetOffsetY());
    }

    public short GetAbsoluteLeft() {
        Viewport viewport = this.m_pViewport;
        return viewport == null ? this.mRect_left : (short)(this.mRect_left + viewport.GetAbsoluteLeft() - viewport.GetOffsetX());
    }

    public short GetRelativeCoordX(short n2) {
        int n3 = n2;
        for (Viewport viewport = this.GetViewport(); viewport != null; viewport = viewport.GetViewport()) {
            n3 = n3 - viewport.GetRectLeft() + viewport.GetOffsetX();
        }
        return (short)(n3 - this.mRect_left);
    }

    public short GetRelativeCoordY(short n2) {
        int n3 = n2;
        for (Viewport viewport = this.GetViewport(); viewport != null; viewport = viewport.GetViewport()) {
            n3 = n3 - viewport.GetRectTop() + viewport.GetOffsetY();
        }
        return (short)(n3 - this.mRect_top);
    }

    public void SetCenter(short s2, short s3) {
        this.Invalidate();
        this.mRect_left = (short)(s2 - this.mRect_width / 2);
        this.mRect_top = (short)(s3 - this.mRect_height / 2);
        this.OnRectChange();
        this.Invalidate();
    }

    public void SetBottomRight(short s2, short s3) {
        this.Invalidate();
        this.mRect_width = (short)(s2 + 1 - this.mRect_left);
        this.mRect_height = (short)(s3 + 1 - this.mRect_top);
        this.OnRectChange();
        this.Invalidate();
    }

    public short GetBottom() {
        return (short)(this.mRect_top + this.mRect_height - 1);
    }

    public short GetRight() {
        return (short)(this.mRect_left + this.mRect_width - 1);
    }

    public void CenterInRect(short s2, short s3, short s4, short s5) {
        this.mRect_left = (short)(s2 + (s4 - this.mRect_width >> 1));
        this.mRect_top = (short)(s3 + (s5 - this.mRect_height >> 1));
    }

    public void SetSize(short s2, short s3) {
        this.Invalidate();
        this.mRect_width = s2;
        this.mRect_height = s3;
        this.OnRectChange();
        this.Invalidate();
    }

    public void SetVisible(boolean bl) {
        if (this.mVisible != bl) {
            this.Invalidate();
            this.mVisible = bl;
            this.OnVisibilityChange();
            this.Invalidate();
        }
    }

    public boolean IsVisible() {
        return this.mVisible;
    }

    public boolean IsGloballyVisible() {
        Viewport viewport = this.m_pViewport;
        return this.IsVisible() && (viewport == null || viewport.IsGloballyVisible());
    }

    public Component GetPreviousSiblingComponent() {
        return this.m_pPreviousSibling;
    }

    public void BringToFront() {
        this.m_pViewport.BringComponentToFront(this);
        this.Invalidate();
    }

    public void SendToBack() {
        this.m_pViewport.SendComponentToBack(this);
        this.Invalidate();
    }

    public void PutBehind(Component component) {
        this.m_pViewport.PutComponentBehind(this, component);
        this.Invalidate();
    }

    public void PutInFront(Component component) {
        this.m_pViewport.PutComponentInFront(this, component);
        this.Invalidate();
    }

    public boolean IsAttached() {
        Component component = this;
        Component component2 = null;
        while ((component = (component2 = component).GetViewport()) != null) {
        }
        return component2 == FlApplication.GetInstance();
    }

    public void OnAttach(boolean bl) {
        FlApplication flApplication;
        if (!bl && (flApplication = FlApplication.GetInstance()).GetCurrentFocus() == this) {
            flApplication.TakeFocus();
        }
    }

    public void Invalidate() {
        if (this.IsVisible()) {
            FlApplication.GetInstance().SetDirty(true);
        }
    }

    public abstract void OnDraw(FlDisplayContext var1);

    public void OnMouseRightDown(Vector2_short vector2_short) {
    }

    public void OnMouseOver() {
    }

    public void OnMouseOut() {
    }

    public void OnMouseRightUp(Vector2_short vector2_short) {
    }

    public void OnMouseRightDrag(Vector2_short vector2_short) {
    }

    public boolean IsTrackingPen() {
        return false;
    }

    public boolean IsTrackingMouse() {
        return false;
    }

    public void OnSerialize(Package package_) {
        this.mRect_left = package_.SerializeIntrinsic(this.mRect_left);
        this.mRect_top = package_.SerializeIntrinsic(this.mRect_top);
        this.mRect_width = package_.SerializeIntrinsic(this.mRect_width);
        this.mRect_height = package_.SerializeIntrinsic(this.mRect_height);
        byte by = 0;
        this.mVisible = ((by = package_.SerializeIntrinsic(by)) & 1) != 0;
    }

    public void ControlValue(int n2, boolean bl, Controller controller) {
        if (bl) {
            short s2 = 0;
            short s3 = 0;
            if (n2 == 1 || n2 == 2 || n2 == 3) {
                s2 = controller.GetCoord2ValueX();
                s3 = controller.GetCoord2ValueY();
            }
            switch (n2) {
                case 1: {
                    this.SetTopLeft(s2, s3);
                    return;
                }
                case 2: {
                    this.SetSize(s2, s3);
                    return;
                }
                case 3: {
                    short s4 = (short)(this.GetRectLeft() + (this.GetRectWidth() >> 1) - (s2 >> 1));
                    short s5 = (short)(this.GetRectTop() + (this.GetRectHeight() >> 1) - (s3 >> 1));
                    this.SetRect(s4, s5, s2, s3);
                    return;
                }
                case 4: {
                    FlRect flRect = controller.GetRectValue();
                    this.SetRect(flRect.GetLeft(), flRect.GetTop(), flRect.GetWidth(), flRect.GetHeight());
                    return;
                }
                case 5: {
                    this.SetVisible(controller.GetBoolValue());
                    return;
                }
            }
        } else {
            switch (n2) {
                case 1: {
                    controller.SetValue(this.mRect_left, this.mRect_top);
                    return;
                }
                case 2: 
                case 3: {
                    controller.SetValue(this.mRect_width, this.mRect_height);
                    return;
                }
                case 4: {
                    controller.SetValue(this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height);
                    return;
                }
                case 5: {
                    controller.SetValue(this.IsVisible());
                    return;
                }
            }
        }
        super.ControlValue(n2, bl, controller);
    }

    public void ResetAncestorScroller() {
        this.SendMsg(this, -114, 0);
    }

    public void TrackPen() {
    }

    public void ReleasePen() {
    }

    public void TrackMouse() {
    }

    public void ReleaseMouse() {
    }

    public void OnVisibilityChange() {
    }

    public void OnRectChange() {
    }

    public void UpdateAttach(boolean bl) {
        if (this.IsAttached()) {
            this.Invalidate();
            this.OnAttach(bl);
        }
    }
}

