/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.PlayerViewportManager;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerState;
import ca.jamdat.texasholdem09.TexasPokerTable;

public class StateWaitingForDeal
extends PokerState {
    public static final byte kUndefined = -1;
    public static final byte kProcessAIIntroduction = 0;
    public static final byte kPayBlinds = 1;
    public static final byte kShowBlinds = 2;
    public static final byte kShowBlindIncrease = 3;
    public static final byte kLeavingState = 4;
    public byte mStateStage = (byte)-1;
    public boolean mNeedToResumeState;

    public StateWaitingForDeal(PokerGame pokerGame) {
        super(pokerGame);
    }

    public void destruct() {
    }

    public byte GetID() {
        return 2;
    }

    public void OnEntry() {
        if (this.mStateStage == -1) {
            this.SetStage((byte)0);
        } else {
            this.mNeedToResumeState = true;
        }
    }

    public void OnExit() {
        this.SetStage((byte)-1);
    }

    public void OnSkip() {
        this.HidePopup();
        this.ManageState();
        if (this.mPokerGame.IsGamePaused()) {
            this.mNeedToResumeState = true;
        }
        super.OnSkip();
    }

    public void OnTime(int n2, int n3) {
        if (this.mNeedToResumeState) {
            this.ResumeGame();
        }
        this.ManageState();
        super.OnTime(n2, n3);
    }

    public void Read(FileSegmentStream fileSegmentStream) {
        this.mStateStage = fileSegmentStream.ReadByte();
    }

    public void Write(FileSegmentStream fileSegmentStream) {
        fileSegmentStream.WriteByte(this.mStateStage);
    }

    public void ManageState() {
        boolean bl = this.ManageNewHand();
        if (bl) {
            this.SetNextState((byte)3);
        }
    }

    public boolean ManageNewHand() {
        TexasPokerTable texasPokerTable = this.mPokerGame.GetTexasPokerTable();
        boolean bl = false;
        switch (this.mStateStage) {
            case 0: {
                this.SetStage((byte)1);
                break;
            }
            case 1: {
                if (!this.mNeedToResumeState) {
                    this.mTexasManager.MakePlayersPostBlinds();
                }
                if (this.mTexasManager.BlindsJustGotIncremented()) {
                    this.SetStage((byte)3, 2500);
                    break;
                }
                this.SetStage((byte)2);
                break;
            }
            case 3: {
                if (!this.mNeedToResumeState) {
                    this.HandlePopup((byte)14);
                }
                this.SetStage((byte)2);
                break;
            }
            case 2: {
                PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
                PokerPlayer pokerPlayer = this.mTexasManager.GetSmallBlindPlayer();
                PokerPlayer pokerPlayer2 = this.mTexasManager.GetBigBlindPlayer();
                byte by = texasPokerTable.GetSeatOfPlayer(pokerPlayer);
                byte by2 = texasPokerTable.GetSeatOfPlayer(pokerPlayer2);
                playerViewportManager.SetPlayerAction(by2, pokerPlayer2.GetState(), pokerPlayer2.GetDecision());
                playerViewportManager.SetPlayerAction(by, pokerPlayer.GetState(), pokerPlayer.GetDecision());
                if (pokerPlayer2.IsPlayerHuman() || pokerPlayer.IsPlayerHuman()) {
                    this.UpdateHumanPlayerStackUI();
                }
                this.mGameScene.GetPotManager().Refresh();
                this.SetStage((byte)4);
                break;
            }
            case 4: {
                bl = true;
            }
        }
        return bl;
    }

    public void ResumeGame() {
        byte by = this.mStateStage;
        this.SetStage((byte)0);
        while (by != this.mStateStage) {
            this.ManageState();
            super.OnSkip();
        }
        this.mNeedToResumeState = false;
    }

    public void SetStage(byte by, int n2) {
        this.mStateStage = by;
        this.SetWaitingTime(n2);
    }

    public void SetStage(byte by) {
        this.SetStage(by, -1);
    }
}

