/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.PlayerViewportManager;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerState;
import ca.jamdat.texasholdem09.PokerTable;
import ca.jamdat.texasholdem09.PtrArray_PokerPlayer;
import ca.jamdat.texasholdem09.TexasPokerTable;

public class StateShowdown
extends PokerState {
    public static final byte kUndefined = -1;
    public static final byte kDetermineNbOfPots = 0;
    public static final byte kRevealPot = 1;
    public static final byte kDetermineShowOrMuck = 2;
    public static final byte kProcessCardsFlip = 3;
    public static final byte kShowingWinningHand = 4;
    public static final byte kPayingPotWinners = 5;
    public static final byte kStartPayingPotWinnerAnim = 6;
    public static final byte kLeavingShowdown = 7;
    public byte mStateStage = (byte)-1;
    public PtrArray_PokerPlayer mPotWinners = new PtrArray_PokerPlayer();
    public boolean mAIWon;
    public boolean mAreInPlayCardsAllShown;

    public StateShowdown(PokerGame pokerGame) {
        super(pokerGame);
    }

    public void destruct() {
        this.mPotWinners.Clear();
    }

    public byte GetID() {
        return 7;
    }

    public void OnEntry() {
        this.mPokerGame.SetSkipToEnd(false);
        this.mGameScene.UpdateSoftKey();
        this.mAreInPlayCardsAllShown = this.mPokerGame.GetTexasPokerTable().AreInPlayCardsAllShown();
        if (this.mStateStage == -1) {
            if (!this.mAreInPlayCardsAllShown) {
                this.HandlePopup((byte)19);
            }
            this.SetStage((byte)0);
            GameApp.Get().GetStatistics().OnShowdown();
        } else {
            this.mPokerGame.SetIsInSkipMode(true);
            this.OnSkip();
            this.mAreInPlayCardsAllShown = this.mPokerGame.GetTexasPokerTable().AreInPlayCardsAllShown();
        }
    }

    public void OnExit() {
        this.SetStage((byte)-1);
    }

    public void OnSkip() {
        this.HidePopup();
        if (this.mStateStage == 5) {
            this.ManageState();
        }
        while (this.mStateStage != 7 && this.mStateStage != 5 && this.mStateStage != 4) {
            this.ManageState();
        }
        super.OnSkip();
    }

    public void OnTime(int n2, int n3) {
        this.ManageState();
        super.OnTime(n2, n3);
    }

    public void Read(FileSegmentStream fileSegmentStream) {
        PokerTable pokerTable = this.mTexasManager.GetPokerTable();
        this.mStateStage = fileSegmentStream.ReadByte();
        byte by = fileSegmentStream.ReadByte();
        byte by2 = 0;
        for (by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            this.mPotWinners.Insert(pokerTable.GetPlayerSeatedAt(fileSegmentStream.ReadByte()));
        }
        int n2 = pokerTable.GetNbOfStartingPlayers();
        for (by2 = by; by2 < n2; by2 = (byte)(by2 + 1)) {
            fileSegmentStream.ReadByte();
        }
    }

    public void Write(FileSegmentStream fileSegmentStream) {
        PokerTable pokerTable = this.mTexasManager.GetPokerTable();
        byte by = (byte)this.mPotWinners.End();
        fileSegmentStream.WriteByte(this.mStateStage);
        fileSegmentStream.WriteByte(by);
        byte by2 = 0;
        for (by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
            fileSegmentStream.WriteByte(pokerTable.GetSeatOfPlayer(this.mPotWinners.GetAt(by2)));
        }
        int n2 = pokerTable.GetNbOfStartingPlayers();
        for (by2 = by; by2 < n2; by2 = (byte)(by2 + 1)) {
            fileSegmentStream.WriteByte((byte)0);
        }
    }

    public void ManageState() {
        boolean bl = this.ManageShowdown();
        if (bl) {
            this.SetNextState((byte)8);
        }
    }

    public boolean ManageShowdown() {
        PlayerViewportManager playerViewportManager = this.mGameScene.GetPlayerViewportManager();
        TexasPokerTable texasPokerTable = this.mPokerGame.GetTexasPokerTable();
        int n2 = texasPokerTable.GetNbOfStartingPlayers();
        boolean bl = false;
        switch (this.mStateStage) {
            case 0: {
                this.mAIWon = false;
                playerViewportManager.HideAIPlayersDecision();
                playerViewportManager.ToggleInfoScreensOutIfNeeded();
                int n3 = texasPokerTable.GetPotsNbr();
                if (n3 > 0) {
                    this.SetStage((byte)1, 600);
                    break;
                }
                this.SetStage((byte)7, 1000);
                this.mGameScene.UpdateSoftKey();
                break;
            }
            case 1: {
                this.mGameScene.GetPotManager().SetPot(texasPokerTable.GetPot(texasPokerTable.GetPotsNbr() - 1));
                this.SetStage((byte)2);
                break;
            }
            case 2: {
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.mTexasManager.UpdateNextPlayerToShow();
                }
                this.SetStage((byte)3);
                break;
            }
            case 3: {
                if (!this.mAreInPlayCardsAllShown && !this.mPokerGame.ProcessCardsFlip()) break;
                this.SetStage((byte)4);
                break;
            }
            case 4: {
                this.mAreInPlayCardsAllShown = this.mPokerGame.GetTexasPokerTable().AreInPlayCardsAllShown();
                texasPokerTable.GetPotWinners(this.mPotWinners, texasPokerTable.GetPotsNbr() - 1);
                this.HandlePopup((byte)12);
                this.SetStage((byte)5);
                break;
            }
            case 5: {
                boolean bl2 = this.mPokerGame.IsInSkipMode();
                int n4 = 0;
                if (!bl2) {
                    PokerPlayer pokerPlayer = null;
                    byte by = -1;
                    byte by2 = PokerTable.GetSeatOfHumanPlayer();
                    int n5 = 0;
                    for (n5 = 0; n5 < this.mPotWinners.End(); ++n5) {
                        pokerPlayer = this.mPotWinners.GetAt(n5);
                        by = texasPokerTable.GetSeatOfPlayer(pokerPlayer);
                        if (by == by2) continue;
                        playerViewportManager.SetupInfoScreen(by, true, pokerPlayer.GetChip(), true);
                        this.mAIWon = true;
                    }
                    texasPokerTable.PayPotWinners(this.mPotWinners, texasPokerTable.GetPotsNbr() - 1);
                    for (n5 = 0; n5 < this.mPotWinners.End(); ++n5) {
                        pokerPlayer = this.mPotWinners.GetAt(n5);
                        by = texasPokerTable.GetSeatOfPlayer(pokerPlayer);
                        playerViewportManager.WonPot(by, pokerPlayer);
                    }
                    n4 = this.mAIWon ? 250 : 0;
                } else {
                    texasPokerTable.PayPotWinners(this.mPotWinners, texasPokerTable.GetPotsNbr() - 1);
                }
                this.SetStage((byte)6, n4);
                this.mPotWinners.Clear();
                break;
            }
            case 6: {
                int n6 = this.mAIWon ? 500 : 0;
                this.mGameScene.GetPotManager().SetPot(0);
                this.SetStage((byte)0, n6);
                break;
            }
            case 7: {
                bl = true;
            }
        }
        return bl;
    }

    public void SetStage(byte by, int n2) {
        this.mStateStage = by;
        this.SetWaitingTime(n2);
    }

    public void SetStage(byte by) {
        this.SetStage(by, -1);
    }
}

