/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlBitmapMap;
import ca.jamdat.flight.FlColor;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.TimeControlled;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;
import ca.jamdat.texasholdem09.BaseScene;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.ResizableFrame;
import ca.jamdat.texasholdem09.Softkey;

public class Popup
extends TimeControlled {
    public static final byte noneId = -1;
    public static final byte messageId = 0;
    public static final byte advisorTutorialId = 1;
    public static final byte promptId = 2;
    public static final byte locationInfoId = 3;
    public static final byte newLocationId = 4;
    public static final byte headsUpChallengeId = 5;
    public static final byte inGameAdvisorId = 6;
    public static final byte aiDialogueBigId = 7;
    public static final byte aiDialogueSmallId = 8;
    public static final byte aiDialogueOutId = 9;
    public static final byte playerActionId = 10;
    public static final byte welcomeToId = 11;
    public static final byte winningHandId = 12;
    public static final byte roundInfoID = 13;
    public static final byte blindIncreaseId = 14;
    public static final byte inGameStatisticsId = 15;
    public static final byte gameWonId = 16;
    public static final byte tutorialId = 17;
    public static final byte playerOutId = 18;
    public static final byte enteringShowdownId = 19;
    public static final byte undefinedState = 0;
    public static final byte loadingState = 1;
    public static final byte initializingState = 2;
    public static final byte openingState = 3;
    public static final byte idleState = 4;
    public static final byte hidingState = 5;
    public static final byte hiddenState = 6;
    public Softkey mSelectSoftKey;
    public Softkey mClearSoftKey;
    public ResizableFrame mPopupViewport;
    public Viewport mContentViewport;
    public MetaPackage mContentMetaPackage;
    public BaseScene mParentScene;
    public MetaPackage mCommonMetaPackage;
    public byte mId;
    public byte mState;
    public int mCommandOnHide;
    public boolean mKeepInstance;
    public Vector2_short mTopLeft;

    public Popup(BaseScene baseScene, Softkey softkey, Softkey softkey2, byte by, boolean bl) {
        this.mSelectSoftKey = softkey;
        this.mClearSoftKey = softkey2;
        this.mParentScene = baseScene;
        this.mId = by;
        this.mState = 0;
        this.mCommandOnHide = 0;
        this.mKeepInstance = bl;
        this.mTopLeft = new Vector2_short(0, 0);
    }

    public void destruct() {
    }

    public void Load() {
        GameApp.Get().TakeFocus();
        this.mParentScene.RemoveSoftKeysCommand();
        this.SetState((byte)1);
        if (this.IsLoaded()) {
            this.OnPopupLoaded();
        } else {
            GameApp.Get().GetHourglass().SetVisible(true);
            this.mCommonMetaPackage = GameLibrary.GetPackage(1212453);
            this.RegisterInGlobalTime();
        }
    }

    public boolean IsLoaded() {
        return this.mCommonMetaPackage != null && this.mCommonMetaPackage.IsLoaded() && this.mContentMetaPackage != null && this.mContentMetaPackage.IsLoaded();
    }

    public void GetEntryPoints() {
        Package package_ = this.mCommonMetaPackage.GetPackage();
        Package package_2 = this.mContentMetaPackage.GetPackage();
        this.mContentViewport = Viewport.Cast(package_2.GetEntryPoint(0), null);
        FlBitmapMap flBitmapMap = null;
        flBitmapMap = FlBitmapMap.Cast(package_.GetEntryPoint(16), null);
        this.mPopupViewport = new ResizableFrame(flBitmapMap);
        this.mPopupViewport.SetRect(this.mContentViewport.GetRect());
    }

    public void InitializeSpecificPopup() {
    }

    public void Unload() {
        if (this.mPopupViewport != null) {
            this.SetViewport(null);
            this.mPopupViewport = null;
        }
        if (this.mContentViewport != null) {
            this.mContentViewport.SetViewport(null);
        }
        if (this.mContentMetaPackage != null) {
            GameLibrary.ReleasePackage(this.mContentMetaPackage);
            this.mContentMetaPackage = null;
        }
        if (this.mCommonMetaPackage != null) {
            GameLibrary.ReleasePackage(this.mCommonMetaPackage);
            this.mCommonMetaPackage = null;
        }
        this.UnRegisterInGlobalTime();
        this.mState = 0;
    }

    public void SetViewport(Viewport viewport) {
        this.mPopupViewport.SetViewport(viewport);
    }

    public void Show() {
        this.mPopupViewport.SetViewport(this.mParentScene.GetView());
        this.mPopupViewport.BringToFront();
        this.mPopupViewport.SetVisible(true);
        this.SetState((byte)3);
        this.mParentScene.OnCommand(-69);
    }

    public void Hide() {
        if (this.mState != 6) {
            this.HideComponents();
            GameApp.Get().TakeFocus();
        }
        this.SetState((byte)5);
        this.mParentScene.OnCommand(-70);
    }

    public void Shown() {
        this.SetState((byte)4);
        this.ShowComponents();
        this.UpdatePopUpSoftKeys();
        this.TakeFocus();
    }

    public void Hidden() {
        if (this.mState == 1) {
            GameApp.Get().GetHourglass().SetVisible(false);
            this.Unload();
        } else if (this.mState != 0) {
            this.SetState((byte)6);
            this.mPopupViewport.SetVisible(false);
        }
        this.mParentScene.ReceiveFocus();
    }

    public boolean IsShown() {
        return this.mContentViewport != null && this.mContentViewport.IsVisible();
    }

    public boolean HasFocus() {
        return this.mPopupViewport != null && this.mPopupViewport.DescendentOrSelfHasFocus();
    }

    public byte GetId() {
        return this.mId;
    }

    public void SetId(byte by) {
        this.mId = by;
    }

    public void SetOnHideCommand(int n2) {
        this.mCommandOnHide = n2;
    }

    public int GetOnHideCommand() {
        return this.mCommandOnHide;
    }

    public boolean IsKeepInstance() {
        return this.mKeepInstance;
    }

    public boolean IsInitializingStateReached() {
        return this.mState >= 2;
    }

    public Scroller GetPenMoveHScrollingComponent() {
        return null;
    }

    public Scroller GetPenMoveVScrollingComponent() {
        return null;
    }

    public void TakeFocus() {
        this.mPopupViewport.TakeFocus();
    }

    public byte GetState() {
        return this.mState;
    }

    public void OnTime(int n2, int n3) {
        if (this.IsLoaded()) {
            this.UnRegisterInGlobalTime();
            GameApp.Get().GetHourglass().SetVisible(false);
            if (this.mState == 1) {
                this.GetEntryPoints();
                this.OnPopupLoaded();
            }
        }
    }

    public void HideComponents() {
        this.mContentViewport.SetVisible(false);
    }

    public void ShowComponents() {
        this.mContentViewport.SetVisible(true);
    }

    public int GetAttributes() {
        int n2 = 0;
        n2 = 15;
        return n2;
    }

    public void UpdateBackgroundAttributes(int n2) {
        Package package_ = this.mCommonMetaPackage.GetPackage();
        FlColor flColor = null;
        flColor = FlColor.Cast(package_.GetEntryPoint(2), null);
        this.mPopupViewport.SetTopRectColor(flColor);
        this.mPopupViewport.SetBackgroundAttributes(n2);
        FlColor flColor2 = null;
        flColor2 = this.mPopupViewport.IsUsingAttribute(8) ? FlColor.Cast(package_.GetEntryPoint(1), null) : FlColor.Cast(package_.GetEntryPoint(0), null);
        this.mPopupViewport.SetBackgroundColor(flColor2);
    }

    public void UpdatePopUpSoftKeys() {
        this.UpdateAcceptSoftKey();
        this.UpdateDeclineSoftKey();
    }

    public void UpdateAcceptSoftKey() {
        this.UpdateSoftKey(this.mSelectSoftKey, this.GetSelectSoftKeyString(), this.GetSelectSoftKeyCommand());
    }

    public void UpdateDeclineSoftKey() {
        this.UpdateSoftKey(this.mClearSoftKey, this.GetClearSoftKeyString(), this.GetClearSoftKeyCommand());
    }

    public int GetSelectSoftKeyCommand() {
        int n2 = 0;
        n2 = this.mContentMetaPackage.GetPackage().GetEntryPoint(2, (int[])null);
        return n2;
    }

    public int GetClearSoftKeyCommand() {
        int n2 = 0;
        n2 = this.mContentMetaPackage.GetPackage().GetEntryPoint(4, (int[])null);
        return n2;
    }

    public FlString GetSelectSoftKeyString() {
        FlString flString = null;
        flString = FlString.Cast(this.mContentMetaPackage.GetPackage().GetEntryPoint(1), null);
        return flString;
    }

    public FlString GetClearSoftKeyString() {
        FlString flString = null;
        flString = FlString.Cast(this.mContentMetaPackage.GetPackage().GetEntryPoint(3), null);
        return flString;
    }

    public void SetState(byte by) {
        this.mState = by;
    }

    public static boolean IsKeepGameScenePopupInMemory() {
        return true;
    }

    public static void CenterAlignItemsInPopup(Viewport viewport, Viewport viewport2) {
        short s2 = (short)((viewport2.GetRectHeight() - viewport.GetRectHeight()) / 2);
        viewport.SetTopLeft(viewport.GetRectLeft(), s2);
    }

    public void Initialize() {
        this.SetState((byte)2);
        this.SetContentDefaultTopLeft();
        this.InitializeSpecificPopup();
        this.mTopLeft.SetX(this.mContentViewport.GetRectLeft());
        this.mTopLeft.SetY(this.mContentViewport.GetRectTop());
        this.mPopupViewport.SetRect(this.mContentViewport.GetRect());
        this.UpdateBackgroundAttributes(this.GetAttributes());
        this.mContentViewport.SetViewport(this.mPopupViewport);
        this.mContentViewport.SetTopLeft((short)0, (short)0);
        this.HideComponents();
    }

    public void OnPopupLoaded() {
        this.Initialize();
        this.Show();
    }

    public void UpdateSoftKey(Softkey softkey, FlString flString, int n2) {
        softkey.SetCaption(flString);
        softkey.SetCommand(n2);
    }

    public void SetContentDefaultTopLeft() {
        if (this.mContentViewport != null && this.mContentViewport.GetViewport() != null) {
            this.mContentViewport.SetTopLeft(this.mTopLeft.GetX(), this.mTopLeft.GetY());
        }
    }

    public Popup(BaseScene baseScene, Softkey softkey, Softkey softkey2, byte by) {
        this(baseScene, softkey, softkey2, by, false);
    }
}

