/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Viewport;
import ca.jamdat.texasholdem09.BaseScene;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.GameSettings;
import ca.jamdat.texasholdem09.HV;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerTable;
import ca.jamdat.texasholdem09.PtrArray_PokerPlayer;
import ca.jamdat.texasholdem09.Softkey;
import ca.jamdat.texasholdem09.TimedPopup;

public class GameInfoPopup
extends TimedPopup {
    public GameInfoPopup(BaseScene baseScene, Softkey softkey, Softkey softkey2, byte by) {
        super(baseScene, softkey, softkey2, by);
    }

    public void destruct() {
    }

    public int GetAttributes() {
        int n2 = 0;
        switch (this.mId) {
            case 11: 
            case 13: {
                n2 = 15;
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 14;
                break;
            }
            default: {
                return super.GetAttributes();
            }
        }
        return n2;
    }

    public void UpdateDeclineSoftKey() {
        if (this.mId != 16) {
            super.UpdateDeclineSoftKey();
        }
    }

    public void LoadMetaPackage() {
        this.mContentMetaPackage = GameLibrary.GetPackage(1409067);
    }

    public void InitializeSpecificPopup() {
        switch (this.mId) {
            case 19: {
                this.InitEnteringShowdown();
                break;
            }
            case 11: {
                this.InitWelcomeTo();
                break;
            }
            case 12: {
                this.InitWinningHand();
                break;
            }
            case 13: {
                this.InitRoundInfo();
                break;
            }
            case 14: {
                this.InitBlindIncrease();
                break;
            }
            case 18: {
                this.InitPlayerOut();
                break;
            }
            case 16: {
                this.InitGameWon();
                break;
            }
        }
    }

    public void InitBlindPopup(int n2, int n3, int n4) {
        this.SetAutoHideTime(1500);
        Package package_ = this.mContentMetaPackage.GetPackage();
        Text text = null;
        FlString flString = null;
        this.mContentViewport = Viewport.Cast(package_.GetEntryPoint(15), null);
        text = Text.Cast(package_.GetEntryPoint(16), null);
        flString = FlString.Cast(package_.GetEntryPoint(n2), null);
        text.SetCaption(flString);
        text = Text.Cast(package_.GetEntryPoint(17), null);
        FlString flString2 = StringUtils.CreateStringPtr("");
        flString2.AddAssign(new FlString(n3));
        flString2.AddAssign(StringUtils.CreateString(" / "));
        flString2.AddAssign(new FlString(n4));
        text.SetCaption(flString2);
    }

    public void InitEnteringShowdown() {
        this.SetAutoHideTime(1000);
        Package package_ = this.mContentMetaPackage.GetPackage();
        this.mContentViewport = Viewport.Cast(package_.GetEntryPoint(20), null);
    }

    public void InitWelcomeTo() {
        this.SetAutoHideTime(2500);
        Package package_ = this.mContentMetaPackage.GetPackage();
        this.mContentViewport = Viewport.Cast(package_.GetEntryPoint(5), null);
        Text text = null;
        text = Text.Cast(package_.GetEntryPoint(6), null);
        GameSettings gameSettings = GameApp.Get().GetGameSettings();
        text.SetCaption(GameSettings.GetLocationName(gameSettings.GetLocation()));
    }

    public void InitPlayerOut() {
        this.SetAutoHideTime(1500);
        Package package_ = this.mContentMetaPackage.GetPackage();
        this.mContentViewport = Viewport.Cast(package_.GetEntryPoint(13), null);
        Text text = null;
        text = Text.Cast(package_.GetEntryPoint(14), null);
        FlString flString = null;
        flString = FlString.Cast(package_.GetEntryPoint(26), null);
        text.SetCaption(flString);
        GameApp.Get().GetMediaPlayer().PlayGameSceneSoundFX(23);
    }

    public void InitBlindIncrease() {
        int n2 = this.mTexasGameManager.GetSmallBlindValue();
        int n3 = this.mTexasGameManager.GetBigBlindValue();
        this.InitBlindPopup(24, n2, n3);
    }

    public void InitRoundInfo() {
        this.SetAutoHideTime(1500);
        Package package_ = this.mContentMetaPackage.GetPackage();
        Text text = null;
        FlString flString = null;
        this.mContentViewport = Viewport.Cast(package_.GetEntryPoint(18), null);
        text = Text.Cast(package_.GetEntryPoint(19), null);
        flString = FlString.Cast(package_.GetEntryPoint(28), null);
        FlString flString2 = new FlString(GameApp.Get().GetGameSettings().GetTournamentRound());
        flString2.AddAssign(flString);
        text.SetCaption(flString2);
    }

    public void InitWinningHand() {
        this.SetAutoHideTime(3500);
        int n2 = 25;
        PokerTable pokerTable = this.mTexasGameManager.GetPokerTable();
        PtrArray_PokerPlayer ptrArray_PokerPlayer = new PtrArray_PokerPlayer();
        int n3 = pokerTable.GetPotsNbr() - 1;
        pokerTable.GetPotWinners(ptrArray_PokerPlayer, n3);
        PokerPlayer pokerPlayer = ptrArray_PokerPlayer.GetAt(0);
        byte by = HV.GetType(pokerPlayer.GetHandValue());
        int n4 = pokerTable.GetPot(n3);
        int n5 = n4 / ptrArray_PokerPlayer.End();
        Package package_ = this.mContentMetaPackage.GetPackage();
        Text text = null;
        FlString flString = null;
        Viewport viewport = null;
        this.mContentViewport = Viewport.Cast(package_.GetEntryPoint(7), null);
        viewport = Viewport.Cast(package_.GetEntryPoint(8), null);
        text = Text.Cast(package_.GetEntryPoint(9), null);
        if (n3 > 0) {
            flString = FlString.Cast(package_.GetEntryPoint(42 + (n3 - 1)), null);
            text.SetCaption(flString);
            text.SetVisible(true);
            viewport.OffsetTo((short)0, (short)0);
        } else {
            text.SetVisible(false);
            viewport.OffsetTo((short)0, (short)8);
        }
        if (ptrArray_PokerPlayer.End() > 1) {
            flString = FlString.Cast(package_.GetEntryPoint(31), null);
        } else if (pokerPlayer.IsPlayerHuman()) {
            flString = FlString.Cast(package_.GetEntryPoint(29), null);
            n2 = by >= 4 ? 14 : 2;
        } else {
            FlString flString2 = null;
            flString2 = FlString.Cast(package_.GetEntryPoint(30), null);
            flString = new FlString(pokerPlayer.GetName());
            flString.AddAssign(flString2);
            if (pokerTable.GetHumanPlayer().IsPlayerInTheHand()) {
                n2 = 13;
            }
        }
        text = Text.Cast(package_.GetEntryPoint(10), null);
        text.SetCaption(flString);
        text = Text.Cast(package_.GetEntryPoint(11), null);
        flString = new FlString(n5);
        text.SetCaption(flString);
        text = Text.Cast(package_.GetEntryPoint(12), null);
        flString = FlString.Cast(package_.GetEntryPoint(32 + by), null);
        text.SetCaption(flString);
        if (25 != n2) {
            GameApp.Get().GetMediaPlayer().PlayGameSceneSoundFX(n2);
        }
        ptrArray_PokerPlayer.Clear();
    }

    public void InitGameWon() {
        this.SetAutoHideTime(3000);
        Package package_ = this.mContentMetaPackage.GetPackage();
        this.mContentViewport = Viewport.Cast(package_.GetEntryPoint(21), null);
        GameApp.Get().GetMediaPlayer().PlayGameSceneSoundFX(24);
    }
}

