/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlMath;
import ca.jamdat.texasholdem09.CareerState;
import ca.jamdat.texasholdem09.Character;
import ca.jamdat.texasholdem09.FileSegmentStream;
import ca.jamdat.texasholdem09.GameApp;
import ca.jamdat.texasholdem09.GameSettings;
import ca.jamdat.texasholdem09.PlayerViewportManager;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerPlayerAI;
import ca.jamdat.texasholdem09.PokerTable;
import ca.jamdat.texasholdem09.TexasGameManager;

public class CharacterManager {
    public static final int undefinedPosition = -1;
    public static final int roundOnePlayerOne = 0;
    public static final int roundOnePlayerTwo = 1;
    public static final int roundOnePlayerThree = 2;
    public static final int roundOnePlayerFour = 3;
    public static final int roundTwoPlayerOne = 4;
    public static final int roundTwoPlayerTwo = 5;
    public static final int roundTwoPlayerThree = 6;
    public static final int roundThreePlayerOne = 7;
    public static final int roundThreePlayerTwo = 8;
    public static final int roundThreePlayerThree = 9;
    public static final int playerAICount = 10;
    public static final int humandAdvisor = 10;
    public static final int playerQueueCount = 11;
    public Character[] mCharacters = new Character[11];

    public CharacterManager() {
        for (int i2 = 0; i2 < 11; ++i2) {
            this.mCharacters[i2] = null;
        }
    }

    public void destruct() {
        for (int i2 = 0; i2 < 11; ++i2) {
            this.mCharacters[i2] = null;
        }
        this.mCharacters = null;
    }

    public void FillTable(PokerTable pokerTable) {
        GameSettings gameSettings = GameApp.Get().GetGameSettings();
        int n2 = gameSettings.GetCurrentGameMode();
        int n3 = gameSettings.GetDifficulty();
        if (gameSettings.IsCurrentModeHeadsUp()) {
            int n4;
            byte by = 2;
            if (gameSettings.IsPractice()) {
                n4 = this.GetSuitableHeroPortrait(n3, n2);
            } else {
                CareerState careerState = GameApp.Get().GetCareerState();
                n4 = careerState.GetHeadsUpHeroCharacterPortrait();
                careerState.SetHeadsUpHeroCharacterPortrait(-1);
            }
            this.mCharacters[0] = new Character(this.GetPersonalityFromPortrait(n4), n4);
            pokerTable.AddAIPlayer(by, TexasGameManager.Get().GetInitialStack(), this.mCharacters[0]);
            this.mCharacters[0].SetCurrentSeat(by);
            pokerTable.GetPlayerSeatedAt(by).ResetForNextHand();
        } else if (gameSettings.IsCurrentModeProGame()) {
            int n5 = pokerTable.GetNbOfStartingAIPlayers();
            for (int i2 = 0; i2 < n5; ++i2) {
                int n6 = 18 + i2;
                this.mCharacters[i2] = new Character(this.GetPersonalityFromPortrait(n6), n6);
                pokerTable.AddAIPlayer((byte)i2, TexasGameManager.Get().GetInitialStack(), this.mCharacters[i2]);
                this.mCharacters[i2].SetCurrentSeat((byte)i2);
            }
        } else {
            short s2;
            int n7;
            int n8;
            int n9;
            int n10 = this.GetAvailableCharacterForkBeginning(n3);
            int n11 = this.GetAvailableCharacterForkSize(n2);
            int[] nArray = new int[11];
            for (n9 = 0; n9 < n11; ++n9) {
                nArray[n9] = n10 + n9;
            }
            int n12 = 1;
            if (4 == n3 && gameSettings.IsCurrentModeTournament()) {
                n12 += 3;
            }
            for (n8 = 0; n8 < n11 * 3; ++n8) {
                n7 = FlMath.Random((short)0, (short)(n11 - n12));
                s2 = FlMath.Random((short)0, (short)(n11 - n12));
                n9 = nArray[n7];
                nArray[n7] = nArray[s2];
                nArray[s2] = n9;
            }
            nArray[n11] = this.GetSuitableHeroPortrait(n3, n2);
            if (gameSettings.IsCurrentModeStandard()) {
                if (FlMath.Random((short)0, (short)1) == 1) {
                    n7 = n11;
                    s2 = FlMath.Random((short)0, (short)(n11 - 1));
                    n9 = nArray[n7];
                    nArray[n7] = nArray[s2];
                    nArray[s2] = n9;
                }
            } else {
                for (n8 = 0; n8 < n12; ++n8) {
                    n7 = n11;
                    s2 = FlMath.Random((short)(n11 - 2), (short)(n11 - 1));
                    n9 = nArray[n7];
                    nArray[n7] = nArray[s2];
                    nArray[s2] = n9;
                }
            }
            byte[] byArray = new byte[]{2, 3, 0, 1};
            int n13 = 0;
            for (int i3 = 0; i3 < 10; ++i3) {
                int n14 = 0 + nArray[i3];
                this.mCharacters[n13] = new Character(this.GetPersonalityFromPortrait(n14), n14);
                if (n13 <= 3) {
                    pokerTable.AddAIPlayer(byArray[i3], TexasGameManager.Get().GetInitialStack(), this.mCharacters[n13]);
                    this.mCharacters[n13].SetCurrentSeat(byArray[i3]);
                }
                ++n13;
            }
        }
    }

    public void RefillTable(PokerTable pokerTable, PlayerViewportManager playerViewportManager) {
        GameApp gameApp = GameApp.Get();
        TexasGameManager texasGameManager = gameApp.GetGameFactory().GetTexasManager();
        int n2 = gameApp.GetGameSettings().GetTournamentRound();
        int n3 = 4 + 3 * (n2 - 2);
        int n4 = 0;
        int n5 = -1;
        int n6 = gameApp.GetGameFactory().GetGame().GetNbOfStartingAIPlayers();
        for (int i2 = 0; i2 < n6 && n4 < 3; ++i2) {
            if (pokerTable.GetPlayerSeatedAt((byte)i2).GetState() != 0) continue;
            int n7 = this.GetIndexOfCharacterAtSeat(i2);
            this.mCharacters[n7].SetCurrentSeat(-1);
            n5 = texasGameManager.GetInitialStack();
            pokerTable.AddAIPlayer((byte)i2, n5, this.mCharacters[n3]);
            this.mCharacters[n3].SetCurrentSeat(i2);
            PokerPlayer pokerPlayer = pokerTable.GetPlayerSeatedAt((byte)i2);
            pokerPlayer.ResetForNextHand();
            playerViewportManager.GetPlayerViewportSeatedAt((byte)i2).NewPlayerOnTable();
            ++n3;
            ++n4;
        }
        pokerTable.ResetNextData();
        GameApp.Get().GetGameFactory().GetGame().ResetDataForAIAlgorithm();
    }

    public void Save(FileSegmentStream fileSegmentStream) {
        for (int i2 = 0; i2 < 10; ++i2) {
            if (this.mCharacters[i2] == null) {
                fileSegmentStream.WriteLong(-1);
                fileSegmentStream.WriteLong(-1);
                fileSegmentStream.WriteLong(-1);
                continue;
            }
            this.mCharacters[i2].Save(fileSegmentStream);
        }
    }

    public void Load(FileSegmentStream fileSegmentStream, PokerTable pokerTable) {
        for (int i2 = 0; i2 < 10; ++i2) {
            this.mCharacters[i2] = new Character(fileSegmentStream);
            if (this.mCharacters[i2].GetPortrait() <= -1) {
                this.mCharacters[i2] = null;
                this.mCharacters[i2] = null;
                continue;
            }
            byte by = (byte)this.mCharacters[i2].GetCurrentSeat();
            if (-1 == by) continue;
            ((PokerPlayerAI)pokerTable.GetPlayerSeatedAt(by)).LoadAIAttributes(this.mCharacters[i2]);
        }
    }

    public Character GetHumanAdvisor() {
        if (this.mCharacters[10] == null) {
            this.mCharacters[10] = new Character(7, -1);
        }
        return this.mCharacters[10];
    }

    public int GetAvailableCharacterForkBeginning(int n2) {
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
            case 4: {
                return 12;
            }
        }
        return 0;
    }

    public int GetAvailableCharacterForkSize(int n2) {
        if (n2 == 1) {
            return 6;
        }
        return 9;
    }

    public int GetPersonalityFromPortrait(int n2) {
        int n3 = -1;
        switch (n2) {
            case -1: {
                n3 = -1;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n3 = n2 / 3;
                break;
            }
            case 18: {
                n3 = 3;
                break;
            }
            case 19: {
                n3 = 4;
                break;
            }
            case 20: {
                n3 = 6;
                break;
            }
            case 21: {
                n3 = 7;
                break;
            }
            default: {
                n3 = -1;
            }
        }
        return n3;
    }

    public int GetSuitableHeroPortrait(int n2, int n3) {
        if (n2 < 4) {
            return 18 + n2;
        }
        if (1 == n3) {
            return 18 + FlMath.Random((short)0, (short)3);
        }
        return 21;
    }

    public int GetIndexOfCharacterAtSeat(int n2) {
        int n3 = -1;
        for (int i2 = 0; i2 < 10; ++i2) {
            if (this.mCharacters[i2].GetCurrentSeat() != n2) continue;
            n3 = i2;
        }
        return n3;
    }

    public static CharacterManager[] InstArrayCharacterManager(int n2) {
        CharacterManager[] characterManagerArray = new CharacterManager[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            characterManagerArray[i2] = new CharacterManager();
        }
        return characterManagerArray;
    }

    public static CharacterManager[][] InstArrayCharacterManager(int n2, int n3) {
        CharacterManager[][] characterManagerArray = new CharacterManager[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            characterManagerArray[i2] = new CharacterManager[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                characterManagerArray[i2][i3] = new CharacterManager();
            }
        }
        return characterManagerArray;
    }

    public static CharacterManager[][][] InstArrayCharacterManager(int n2, int n3, int n4) {
        CharacterManager[][][] characterManagerArray = new CharacterManager[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            characterManagerArray[i2] = new CharacterManager[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                characterManagerArray[i2][i3] = new CharacterManager[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    characterManagerArray[i2][i3][i4] = new CharacterManager();
                }
            }
        }
        return characterManagerArray;
    }
}

