/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.texasholdem09;

import ca.jamdat.flight.FlColor;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Viewport;
import ca.jamdat.texasholdem09.GameLibrary;
import ca.jamdat.texasholdem09.MetaPackage;
import ca.jamdat.texasholdem09.PlayerDecision;
import ca.jamdat.texasholdem09.PlayerViewport;
import ca.jamdat.texasholdem09.PokerGame;
import ca.jamdat.texasholdem09.PokerPlayer;
import ca.jamdat.texasholdem09.PokerPlayerAI;
import ca.jamdat.texasholdem09.TexasGameManager;

public class AIPlayerViewport
extends PlayerViewport {
    public boolean mNeedToInitializeInfoScreen = true;
    public Text mPlayerActionText;
    public Viewport mInfoScreen;
    public boolean mInfoScreenShown;
    public Text mInfoScreenBottomText;

    public AIPlayerViewport(byte by) {
        super(by);
    }

    public void destruct() {
    }

    public void Initialize() {
        int n2 = 0;
        int n3 = -1;
        switch (this.mPlayerSeat) {
            case 2: {
                n2 = 141;
                n3 = 100;
                break;
            }
            case 3: {
                n2 = 155;
                n3 = 108;
                break;
            }
            case 0: {
                n2 = 148;
                n3 = 116;
                break;
            }
            case 1: {
                n2 = 134;
                n3 = 92;
                break;
            }
        }
        this.InitializeMembers(n2, n3);
        this.mPlayerViewport.SetVisible(true);
        super.Initialize();
    }

    public void InitializeMembers(int n2, int n3) {
        Text text;
        MetaPackage metaPackage = GameLibrary.GetPackage(1081377);
        Package package_ = metaPackage.GetPackage();
        int n4 = n2;
        this.mInfoScreen = Viewport.Cast(package_.GetEntryPoint(n4++), null);
        this.mPlayerActionText = Text.Cast(package_.GetEntryPoint(n4++), null);
        this.mInfoScreenBottomText = text = (Text)this.mInfoScreen.GetChild(3);
        short s2 = 0;
        this.mInfoScreen.SetTopLeft(s2, this.mInfoScreen.GetRectTop());
        this.mInfoScreen.SetVisible(false);
        GameLibrary.ReleasePackage(metaPackage);
        super.InitializeMembers(n4, n3);
    }

    public void UnloadResources() {
        if (this.mPlayerActionText != null) {
            this.mPlayerActionText = null;
        }
        if (this.mInfoScreenBottomText != null) {
            this.mInfoScreenBottomText = null;
        }
        if (this.mInfoScreen != null) {
            this.mInfoScreen = null;
        }
        super.UnloadResources();
    }

    public void NewPlayerOnTable() {
        this.mNeedToInitializeInfoScreen = true;
        super.NewPlayerOnTable();
    }

    public void ToggleInfoScreen(boolean bl, int n2, FlString flString, FlFont flFont) {
        if (bl) {
            if (flString != null) {
                this.mInfoScreenBottomText.SetCaption(flString);
            } else {
                this.UpdateStackAmount(n2);
            }
            this.mInfoScreenShown = true;
            this.mInfoScreenBottomText.SetFont(flFont);
            this.mInfoScreen.SetVisible(true);
        } else {
            this.mInfoScreenShown = false;
            this.mInfoScreen.SetVisible(false);
        }
    }

    public boolean IsInfoScreenShown() {
        return this.mInfoScreenShown;
    }

    public void InitializeInfoScreen(PokerGame pokerGame) {
        if (this.mNeedToInitializeInfoScreen) {
            FlString flString = null;
            MetaPackage metaPackage = GameLibrary.GetPackage(1540143);
            Package package_ = metaPackage.GetPackage();
            PokerPlayerAI pokerPlayerAI = (PokerPlayerAI)pokerGame.GetTexasPokerTable().GetPlayerSeatedAt(this.mPlayerSeat);
            int n2 = pokerPlayerAI.GetPortrait();
            flString = FlString.Cast(package_.GetEntryPoint(0 + n2), null);
            pokerGame.SetAIPlayerName(this.mPlayerSeat, flString);
            ((Text)this.mInfoScreen.GetChild(2)).SetCaption(new FlString(flString));
            PokerPlayer pokerPlayer = pokerGame.GetTexasPokerTable().GetPlayerSeatedAt(this.mPlayerSeat);
            this.UpdateStackAmount(pokerPlayer.GetChip());
            this.SetInfoScreenBackground(pokerPlayer.IsPlayerHero());
            this.mNeedToInitializeInfoScreen = false;
            GameLibrary.ReleasePackage(metaPackage);
        }
    }

    public void UpdateStackAmount(int n2) {
        FlString flString = new FlString();
        flString.AddAssign(new FlString(n2));
        this.mInfoScreenBottomText.SetCaption(flString);
    }

    public void HideThinkingString() {
        FlString flString = new FlString();
        this.mInfoScreenBottomText.SetCaption(flString);
    }

    public void HideStack() {
        FlString flString = new FlString();
        this.mMoneyText.SetCaption(flString);
    }

    public void HideActionText() {
        FlString flString = new FlString();
        this.mPlayerActionText.SetCaption(flString);
    }

    public void OnMoneyWon(PokerPlayer pokerPlayer) {
        this.HideActionText();
        this.HideStack();
        this.mInfoScreenBottomText.SetCaption(new FlString(pokerPlayer.GetChip()));
    }

    public void SetPlayerAction(byte by, PlayerDecision playerDecision) {
        this.HideStack();
        super.SetPlayerAction(by, playerDecision);
        this.SetActionString(playerDecision);
    }

    public void UpdatePlayerState(byte by, boolean bl) {
        if (by == 2) {
            this.MuckHand();
        } else if (by == 6) {
            this.HideActionText();
            this.HideStack();
        }
        super.UpdatePlayerState(by, bl);
    }

    public Text GetMoneyText() {
        return this.mInfoScreenBottomText;
    }

    public void PrepareForNewDeal() {
        this.HideActionText();
        this.HideStack();
        super.PrepareForNewDeal();
    }

    public void RemovePlayerFromTable() {
        this.HideActionText();
        this.HideStack();
        super.RemovePlayerFromTable();
    }

    public void SetInfoScreenBackground(boolean bl) {
        MetaPackage metaPackage = GameLibrary.GetPackage(1081377);
        Package package_ = metaPackage.GetPackage();
        int n2 = -1;
        FlColor flColor = null;
        Shape shape = null;
        shape = (Shape)this.mInfoScreen.GetChild(1);
        n2 = bl ? 163 : 162;
        flColor = FlColor.Cast(package_.GetEntryPoint(n2), null);
        shape.SetColor(flColor);
        GameLibrary.ReleasePackage(metaPackage);
    }

    public void SetActionString(PlayerDecision playerDecision) {
        FlString flString = new FlString();
        byte by = playerDecision.GetPlayerAction();
        TexasGameManager texasGameManager = TexasGameManager.Get();
        if (this.IsAllIn()) {
            flString.Assign(texasGameManager.GetActionString((byte)5));
        } else if (by != 6 && by != 7) {
            flString.Assign(texasGameManager.GetActionString(by));
        }
        if (playerDecision.GetPlayerAction() == 4 || playerDecision.GetPlayerAction() == 3) {
            FlString flString2 = new FlString();
            flString2.AddAssign(new FlString(playerDecision.GetChip()));
            this.mMoneyText.SetCaption(flString2);
        }
        this.mPlayerActionText.SetCaption(flString);
    }

    public void MuckHand() {
        this.SetHoleCardsState((byte)1);
        this.HideStack();
        MetaPackage metaPackage = GameLibrary.GetPackage(1081377);
        Package package_ = metaPackage.GetPackage();
        FlString flString = null;
        flString = FlString.Cast(package_.GetEntryPoint(31), null);
        this.mPlayerActionText.SetCaption(flString);
        GameLibrary.ReleasePackage(metaPackage);
    }
}

