/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Array_int;
import ca.jamdat.flight.Characters;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlDisplayContext;
import ca.jamdat.flight.FlFont;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public class Text
extends Component {
    public static final byte typeNumber = 71;
    public static final byte typeID = 71;
    public static final boolean supportsDynamicSerialization = true;
    public static final byte wrapDataFieldLineStartIndex = 0;
    public static final byte wrapDataFieldLineEndIndex = 1;
    public static final byte wrapDataFieldLineWidth = 2;
    public static final byte wrapDataFieldCount = 3;
    public static final byte breakTypeLineBreakChar = 0;
    public static final byte breakTypeWordBreakChar = 1;
    public static final byte breakTypeWrapAfterChar = 2;
    public static final byte breakTypeOptWordBreakChar = 3;
    public static final byte breakTypeLastChar = 4;
    public FlFont mFont;
    public byte mAlignment;
    public FlString mpCaption;
    public int mCaptionLength;
    public boolean mKeepTrailingWhiteSpaces;
    public short mLineCount;
    public boolean mIsMultiline;
    public short mCurrentLine;
    public int[] mLines = null;
    public short[] mLinesWidth = null;
    public short mPreviousWidth;

    public static Text Cast(Object object, Text text) {
        return (Text)object;
    }

    public byte GetTypeID() {
        return 71;
    }

    public static Class AsClass() {
        return null;
    }

    public Text() {
        this.mAlignment = 0;
        this.mpCaption = new FlString();
        this.mLineCount = 1;
    }

    public Text(Viewport viewport) {
        this.mAlignment = 0;
        this.mpCaption = new FlString();
        this.mLineCount = 1;
        this.SetViewport(viewport);
    }

    public Text(Viewport viewport, FlFont flFont, FlString flString, short s2, short s3, short s4, short s5, byte by) {
        this.mLineCount = 1;
        this.SetViewport(viewport);
        this.SetRect(s2, s3, s4, s5);
        this.SetFont(flFont);
        this.SetCaption(flString);
        this.SetAlignment(by);
    }

    public void destruct() {
        this.mpCaption = null;
        this.mLines = null;
        this.mLinesWidth = null;
    }

    public void OnRectChange() {
        if (this.IsMultiline() && this.mPreviousWidth != this.GetRectWidth()) {
            this.WrapText();
        }
    }

    public void SetCaption(FlString flString, boolean bl) {
        this.mpCaption = flString;
        this.SetCaptionLength(this.mpCaption.GetLength());
        this.WrapText();
        this.SetCurrentLine(0);
    }

    public void KeepTrailingWhiteSpaces(boolean bl) {
        this.mKeepTrailingWhiteSpaces = bl;
    }

    public FlString GetCaption() {
        return this.mpCaption;
    }

    public FlString GetLineString(int n2) {
        FlString flString = this.mpCaption;
        if (!this.IsMultiline()) {
            return flString;
        }
        int n3 = this.GetLineStartIndex(n2);
        int n4 = this.GetLineEndIndex(n2);
        int n5 = n4 - n3 + 1;
        FlString flString2 = new FlString(flString, n3, n5);
        return flString2;
    }

    public int GetLineStartIndex(int n2) {
        return Text.GetStartOfLine(this.mLines, n2);
    }

    public int GetLineEndIndex(int n2) {
        if (this.mKeepTrailingWhiteSpaces) {
            return Text.GetStartOfLine(this.mLines, n2 + 1) - 1;
        }
        return Text.GetEndOfLine(this.mLines, n2);
    }

    public void SetAlignment(byte by) {
        if (this.mAlignment != by) {
            this.mAlignment = by;
            this.Invalidate();
        }
    }

    public byte GetAlignment() {
        return this.mAlignment;
    }

    public boolean IsMultiline() {
        return this.mIsMultiline;
    }

    public void SetMultiline(boolean bl) {
        if (bl != this.mIsMultiline) {
            this.mIsMultiline = bl;
            if (this.mIsMultiline) {
                this.WrapText();
            }
            this.Invalidate();
        }
    }

    public void SetFont(FlFont flFont) {
        if (this.mFont != flFont) {
            this.mFont = flFont;
            if (flFont == null) {
                return;
            }
            this.WrapText();
            this.Invalidate();
        }
    }

    public FlFont GetFont() {
        return this.mFont;
    }

    public static int GetStartOfLine(int[] nArray, int n2) {
        return nArray[n2] & 0xFFFF;
    }

    public static void SetStartOfLine(int[] nArray, int n2, int n3) {
        nArray[n2] = nArray[n2] & 0xFFFF0000 | n3;
    }

    public static int GetEndOfLine(int[] nArray, int n2) {
        return nArray[n2] >> 16;
    }

    public static void SetEndOfLine(int[] nArray, int n2, int n3) {
        nArray[n2] = nArray[n2] & 0xFFFF | n3 << 16;
    }

    public void OnDraw(FlDisplayContext flDisplayContext) {
        FlString flString = this.mpCaption;
        FlFont flFont = this.mFont;
        if (flString.IsEmpty() || flFont == null) {
            return;
        }
        if (this.mIsMultiline && this.mLineCount > 1) {
            flDisplayContext.DrawMultilineString(flString, this.mLines, this.mLineCount, this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height, this.mCurrentLine, flFont, this.mAlignment, this.mLinesWidth);
        } else {
            flDisplayContext.DrawString(flString, this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height, flFont, this.mAlignment, 0, this.mCaptionLength, this.mLinesWidth[0]);
        }
    }

    public void NextPage() {
        if (this.mCurrentLine + this.GetLinesPerPage() < this.mLineCount) {
            this.SetCurrentLine(this.mCurrentLine + this.GetLinesPerPage());
        }
    }

    public void PreviousPage() {
        this.SetCurrentLine(this.mCurrentLine - this.GetLinesPerPage());
    }

    public boolean IsFirstPage() {
        return this.mCurrentLine < this.GetLinesPerPage();
    }

    public boolean IsLastPage() {
        return this.mCurrentLine + this.GetLinesPerPage() >= this.mLineCount;
    }

    public void NextLine() {
        this.SetCurrentLine(this.mCurrentLine + 1);
    }

    public void PreviousLine() {
        this.SetCurrentLine(this.mCurrentLine - 1);
    }

    public void SetCurrentLine(int n2) {
        short s2 = n2 < 0 ? (short)0 : (n2 >= this.mLineCount && this.mLineCount > 0 ? (short)(this.mLineCount - 1) : (short)n2);
        this.mCurrentLine = s2;
        this.Invalidate();
    }

    public int GetCurrentLine() {
        return this.mCurrentLine;
    }

    public short GetLineHeight() {
        return (short)this.mFont.GetLineHeight();
    }

    public boolean IsFirstLine() {
        return this.mCurrentLine == 0;
    }

    public boolean IsLastLine() {
        return this.mLineCount == this.mCurrentLine + 1;
    }

    public int GetNbPages() {
        if (this.GetLinesPerPage() != 0) {
            return this.mLineCount / this.GetLinesPerPage() + (this.mLineCount % this.GetLinesPerPage() != 0 ? 1 : 0);
        }
        return 1;
    }

    public int GetNbLines() {
        return this.mLineCount;
    }

    public int GetLinesPerPage() {
        return this.GetRectHeight() / this.GetLineHeight();
    }

    public void OnVisibilityChange() {
        if (this.IsVisible() && this.mIsMultiline) {
            this.Invalidate();
        }
        super.OnVisibilityChange();
    }

    public void OnSerialize(Package package_) {
        super.OnSerialize(package_);
        this.mpCaption = null;
        this.mpCaption = FlString.Cast(package_.SerializePointer((byte)35, false, false), null);
        this.SetCaptionLength(this.mpCaption.GetLength());
        this.mFont = FlFont.Cast(package_.SerializePointer((byte)36, false, false), null);
        byte by = this.mAlignment;
        this.mAlignment = by = package_.SerializeIntrinsic(by);
        short s2 = 0;
        s2 = package_.SerializeIntrinsic(s2);
        this.mIsMultiline = package_.SerializeIntrinsic(this.mIsMultiline);
        this.WrapText();
    }

    public Vector2_short GetCharIndex2DPosition(int n2) {
        short s2;
        if (!this.IsMultiline()) {
            return new Vector2_short((short)n2, 0);
        }
        for (s2 = 0; s2 < this.mLineCount && n2 > Text.GetStartOfLine(this.mLines, s2); s2 = (short)(s2 + 1)) {
        }
        if (s2 == this.mLineCount) {
            s2 = (short)(s2 - 1);
        }
        return new Vector2_short((short)(n2 - Text.GetStartOfLine(this.mLines, s2)), s2);
    }

    public short GetLineWidth(int n2) {
        return this.mLinesWidth[n2];
    }

    public void ComputeLineWidth(boolean bl) {
        int n2;
        FlString flString = this.mpCaption;
        if (flString == null || this.mFont == null) {
            if (flString == null) {
                this.SetCaptionLength(0);
            }
            return;
        }
        if (!this.mKeepTrailingWhiteSpaces) {
            for (n2 = this.mCaptionLength; n2 > 0 && (flString.GetCharAt(n2 - 1) == 32 || flString.GetCharAt(n2 - 1) == 29); --n2) {
            }
            this.SetCaptionLength(n2);
        }
        short[] sArray = new short[]{(short)this.mFont.GetLineWidth(flString, 0, n2, bl)};
        this.mLinesWidth = sArray;
    }

    public void WrapText() {
        if (!this.mIsMultiline) {
            this.mLineCount = 1;
            this.ComputeLineWidth();
            return;
        }
        short s2 = this.GetRectWidth();
        FlFont flFont = this.mFont;
        if (s2 != 0 && flFont != null) {
            int n2;
            int n3 = 192;
            Array_int array_int = new Array_int(n3, n3);
            int n4 = this.WrapString(flFont, s2, array_int);
            int[] nArray = new int[n4 + 1];
            for (n2 = 0; n2 <= n4; ++n2) {
                Text.SetStartOfLine(nArray, n2, (short)Text.WrapDataLineStart(array_int, n2));
                Text.SetEndOfLine(nArray, n2, Text.WrapDataLineEnd(array_int, n2));
            }
            short[] sArray = new short[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                sArray[n2] = (short)Text.WrapDataLineWidth(array_int, n2);
            }
            this.mLines = nArray;
            this.mLinesWidth = sArray;
            this.mPreviousWidth = s2;
            this.mLineCount = (short)n4;
            int n5 = n4 * this.GetLineHeight() - this.GetLeading();
            this.SetSize(s2, (short)n5);
        }
    }

    public static void WrapDataEnsureSize(Array_int array_int, int n2) {
        int n3;
        int n4 = array_int.GetCapacity();
        array_int.SetSize(n4 > (n3 = n2 * 3) ? n4 : n3);
    }

    public static int WrapDataArrayPosition(int n2, byte by) {
        return n2 * 3 + by;
    }

    public static int WrapDataLineStart(Array_int array_int, int n2) {
        return array_int.GetAt(Text.WrapDataArrayPosition(n2, (byte)0));
    }

    public static void WrapDataSetLineStart(Array_int array_int, int n2, int n3) {
        array_int.SetAt(n3, Text.WrapDataArrayPosition(n2, (byte)0));
    }

    public static int WrapDataLineEnd(Array_int array_int, int n2) {
        return array_int.GetAt(Text.WrapDataArrayPosition(n2, (byte)1));
    }

    public static void WrapDataSetLineEnd(Array_int array_int, int n2, int n3) {
        array_int.SetAt(n3, Text.WrapDataArrayPosition(n2, (byte)1));
    }

    public static int WrapDataLineWidth(Array_int array_int, int n2) {
        return array_int.GetAt(Text.WrapDataArrayPosition(n2, (byte)2));
    }

    public static void WrapDataSetLineWidth(Array_int array_int, int n2, int n3) {
        array_int.SetAt(n3, Text.WrapDataArrayPosition(n2, (byte)2));
    }

    public int WrapString(FlFont flFont, int n2, Array_int array_int) {
        FlString flString = this.mpCaption;
        int n3 = 1;
        int n4 = 4;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        byte by = 0;
        Text.WrapDataEnsureSize(array_int, 2);
        Text.WrapDataSetLineStart(array_int, 0, 0);
        int n8 = 0;
        FlFont flFont2 = flFont;
        byte by2 = flString.GetCharAt(0);
        int n9 = Characters.GetCharType(by2);
        if (by2 == 0) {
            Text.WrapDataSetLineEnd(array_int, 0, 0);
            Text.WrapDataSetLineStart(array_int, n3, 1);
            n3 = (short)(n3 + 1);
        }
        while (by2 != 0) {
            byte by3 = by2;
            int n10 = n9;
            by2 = flString.GetCharAt(n8 + 1);
            n9 = Characters.GetCharType(by2);
            boolean bl2 = true;
            int n11 = flFont2.GetCharWidth(by3, n6 == 0, true);
            byte by4 = n6 + n11;
            if (by4 > n2) {
                bl2 = false;
            } else if (by4 == n2) {
                bl2 = Characters.IsWordSeparator(n9);
            }
            int n12 = flFont2.GetCharWidth(by3, n6 == 0, false);
            n6 += n12;
            n11 = 0;
            if (by3 == 13 && by2 == 10) {
                bl = true;
            } else {
                if (Characters.IsLineSeparator(n10)) {
                    by4 = (byte)(1 + (bl ? 1 : 0));
                    by = n4 == 1 && n5 == n8 - by4 ? (byte)(by + by4) : by4;
                    n4 = 0;
                    n11 = 1;
                } else if (n4 >= 1 && Characters.IsWordSeparator(n10)) {
                    if (by3 != -83 || bl2) {
                        by4 = 1;
                        if (by3 == -83) {
                            by4 = 0;
                        }
                        by = n4 == 1 && n5 == n8 - 1 ? (byte)(by + by4) : by4;
                        n4 = 1;
                        n11 = 1;
                    }
                } else if (n4 >= 3 && Characters.IsOptionalWordBreak(n10)) {
                    n4 = 3;
                    by = 1;
                    n11 = 1;
                }
                if (bl2) {
                    if (n4 >= 2 && Characters.CanWrapAfter(n10) && Characters.CanWrapBefore(n9)) {
                        n4 = 2;
                        by = 0;
                        n11 = 1;
                    }
                    if (n4 != 0 && by2 == 0) {
                        n4 = 0;
                        if (n11 == 0) {
                            by = 0;
                        }
                        n11 = 1;
                    }
                } else if (n4 == 4) {
                    n5 = (short)(n8 - 1);
                    n7 = n6 - flFont2.GetCharWidth(by3, n6 == 0, false);
                }
                if (n11 != 0) {
                    n5 = n8;
                    n7 = n6;
                }
                if (n4 == 0 || !bl2) {
                    n8 = n5;
                    by4 = flString.GetCharAt(n5);
                    FlFont flFont3 = flFont;
                    while (n8 - by < n5) {
                        n7 -= flFont3.GetCharWidth(by4, n7 == 0, false);
                        if ((n5 = (int)((short)(n5 - 1))) < 0) continue;
                        by4 = flString.GetCharAt(n5);
                    }
                    if (n5 > Text.WrapDataLineStart(array_int, n3 - 1)) {
                        n7 += flFont3.GetCharWidth(by4, (n7 -= flFont3.GetCharWidth(by4, n7 == 0, false)) == 0, true);
                    }
                    Text.WrapDataEnsureSize(array_int, n3 + 1);
                    Text.WrapDataSetLineWidth(array_int, n3 - 1, n7);
                    Text.WrapDataSetLineEnd(array_int, n3 - 1, n5);
                    Text.WrapDataSetLineStart(array_int, n3, n8 + 1);
                    n3 = (short)(n3 + 1);
                    by2 = flString.GetCharAt(n8 + 1);
                    n9 = Characters.GetCharType(by2);
                    n5 = -1;
                    n6 = 0;
                    bl = false;
                    n4 = 4;
                    by = 0;
                }
            }
            n8 = (short)(n8 + 1);
        }
        Text.WrapDataEnsureSize(array_int, n3 + 1);
        Text.WrapDataSetLineStart(array_int, n3, n8);
        Text.WrapDataSetLineEnd(array_int, n3, -1);
        return n3 - 1;
    }

    public byte GetLeading() {
        return this.mFont.GetLeading();
    }

    public void SetCaptionLength(int n2) {
        this.mCaptionLength = n2;
    }

    public void SetCaption(FlString flString) {
        this.SetCaption(flString, true);
    }

    public short GetLineWidth() {
        return this.GetLineWidth(0);
    }

    public void ComputeLineWidth() {
        this.ComputeLineWidth(true);
    }

    public static Text[] InstArrayText(int n2) {
        Text[] textArray = new Text[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            textArray[i2] = new Text();
        }
        return textArray;
    }

    public static Text[][] InstArrayText(int n2, int n3) {
        Text[][] textArray = new Text[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            textArray[i2] = new Text[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                textArray[i2][i3] = new Text();
            }
        }
        return textArray;
    }

    public static Text[][][] InstArrayText(int n2, int n3, int n4) {
        Text[][][] textArray = new Text[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            textArray[i2] = new Text[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                textArray[i2][i3] = new Text[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    textArray[i2][i3][i4] = new Text();
                }
            }
        }
        return textArray;
    }
}

