/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.Viewport;

public class Scene
extends Viewport {
    public static final byte noTransition = 0;
    public static final byte dismiss = 1;
    public static final byte launch = 2;
    public static final byte launchPopUp = 3;
    public static final byte transitionIsLaunch = -2;
    public static final byte lastDismissParam = -3;
    public Scene mReturnScene;

    public void destruct() {
    }

    public static void Launch(Scene scene) {
        Scene.StartTransition((byte)2, scene, -2);
    }

    public static void LaunchPopUp(Scene scene) {
        Scene.StartTransition((byte)3, scene, -2);
    }

    public static void Dismiss(int n2) {
        FlApplication flApplication = FlApplication.GetInstance();
        Scene scene = flApplication.mCurrentScene;
        Scene scene2 = scene.mReturnScene;
        if (scene2 != null) {
            Scene.StartTransition((byte)1, scene2, n2);
        } else {
            flApplication.TakeFocus();
            flApplication.mCurrentScene = null;
            scene.SetViewportNull();
            scene.OnDelete();
        }
    }

    public void CompleteTransition() {
        FlApplication flApplication = FlApplication.GetInstance();
        byte by = flApplication.mCurrentTransitionType;
        Scene scene = by == 1 ? flApplication.mCurrentScene : this.mReturnScene;
        Viewport viewport = null;
        if (scene != null) {
            if (this.GetViewport() == null) {
                viewport = scene.GetViewport();
            }
            if (by == 1) {
                this.SendMsg(scene, -116);
                flApplication.mCurrentScene = this;
            } else if (by == 2) {
                scene.SetViewportNull();
            }
            if (viewport != null) {
                this.SetViewport(viewport);
            }
        }
        flApplication.ResetDownKeys();
        this.TakeFocus();
        flApplication.mCurrentTransitionType = 0;
    }

    public void DetachAndSkip(Component component, int n2, int n3) {
        this.SetViewportNull();
        this.mReturnScene.SendMsg(component, n2, n3);
    }

    public void OnDelete() {
    }

    public boolean OnDefaultMsg(Component component, int n2, int n3) {
        switch (n2) {
            case -117: {
                this.CompleteTransition();
                return true;
            }
            case -118: {
                component.SetViewportNull();
                ((Scene)component).OnDelete();
                return true;
            }
            case -116: {
                Scene scene = (Scene)component;
                Scene scene2 = null;
                while (scene != this) {
                    scene2 = scene.mReturnScene;
                    scene.mReturnScene = null;
                    scene2.SendMsg(scene, -118);
                    scene = scene2;
                }
                return true;
            }
            case -115: {
                if (this.mReturnScene != null) {
                    this.DetachAndSkip(component, n2, n3);
                } else {
                    FlApplication flApplication = FlApplication.GetInstance();
                    this.SendMsg(flApplication.mCurrentScene, -116);
                    flApplication.mCurrentScene = this;
                    flApplication.mCurrentTransitionType = 0;
                    Scene.Dismiss(-3);
                }
                return true;
            }
        }
        return false;
    }

    public static void StartTransition(byte by, Scene scene, int n2) {
        FlApplication flApplication = FlApplication.GetInstance();
        if (n2 == -2) {
            scene.mReturnScene = flApplication.mCurrentScene;
            flApplication.mCurrentScene = scene;
        }
        flApplication.mCurrentTransitionType = by;
        flApplication.TakeFocus();
        scene.SendMsg(flApplication.mCurrentScene, -117, n2);
    }

    public static Scene[] InstArrayScene(int n2) {
        Scene[] sceneArray = new Scene[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sceneArray[i2] = new Scene();
        }
        return sceneArray;
    }

    public static Scene[][] InstArrayScene(int n2, int n3) {
        Scene[][] sceneArray = new Scene[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            sceneArray[i2] = new Scene[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                sceneArray[i2][i3] = new Scene();
            }
        }
        return sceneArray;
    }

    public static Scene[][][] InstArrayScene(int n2, int n3, int n4) {
        Scene[][][] sceneArray = new Scene[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            sceneArray[i2] = new Scene[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                sceneArray[i2][i3] = new Scene[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    sceneArray[i2][i3][i4] = new Scene();
                }
            }
        }
        return sceneArray;
    }
}

