/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Memory;
import ca.jamdat.flight.Package;

public class FlColor {
    public static final byte typeNumber = 20;
    public static final byte typeID = 20;
    public static final boolean supportsDynamicSerialization = false;
    public short[] rgb = new short[3];

    public static FlColor Cast(Object object, FlColor flColor) {
        return (FlColor)object;
    }

    public FlColor() {
    }

    public FlColor(int n2, int n3, int n4) {
        this.rgb[0] = (short)n2;
        this.rgb[1] = (short)n3;
        this.rgb[2] = (short)n4;
    }

    public FlColor(FlColor flColor) {
        this.rgb[0] = flColor.rgb[0];
        this.rgb[1] = flColor.rgb[1];
        this.rgb[2] = flColor.rgb[2];
    }

    public void OnSerialize(Package package_) {
        byte by = (byte)this.rgb[0];
        by = package_.SerializeIntrinsic(by);
        this.rgb[0] = (short)Memory.MakeUnsignedByte(by);
        by = (byte)this.rgb[1];
        by = package_.SerializeIntrinsic(by);
        this.rgb[1] = (short)Memory.MakeUnsignedByte(by);
        by = (byte)this.rgb[2];
        by = package_.SerializeIntrinsic(by);
        this.rgb[2] = (short)Memory.MakeUnsignedByte(by);
    }

    public int GetRed() {
        return this.rgb[0];
    }

    public int GetGreen() {
        return this.rgb[1];
    }

    public int GetBlue() {
        return this.rgb[2];
    }

    public void SetRed(int n2) {
        this.rgb[0] = (short)n2;
    }

    public void SetGreen(int n2) {
        this.rgb[1] = (short)n2;
    }

    public void SetBlue(int n2) {
        this.rgb[2] = (short)n2;
    }

    public FlColor Darker() {
        return new FlColor(this.GetRed() / 2, this.GetGreen() / 2, this.GetBlue() / 2);
    }

    public FlColor Lighter() {
        return new FlColor(255 - (255 - this.GetRed()) / 2, 255 - (255 - this.GetGreen()) / 2, 255 - (255 - this.GetBlue()) / 2);
    }

    public int ToRGB888() {
        return this.rgb[0] << 16 | this.rgb[1] << 8 | this.rgb[2];
    }

    public boolean Equals(FlColor flColor) {
        return this.rgb[0] == flColor.rgb[0] && this.rgb[1] == flColor.rgb[1] && this.rgb[2] == flColor.rgb[2];
    }

    public FlColor Assign(FlColor flColor) {
        this.rgb[0] = flColor.rgb[0];
        this.rgb[1] = flColor.rgb[1];
        this.rgb[2] = flColor.rgb[2];
        return this;
    }

    public static FlColor Black() {
        return new FlColor(0, 0, 0);
    }

    public static FlColor Blue() {
        return new FlColor(0, 0, 255);
    }

    public static FlColor Green() {
        return new FlColor(0, 255, 0);
    }

    public static FlColor Cyan() {
        return new FlColor(0, 255, 255);
    }

    public static FlColor Red() {
        return new FlColor(255, 0, 0);
    }

    public static FlColor Purple() {
        return new FlColor(255, 0, 255);
    }

    public static FlColor Yellow() {
        return new FlColor(255, 255, 0);
    }

    public static FlColor White() {
        return new FlColor(255, 255, 255);
    }

    public static FlColor Gray() {
        return new FlColor(127, 127, 127);
    }

    public static FlColor[] InstArrayFlColor(int n2) {
        FlColor[] flColorArray = new FlColor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            flColorArray[i2] = new FlColor();
        }
        return flColorArray;
    }

    public static FlColor[][] InstArrayFlColor(int n2, int n3) {
        FlColor[][] flColorArray = new FlColor[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            flColorArray[i2] = new FlColor[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                flColorArray[i2][i3] = new FlColor();
            }
        }
        return flColorArray;
    }

    public static FlColor[][][] InstArrayFlColor(int n2, int n3, int n4) {
        FlColor[][][] flColorArray = new FlColor[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            flColorArray[i2] = new FlColor[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                flColorArray[i2][i3] = new FlColor[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    flColorArray[i2][i3][i4] = new FlColor();
                }
            }
        }
        return flColorArray;
    }
}

