/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlColor;
import ca.jamdat.flight.FlPalette;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Memory;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.StringUtils;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class FlBitmapImplementor
extends FlBitmap {
    public static final byte typeNumber = 91;
    public static final byte typeID = 91;
    public static final boolean supportsDynamicSerialization = true;
    public Image mImage;
    private static Hashtable mImageCacheKeysValues = new Hashtable();
    static final String PNG_HEADER = "\u8950\u4e47\u0d0a\u1a0a\u0000\r\u4948\u4452";
    static final int PNG_HEADER_SIZE = 16;
    static final int PNG_HEADER_DATA = 17;
    static final String PNG_PLTE = "\u504c\u5445";
    static final int PNG_PLTE_SIZE = 4;
    static final String PNG_TRNS = "\u7452\u4e53";
    static final int PNG_TRNS_SIZE = 4;
    static final int PNG_IDATSIZE_SIZE = 4;
    static final String PNG_IDAT = "\u4944\u4154";
    static final int PNG_IDAT_SIZE = 4;
    static final String PNG_IEND = "\u0000\u4945\u4e44\uae42\u6082";
    static final int PNG_IEND_SIZE = 10;
    static final int PNG_EMBEDDED_DATA_SIZE = 30;
    static final int PNG_BYTECOUNT_OVERHEAD = 4;
    static final int PNG_CRC_OVERHEAD = 4;
    static final int PNG_CHUNK_OVERHEAD = 12;
    static final int PNG_HEADER_SIZE_IN_PACKAGE = 21;
    static final int PNG_PALETTE_SIZE_PER_COLOR = 3;
    static final int PNG_PALETTE_FOOTER_SIZE = 4;
    static final int PNG_PALETTE_POSITION_IN_PNG = 33;

    public static FlBitmapImplementor Cast(Object object, FlBitmapImplementor flBitmapImplementor) {
        return (FlBitmapImplementor)object;
    }

    public byte GetTypeID() {
        return 91;
    }

    public static Class AsClass() {
        return null;
    }

    public FlBitmapImplementor() {
    }

    public FlBitmapImplementor(FlString flString) {
        String string = new String(StringUtils.CreateJavaString(flString));
        if (string.charAt(0) != '/') {
            string = '/' + string;
        }
        try {
            this.mImage = Image.createImage((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mImage != null) {
            this.mDataWidth = (short)this.mImage.getWidth();
            this.mDataHeight = (short)this.mImage.getHeight();
        }
    }

    public void destruct() {
    }

    public void SetSize(short s2, short s3) {
    }

    public int GetPixelFormat() {
        int n2 = 51456;
        return n2;
    }

    public void Clone(FlBitmap flBitmap) {
        short s2 = flBitmap.GetWidth();
        short s3 = flBitmap.GetHeight();
        this.mImage = Image.createImage((Image)flBitmap.getImage());
        this.CloneAttributes(flBitmap);
    }

    public void Duplicate(FlBitmap flBitmap) {
    }

    public void OnSerialize(Package package_) {
        byte[] byArray = null;
        short s2 = 0;
        int n2 = 0;
        n2 = package_.SerializeIntrinsic(n2);
        s2 = package_.SerializeIntrinsic(s2);
        int n3 = 0;
        n3 = package_.SerializeIntrinsic((short)n3);
        boolean bl = false;
        bl = package_.SerializeIntrinsic(bl);
        int n4 = 33;
        int n5 = s2 * 3;
        if (s2 > 0) {
            n4 += (n5 += 12);
        }
        int n6 = n3;
        if (n3 > 0) {
            n4 += (n6 += 12);
            n2 -= n3 + 4;
        }
        byArray = new byte[n4 += 4 + n2 - 21 + 10 + 4];
        int n7 = 0;
        n7 = StringUtils.StringToBytes(PNG_HEADER, byArray, n7);
        n7 = this.Library_loadBytes(package_, 17, byArray, n7);
        n7 += n5;
        if (n3 > 0) {
            byArray[n7++] = 0;
            byArray[n7++] = 0;
            byArray[n7++] = (byte)(n3 >>> 8);
            byArray[n7++] = (byte)(n3 & 0xFF);
            n7 = StringUtils.StringToBytes(PNG_TRNS, byArray, n7);
            n7 = this.Library_loadBytes(package_, n3 + 4, byArray, n7);
        }
        n7 = this.Library_loadBytes(package_, 4, byArray, n7);
        n7 = StringUtils.StringToBytes(PNG_IDAT, byArray, n7);
        n7 = this.Library_loadBytes(package_, n2 - 21, byArray, n7);
        n7 = StringUtils.StringToBytes(PNG_IEND, byArray, n7);
        FlPalette flPalette = null;
        flPalette = FlPalette.Cast(package_.SerializePointer((byte)33, false, false), null);
        if (flPalette != null) {
            this.CreateImage(byArray, flPalette.GetData());
        } else {
            this.CreateImage(byArray, null);
        }
        if (!bl) {
            byArray = null;
        }
        this.mData = byArray;
    }

    public FlPalette GetPalette() {
        return null;
    }

    public void SetPalette(FlPalette flPalette) {
    }

    public void GetRGB(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.mImage.getRGB(nArray, n3, n4, n5, n6, n7, n8);
    }

    public void CreateEmptyImage(short s2, short s3) {
        this.mImage = Image.createImage((int)s2, (int)s3);
        this.mDataWidth = s2;
        this.mDataHeight = s3;
    }

    public void CreateImageFromPNGData(byte[] byArray, int n2, int n3) {
        Long l2 = new Long(Memory.CalculateCRC(byArray, n2, n3));
        if (!mImageCacheKeysValues.containsKey(l2)) {
            this.mImage = Image.createImage((byte[])byArray, (int)n2, (int)n3);
            mImageCacheKeysValues.put(l2, this.mImage);
        } else {
            this.mImage = (Image)mImageCacheKeysValues.get(l2);
        }
        this.mDataWidth = (short)this.mImage.getWidth();
        this.mDataHeight = (short)this.mImage.getHeight();
    }

    public void CreateImageFromDepalettizedRawData(int[] nArray, int n2, short s2, short s3, FlColor flColor, boolean bl) {
        Long l2 = new Long(Memory.CalculateCRC(nArray, 0, nArray.length));
        if (!mImageCacheKeysValues.containsKey(l2)) {
            this.mImage = Image.createRGBImage((int[])nArray, (int)s2, (int)s3, (boolean)bl);
            mImageCacheKeysValues.put(l2, this.mImage);
        } else {
            this.mImage = (Image)mImageCacheKeysValues.get(l2);
        }
        this.mDataWidth = s2;
        this.mDataHeight = s3;
    }

    public void CreateAlphaImageFromRawData(int[] nArray, short s2, short s3, int n2, FlColor flColor) {
        int n3 = s2 * s3;
        int[] nArray2 = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] == 0) continue;
            nArray2[i2] = ((nArray[i2] & 0xFF000000) >>> 24) * (n2 & 0xFF) / 255 << 24 | nArray[i2] & 0xFFFFFF;
        }
        this.CreateImageFromDepalettizedRawData(nArray2, 51456, s2, s3, flColor, true);
    }

    public void CreateImageFromRawData(byte[] byArray, byte[] byArray2, short s2, short s3) {
        this.CreateImageFromRawData(byArray, byArray2, s2, s3, -1);
    }

    public void CreateImageFromRawData(byte[] byArray, byte[] byArray2, short s2, short s3, int n2) {
        boolean bl = n2 != -1;
        int n3 = s2 * s3;
        int[] nArray = new int[n3];
        int n4 = n3;
        while (--n4 >= 0) {
            int n5 = byArray[n4] & 0xFF;
            if (n5 == n2) {
                nArray[n4] = 0;
                continue;
            }
            nArray[n4] = 0xFF000000 | ((byArray2[n5 *= 3] & 0xFF) << 16 | (byArray2[n5 + 1] & 0xFF) << 8 | byArray2[n5 + 2] & 0xFF);
        }
        this.CreateImageFromDepalettizedRawData(nArray, 51456, s2, s3, null, bl);
    }

    public void CreateImageFromRawData(byte[] byArray, byte[] byArray2, short s2, short s3, FlColor flColor) {
        int n2 = -1;
        int n3 = byArray2.length / 3;
        for (int i2 = 0; i2 < n3; ++i2) {
            if ((byArray2[i2 * 3] & 0xFF) != flColor.GetRed() || (byArray2[i2 * 3 + 1] & 0xFF) != flColor.GetGreen() || (byArray2[i2 * 3 + 2] & 0xFF) != flColor.GetBlue()) continue;
            n2 = i2;
            break;
        }
        this.CreateImageFromRawData(byArray, byArray2, s2, s3, n2);
    }

    public byte[] CreatePNGBuffer(byte[] byArray, byte[] byArray2, short s2, short n2, int n3) {
        int n4;
        int n5;
        byte[] byArray3 = null;
        int n6 = (251 + (s2 * n2 + n2)) / 252;
        int n7 = 75 + byArray2.length + s2 * n2 + n2 + 5 * n6;
        int n8 = byArray2.length / 3;
        if (n3 != -1) {
            n7 += 12 + n8;
        }
        byArray3 = new byte[n7];
        int n9 = 0;
        n9 = StringUtils.StringToBytes(PNG_HEADER, byArray3, 0);
        byArray3[11] = 13;
        int n10 = 12;
        n9 = Memory.WriteIntToByteArray(s2, byArray3, n9);
        n9 = Memory.WriteIntToByteArray(n2, byArray3, n9);
        byArray3[n9++] = 8;
        byArray3[n9++] = 3;
        int n11 = (int)Memory.CalculateCRC(byArray3, n10, (n9 += 3) - n10);
        n9 = Memory.WriteIntToByteArray(n11, byArray3, n9);
        n10 = n9 = Memory.WriteIntToByteArray(byArray2.length, byArray3, n9);
        n9 = StringUtils.StringToBytes(PNG_PLTE, byArray3, n9);
        System.arraycopy(byArray2, 0, byArray3, n9, byArray2.length);
        n11 = (int)Memory.CalculateCRC(byArray3, n10, (n9 += byArray2.length) - n10);
        n9 = Memory.WriteIntToByteArray(n11, byArray3, n9);
        if (n3 != -1) {
            n10 = n9 = Memory.WriteIntToByteArray(n8, byArray3, n9);
            n9 = StringUtils.StringToBytes(PNG_TRNS, byArray3, n9);
            for (n5 = 0; n5 < n8; ++n5) {
                byArray3[n9 + n5] = -1;
            }
            byArray3[n9 + n3] = 0;
            n11 = (int)Memory.CalculateCRC(byArray3, n10, (n9 += n8) - n10);
            n9 = Memory.WriteIntToByteArray(n11, byArray3, n9);
        }
        n5 = s2 * n2 + 2 + 4 + n2 + 5 * n6;
        n10 = n9 = Memory.WriteIntToByteArray(n5, byArray3, n9);
        n9 = StringUtils.StringToBytes(PNG_IDAT, byArray3, n9);
        byArray3[n9++] = 24;
        byArray3[n9++] = 25;
        int n12 = 0;
        byte[] byArray4 = new byte[(s2 + 1) * n2];
        for (n4 = 0; n4 < n2; ++n4) {
            byArray4[n12++] = 0;
            System.arraycopy(byArray, n4 * s2, byArray4, n12, s2);
            n12 += s2;
        }
        int n13 = n12;
        int n14 = 252;
        byte by = 0;
        n12 = 0;
        while (n13 - n12 > 0) {
            if (n13 - n12 <= 252) {
                by = 1;
                n14 = n13 - n12;
            }
            byArray3[n9++] = by;
            byArray3[n9++] = (byte)n14;
            byArray3[n9++] = 0;
            byArray3[n9++] = (byte)(255 - n14);
            byArray3[n9++] = -1;
            System.arraycopy(byArray4, n12, byArray3, n9, n14);
            n9 += n14;
            n12 += n14;
        }
        int n15 = 1;
        int n16 = 0;
        for (n4 = 0; n4 < byArray4.length; ++n4) {
            n15 += byArray4[n4] & 0xFF;
            n16 += (n15 %= 65521);
            n16 %= 65521;
        }
        byArray3[n9++] = (byte)((n16 & 0xFF00) >> 8);
        byArray3[n9++] = (byte)(n16 & 0xFF);
        byArray3[n9++] = (byte)((n15 & 0xFF00) >> 8);
        byArray3[n9++] = (byte)(n15 & 0xFF);
        n11 = (int)Memory.CalculateCRC(byArray3, n10, n9 - n10);
        n9 = Memory.WriteIntToByteArray(n11, byArray3, n9);
        n9 += 2;
        n9 = StringUtils.StringToBytes(PNG_IEND, byArray3, n9);
        return byArray3;
    }

    public void CloneAttributes(FlBitmap flBitmap) {
        this.mDataWidth = flBitmap.GetDataWidth();
        this.mDataHeight = flBitmap.GetDataHeight();
    }

    public Image getImage() {
        return this.mImage;
    }

    public int Library_loadBytes(Package package_, int n2, byte[] byArray, int n3) {
        package_.ReadBufferAtOffset(byArray, n3, n2);
        return n3 + n2;
    }

    public void CreateImageForRepalettization(FlBitmap flBitmap, FlPalette flPalette) {
        this.CreateImage(flBitmap.mData, flPalette.GetData());
        this.mData = null;
    }

    public void ReallocateData(short s2, short s3) {
        if (this.mDataWidth == s2 && this.mDataHeight == s3) {
            return;
        }
        this.mData = null;
        this.mDataWidth = s2;
        this.mDataHeight = s3;
        this.mData = new byte[s3 * (short)this.GetBytesPerLine()];
    }

    public void CreateImage(byte[] byArray, byte[] byArray2) {
        Image image;
        Long l2;
        if (byArray2 != null) {
            int n2 = byArray2.length - 4;
            byArray[33] = 0;
            byArray[34] = 0;
            byArray[35] = (byte)(n2 >>> 8);
            byArray[36] = (byte)(n2 & 0xFF);
            StringUtils.StringToBytes(PNG_PLTE, byArray, 37);
            System.arraycopy(byArray2, 0, byArray, 41, byArray2.length);
        }
        if (!mImageCacheKeysValues.containsKey(l2 = new Long(Memory.CalculateCRC(byArray, 0, byArray.length)))) {
            image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            mImageCacheKeysValues.put(l2, image);
        } else {
            image = (Image)mImageCacheKeysValues.get(l2);
        }
        this.mDataWidth = (short)image.getWidth();
        this.mDataHeight = (short)image.getHeight();
        this.mImage = image;
    }

    public static FlBitmapImplementor[] InstArrayFlBitmapImplementor(int n2) {
        FlBitmapImplementor[] flBitmapImplementorArray = new FlBitmapImplementor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            flBitmapImplementorArray[i2] = new FlBitmapImplementor();
        }
        return flBitmapImplementorArray;
    }

    public static FlBitmapImplementor[][] InstArrayFlBitmapImplementor(int n2, int n3) {
        FlBitmapImplementor[][] flBitmapImplementorArray = new FlBitmapImplementor[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            flBitmapImplementorArray[i2] = new FlBitmapImplementor[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                flBitmapImplementorArray[i2][i3] = new FlBitmapImplementor();
            }
        }
        return flBitmapImplementorArray;
    }

    public static FlBitmapImplementor[][][] InstArrayFlBitmapImplementor(int n2, int n3, int n4) {
        FlBitmapImplementor[][][] flBitmapImplementorArray = new FlBitmapImplementor[n2][][];
        for (int i2 = 0; i2 < n2; ++i2) {
            flBitmapImplementorArray[i2] = new FlBitmapImplementor[n3][];
            for (int i3 = 0; i3 < n3; ++i3) {
                flBitmapImplementorArray[i2][i3] = new FlBitmapImplementor[n4];
                for (int i4 = 0; i4 < n4; ++i4) {
                    flBitmapImplementorArray[i2][i3][i4] = new FlBitmapImplementor();
                }
            }
        }
        return flBitmapImplementorArray;
    }
}

